/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.standard.filter.Action;
import biouml.standard.filter.HideAction;
import biouml.standard.filter.HighlightAction;
import com.developmentontheedge.beans.editors.ColorComboBox;
import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import ru.biosoft.graphics.Brush;

public class ActionEditor
extends CustomEditorSupport {
    private static ActionRenderer renderer;
    protected ActionComboBox editor;
    private static Font FONT;
    private static int REN_WIDTH;

    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        if (renderer == null) {
            renderer = new ActionRenderer();
        }
        renderer.setAction((Action)this.getValue());
        return renderer;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ActionComboBox();
            this.editor.addColorPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Color c = (Color)evt.getNewValue();
                    if (c == ActionComboBox.hide) {
                        ActionEditor.this.setValue(HideAction.instance);
                    } else {
                        ActionEditor.this.setValue(new HighlightAction(new Brush((Paint)c)));
                    }
                }
            });
        }
        return this.editor;
    }

    protected Object processValue() {
        Object value = this.editor.getSelectedItem();
        if (value instanceof Color) {
            return new HighlightAction(new Brush((Paint)((Color)value)));
        }
        return HideAction.instance;
    }

    static {
        FONT = new Font("Arial", 0, 11);
        REN_WIDTH = 30;
    }

    public static class ActionComboBox
    extends ColorComboBox {
        static ColorComboBox.NamedColor hide = new ColorComboBox.NamedColor(Color.white, "hide", false);

        public ActionComboBox() {
            super((Color)hide);
        }
    }

    public static class ActionRenderer
    extends JLabel {
        protected Action action;

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        @Override
        public void paint(Graphics g) {
            if (this.action instanceof HideAction) {
                g.setFont(FONT);
                g.setColor(Color.black);
                g.drawString("hide", 9, 12);
            } else if (this.action instanceof HighlightAction) {
                Color color = (Color)((HighlightAction)this.action).getBrush().getPaint();
                g.setColor(color);
                g.fillRect(9, 5, REN_WIDTH, 8);
                g.setColor(Color.black);
                g.drawRect(9, 5, REN_WIDTH, 8);
                String text = ColorComboBox.getText((Color)color);
                if (text == null) {
                    text = "custom";
                }
                g.setFont(FONT);
                g.setColor(Color.black);
                g.drawString(text, 20 + REN_WIDTH, 12);
            }
        }
    }
}

