/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.editors;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.type.ImageDescriptor;
import biouml.standard.type.Substance;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.graph.DiagramToGraphTransformer;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.Option;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import one.util.streamex.StreamEx;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.util.OkCancelDialog;
import ru.biosoft.util.TextUtil;

public class NodeImageChoiceDialog
extends OkCancelDialog {
    protected JPanel content;
    protected JComboBox<String> fileName = new JComboBox();
    protected JComboBox<String> structure = new JComboBox();
    protected JTextField location = new JTextField();
    protected JButton fileImportButton;
    protected JTextField titleField = new JTextField(20);
    protected JTextField shiftOffsetField = new JTextField(20);
    protected JLabel image = new JLabel();
    protected ViewPane viewPane;
    protected String value;
    protected ImageDescriptor imageDescriptor;
    protected Node nodeClone;
    protected Diagram diagram;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    public static final String DEFAULT = "<default>";
    private static final MessageBundle mb = BioUMLApplication.getMessageBundle();

    public NodeImageChoiceDialog(Component parent, String title, ImageDescriptor imageDescriptor) {
        super(parent, title);
        this.imageDescriptor = imageDescriptor;
        this.value = imageDescriptor.getSource();
        Node tmpNode = (Node)imageDescriptor.getParent();
        this.diagram = (Diagram)((Object)((StreamEx)StreamEx.iterate((Object)((Object)tmpNode), Option::getParent).takeWhile(Objects::nonNull)).select(Diagram.class).findFirst().get());
        this.nodeClone = new Node(this.diagram, tmpNode.getKernel());
        this.nodeClone.setTitleAngle(tmpNode.getTitleAngle());
        this.nodeClone.setTitleOffset(tmpNode.getTitleOffset());
        this.content = new JPanel(new GridBagLayout());
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.fileName.addItem(DEFAULT);
        StreamEx.of((Object[])imageDescriptor.getImages()).forEach(this.fileName::addItem);
        this.fileName.addItemListener(e -> {
            this.value = (String)this.fileName.getSelectedItem();
            if (this.value.equals(DEFAULT)) {
                this.value = null;
            }
            this.nodeClone.getImage().setSource(this.value);
            this.refreshImage(this.nodeClone);
        });
        this.fileImportButton = new JButton("Import");
        this.fileImportButton.addActionListener(event -> this.addImageAction());
        Object[] structures = imageDescriptor.getStructures(Module.optModule(((Node)imageDescriptor.getParent()).getKernel()));
        if (structures != null) {
            StreamEx.of((Object[])structures).forEach(this.structure::addItem);
        }
        this.structure.addItemListener(e -> {
            this.value = (String)this.structure.getSelectedItem();
            this.nodeClone.getImage().setSource(this.value);
            this.refreshImage(this.nodeClone);
        });
        this.titleField.addActionListener(e -> {
            this.nodeClone.setTitle(this.titleField.getText());
            this.nodeClone.getImage().setSource(this.value);
            this.refreshImage(this.nodeClone);
        });
        this.location.setText(String.valueOf(this.nodeClone.getTitleAngle()));
        this.location.addActionListener(event -> {
            this.nodeClone.setTitleAngle(Double.parseDouble(this.location.getText()));
            this.nodeClone.setTitleOffset(this.getInt(this.shiftOffsetField.getText()));
            this.nodeClone.getImage().setSource(this.value);
            this.refreshImage(this.nodeClone);
        });
        this.shiftOffsetField.setText(String.valueOf(this.nodeClone.getTitleOffset()));
        this.shiftOffsetField.addActionListener(e -> {
            this.nodeClone.setTitleAngle(Double.parseDouble(this.location.getText()));
            int intValue = this.getInt(this.shiftOffsetField.getText());
            this.nodeClone.setTitleOffset(this.getInt(this.shiftOffsetField.getText()));
            this.shiftOffsetField.setText(String.valueOf(intValue));
            this.nodeClone.getImage().setSource(this.value);
            this.refreshImage(this.nodeClone);
        });
        this.viewPane = new ViewPane();
        if (this.value == null) {
            this.fileName.setSelectedItem(DEFAULT);
        } else if (this.value.startsWith("Data/structure/")) {
            this.structure.setSelectedItem(this.value);
        } else {
            this.fileName.setSelectedItem(this.value);
        }
        if (imageDescriptor.getParent() instanceof Node) {
            Node node = (Node)imageDescriptor.getParent();
            this.titleField.setText(node.getTitle());
        }
        this.updateOKButton();
        boolean isMolecule = false;
        if (imageDescriptor.getParent() instanceof Node && ((Node)imageDescriptor.getParent()).getKernel() instanceof Substance) {
            isMolecule = true;
        }
        this.content.add((Component)new JLabel("Image:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add(this.fileName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)this.fileImportButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)this.viewPane, new GridBagConstraints(3, 0, 1, 10, 1.0, 1.0, 11, 1, new Insets(10, 10, 0, 0), 0, 0));
        if (isMolecule) {
            this.content.add((Component)new JLabel("Chemical structure:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.content.add(this.structure, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        }
        this.content.add((Component)new JLabel("Title:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.titleField, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel("Location:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.location, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel("Shift offset:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.shiftOffsetField, new GridBagConstraints(1, 5, 1, 2, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.refreshImage((Node)imageDescriptor.getParent());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                NodeImageChoiceDialog.this.refreshImage(NodeImageChoiceDialog.this.nodeClone);
            }
        });
        this.setContent(this.content);
    }

    private void updateOKButton() {
        boolean correctFileName = (String)this.fileName.getSelectedItem() != null && ((String)this.fileName.getSelectedItem()).length() > 0 || (String)this.structure.getSelectedItem() != null && ((String)this.structure.getSelectedItem()).length() > 0;
        this.okButton.setEnabled(correctFileName);
    }

    protected void okPressed() {
        if (this.imageDescriptor.getParent() instanceof Node) {
            Node node = (Node)this.imageDescriptor.getParent();
            node.setTitle(this.titleField.getText());
            node.setTitleOffset(this.getInt(this.shiftOffsetField.getText()));
            node.setTitleAngle(Double.parseDouble(this.location.getText()));
            DiagramToGraphTransformer.layoutSingleNodeEdges((Node)node, (Layouter)this.diagram.getPathLayouter(), null);
        }
        super.okPressed();
    }

    protected void refreshImage(Node node) {
        if (this.diagram != null && node != null) {
            CompositeView view = this.diagram.getType().getDiagramViewBuilder().createNodeView(node, this.diagram.getViewOptions(), this.getParent().getGraphics());
            Dimension paneSize = this.viewPane.getSize();
            Dimension viewSize = view.getBounds().getSize();
            this.viewPane.setView(view, new Point((paneSize.width - viewSize.width) / 2, (paneSize.height - viewSize.height) / 2));
        }
    }

    public String getImageSource() {
        return this.value;
    }

    private int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void addImageAction() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.isFile() && null != file.getName()) {
                    String fileName = file.getName().toLowerCase();
                    Object[] extensions = TextUtil.split((String)mb.getResourceString("PIC_EXTENSIONS"), (char)' ');
                    return StreamEx.of((Object[])extensions).anyMatch(fileName::endsWith);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return mb.getResourceString("PIC_EXTENSIONS_TITLE");
            }
        });
        chooser.setMultiSelectionEnabled(true);
        int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
        if (res == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    BufferedImage image = this.getBufferedImageFromImage(toolkit.getImage(file.getPath()));
                    this.imageDescriptor.addImage(image, file.getName());
                    this.fileName.addItem(file.getName());
                }
                catch (Exception e) {
                    ApplicationUtils.errorBox((String)ExceptionRegistry.log((Throwable)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getBufferedImageFromImage(Image image) throws Exception {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            boolean error = tracker.isErrorID(0);
            Object[] errors = tracker.getErrorsID(0);
            tracker.removeImage(image, 0);
            if (error) {
                throw new Exception("Error during get buffered image occurred: " + StreamEx.of((Object[])errors).joining((CharSequence)"\n"));
            }
        }
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

