/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram.properties;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramViewBuilder;
import biouml.model.InitialElementPropertiesSupport;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.standard.diagram.CompositeSemanticController;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.util.DPSUtils;

@PropertyName(value="Switch element properties")
@PropertyDescription(value="Switch element properties.")
public class SwitchElementProperties
extends InitialElementPropertiesSupport {
    protected static final Logger log = Logger.getLogger(SwitchElementProperties.class.getName());
    private String name;

    public SwitchElementProperties(String name) {
        this.name = name;
    }

    @PropertyName(value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DiagramElementGroup doCreateElements(Compartment compartment, Point location, ViewEditorPane viewPane) {
        return new DiagramElementGroup(this.createSwitchNode(compartment, location));
    }

    public Compartment createSwitchNode(Compartment parent, Point pt) {
        try {
            Diagram diagram = Diagram.getDiagram(parent);
            Compartment switchNode = new Compartment(parent, (Base)new Stub.SwitchElement(parent, DefaultSemanticController.generateUniqueNodeName(diagram, this.name)));
            switchNode.getAttributes().add(DPSUtils.createHiddenReadOnly((String)"innerNodesPortFinder", Boolean.class, (Object)true));
            switchNode.getAttributes().add(new DynamicProperty("Condition", String.class, (Object)"false"));
            switchNode.setShapeSize(new Dimension(120, 100));
            DiagramViewBuilder viewBuilder = diagram.getType().getDiagramViewBuilder();
            viewBuilder.createCompartmentView(switchNode, diagram.getViewOptions(), ApplicationUtils.getGraphics());
            Node defaultPort = new Node(switchNode, (Base)new Stub.InputConnectionPort(parent, "default"));
            Util.setOrientation(defaultPort, SubDiagram.PortOrientation.LEFT);
            Util.setPortVariable(defaultPort, "default");
            defaultPort.setLocation(new Point(0, 20));
            switchNode.put(defaultPort);
            Node experimentPort = new Node(switchNode, (Base)new Stub.InputConnectionPort(parent, "experiment"));
            Util.setOrientation(experimentPort, SubDiagram.PortOrientation.LEFT);
            Util.setPortVariable(experimentPort, "experiment");
            experimentPort.setLocation(new Point(0, 68));
            switchNode.put(experimentPort);
            Node outPort = new Node(switchNode, (Base)new Stub.OutputConnectionPort(parent, "out"));
            Util.setOrientation(outPort, SubDiagram.PortOrientation.RIGHT);
            Util.setPortVariable(outPort, "out");
            CompositeView outPortView = viewBuilder.createNodeView(outPort, diagram.getViewOptions(), ApplicationUtils.getGraphics());
            outPort.setLocation(120 - outPortView.getBounds().width, 44);
            switchNode.put(outPort);
            CompositeSemanticController.movePortToEdge(outPort, switchNode, outPort.getLocation(), true);
            return switchNode;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during switch node creation: " + ex.getMessage());
            return null;
        }
    }
}

