/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram.properties;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementPropertiesSupport;
import biouml.model.Node;
import biouml.standard.diagram.properties.SwitchElementProperties;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Constant element properties")
@PropertyDescription(value="Constant element properties.")
public class ConstantElementProperties
extends InitialElementPropertiesSupport {
    protected static final Logger log = Logger.getLogger(SwitchElementProperties.class.getName());
    private String name;
    private double value = 0.0;

    public ConstantElementProperties(String name) {
        this.name = name;
    }

    @PropertyName(value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyName(value="Value")
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public DiagramElementGroup doCreateElements(Compartment compartment, Point location, ViewEditorPane viewPane) {
        return new DiagramElementGroup(this.createConstantNode(compartment, this.name, location));
    }

    public Node createConstantNode(Compartment parent, String name, Point location) {
        try {
            Diagram diagram = Diagram.getDiagram(parent);
            Node node = new Node(parent, (Base)new Stub.Constant(parent, DefaultSemanticController.generateUniqueNodeName(diagram, name)));
            node.getAttributes().add(new DynamicProperty("Initial value", Double.class, (Object)this.value));
            node.setLocation(location);
            return node;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during constant node creation: " + ex.getMessage());
            return null;
        }
    }
}

