/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PortProperties;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.util.DPSUtils;

public class Util {
    public static final String INITIAL_VALUE = "Initial value";
    public static final String CONDITION = "Condition";
    public static final String INITIAL_TIME = "Inital time";
    public static final String COMPLETION_TIME = "Completion time";
    public static final String TIME_INCREMENT = "Time increment";
    public static final String TIME_SCALE = "Time scale";
    public static final String ORIGINAL_PATH = "originalPath";
    public static final String EXTENT_FACTOR = "Extent factor";
    public static final String REACTION_LABEL = "Reaction label";
    public static final String COMPLEX_STRUCTURE = "Structure";
    public static final String HIGHLIGHT_PROPERTY = "highlight";

    public static boolean isBus(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("connection bus");
    }

    public static boolean isContactPort(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("contact connection port");
    }

    public static boolean isInputPort(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("input connection port");
    }

    public static boolean isOutputPort(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("output connection port");
    }

    public static boolean isPort(DiagramElement de) {
        return de.getKernel() instanceof Stub.ConnectionPort || de.getKernel() instanceof Stub && de.getKernel().getType().equals("port");
    }

    public static boolean isTopLevelPort(DiagramElement de) {
        return Util.isPort(de) && (de.getParent() instanceof Diagram || de.getParent() instanceof biouml.model.Compartment && ((biouml.model.Compartment)de.getParent()).getKernel() instanceof Compartment);
    }

    public static boolean isPropagatedPort(DiagramElement de) {
        if (Util.isModulePort(de)) {
            return false;
        }
        return Util.isPort(de) && de.getAttributes().getProperty("accessType") != null && de.getAttributes().getProperty("accessType").getValue().equals("propagated");
    }

    public static boolean isPropagatedPort2(DiagramElement de) {
        return Util.isPort(de) && de.getAttributes().getProperty("accessType") != null && de.getAttributes().getProperty("accessType").getValue().equals("propagated");
    }

    public static void setPropagated(DiagramElement de, Node basePort) throws IllegalArgumentException {
        if (!Util.isPort(de)) {
            throw new IllegalArgumentException("Only ports can be propagated");
        }
        de.getAttributes().add(new DynamicProperty("accessType", String.class, (Object)"propagated"));
        de.getAttributes().add(new DynamicProperty("basePortName", String.class, (Object)basePort.getName()));
        de.getAttributes().add(new DynamicProperty("baseModuleName", String.class, (Object)basePort.getCompartment().getName()));
    }

    public static void setPublic(Node port) {
        port.getAttributes().getProperty("accessType").setValue((Object)"public");
    }

    public static boolean isPublicPort(DiagramElement de) {
        return Util.isPort(de) && (de.getAttributes().getProperty("accessType") == null || de.getAttributes().getProperty("accessType").getValue().equals("public"));
    }

    public static boolean isPrivatePort(DiagramElement de) {
        return Util.isPort(de) && de.getAttributes().getProperty("accessType") != null && de.getAttributes().getProperty("accessType").getValue().equals("private");
    }

    public static boolean isSwitch(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("switch");
    }

    public static boolean isAverager(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("adapter");
    }

    public static boolean isPlot(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("plot");
    }

    public static boolean isReaction(DiagramElement de) {
        return de.getKernel() instanceof Reaction;
    }

    public static boolean isFastReaction(DiagramElement de) {
        return de.getKernel() instanceof Reaction && ((Reaction)de.getKernel()).isFast();
    }

    public static boolean hasFastReactions(Diagram d) {
        return d.recursiveStream().anyMatch(de -> Util.isFastReaction(de));
    }

    public static boolean isSpecieReference(DiagramElement de) {
        return de.getKernel() instanceof SpecieReference;
    }

    public static boolean isSourceSink(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("source-sink");
    }

    public static boolean isModule(DiagramElement de) {
        return de instanceof DiagramContainer || Util.isSwitch(de) || Util.isAverager(de);
    }

    public static boolean isModulePort(DiagramElement de) {
        return Util.isPort(de) && Util.isModule(de.getCompartment());
    }

    public static boolean isConstant(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("constant");
    }

    public static boolean isBlock(DiagramElement de) {
        return de.getKernel() != null && de.getKernel().getType().equals("block");
    }

    public static boolean isVariable(DiagramElement de) {
        return de.getRole() instanceof VariableRole;
    }

    public static boolean isDiagram(DiagramElement de) {
        return de instanceof Diagram;
    }

    public static boolean isSubDiagram(DiagramElement de) {
        return de instanceof SubDiagram;
    }

    public static boolean isConnection(DiagramElement de) {
        return de.getKernel() instanceof Stub.DirectedConnection || de.getKernel() instanceof Stub.UndirectedConnection;
    }

    public static boolean isDirectedConnection(Edge edge) {
        return edge.getKernel() instanceof Stub.DirectedConnection;
    }

    public static boolean isUndirectedConnection(Edge edge) {
        return edge.getKernel() instanceof Stub.UndirectedConnection;
    }

    public static boolean isPortLink(Edge edge) {
        return edge.getKernel() != null && edge.getKernel().getType().equals("portlink");
    }

    public static List<Edge> getEdges(Node node) {
        if (node instanceof biouml.model.Compartment) {
            biouml.model.Compartment c = (biouml.model.Compartment)node;
            return ((StreamEx)c.recursiveStream().select(Node.class).flatMap(Node::edges).filter(e -> !Util.contains(c, e.getInput()) || !Util.contains(c, e.getOutput()))).toList();
        }
        return node.edges().toList();
    }

    public static boolean contains(biouml.model.Compartment compartment, Node node) {
        return compartment.recursiveStream().select(biouml.model.Compartment.class).anyMatch(c -> ((Object)((Object)node)).equals((Object)c.get(node.getName())));
    }

    public static String getPortVariable(DiagramElement de) {
        DynamicProperty dp = de.getAttributes().getProperty("variableName");
        if (dp != null) {
            return dp.getValue().toString();
        }
        return null;
    }

    public static String getPortModule(DiagramElement de) {
        DynamicProperty dp = de.getAttributes().getProperty("baseModuleName");
        if (dp != null) {
            return dp.getValue().toString();
        }
        return null;
    }

    public static Node getBasePort(Node node) throws Exception {
        DynamicProperty dp = node.getAttributes().getProperty("baseModuleName");
        if (dp == null) {
            throw new Exception("Incorrect propagated port " + node.getName() + " attribute baseModuleName is missing");
        }
        String moduleName = dp.getValue().toString();
        Node module = Diagram.getDiagram(node).findNode(moduleName);
        if (module == null || !(module instanceof biouml.model.Compartment)) {
            moduleName = moduleName.replace(" ", "_");
            module = Diagram.getDiagram(node).findNode(moduleName);
        }
        if (module == null || !(module instanceof biouml.model.Compartment)) {
            throw new Exception("Incorrect propagated port " + node.getName() + " can not find base module " + moduleName);
        }
        dp = node.getAttributes().getProperty("basePortName");
        if (dp == null) {
            throw new Exception("Incorrect propagated port " + node.getName() + " attribute basePortName is missing");
        }
        Node basePort = ((biouml.model.Compartment)module).findNode(dp.getValue().toString());
        if (basePort == null) {
            throw new Exception("Incorrect propagated port " + node.getName() + " base port" + dp.getValue().toString() + "is missing in module " + moduleName);
        }
        return basePort;
    }

    public static void setPortVariable(Node node, String variableName) {
        node.getAttributes().add(DPSUtils.createReadOnly((String)"variableName", String.class, (Object)variableName));
    }

    public static boolean hasOrientation(Node node) {
        return node.getAttributes().hasProperty("orientation");
    }

    public static SubDiagram.PortOrientation getPortOrientation(Node node) {
        Object obj = node.getAttributes().getValue("orientation");
        if (obj instanceof SubDiagram.PortOrientation) {
            return (SubDiagram.PortOrientation)((Object)obj);
        }
        if (obj instanceof String) {
            return SubDiagram.PortOrientation.getOrientation((String)obj);
        }
        node.getAttributes().add(new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)SubDiagram.PortOrientation.RIGHT));
        return SubDiagram.PortOrientation.RIGHT;
    }

    public static void setPortOrientation(Node node, SubDiagram.PortOrientation orientation) {
        node.getAttributes().add(new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)orientation));
    }

    public static void redirect(Edge edge, Node node, Node newNode) {
        if (((Object)((Object)node)).equals((Object)edge.getInput())) {
            edge.setInput(newNode);
            node.removeEdge(edge);
            newNode.addEdge(edge);
        } else if (((Object)((Object)node)).equals((Object)edge.getOutput())) {
            edge.setOutput(newNode);
            node.removeEdge(edge);
            newNode.addEdge(edge);
        }
    }

    public static StreamEx<Node> getPorts(biouml.model.Compartment diagram) {
        return (StreamEx)diagram.recursiveStream().select(Node.class).filter(Util::isTopLevelPort);
    }

    public static Node[] getModulesPorts(Diagram diagram, Class<?> type) {
        if (!DiagramUtility.isComposite(diagram)) {
            return new Node[0];
        }
        return (Node[])((StreamEx)diagram.stream(SubDiagram.class).flatMap(d -> d.stream(Node.class)).filter(node -> Util.isPort(node) && (type == null || node.getKernel().getClass().equals(type)))).toArray(Node[]::new);
    }

    public static Node[] getModules(Diagram diagram) {
        if (!DiagramUtility.isComposite(diagram)) {
            return new Node[0];
        }
        return (Node[])((StreamEx)diagram.recursiveStream().select(Node.class).filter(node -> node instanceof SubDiagram || Util.isAverager(node) || Util.isSwitch(node))).toArray(Node[]::new);
    }

    private static <T> StreamEx<T> ofTree(T root, Predicate<T> hasChildren, Function<T, Stream<T>> mapper) {
        return StreamEx.ofTree(root, t -> hasChildren.test(t) ? (Stream)mapper.apply(t) : null);
    }

    public static Node findPort(biouml.model.Compartment compartment, String variableName) {
        return Util.ofTree(compartment, n -> n instanceof biouml.model.Compartment && !(n instanceof SubDiagram), n -> ((biouml.model.Compartment)((Object)n)).stream(Node.class)).findAny(node -> Util.isPort(node) && variableName.equals(Util.getPortVariable(node))).orElse(null);
    }

    public static List<Node> findPrivatePorts(biouml.model.Compartment compartment, String variableName) {
        return ((StreamEx)Util.ofTree(compartment, n -> n instanceof biouml.model.Compartment && !(n instanceof SubDiagram), n -> ((biouml.model.Compartment)((Object)n)).stream(Node.class)).filter(node -> Util.isPrivatePort(node) && variableName.equals(Util.getPortVariable(node)))).toList();
    }

    public static Node findPort(biouml.model.Compartment compartment, PortProperties properties) {
        return Util.ofTree(compartment, n -> n instanceof biouml.model.Compartment && !(n instanceof SubDiagram), n -> ((biouml.model.Compartment)((Object)n)).stream(Node.class)).findAny(n -> Util.isPort(n) && Util.matches(n, properties)).orElse(null);
    }

    public static boolean matches(Node n, PortProperties properties) {
        try {
            boolean propagated = properties.getAccessType().equals("propagated");
            boolean propagatedPort = Util.isPropagatedPort(n);
            if (propagated != propagatedPort) {
                return false;
            }
            if (propagated && !((Object)((Object)Util.getBasePort(n))).equals((Object)properties.getModule().findNode(properties.getBasePortName()))) {
                return false;
            }
            if (!propagated && !Util.getPortVariable(n).equals(properties.getVarName())) {
                return false;
            }
            return properties.getPortClass().isAssignableFrom(n.getKernel().getClass()) && Util.getAccessType(n).equals(properties.getAccessType());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<SubDiagram> getSubDiagrams(Diagram diagram) {
        ArrayList<SubDiagram> result = new ArrayList<SubDiagram>();
        if (!DiagramUtility.isComposite(diagram)) {
            return result;
        }
        for (SubDiagram node : diagram.stream(SubDiagram.class)) {
            result.add(node);
            result.addAll(Util.getSubDiagrams(node.getDiagram()));
        }
        return result;
    }

    public static Diagram getInnerDiagram(Diagram diagram, String path) {
        if (path.isEmpty()) {
            return diagram;
        }
        SubDiagram subdiagram = Util.getSubDiagram(diagram, path);
        return subdiagram == null ? diagram : subdiagram.getDiagram();
    }

    public static String[] getMainPathComponents(String path) {
        if (!path.contains("/")) {
            return new String[]{"", path};
        }
        int index = path.lastIndexOf("/");
        return new String[]{path.substring(0, index), path.substring(index + 1)};
    }

    public static Variable getVariable(Diagram diagram, String path) {
        if (!path.contains("/")) {
            return diagram.getRole(EModel.class).getVariable(path);
        }
        int index = path.lastIndexOf("/");
        String subDiagramPath = path.substring(0, index);
        String name = path.substring(index + 1);
        return Util.getInnerDiagram(diagram, subDiagramPath).getRole(EModel.class).getVariable(name);
    }

    public static Variable getVariable(Diagram diagram, String path, String delimiter) {
        if (!path.contains(delimiter)) {
            return diagram.getRole(EModel.class).getVariable(path);
        }
        int index = path.lastIndexOf(delimiter);
        String subDiagramPath = path.substring(0, index);
        String name = path.substring(index + 1);
        return Util.getInnerDiagram(diagram, subDiagramPath).getRole(EModel.class).getVariable(name);
    }

    public static SubDiagram getSubDiagram(Diagram diagram, String path) {
        String[] stringArray;
        if (path.isEmpty()) {
            return null;
        }
        if (path.contains("/")) {
            stringArray = path.split("/");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        String[] pathElements = stringArray;
        SubDiagram subdiagram = null;
        for (String pathElement : pathElements) {
            subdiagram = Util.findDiagramElement(diagram, pathElement, SubDiagram.class).findFirst().orElse(null);
            if (subdiagram == null) {
                return null;
            }
            diagram = subdiagram.getDiagram();
        }
        return subdiagram;
    }

    public static <T extends DiagramElement> Stream<T> findDiagramElement(Diagram diagram, String name, Class<T> clazz) {
        return diagram.recursiveStream().select(clazz).filter(de -> de.getName().equals(name));
    }

    public static String getPath(SubDiagram subdiagram) {
        ArrayList<String> pathElements = new ArrayList<String>();
        while (subdiagram != null) {
            pathElements.add(subdiagram.getName());
            subdiagram = SubDiagram.getParentSubDiagram(Diagram.getDiagram(subdiagram));
        }
        Collections.reverse(pathElements);
        return StreamEx.of(pathElements).joining((CharSequence)"/");
    }

    public static StreamEx<String> getModelDefinitionNames(Diagram diagram) {
        if (!DiagramUtility.isComposite(diagram)) {
            return StreamEx.of(Collections.emptyList());
        }
        return diagram.recursiveStream().select(ModelDefinition.class).map(MutableDataElementSupport::getName);
    }

    public static void removeProperties(DiagramElement de, Set<String> exceptions) {
        DynamicPropertySet dps = de.getAttributes();
        HashSet attributeNames = new HashSet(dps.asMap().keySet());
        attributeNames.removeAll(exceptions);
        for (String attributeName : attributeNames) {
            dps.remove(attributeName);
        }
    }

    public static String getAccessType(Node port) {
        return Util.isPublicPort(port) ? "public" : (Util.isPropagatedPort(port) ? "propagated" : "private");
    }

    public static String getPortType(Node port) {
        return Util.isOutputPort(port) ? "output" : (Util.isInputPort(port) ? "input" : "contact");
    }

    public static void moveToPositive(Diagram diagram) {
        int minX = 0;
        int minY = 0;
        for (Point p : diagram.recursiveStream().select(Node.class).map(n -> n.getLocation())) {
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y >= minY) continue;
            minY = p.y;
        }
        if (minX == 0 && minY == 0) {
            return;
        }
        minX = Math.max(0, -minX);
        minY = Math.max(0, -minY);
        for (DiagramElement de : diagram.recursiveStream()) {
            if (de instanceof Node) {
                Point p = ((Node)de).getLocation();
                p.translate(minX, minY);
                ((Node)de).setLocation(p);
            }
            if (!(de instanceof Edge)) continue;
            Edge e = (Edge)de;
            if (e.getPath() != null) {
                e.getPath().translate(minX, minY);
            }
            Point inPort = e.getInPort();
            Point outPort = e.getOutPort();
            inPort.translate(minX, minY);
            outPort.translate(minX, minY);
            e.setInPort(inPort);
            e.setOutPort(outPort);
        }
    }

    public static void setOrientation(Diagram diagram, boolean vertical) {
        diagram.recursiveStream().select(Node.class).forEach(n -> Util.setOrientation(n, vertical ? SubDiagram.PortOrientation.BOTTOM : SubDiagram.PortOrientation.RIGHT));
    }

    public static void setOrientation(Node node, SubDiagram.PortOrientation orientation) {
        SubDiagram.PortOrientation oldOrientation;
        DynamicProperty dp = node.getAttributes().getProperty("orientation");
        if (dp == null) {
            dp = new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)orientation);
            node.getAttributes().add(dp);
        }
        if (orientation.equals((Object)(oldOrientation = (SubDiagram.PortOrientation)((Object)dp.getValue())))) {
            return;
        }
        if (oldOrientation.isVertical() != orientation.isVertical()) {
            int w = node.getShapeSize().width;
            int h = node.getShapeSize().height;
            int x = node.getLocation().x + (w - h) / 2;
            int y = node.getLocation().y + (h - w) / 2;
            node.setLocation(new Point(x, y));
            node.setShapeSize(new Dimension(h, w));
        }
        dp.setValue((Object)orientation);
        node.setView(null);
    }

    public static void defineOrientation(Node node) {
        if (!Util.isReaction(node)) {
            return;
        }
        List products = ((StreamEx)node.edges().filter(e -> e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isProduct())).map(e -> e.getOtherEnd(node).getLocation()).toList();
        List reactants = ((StreamEx)node.edges().filter(e -> e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isReactant())).map(e -> e.getOtherEnd(node).getLocation()).toList();
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        for (Point product : products) {
            for (Point reactant : reactants) {
                int xDist = product.x - reactant.x;
                int yDist = product.y - reactant.y;
                if (Math.abs(xDist) > Math.abs(yDist)) {
                    if (xDist > 0) {
                        ++right;
                        continue;
                    }
                    ++left;
                    continue;
                }
                if (yDist > 0) {
                    ++bottom;
                    continue;
                }
                ++top;
            }
        }
        if (top >= right && top >= left && top >= bottom) {
            Util.setOrientation(node, SubDiagram.PortOrientation.TOP);
        } else if (right >= left && right >= bottom) {
            Util.setOrientation(node, SubDiagram.PortOrientation.RIGHT);
        } else {
            Util.setOrientation(node, bottom >= left ? SubDiagram.PortOrientation.BOTTOM : SubDiagram.PortOrientation.LEFT);
        }
    }

    public static boolean isProduct(Edge e) {
        return e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isProduct() || "production".equals(e.getKernel().getType());
    }

    public static boolean isReactant(Edge e) {
        return e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isReactant() || "consumption".equals(e.getKernel().getType());
    }

    public static boolean isModifier(Edge e) {
        return e.getKernel() instanceof SpecieReference && !((SpecieReference)e.getKernel()).isReactantOrProduct() || "regulation".equals(e.getKernel().getType());
    }

    public static void setConnectionPort(Connection connection, Node node, boolean input) {
        String varName = null;
        if (Util.isPort(node)) {
            varName = Util.getPortVariable(node);
        } else if (node.getRole() instanceof VariableRole) {
            varName = node.getRole(VariableRole.class).getName();
        }
        if (input) {
            connection.setInputPort(new Connection.Port(varName));
        } else {
            connection.setOutputPort(new Connection.Port(varName));
        }
    }

    public static StreamEx<Edge> getBusEdges(Node bus) {
        return StreamEx.of((Object[])bus.getRole(VariableRole.class).getAssociatedElements()).select(Node.class).flatMap(node -> node.edges());
    }

    public static boolean hasNodeWithKernel(biouml.model.Compartment cmp, Base kernel) {
        DiagramElement diagramElement = ((StreamEx)cmp.stream().filter(de -> de.getKernel() != null && de.getKernel().getName().equals(kernel.getName()) && de.getKernel().getClass().equals(kernel.getClass()))).findAny().orElse(null);
        return diagramElement != null;
    }

    public static Node findNode(biouml.model.Compartment cmp, Base kernel) {
        return cmp.recursiveStream().select(biouml.model.Compartment.class).flatMap(c -> c.getKernelNodes(kernel)).findAny().orElse(null);
    }
}

