/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramViewBuilder;
import biouml.model.InitialElementPropertiesSupport;
import biouml.model.ModelDefinition;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.standard.diagram.Util;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Subdiagram properties")
@PropertyDescription(value="Subdiagram properties.")
public class SubDiagramProperties
extends InitialElementPropertiesSupport {
    private static final Logger log = Logger.getLogger(SubDiagramProperties.class.getName());
    public static final String NOT_SELECTED = "Not selected";
    private final Module module;
    private final Diagram upperDiagram;
    private final String[] availableModelDefs;
    private DataElementPath diagramPath;
    private String name = "Subdiagram";
    private boolean external = true;
    private String modelDefinitionName = "Not selected";

    public SubDiagramProperties(Diagram diagram) {
        this.module = Module.getModule((DataElement)diagram);
        this.upperDiagram = diagram;
        this.availableModelDefs = (String[])Util.getModelDefinitionNames(diagram).toArray(String[]::new);
        if (this.availableModelDefs.length > 0) {
            this.modelDefinitionName = this.availableModelDefs[0];
        }
    }

    public void setDiagramPath(DataElementPath diagramPath) {
        DataElement obj = diagramPath.getDataElement();
        if (!(obj instanceof Diagram)) {
            log.log(Level.SEVERE, "Only diagram may be selected for subidgram");
            return;
        }
        if (!((Object)((Object)Module.getModule(obj))).equals((Object)this.module)) {
            log.log(Level.SEVERE, "Please select diagram from module " + this.module.getName());
            return;
        }
        this.diagramPath = diagramPath;
        this.setName(diagramPath.getName());
    }

    @Override
    public DiagramElementGroup doCreateElements(Compartment compartment, Point location, ViewEditorPane viewPane) throws Exception {
        DiagramElement de;
        if (this.name.isEmpty()) {
            log.log(Level.SEVERE, "Please choose name for subdiagram");
            return null;
        }
        Diagram diagram = null;
        if (this.isExternal()) {
            diagram = (Diagram)this.diagramPath.getDataElement();
        } else {
            if (this.modelDefinitionName.equals(NOT_SELECTED)) {
                log.log(Level.SEVERE, "Please choose model definition");
                return null;
            }
            de = this.upperDiagram.get(this.modelDefinitionName);
            diagram = ((ModelDefinition)de.cast(ModelDefinition.class)).getDiagram();
        }
        de = new SubDiagram(compartment, diagram, DefaultSemanticController.generateUniqueNodeName(compartment, this.name));
        this.arrangeView((Compartment)de);
        return new DiagramElementGroup(de);
    }

    @PropertyName(value="External diagram")
    @PropertyDescription(value="Type of associated diagram.")
    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="Subdiagram name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.validateName(name);
    }

    @PropertyName(value="Diagram")
    @PropertyDescription(value="Diagram associated with subdiagram.")
    public DataElementPath getDiagramPath() {
        return this.diagramPath;
    }

    @PropertyName(value="Model definition")
    @PropertyDescription(value="Model definition name.")
    public String getModelDefinitionName() {
        return this.modelDefinitionName;
    }

    public void setModelDefinitionName(String modelDefinitionName) {
        this.modelDefinitionName = modelDefinitionName;
    }

    public String[] getAvailableModelDefinitions() {
        return this.availableModelDefs;
    }

    public boolean isInternal() {
        return !this.isExternal();
    }

    protected String validateName(String name) {
        return name;
    }

    private void arrangeView(Compartment c) throws Exception {
        SemanticController controller = Diagram.getDiagram(c).getType().getSemanticController();
        DiagramViewBuilder viewBuilder = Diagram.getDiagram(c).getType().getDiagramViewBuilder();
        viewBuilder.createCompartmentView(c, Diagram.getDiagram(c).getViewOptions(), ApplicationUtils.getGraphics());
        int width = c.getShapeSize().width;
        int height = c.getNodes().length * 50;
        c.setShapeSize(new Dimension(width, height));
        int x = 10;
        for (String name : (StreamEx)StreamEx.of(c.getNameList()).sorted()) {
            Node node = c.findNode(name);
            Dimension dim = new Dimension(width, x);
            controller.move(node, c, dim, node.getView().getBounds());
            x += node.getView().getBounds().height;
        }
        height = x - c.getLocation().x + 10;
        c.setShapeSize(new Dimension(width, height));
    }
}

