/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementPropertiesSupport;
import biouml.model.Node;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Initial properties")
@PropertyDescription(value="Initial properties.")
public class StubInitialProperties
extends InitialElementPropertiesSupport {
    private String name;
    private String title;
    private String type;
    private Class<? extends Node> clazz;

    @Override
    public DiagramElementGroup doCreateElements(Compartment c, Point location, ViewEditorPane viewPane) throws Exception {
        Stub kernel = new Stub(null, this.name, this.type);
        this.name = DefaultSemanticController.generateUniqueNodeName(c, this.name);
        Node node = this.clazz.getConstructor(DataCollection.class, Base.class).newInstance(new Object[]{c, kernel});
        return new DiagramElementGroup(node);
    }

    public StubInitialProperties(Compartment c, String type, Class<? extends Node> clazz) {
        this.type = type;
        this.title = this.name = DefaultSemanticController.generateUniqueNodeName(c, type);
        this.clazz = clazz;
    }

    @PropertyName(value="Title")
    @PropertyDescription(value="Element title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="Element name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.title = name;
    }
}

