/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Compartment;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.math.model.Utils;
import ru.biosoft.util.bean.BeanInfoEx2;

public class SplitDiagramAction
extends BackgroundDynamicAction {
    public boolean isApplicable(Object object) {
        return object instanceof Diagram && DiagramUtility.isComposite((Diagram)((Object)object));
    }

    public Object getProperties(Object model, List<DataElement> selectedItems) {
        if (!this.isApplicable(selectedItems)) {
            return null;
        }
        return new SplitDiagramActionParameters(selectedItems);
    }

    boolean isApplicable(List<DataElement> selectedItems) {
        return true;
    }

    public JobControl getJobControl(final Object model, final List<DataElement> selectedItems, final Object properties) throws Exception {
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                if (!SplitDiagramAction.this.isApplicable(selectedItems)) {
                    return;
                }
                SplitDiagramAction.this.doSplit((Diagram)((Object)model), StreamEx.of((Collection)selectedItems).map(d -> (DiagramElement)((Object)d)).toList(), (SplitDiagramActionParameters)properties);
            }
        };
    }

    public Diagram doSplit(Diagram diagram, List<DiagramElement> selectedItems, SplitDiagramActionParameters parameters) {
        try {
            DataCollection origin = diagram.getOrigin();
            DataElementPath path = parameters.getResultPath();
            if (path != null) {
                DataCollectionUtils.createSubCollection((DataElementPath)path.getParentPath(), (boolean)true);
                origin = path.getParentPath().getDataCollection();
            }
            SemanticController controller = diagram.getType().getSemanticController();
            EModel emodel = diagram.getRole(EModel.class);
            String name = path == null ? parameters.getSubDiagramName() : path.getName();
            Diagram innerDiagram = diagram.getType().createDiagram(origin, name, new DiagramInfo(name));
            EModel innerEModel = innerDiagram.getRole(EModel.class);
            Set selectedNodes = StreamEx.of(selectedItems).select(Node.class).toSet();
            Set selectedEdges = StreamEx.of(selectedItems).select(Edge.class).toSet();
            if (parameters.isAutoIncludeReactions()) {
                Set<Node> excludedReactions = SplitDiagramAction.getReactions(diagram, selectedNodes);
                selectedNodes.addAll(excludedReactions);
            }
            Set excludedParticipants = ((StreamEx)StreamEx.of((Collection)selectedNodes).filter(n -> Util.isReaction(n))).flatMap(n -> SplitDiagramAction.getParticipants(n)).toSet();
            excludedParticipants.removeAll(selectedNodes);
            selectedNodes.addAll(excludedParticipants);
            Set excludedContent = StreamEx.of((Collection)selectedNodes).flatMap(n -> SplitDiagramAction.getAllContent(n)).toSet();
            selectedNodes.addAll(excludedContent);
            selectedEdges.addAll(((StreamEx)diagram.recursiveStream().select(Edge.class).filter(e -> selectedNodes.containsAll(e.nodes().toSet()))).toSet());
            HashSet<Node> excludedEquations = new HashSet<Node>();
            HashSet<String> excludedParameters = new HashSet<String>();
            HashSet<Node> excludedVariables = new HashSet<Node>();
            SplitDiagramAction.fillExcludedParamsEquations(diagram, selectedNodes, excludedEquations, excludedParameters, excludedVariables);
            selectedNodes.addAll(excludedVariables);
            selectedNodes.addAll(excludedEquations);
            Set excludedCompartments = StreamEx.of((Collection)selectedNodes).flatMap(n -> SplitDiagramAction.getAllCompartments(n)).toSet();
            excludedCompartments.removeAll(selectedNodes);
            selectedNodes.addAll(excludedCompartments);
            for (Variable var : StreamEx.of(excludedParameters).map(p -> emodel.getVariable((String)p))) {
                innerEModel.getVariables().put((DataElement)var.clone(var.getName()));
            }
            HashSet<Node> usedNodes = new HashSet<Node>();
            HashSet<String> usedParameters = new HashSet<String>();
            SplitDiagramAction.getUsedNodes(diagram, selectedNodes, selectedEdges, usedNodes, usedParameters);
            usedNodes.addAll(excludedParticipants);
            usedNodes.addAll(excludedCompartments);
            usedNodes.addAll(excludedVariables);
            TreeMap nodeToLevel = new TreeMap();
            StreamEx.of((Collection)selectedNodes).forEach(n -> nodeToLevel.computeIfAbsent(SplitDiagramAction.getDepth(n), k -> new HashSet()).add(n));
            for (Map.Entry entry : nodeToLevel.entrySet()) {
                for (Node node : (Set)entry.getValue()) {
                    SplitDiagramAction.copyNode(node, innerDiagram);
                }
            }
            for (Edge e2 : selectedEdges) {
                biouml.model.Compartment oldParent = e2.getCompartment();
                biouml.model.Compartment newParent = ((Object)((Object)oldParent)).equals((Object)diagram) ? innerDiagram : (biouml.model.Compartment)innerDiagram.findNode(oldParent.getCompleteNameInDiagram());
                Edge newEdge = e2.clone(newParent, e2.getName());
                newParent.put(newEdge);
                if (!parameters.isAddModule()) continue;
                oldParent.remove(e2.getName());
            }
            SemanticController subDiagramController = innerDiagram.getType().getSemanticController();
            Set<String> calculatedInModule = this.getCalculatedVariables(innerDiagram, new HashSet<Node>());
            Set<String> calculatedInRest = this.getCalculatedVariables(diagram, selectedNodes);
            for (Node node : selectedNodes) {
                if (usedNodes.contains((Object)node)) {
                    if (node.getKernel() instanceof Compartment || !Util.isVariable(node)) continue;
                    String varName = node.getRole(VariableRole.class).getName();
                    boolean isCalculatedInModule = calculatedInModule.contains(varName);
                    boolean isCalculatedInRest = calculatedInRest.contains(varName);
                    String portType = "contact";
                    portType = isCalculatedInModule ? (isCalculatedInRest ? "contact" : "output") : "input";
                    PortProperties portProperties = new PortProperties(innerDiagram, "contact");
                    portProperties.setVarName(varName);
                    portProperties.setName("port_" + node.getName());
                    portProperties.setPortType(portType);
                    subDiagramController.createInstance((biouml.model.Compartment)innerDiagram, Stub.ConnectionPort.class, new Point(), portProperties);
                    if (!parameters.isAddModule()) continue;
                    portProperties = new PortProperties(diagram, "contact");
                    portProperties.setVarName(varName);
                    portProperties.setName("port_" + node.getName());
                    controller.createInstance((biouml.model.Compartment)diagram, Stub.ConnectionPort.class, new Point(), portProperties);
                    continue;
                }
                if (!parameters.isAddModule()) continue;
                node.getCompartment().remove(node.getName());
            }
            if (parameters.isAddModule()) {
                SubDiagram subDigaram = (SubDiagram)controller.createInstance((biouml.model.Compartment)diagram, SubDiagram.class, SplitDiagramAction.getLocation(selectedItems), (Object)innerDiagram).getElement();
                diagram.put(subDigaram);
                for (Node port : subDigaram.getNodes()) {
                    Node topLevelPort = diagram.findNode(port.getName());
                    this.createConnection(diagram, port, topLevelPort);
                }
            }
            SplitDiagramAction.arrangePorts(innerDiagram);
            innerDiagram.save();
            return innerDiagram;
        }
        catch (Exception e3) {
            this.log.severe("Error during split: " + e3.getMessage());
            return null;
        }
    }

    private Set<String> getCalculatedVariables(Diagram diagram, Set<Node> exclude) {
        Set eqs = ((StreamEx)StreamEx.of(diagram.recursiveStream()).select(Node.class).filter(n -> !exclude.contains(n))).map(n -> n.getRole()).select(Equation.class).toSet();
        Set reactioneqs = ((StreamEx)StreamEx.of(diagram.recursiveStream()).select(Node.class).filter(n -> !exclude.contains(n) && Util.isReaction(n))).flatCollection(n -> n.edges().toList()).map(e -> e.getRole()).select(Equation.class).toSet();
        return StreamEx.of((Collection)eqs).append((Collection)reactioneqs).map(eq -> eq.getVariable()).toSet();
    }

    private static void copyNode(Node node, Diagram to) {
        biouml.model.Compartment oldParent = node.getCompartment();
        Diagram newParent = oldParent instanceof Diagram ? to : (biouml.model.Compartment)to.findNode(oldParent.getCompleteNameInDiagram());
        Node newNode = node.getKernel() instanceof Compartment ? SplitDiagramAction.cloneWithoutContent((biouml.model.Compartment)node, newParent, node.getName()) : node.clone(newParent, node.getName());
        ((biouml.model.Compartment)newParent).put(newNode);
        if (Util.isVariable(newNode)) {
            to.getRole(EModel.class).getVariables().put((DataElement)((VariableRole)newNode.getRole()));
        }
    }

    private static biouml.model.Compartment cloneWithoutContent(biouml.model.Compartment comp, biouml.model.Compartment newParent, String newName) {
        biouml.model.Compartment result = new biouml.model.Compartment(newParent, newName, comp.getKernel());
        result.setShapeType(comp.getShapeType());
        result.setShapeSize(comp.getShapeSize());
        result.setVisible(comp.isVisible());
        result.setTitle(comp.getTitle());
        Role compRole = comp.getRole();
        if (compRole != null) {
            result.setRole(compRole.clone(result));
        }
        if (comp.getAttributes() != null) {
            Iterator iter = comp.getAttributes().nameIterator();
            while (iter.hasNext()) {
                DynamicProperty oldProp = comp.getAttributes().getProperty((String)iter.next());
                DynamicProperty prop = null;
                try {
                    prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                }
                catch (Exception e) {
                    prop = oldProp;
                }
                result.getAttributes().add(prop);
            }
        }
        result.setComment(comp.getComment());
        result.setLocation(comp.getLocation());
        result.setShapeSize(comp.getShapeSize());
        result.setFixed(comp.isFixed());
        result.setVisible(comp.isVisible());
        result.setShowTitle(comp.isShowTitle());
        result.setPredefinedStyle(comp.getPredefinedStyle());
        if (result.getPredefinedStyle().equals("Not selected")) {
            result.setCustomStyle(comp.getCustomStyle().clone());
        }
        return result;
    }

    private Edge createConnection(Diagram diagram, Node port, Node otherNode) {
        String name = DefaultSemanticController.generateUniqueNodeName(diagram, "connection");
        Edge edge = new Edge(new Stub.UndirectedConnection(null, name), port, otherNode);
        UndirectedConnection role = new UndirectedConnection(edge);
        String varName = Util.getPortVariable(port);
        ((Connection)role).setInputPort(new Connection.Port(varName, port.getTitle()));
        ((Connection)role).setOutputPort(new Connection.Port(varName, otherNode.getTitle()));
        edge.setRole(role);
        diagram.put(edge);
        return edge;
    }

    public static void getUsedNodes(Diagram diagram, Set<Node> selectedNodes, Set<Edge> selectedEdges, Set<Node> usedNodes, Set<String> usedVariables) {
        EModel emodel = diagram.getRole(EModel.class);
        Set usedVariableRoles = ((StreamEx)emodel.getEquations().filter(eq -> !selectedNodes.contains((Object)eq.getDiagramElement()) || selectedEdges.contains((Object)eq.getDiagramElement()))).flatCollection(eq -> Utils.getVariables((ru.biosoft.math.model.Node)eq.getMath())).toSet();
        usedVariables.addAll(((StreamEx)StreamEx.of((Collection)usedVariableRoles).filter(s -> !s.startsWith("$"))).toSet());
        usedNodes.addAll(((StreamEx)StreamEx.of(selectedNodes).filter(n -> n.edges().anyMatch(e -> !selectedEdges.contains(e)))).toSet());
        usedNodes.addAll(((StreamEx)StreamEx.of(selectedNodes).filter(n -> n.getRole() instanceof VariableRole && usedVariables.contains(n.getRole(VariableRole.class).getName()))).toSet());
    }

    public static Set<Node> getDefiningEquations(Set<String> variables, Diagram diagram, Set<Node> exclude) {
        return ((StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> !exclude.contains(n) && n.getKernel().getType().equals("math-equation") && variables.contains(n.getRole(Equation.class).getVariable()))).toSet();
    }

    public static Set<String> getUsedParameters(Set<Node> selectedNodes, Diagram diagram, Set<String> exclude) {
        return ((StreamEx)StreamEx.of(selectedNodes).map(n -> n.getRole()).select(Equation.class).flatCollection(eq -> StreamEx.of((Collection)Utils.getVariables((ru.biosoft.math.model.Node)eq.getMath())).append((Object)eq.getVariable()).toSet()).filter(p -> !p.startsWith("$$") && !exclude.contains(p))).toSet();
    }

    public static void fillExcludedParamsEquations(Diagram diagram, Set<Node> selectedNodes, Set<Node> equations, Set<String> parameters, Set<Node> variables) {
        Set<String> usedParameters = SplitDiagramAction.getUsedParameters(selectedNodes, diagram, parameters);
        while (!usedParameters.isEmpty()) {
            parameters.addAll(usedParameters);
            Set<Node> usedEquations = SplitDiagramAction.getDefiningEquations(usedParameters, diagram, equations);
            equations.addAll(usedEquations);
            usedParameters = SplitDiagramAction.getUsedParameters(usedEquations, diagram, parameters);
        }
        EModel emodel = diagram.getRole(EModel.class);
        Set variableRoles = ((StreamEx)StreamEx.of(parameters).filter(p -> p.startsWith("$"))).toSet();
        variables.addAll(StreamEx.of((Collection)variableRoles).map(n -> (Node)((VariableRole)emodel.getVariable((String)n)).getDiagramElement()).toSet());
        variables.removeAll(selectedNodes);
        parameters.removeAll(variableRoles);
    }

    public static Integer getDepth(Node node) {
        int result = 0;
        biouml.model.Compartment compartment = node.getCompartment();
        while (!(compartment instanceof Diagram)) {
            ++result;
            compartment = compartment.getCompartment();
        }
        return result;
    }

    public static StreamEx<Node> getAllContent(Node node) {
        if (node instanceof biouml.model.Compartment) {
            return StreamEx.of((Object[])((biouml.model.Compartment)node).getNodes()).flatMap(n -> SplitDiagramAction.getAllContent(n)).append((Object)node);
        }
        return StreamEx.of((Object)((Object)node));
    }

    public static StreamEx<biouml.model.Compartment> getAllCompartments(Node node) {
        HashSet<biouml.model.Compartment> result = new HashSet<biouml.model.Compartment>();
        biouml.model.Compartment compartment = node.getCompartment();
        while (!(compartment instanceof Diagram)) {
            result.add(compartment);
            compartment = compartment.getCompartment();
        }
        return StreamEx.of(result);
    }

    public static StreamEx<Node> getParticipants(Node reactionNode) {
        return ((StreamEx)reactionNode.edges().filter(e -> e.getKernel() instanceof SpecieReference)).map(e -> e.getOtherEnd(reactionNode));
    }

    public static StreamEx<Node> getReactions(Node node) {
        return (StreamEx)((StreamEx)node.edges().filter(e -> e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isReactantOrProduct())).map(e -> e.getOtherEnd(node)).filter(n -> Util.isReaction(n) && ((Reaction)n.getKernel()).getSize() == 1);
    }

    public static Set<Node> getReactions(Diagram diagram, Set<Node> nodes) {
        return ((StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> Util.isReaction(n) && nodes.containsAll(SplitDiagramAction.getParticipants(diagram, (Reaction)n.getKernel())))).toSet();
    }

    public static Set<Node> getParticipants(Diagram diagram, Reaction reaction) {
        return StreamEx.of((Object[])reaction.getSpecieReferences()).map(sr -> diagram.findNode(sr.getSpecie())).toSet();
    }

    private static Point getLocation(List<DiagramElement> elements) {
        List nodes = StreamEx.of(elements).select(Node.class).toList();
        if (nodes.isEmpty()) {
            return new Point();
        }
        Point result = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (Node node : nodes) {
            Point p = node.getLocation();
            result.x = Math.min(result.x, p.x);
            result.y = Math.min(result.y, p.y);
        }
        return result;
    }

    private static Set<String> copyParameters(Set<Node> nodes, Diagram from, Diagram to) {
        return ((StreamEx)StreamEx.of(nodes).map(n -> n.getRole()).select(Equation.class).flatMap(eq -> StreamEx.of((Collection)Utils.getVariables((ru.biosoft.math.model.Node)eq.getMath())).append((Object)eq.getVariable())).filter(s -> !s.contains("$"))).toSet();
    }

    public static void arrangePorts(Diagram diagram) {
        SemanticController controller = diagram.getType().getSemanticController();
        DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
        builder.createDiagramView(diagram, ApplicationUtils.getGraphics());
        List ports = ((StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> Util.isPort(n))).toList();
        int x = diagram.stream(Node.class).map(n -> n.getView().getBounds()).mapToInt(b -> b.x + b.width).max().orElse(0) + 50;
        int y = 50;
        for (Node port : ports) {
            port.setLocation(new Point(x, y));
            y += 50;
            for (Edge e : port.edges()) {
                controller.recalculateEdgePath(e);
            }
        }
    }

    public static class SplitDiagramActionParametersBeanInfo
    extends BeanInfoEx2<SplitDiagramActionParameters> {
        public SplitDiagramActionParametersBeanInfo() {
            super(SplitDiagramActionParameters.class);
        }

        protected void initProperties() throws Exception {
            this.add("subDiagramName");
            this.add("autoIncludeReactions");
            this.add("addModule");
        }
    }

    public static class SplitDiagramActionParameters {
        private String subDiagramName;
        private DataElementPath resultPath;
        private boolean autoIncludeReactions = false;
        private boolean addModule = false;

        @PropertyName(value="Module name")
        @PropertyDescription(value="Module name.")
        public String getSubDiagramName() {
            return this.subDiagramName;
        }

        public void setSubDiagramName(String subDiagramName) {
            this.subDiagramName = subDiagramName;
        }

        @PropertyName(value="Add all reactions for selected species")
        @PropertyDescription(value="Add all reactions for selected species.")
        public boolean isAutoIncludeReactions() {
            return this.autoIncludeReactions;
        }

        public void setAutoIncludeReactions(boolean autoIncludeReactions) {
            this.autoIncludeReactions = autoIncludeReactions;
        }

        @PropertyName(value="Add created diagram as a module")
        @PropertyDescription(value="Add created diagram as a module.")
        public boolean isAddModule() {
            return this.addModule;
        }

        public void setAddModule(boolean addModule) {
            this.addModule = addModule;
        }

        public SplitDiagramActionParameters() {
            this.subDiagramName = "Module";
        }

        public SplitDiagramActionParameters(List<DataElement> elements) {
            if (!elements.isEmpty()) {
                Diagram diagram = Diagram.getDiagram((DiagramElement)elements.get(0));
                this.subDiagramName = DefaultSemanticController.generateUniqueNodeName(diagram, "Module");
            }
            this.subDiagramName = "Module";
        }

        public DataElementPath getResultPath() {
            return this.resultPath;
        }

        public void setResultPath(DataElementPath resultPath) {
            this.resultPath = resultPath;
        }
    }
}

