/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.standard.diagram.SemanticRelationPane;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class SimpleEdgePane
extends SemanticRelationPane {
    protected static final Logger log = Logger.getLogger(SimpleEdgePane.class.getName());
    protected Stub edgeStub;
    protected String edgeName;
    protected String edgeType;
    protected DynamicPropertySet initAttributes;
    protected Edge newEdge;

    public SimpleEdgePane(Module module, ViewEditorPane viewEditor, String edgeName, String edgeType, DynamicPropertySet initAttributes) {
        super(module, viewEditor);
        this.edgeName = edgeName;
        this.edgeType = edgeType;
        this.initAttributes = initAttributes;
    }

    @Override
    protected boolean createRelation() {
        try {
            Stub edgeStub;
            this.edgeStub = edgeStub = new Stub(null, this.edgeName, this.edgeType);
            return true;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "Exception: " + t, "Error", 0);
            return false;
        }
    }

    @Override
    protected void createEdge() {
        try {
            Diagram diagram;
            SemanticController semanticController;
            Node inNode = (Node)this.inSelector.getDiagramElement();
            Node outNode = (Node)this.outSelector.getDiagramElement();
            Compartment origin = Node.findCommonOrigin(inNode, outNode);
            this.newEdge = new Edge(origin, this.edgeStub.getName(), this.edgeStub, inNode, outNode);
            if (this.initAttributes != null) {
                for (DynamicProperty property : this.initAttributes) {
                    this.newEdge.getAttributes().add(property);
                }
            }
            if ((semanticController = (diagram = Diagram.getDiagram(origin)).getType().getSemanticController()).canAccept(origin, this.newEdge)) {
                if (semanticController instanceof XmlDiagramSemanticController) {
                    Edge validatedEdge = (Edge)((XmlDiagramSemanticController)semanticController).getPrototype().validate(origin, this.newEdge);
                    this.viewEditor.add((Object)validatedEdge, new Point(0, 0));
                } else {
                    this.viewEditor.add((Object)this.newEdge, new Point(0, 0));
                }
            } else {
                JOptionPane.showMessageDialog(null, "can't create edge with '" + inNode.getKernel().getType() + "' input and '" + outNode.getKernel().getType() + "' output");
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not create Edge for relation '" + this.edgeStub.getName() + "'", t);
        }
    }

    @Override
    public void release() {
        this.viewEditor.setSelectionEnabled(true);
        this.viewEditor.removeViewPaneListener((ViewPaneListener)this.adapter);
    }

    @Override
    public void okPressed() {
        this.createEdge();
        this.release();
    }

    @Override
    protected void cancelPressed() {
        this.release();
    }
}

