/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementProperties;
import biouml.model.Node;
import biouml.standard.diagram.Bus;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Simple Bus properties")
@PropertyDescription(value="Simple Bus properties.")
public class SimpleBusProperties
extends Option
implements InitialElementProperties {
    protected String name;
    private boolean newBus = true;
    private boolean directed = false;
    private Color color = Color.RED;
    private Map<String, Bus> nameToBus = new HashMap<String, Bus>();

    public SimpleBusProperties(Diagram diagram) {
        this.name = DefaultSemanticController.generateUniqueName(diagram, "Bus");
        this.nameToBus = ((StreamEx)diagram.recursiveStream().map(n -> n.getRole()).select(Bus.class).distinct()).toMap(b -> b.getName(), b -> b);
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="New bus name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    @PropertyName(value="Existing bus")
    @PropertyDescription(value="Existing bus name")
    public String getExistingName() {
        return this.name;
    }

    public void setExistingName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public void setNewBus(boolean newBus) {
        Boolean oldValue = this.newBus;
        this.newBus = newBus;
        this.setName(newBus ? "" : this.getExistingBuses().findAny().orElse(""));
        this.firePropertyChange("newBus", oldValue, newBus);
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="New bus")
    @PropertyDescription(value="If true then this bus will be new.")
    public boolean isNewBus() {
        return this.newBus;
    }

    public boolean isExistingBus() {
        return !this.newBus;
    }

    public Stream<String> getExistingBuses() {
        return this.nameToBus.keySet().stream();
    }

    public Bus findBus(String name) {
        return this.nameToBus.get(name);
    }

    @Override
    public DiagramElementGroup createElements(Compartment compartment, Point location, ViewEditorPane viewPane) throws Exception {
        Bus bus;
        if (this.name.isEmpty()) {
            throw new Exception("Can not create new Bus node with empty bus name");
        }
        String nodeName = DefaultSemanticController.generateUniqueName(Diagram.getDiagram(compartment), this.name);
        Node node = new Node(compartment, nodeName, (Base)new Stub(null, nodeName, "connection bus"));
        Bus bus2 = bus = this.newBus ? new Bus(this.name, this.directed) : this.findBus(this.name);
        if (bus == null) {
            throw new Exception("Can not create new Bus node for Bus " + this.name + ". Can not find it.");
        }
        if (this.newBus) {
            bus.setColor(this.color);
        }
        bus.addNode(node);
        node.setRole(bus);
        node.setTitle(bus.getName());
        if (viewPane != null) {
            node.setNotificationEnabled(true);
            boolean isNotificationEnabled = compartment.isNotificationEnabled();
            compartment.setNotificationEnabled(true);
            viewPane.add((Object)node, location);
            compartment.setNotificationEnabled(isNotificationEnabled);
        }
        return new DiagramElementGroup(node);
    }

    @PropertyName(value="Directed")
    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    @PropertyName(value="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

