/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.diagram.DiagramElementSelector;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.type.Base;
import biouml.standard.type.SemanticRelation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.support.IdGenerator;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class SemanticRelationPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(SemanticRelationPane.class.getName());
    protected DiagramElementSelector inSelector;
    protected DiagramElementSelector outSelector;
    protected Base relation;
    protected Module module;
    protected ViewEditorPane viewEditor;
    protected ViewPaneAdapter adapter;
    protected JButton okButton;
    protected DataCollection relationDC;

    public SemanticRelationPane(Module module, ViewEditorPane viewEditor) {
        super(new GridBagLayout());
        this.module = module;
        this.viewEditor = viewEditor;
        viewEditor.setSelectionEnabled(false);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        ResourceBundle resources = ResourceBundle.getBundle(MessageBundle.class.getName());
        this.inSelector = new DiagramElementSelector(resources.getString("RELATION_IN"));
        this.outSelector = new DiagramElementSelector(resources.getString("RELATION_OUT"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inSelector.getRadioButton());
        buttonGroup.add(this.outSelector.getRadioButton());
        this.inSelector.getRadioButton().setSelected(true);
        this.add((Component)this.inSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.outSelector, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)new JLabel(resources.getString("RELATION_DESCRIPTION")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(30, 0, 0, 0), 0, 0));
        this.adapter = new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                Object model = e.getViewSource().getModel();
                if (model instanceof DiagramElement) {
                    if (SemanticRelationPane.this.inSelector.isSelected()) {
                        SemanticRelationPane.this.inSelector.setDiagramElement((DiagramElement)((Object)model));
                        SemanticRelationPane.this.outSelector.getRadioButton().setSelected(true);
                    } else {
                        SemanticRelationPane.this.outSelector.setDiagramElement((DiagramElement)((Object)model));
                    }
                    if (SemanticRelationPane.this.inSelector.getDiagramElement() != null && SemanticRelationPane.this.outSelector.getDiagramElement() != null) {
                        boolean status = SemanticRelationPane.this.createRelation();
                        if (SemanticRelationPane.this.okButton != null) {
                            SemanticRelationPane.this.okButton.setEnabled(status);
                        }
                    }
                }
            }
        };
        viewEditor.addViewPaneListener((ViewPaneListener)this.adapter);
    }

    protected boolean createRelation() {
        try {
            Base in = this.inSelector.getDiagramElement().getKernel();
            Base out = this.outSelector.getDiagramElement().getKernel();
            String inElementName = DataElementPath.EMPTY_PATH.getChildPath(new String[]{in.getOrigin().getName(), in.getName()}).toString();
            String outElementName = DataElementPath.EMPTY_PATH.getChildPath(new String[]{out.getOrigin().getName(), out.getName()}).toString();
            String relationName = inElementName + " -> " + outElementName;
            this.relationDC = this.module.getCategory(SemanticRelation.class);
            String id = relationName;
            String formatter = this.relationDC.getInfo().getProperty("id-format");
            if (formatter != null) {
                id = IdGenerator.generateUniqueName((DataCollection)this.relationDC, (DecimalFormat)new DecimalFormat(formatter));
            }
            SemanticRelation sr = new SemanticRelation((DataCollection<?>)this.relationDC, id, " ");
            sr.setTitle(" ");
            sr.setInputElementName(inElementName);
            sr.setOutputElementName(outElementName);
            sr.setParticipation("");
            this.relation = sr;
            return true;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "Exception: " + t, "Error", 0);
            return false;
        }
    }

    protected void createEdge() {
        try {
            int result;
            SemanticRelation sr;
            boolean useOldKernel = false;
            if (this.relationDC != null && (sr = this.findRelation()) != null && (result = JOptionPane.showConfirmDialog(this, "Relation with the same input and output already exists. Would you like to use old relation?")) == 0) {
                useOldKernel = true;
                this.relation = sr;
            }
            if (!useOldKernel) {
                CollectionFactoryUtils.save((DataElement)this.relation);
            }
            Node inNode = (Node)this.inSelector.getDiagramElement();
            Node outNode = (Node)this.outSelector.getDiagramElement();
            Edge edge = new Edge(this.relation, inNode, outNode);
            this.viewEditor.add((Object)edge, new Point(0, 0));
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not create Edge for relation '" + this.relation.getName() + "'", t);
        }
    }

    public void release() {
        this.viewEditor.setSelectionEnabled(true);
        this.viewEditor.removeViewPaneListener((ViewPaneListener)this.adapter);
    }

    public void okPressed() {
        this.createEdge();
        this.release();
    }

    protected void cancelPressed() {
        this.release();
    }

    private SemanticRelation findRelation() throws Exception {
        SemanticRelation sr = null;
        return sr;
    }
}

