/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.GlobalViewOptions;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.diagram.ReactionEditPane;
import biouml.standard.diagram.ReactionInitialProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class ReactionPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(ReactionEditPane.class.getName());
    protected ReactionInitialProperties properties = null;
    protected Diagram diagram;
    protected Compartment compartment;
    protected Reaction reactionTemplate;
    protected Point point;
    protected ViewEditorPane viewEditor;
    protected ViewPaneAdapter adapter;
    protected JTextField titleField;
    protected JTextField reactionName;
    protected JTextField reactionTitle;
    protected JTextField componentName;
    protected JTextField variableName;
    protected ReactionEditPane reactionEditPane = null;
    protected JComboBox<String> componentRole;
    protected ResourceBundle resources = ResourceBundle.getBundle(MessageBundle.class.getName());
    protected DefaultRowModel components;
    protected TabularPropertyInspector componentsTable;
    private JTabbedPane tabbedPane;
    private JButton addButton;
    private JButton removeButton;
    protected boolean newReaction;
    private boolean simulatable;

    public ReactionPane(Reaction reaction, Diagram diagram, Compartment compartment, Point point, ViewEditorPane viewEditor) {
        this(reaction, diagram, compartment, point, viewEditor, null);
    }

    public ReactionPane(Diagram diagram, Compartment compartment, Point point, ViewEditorPane viewEditor) {
        this(null, diagram, compartment, point, viewEditor, null);
    }

    public ReactionPane(Diagram diagram, Compartment compartment, Point point, ViewEditorPane viewEditor, ReactionInitialProperties properties) {
        this(null, diagram, compartment, point, viewEditor, properties);
    }

    public ReactionPane(Reaction reaction, final Diagram diagram, Compartment compartment, Point point, ViewEditorPane viewEditor, ReactionInitialProperties properties) {
        super(new BorderLayout());
        this.properties = properties;
        this.diagram = diagram;
        this.compartment = compartment;
        this.point = point;
        this.viewEditor = viewEditor;
        this.newReaction = reaction == null;
        this.simulatable = diagram.getRole() instanceof EModel;
        String reactionName = ReactionInitialProperties.generateReactionName(diagram);
        this.reactionTemplate = this.newReaction ? new Reaction(null, reactionName) : reaction;
        this.tabbedPane = new JTabbedPane();
        this.components = new DefaultRowModel();
        this.componentsTable = new TabularPropertyInspector();
        viewEditor.setSelectionEnabled(false);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.createReactionNamePanel(), "North");
        Node reactionNode = Util.findNode(diagram, this.reactionTemplate);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createEditComponentsPanel(), "North");
        mainPanel.add((Component)this.createComponentListPanel(this.components, this.componentsTable), "Center");
        if (this.simulatable) {
            this.tabbedPane.addTab("Components", mainPanel);
            this.reactionEditPane = new ReactionEditPane(this.reactionTemplate, reactionNode != null ? reactionNode.getRole() : null, diagram, this.components, this.newReaction, true);
            this.tabbedPane.addTab("Edit formula", this.reactionEditPane);
            this.add((Component)this.tabbedPane, "Center");
        } else {
            this.add((Component)mainPanel, "Center");
        }
        this.addButton.addActionListener(e -> this.addComponent(this.componentName.getText(), (String)this.componentRole.getSelectedItem()));
        this.removeButton.addActionListener(e -> this.removeComponent(this.componentsTable.getTable().getSelectedRow()));
        this.componentsTable.getTable().getSelectionModel().addListSelectionListener(e -> this.removeButton.setEnabled(this.componentsTable.getTable().getSelectedRow() >= 0));
        this.adapter = new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                Object model = e.getViewSource().getModel();
                if (model instanceof Role) {
                    model = ((Role)model).getDiagramElement();
                }
                if (model instanceof Node) {
                    Node node = (Node)((Object)model);
                    if (!diagram.getType().getSemanticController().isAcceptableForReaction(node)) {
                        return;
                    }
                    ReactionPane.this.componentName.setText(CollectionFactory.getRelativeName((DataElement)node, (DataCollection)ReactionPane.this.diagram));
                    ReactionPane.this.addButton.setEnabled(true);
                    if (ReactionPane.this.simulatable) {
                        String variable = "";
                        if (node.getRole() instanceof VariableRole) {
                            variable = node.getRole(VariableRole.class).getName();
                            variable = diagram.getRole(EModel.class).getQualifiedName(variable, node, GlobalViewOptions.getVarNameMode());
                        }
                        ReactionPane.this.variableName.setText(variable);
                    }
                }
            }
        };
        viewEditor.addViewPaneListener((ViewPaneListener)this.adapter);
    }

    protected void removeComponent(int index) {
        if (index >= 0 && index < this.components.size()) {
            this.components.remove(index);
            this.buildReactionTitle();
            if (this.simulatable) {
                this.reactionEditPane.changeComponents();
            }
        }
    }

    private void buildReactionTitle() {
        this.titleField.setText(DiagramUtility.generateReactionTitle(this.getComponentList()));
    }

    public List<SpecieReference> getComponentList() {
        ArrayList<SpecieReference> componentsList = new ArrayList<SpecieReference>();
        for (int i = 0; i < this.components.size(); ++i) {
            componentsList.add((SpecieReference)this.components.getBean(i));
        }
        return componentsList;
    }

    public void release() {
        this.viewEditor.setSelectionEnabled(true);
        this.viewEditor.removeViewPaneListener((ViewPaneListener)this.adapter);
    }

    public boolean okPressed() {
        try {
            boolean result;
            boolean bl = result = this.newReaction ? this.createReaction() : this.modifyReaction();
            if (!result) {
                return false;
            }
        }
        catch (CreateReactionException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.resources.getString("REACTION_ERROR_TITLE"), 0);
            return false;
        }
        catch (Exception ex) {
            String dialogTitle = this.resources.getString("REACTION_ERROR_TITLE");
            String message = this.resources.getString("REACTION_ERROR_MESSAGE") + ex.getMessage();
            JOptionPane.showMessageDialog(this, message, dialogTitle, 0);
            return false;
        }
        this.release();
        return true;
    }

    protected void cancelPressed() {
        this.release();
    }

    public void addComponent(String name, String role) {
        for (int i = 0; i < this.components.size(); ++i) {
            SpecieReference component = (SpecieReference)this.components.getBean(i);
            if (!component.getName().equals(name) || !component.getRole().equals(role)) continue;
            String title = this.resources.getString("REACTION_ERROR_TITLE");
            String message = this.resources.getString("REACTION_COMPONENT_DUPLICATED");
            message = MessageFormat.format(message, name, role);
            JOptionPane.showMessageDialog(this, message, title, 0);
            return;
        }
        try {
            SpecieReference component = new SpecieReference(this.reactionTemplate, name, role);
            boolean notificationEnabled = component.isNotificationEnabled();
            component.setNotificationEnabled(false);
            DiagramElement de = (DiagramElement)CollectionFactory.getDataElement((String)component.getName(), (DataCollection)this.diagram);
            if (de != null) {
                component.setTitle(SpecieReference.generateSpecieReferenceName(this.reactionTemplate.getName(), de.getKernel().getName(), role));
                component.setSpecie(CollectionFactory.getRelativeName((DataElement)de, (DataCollection)Module.getModule((DataElement)de)));
            } else {
                component.setTitle(SpecieReference.generateSpecieReferenceName(this.reactionTemplate.getName(), name, role));
                component.setSpecie(name);
            }
            component.setInitialized(false);
            if (notificationEnabled) {
                component.setNotificationEnabled(true);
            }
            component.addPropertyChangeListener(l -> {
                if (l.getPropertyName().equals("role")) {
                    this.buildReactionTitle();
                }
            });
            this.components.add((Object)component);
            if (this.simulatable) {
                this.reactionEditPane.changeComponents();
            }
            this.buildReactionTitle();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not add reaction component " + name + " as " + role, t);
        }
    }

    protected boolean createReaction() throws Exception {
        String message;
        int res;
        if (!this.isReactionValid() && (res = JOptionPane.showConfirmDialog(this, message = this.resources.getString("REACTION_IS_EMPTY"), "", 0, 2)) != 0) {
            return false;
        }
        this.viewEditor.startTransaction("Create reaction");
        List<SpecieReference> componentsList = this.getComponentList();
        componentsList.stream().forEach(sr -> sr.setInitialized(true));
        if (this.properties != null) {
            this.properties.setReactionName(this.reactionName.getText());
            if (this.simulatable) {
                this.properties.setKineticlaw(new KineticLaw(this.reactionEditPane.getFormula()));
            }
            this.properties.setReactionTitle(this.getReactionTitle());
            this.properties.setSpecieReferences(componentsList);
            DiagramElementGroup group = this.properties.createElements(this.compartment, this.point, this.viewEditor);
            this.properties.putResults(group);
        } else {
            String formula = this.simulatable ? this.reactionEditPane.getFormula() : "";
            DiagramUtility.createReactionNode(this.diagram, this.compartment, this.reactionTemplate, componentsList, formula, this.point, null);
        }
        this.viewEditor.completeTransaction();
        return true;
    }

    protected boolean modifyReaction() throws Exception {
        String message;
        int res;
        if (!this.isReactionValid() && (res = JOptionPane.showConfirmDialog(this, message = this.resources.getString("REACTION_IS_EMPTY"), "", 0, 2)) != 0) {
            return false;
        }
        Node reactionNode = Util.findNode(this.diagram, this.reactionTemplate);
        this.reactionTemplate.setTitle(this.titleField.getText());
        if (this.simulatable) {
            this.reactionTemplate.setKineticLaw(new KineticLaw(this.reactionEditPane.getFormula()));
        }
        List<SpecieReference> componentsList = this.getComponentList();
        HashMap oldComponents = new HashMap();
        this.reactionTemplate.stream().forEach(sr -> oldComponents.put(sr.getName(), sr));
        ReactionInitialProperties props = (ReactionInitialProperties)this.diagram.getType().getSemanticController().getPropertiesByType(this.diagram, Reaction.class, null);
        DiagramElementGroup result = new DiagramElementGroup();
        HashMap<String, BaseSupport> specieToRole = new HashMap<String, BaseSupport>();
        this.viewEditor.startTransaction("Modify reaction");
        for (SpecieReference prototype : componentsList) {
            String key = prototype.getSpecie() + prototype.getRole();
            if (specieToRole.containsKey(key)) {
                SpecieReference ref = (SpecieReference)specieToRole.get(key);
                String stoichiometry = ref.getStoichiometry();
                if (!stoichiometry.startsWith("-")) {
                    stoichiometry = "+" + stoichiometry;
                }
                ref.setStoichiometry(prototype.getStoichiometry() + stoichiometry);
                continue;
            }
            String specieReferenceName = prototype.getName();
            Node specieNode = null;
            DiagramElement de = this.diagram.findDiagramElement(DiagramUtility.toDiagramPath(specieReferenceName));
            if (de == null || !(de instanceof Node)) {
                de = this.diagram.findNode(DiagramUtility.toDiagramPath(prototype.getSpecie()));
            }
            if (de != null && de instanceof Node) {
                specieNode = (Node)de;
            }
            if (specieNode == null) continue;
            BaseSupport real = null;
            if (this.reactionTemplate.contains(specieReferenceName)) {
                SpecieReference old = this.reactionTemplate.get(specieReferenceName);
                if (prototype.equals(old)) {
                    real = old;
                } else {
                    this.reactionTemplate.remove(specieReferenceName);
                    real = prototype.clone(this.reactionTemplate, specieReferenceName);
                    String specieLink = ReactionInitialProperties.getReactionOrigin(this.diagram) != null ? CollectionFactory.getRelativeName((DataElement)specieNode.getKernel(), (DataCollection)Module.getModule((DataElement)this.diagram)) : specieNode.getCompleteNameInDiagram();
                    ((SpecieReference)real).setSpecie(specieLink);
                    this.reactionTemplate.put((SpecieReference)real);
                }
                Edge oldEdge = reactionNode.edges().findFirst(e -> e.getKernel().equals(old)).orElse(null);
                Path path = null;
                if (oldEdge != null) {
                    path = oldEdge.getPath();
                    try {
                        oldEdge.getInput().removeEdge(oldEdge);
                        oldEdge.getOutput().removeEdge(oldEdge);
                        oldEdge.getOrigin().remove(oldEdge.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Edge edge = props.createEdge((SpecieReference)real, reactionNode, specieNode);
                if (path != null) {
                    edge.setPath(path);
                }
                result.add(edge);
                oldComponents.remove(specieReferenceName);
            } else {
                real = prototype.clone(this.reactionTemplate, specieReferenceName);
                String specieLink = ReactionInitialProperties.getReactionOrigin(this.diagram) != null ? CollectionFactory.getRelativeName((DataElement)specieNode.getKernel(), (DataCollection)Module.getModule((DataElement)this.diagram)) : specieNode.getCompleteNameInDiagram();
                ((SpecieReference)real).setSpecie(specieLink);
                this.reactionTemplate.put((SpecieReference)real);
                Edge edge = props.createEdge((SpecieReference)real, reactionNode, specieNode);
                result.add(edge);
            }
            specieToRole.put(key, real);
        }
        result.putToCompartment();
        HashSet toRemove = new HashSet();
        for (SpecieReference removed : oldComponents.values()) {
            ((StreamEx)reactionNode.edges().filter(e -> e.getKernel().equals(removed))).forEach(e -> toRemove.add(e));
            this.reactionTemplate.remove(removed.getName());
        }
        for (Edge oldEdge : toRemove) {
            oldEdge.getInput().removeEdge(oldEdge);
            oldEdge.getOutput().removeEdge(oldEdge);
            oldEdge.getOrigin().remove(oldEdge.getName());
        }
        DiagramUtility.generateRoles(this.diagram, reactionNode);
        this.viewEditor.completeTransaction();
        return true;
    }

    protected boolean isReactionValid() {
        return this.getComponentList().stream().filter(c -> c.isReactantOrProduct()).count() > 0L;
    }

    private JPanel createReactionNamePanel() {
        this.reactionName = new JTextField(30);
        DataCollection<Reaction> module = ReactionInitialProperties.getReactionOrigin(this.diagram);
        if (!this.newReaction || module != null) {
            this.reactionName.setEditable(false);
        } else {
            this.reactionName.setEditable(true);
        }
        this.reactionName.setText(this.reactionTemplate.getName());
        this.reactionName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String newName = ReactionPane.this.diagram.getType().getSemanticController().validateName(ReactionPane.this.reactionName.getText());
                ReactionPane.this.reactionName.setText(newName);
            }
        });
        JPanel reactionNamePanel = new JPanel(new BorderLayout());
        reactionNamePanel.setBorder(new EmptyBorder(new Insets(10, 0, 10, 10)));
        reactionNamePanel.add((Component)new JLabel(this.resources.getString("REACTION_NAME")), "Before");
        reactionNamePanel.add((Component)this.reactionName, "After");
        this.titleField = new JTextField(30);
        this.titleField.setText(this.newReaction ? "" : this.reactionTemplate.getTitle());
        JPanel reactionTitlePanel = new JPanel(new BorderLayout());
        reactionTitlePanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 0)));
        reactionTitlePanel.add((Component)new JLabel(this.resources.getString("REACTION_TITLE")), "Before");
        reactionTitlePanel.add((Component)this.titleField, "After");
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)reactionNamePanel, "Before");
        result.add((Component)reactionTitlePanel, "After");
        result.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        return result;
    }

    private JPanel createComponentListPanel(DefaultRowModel components, TabularPropertyInspector componentsTable) {
        JPanel componentsPanel = new JPanel(new BorderLayout(10, 10));
        componentsPanel.setBorder(new TitledBorder(new EmptyBorder(10, 10, 10, 10), this.resources.getString("REACTION_COMPONENTS_PANEL")));
        Dimension size = new Dimension(600, 100);
        componentsTable.setMinimumSize(size);
        componentsTable.setPreferredSize(size);
        componentsTable.getTable().setSelectionMode(0);
        componentsTable.explore((RowModel)components, (Object)new SpecieReference(null, "template"), 0);
        componentsTable.getTable().setAutoResizeMode(4);
        componentsPanel.add((Component)new JScrollPane((Component)componentsTable), "Center");
        return componentsPanel;
    }

    private JPanel createEditComponentsPanel() {
        JLabel componentNameLabel = new JLabel(this.resources.getString("REACTION_COMPONENT_NAME"));
        this.componentName = new JTextField(30);
        this.componentName.setEditable(false);
        JLabel variableLabel = new JLabel(this.resources.getString("REACTION_VARIABLE_NAME"));
        this.variableName = new JTextField(30);
        this.variableName.setEditable(false);
        componentNameLabel.setPreferredSize(variableLabel.getPreferredSize());
        JLabel componentRoleLabel = new JLabel(this.resources.getString("REACTION_COMPONENT_ROLE"));
        this.componentRole = new JComboBox<String>(new String[]{"reactant", "product", "modifier"});
        this.addButton = new JButton(this.resources.getString("REACTION_ADD_COMPONENT"));
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(this.resources.getString("REACTION_REMOVE_COMPONENT"));
        this.removeButton.setEnabled(false);
        JPanel componentPanel = new JPanel(new GridBagLayout());
        componentPanel.setBorder(new TitledBorder(new EmptyBorder(10, 10, 10, 10), this.resources.getString("REACTION_COMPONENT_PANEL")));
        JPanel componentNamePanel = new JPanel(new BorderLayout(5, 5));
        componentNamePanel.add((Component)componentNameLabel, "West");
        componentNamePanel.add((Component)this.componentName, "Center");
        JPanel componentRolePanel = new JPanel(new BorderLayout(5, 5));
        componentRolePanel.add((Component)componentRoleLabel, "West");
        componentRolePanel.add(this.componentRole, "Center");
        componentPanel.add((Component)componentNamePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        componentPanel.add((Component)componentNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        componentPanel.add((Component)this.componentName, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        componentPanel.add((Component)componentRolePanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        componentPanel.add((Component)this.addButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        componentPanel.add((Component)this.removeButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        componentPanel.add((Component)variableLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        componentPanel.add((Component)this.variableName, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        componentPanel.add((Component)new JLabel(this.resources.getString("REACTION_HELP_MESSAGE")), new GridBagConstraints(3, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        return componentPanel;
    }

    public String getReactionTitle() {
        return this.titleField.getText();
    }

    public static class CreateReactionException
    extends Exception {
        public CreateReactionException(String str) {
            super(str);
        }
    }
}

