/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.InitialElementProperties;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.Option;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class ReactionInitialProperties
implements InitialElementProperties {
    private List<SpecieReference> references = new ArrayList<SpecieReference>();
    private DataCollection origin;
    private KineticLaw kineticLaw = new KineticLaw();
    private Reaction reaction;
    private String reactionName = null;
    private String reactionTitle = null;

    public void setSpecieReferences(List<SpecieReference> references) {
        this.references = references;
    }

    public void setKineticlaw(KineticLaw kineticLaw) {
        this.kineticLaw = kineticLaw;
    }

    public void setReactionName(String name) {
        this.reactionName = name;
    }

    public String getReactionName() {
        return this.reactionName;
    }

    public String getReactionTitle() {
        return this.reactionTitle;
    }

    public void setReactionTitle(String reactionTitle) {
        this.reactionTitle = reactionTitle;
    }

    @Override
    public DiagramElementGroup createElements(Compartment compartment, Point location, ViewEditorPane viewPane) throws Exception {
        Diagram diagram = Diagram.getDiagram(compartment);
        boolean notificationEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(false);
        this.origin = this.initReactionOrigin(diagram);
        if (this.reactionName != null && this.origin == null && diagram.recursiveStream().map(de -> de.getName()).toSet().contains(this.reactionName)) {
            throw new IllegalArgumentException("Reaction with name " + this.reactionName + " already exists.");
        }
        if (this.reactionName == null) {
            this.reactionName = DefaultSemanticController.generateReactionName(this.origin != null ? this.origin : diagram);
        }
        this.reaction = new Reaction((DataCollection<?>)this.origin, this.reactionName);
        this.reaction.setTitle(this.reactionTitle != null ? this.reactionTitle : DiagramUtility.generateReactionTitle(this.references));
        this.reaction.setKineticLaw(this.kineticLaw);
        Node reactionNode = new Node(compartment, (Base)this.reaction);
        this.reaction.setParent((Option)reactionNode);
        reactionNode.setShowTitle(false);
        reactionNode.setNotificationEnabled(false);
        reactionNode.setRelativeLocation(diagram, location);
        DiagramElementGroup result = new DiagramElementGroup(reactionNode);
        for (SpecieReference prototype : this.references) {
            result.add(this.createSpecieReference(diagram, prototype, reactionNode));
        }
        DiagramUtility.generateRoles(diagram, reactionNode);
        reactionNode.setNotificationEnabled(true);
        diagram.setNotificationEnabled(notificationEnabled);
        return result;
    }

    private Edge createSpecieReference(Diagram diagram, SpecieReference prototype, Node reactionNode) throws Exception {
        Node de = diagram.findNode(DiagramUtility.toDiagramPath(prototype.getName()));
        if (de == null) {
            de = diagram.findNode(DiagramUtility.toDiagramPath(prototype.getSpecie()));
        }
        if (!this.acceptForReaction(de)) {
            throw new Exception("incorrect reaction participant: " + de.getName());
        }
        String id = SpecieReference.generateSpecieReferenceName(this.reaction.getName(), de.getKernel().getName(), prototype.getRole());
        id = DefaultSemanticController.generateUniqueName(diagram, id);
        BaseSupport real = prototype.clone(this.reaction, id);
        String specieLink = this.origin != null ? CollectionFactory.getRelativeName((DataElement)de.getKernel(), (DataCollection)Module.getModule((DataElement)diagram)) : de.getCompleteNameInDiagram();
        ((SpecieReference)real).setSpecie(specieLink);
        this.reaction.put((SpecieReference)real);
        return this.createEdge((SpecieReference)real, reactionNode, de);
    }

    public Edge createEdge(SpecieReference sr, Node reactionNode, Node otherNode) {
        Edge edge = sr.isProduct() ? new Edge(sr, reactionNode, otherNode) : new Edge(sr, otherNode, reactionNode);
        reactionNode.addEdge(edge);
        return edge;
    }

    public boolean acceptForReaction(Node node) {
        return node != null && node.getRole() instanceof VariableRole && !(node instanceof Compartment);
    }

    public void putResults(List<DiagramElement> elements) {
        StreamEx.of(elements).select(Node.class).forEach(n -> n.getOrigin().put((DataElement)n));
        StreamEx.of(elements).select(Edge.class).forEach(e -> e.getOrigin().put((DataElement)e));
        if (this.reaction != null && this.reaction.getOrigin() != null) {
            this.reaction.getOrigin().put((DataElement)this.reaction);
        }
    }

    public void putResults(DiagramElementGroup elements) {
        elements.nodesStream().forEach(n -> n.getOrigin().put((DataElement)n));
        elements.edgesStream().forEach(e -> e.getOrigin().put((DataElement)e));
        this.putReaction();
    }

    public void putReaction() {
        if (this.reaction != null && this.reaction.getOrigin() != null) {
            this.reaction.getOrigin().put((DataElement)this.reaction);
        }
    }

    protected DataCollection<Reaction> initReactionOrigin(Diagram diagram) {
        return ReactionInitialProperties.getReactionOrigin(diagram);
    }

    public static DataCollection<Reaction> getReactionOrigin(Diagram diagram) {
        Module module = null;
        try {
            module = Module.getModule((DataElement)diagram);
        }
        catch (InternalException ex) {
            return null;
        }
        return module.getType().isCategorySupported() ? module.getCategory(Reaction.class) : null;
    }

    public static String generateReactionName(Diagram diagram) {
        DataCollection<Reaction> origin = ReactionInitialProperties.getReactionOrigin(diagram);
        if (origin == null) {
            return DefaultSemanticController.generateUniqueName(diagram, "Reaction", false);
        }
        return DefaultSemanticController.generateReactionName(origin);
    }
}

