/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.GlobalViewOptions;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.standard.diagram.ReactionEditPane;
import biouml.standard.type.Reaction;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.math.Expression;
import ru.biosoft.math.ExpressionEditorPane;
import ru.biosoft.math.model.AbstractParser;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.math.view.FormulaViewBuilder;

public class ReactionFormulaPanel
extends JPanel {
    private final AbstractParser linearParser = new Parser();
    protected FormulaViewBuilder viewBuilder = new FormulaViewBuilder();
    protected Expression expression;
    protected ViewPane reactionView;
    private int status = 0;

    public ReactionFormulaPanel(EModel emodel, Reaction reaction, Role reactionRole) {
        super(new BorderLayout(10, 10));
        this.setBorder(new TitledBorder(new EmptyBorder(10, 10, 10, 10), ReactionEditPane.resources.getString("REACTION_RATE_PANEL")));
        this.reactionView = new ViewPane();
        this.reactionView.setPreferredSize(new Dimension(0, 100));
        this.initExpression(emodel, reaction, reactionRole);
        this.add((Component)this.reactionView, "Center");
    }

    protected void processFormulaEvent(String text) {
        if (this.expression == null) {
            return;
        }
        this.linearParser.setDeclareUndefinedVariables(false);
        this.linearParser.setContext(this.expression.getParserContext());
        this.status = 0;
        try {
            this.status = this.linearParser.parse(text);
        }
        catch (Exception ex) {
            this.status |= 4;
        }
        if ((this.status & 4) == 0) {
            this.expression.setAstStart(this.linearParser.getStartNode());
            if (this.isVisible()) {
                CompositeView expressionView = this.viewBuilder.createView(this.expression.getAstStart(), (Graphics)ApplicationUtils.getGraphics());
                int x = 0;
                if ((double)this.reactionView.getWidth() > expressionView.getBounds().getWidth()) {
                    x = (int)((double)this.reactionView.getWidth() - expressionView.getBounds().getWidth()) / 2;
                }
                int y = 0;
                if ((double)this.reactionView.getHeight() > expressionView.getBounds().getHeight()) {
                    y = (int)((double)this.reactionView.getHeight() - expressionView.getBounds().getHeight()) / 2;
                }
                this.reactionView.setView(expressionView, new Point(x, y));
            }
        }
    }

    private void initExpression(EModel emodel, Reaction reaction, Role reactionRole) {
        if (reaction != null) {
            AstStart astStart = emodel.readMath(reaction.getKineticLaw().getFormula(), reactionRole, GlobalViewOptions.getVarNameMode());
            this.expression = new Expression(null, ExpressionEditorPane.linearFormatter.format(astStart)[1]);
            this.expression.setAstStart(astStart);
        } else {
            this.expression = new Expression(null, "0");
        }
        this.expression.setParserContext((ParserContext)emodel);
        this.linearParser.setVariableResolver((VariableResolver)emodel.getVariableResolver(0));
    }

    public int getStatus() {
        return this.status;
    }
}

