/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.GlobalViewOptions;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.standard.diagram.FormulaTemplatePane;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.diagram.ReactionFormulaPanel;
import biouml.standard.type.Reaction;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.biosoft.math.ExpressionEditorPane;
import ru.biosoft.math.model.AstStart;

public class ReactionEditPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(ReactionEditPane.class.getName());
    protected static ResourceBundle resources = ResourceBundle.getBundle(MessageBundle.class.getName());
    protected Diagram diagram;
    protected ReactionFormulaPanel formulaPanel;
    protected DefaultRowModel components;
    protected JTextField reactionRate;
    protected FormulaTemplatePane specialPanel;
    protected Reaction reactionTemplate;
    protected JTextField titleField;
    public static final String RATE_SIMPLE_TAB_NAME = "Simple";

    public ReactionEditPane(Reaction reaction, Role reactionRole, Diagram diagram, DefaultRowModel components, boolean newReaction, boolean canModifyReaction) {
        super(new BorderLayout());
        this.diagram = diagram;
        this.components = components;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.reactionRate = new JTextField();
        this.formulaPanel = new ReactionFormulaPanel(diagram.getRole(EModel.class), reaction, reactionRole);
        this.add((Component)this.formulaPanel, "North");
        if (newReaction) {
            this.reactionRate.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ReactionEditPane.this.formulaPanel.processFormulaEvent(ReactionEditPane.this.reactionRate.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ReactionEditPane.this.formulaPanel.processFormulaEvent(ReactionEditPane.this.reactionRate.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ReactionEditPane.this.formulaPanel.processFormulaEvent(ReactionEditPane.this.reactionRate.getText());
                }
            });
        }
        JPanel simplePanel = new JPanel(new BorderLayout());
        simplePanel.add((Component)this.reactionRate, "North");
        this.specialPanel = new FormulaTemplatePane(this.reactionRate, components, diagram);
        tabbedPane.add("SBO template", this.specialPanel);
        tabbedPane.add(RATE_SIMPLE_TAB_NAME, simplePanel);
        this.add((Component)tabbedPane, "Center");
        this.formulaPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ReactionEditPane.this.formulaPanel.processFormulaEvent(ReactionEditPane.this.reactionRate.getText());
            }
        });
        this.initReactionInfo(reaction, reactionRole, canModifyReaction);
    }

    public String getFormula() {
        String formula = this.reactionRate.getText();
        if (formula.trim().isEmpty()) {
            return "0";
        }
        Role role = this.diagram.getRole();
        if (role instanceof EModel) {
            AstStart astStart = ((EModel)role).readMath(formula, null, 0);
            return ExpressionEditorPane.linearFormatter.format(astStart)[1];
        }
        return formula;
    }

    protected void initReactionInfo(Reaction reaction, Role reactionRole, boolean canModifyReaction) {
        if (reaction != null) {
            this.reactionTemplate = reaction;
            reaction.forEach(s -> {
                s.setInitialized(false);
                this.components.add(s);
            });
            this.specialPanel.changeComponents();
            String rateText = this.getTitledFormula(reaction.getFormula(), reaction, reactionRole);
            this.reactionRate.setText(rateText);
            this.formulaPanel.processFormulaEvent(rateText);
        }
    }

    protected String getTitledFormula(String formula, Reaction reaction, Role reactionRole) {
        Role role = this.diagram.getRole();
        if (role instanceof EModel) {
            AstStart astStart = ((EModel)role).readMath(formula, reactionRole, GlobalViewOptions.getVarNameMode());
            return ExpressionEditorPane.linearFormatter.format(astStart)[1];
        }
        return formula;
    }

    protected void changeComponents() {
        this.specialPanel.changeComponents();
    }
}

