/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementPropertiesSupport;
import biouml.model.Node;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Port properties")
@PropertyDescription(value="Port properties.")
public class PortProperties
extends InitialElementPropertiesSupport {
    protected String[] availableParameters;
    protected String[] availablePorts;
    protected String[] availableModules;
    private String name;
    private String title;
    private String portType;
    private String accessType = "public";
    private String varName = "";
    private String portName = "";
    private final Diagram diagram;
    private Compartment module;
    private boolean isTypeFixed = false;
    private List<Node> existingPorts;

    @Override
    public DiagramElementGroup doCreateElements(Compartment c, Point location, ViewEditorPane viewPane) throws Exception {
        return new DiagramElementGroup(DiagramUtility.createPortNode(c, this, viewPane, location));
    }

    public PortProperties(Diagram diagram, Class<? extends Base> type) {
        this(diagram, type == Stub.InputConnectionPort.class ? "input" : (type == Stub.OutputConnectionPort.class ? "output" : "contact"));
        if (type == Stub.ConnectionPort.class) {
            this.isTypeFixed = false;
        }
    }

    public PortProperties(Diagram diagram, String type) {
        this.diagram = diagram;
        this.existingPorts = Util.getPorts(diagram).toList();
        this.availableModules = PortProperties.getModuleNames(diagram);
        this.module = this.availableModules.length > 0 ? (Compartment)diagram.get(this.availableModules[0]) : null;
        this.isTypeFixed = true;
        this.setPortType(type);
        this.generatePortName();
    }

    @PropertyName(value="Port type")
    @PropertyDescription(value="Port type.")
    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String type) {
        if (type.equals(this.portType)) {
            return;
        }
        String oldValue = this.portType;
        this.portType = type;
        this.findAvailablePorts();
        this.portName = this.availablePorts.length > 0 ? this.availablePorts[0] : "";
        this.availableParameters = this.getAvailableParameters(this.diagram);
        if (this.alreadyHasPort(this.varName, this.portType, this.accessType) || this.varName.isEmpty()) {
            this.varName = this.availableParameters.length > 0 ? this.availableParameters[0] : "";
        }
        this.generatePortName();
        this.firePropertyChange("type", oldValue, type);
    }

    private void findAvailablePorts() {
        this.availablePorts = this.module != null ? (this.accessType.equals("propagated") ? this.getPropagatablePorts(this.module, this.getPortClass()) : (this.accessType.equals("private") ? this.getPrivateConnectablePorts(this.module, this.getPortClass()) : new String[0])) : new String[0];
        this.portName = this.availablePorts.length > 0 ? this.availablePorts[0] : "";
    }

    public Class<? extends Base> getPortClass() {
        return Stub.ConnectionPort.typeNameToType.get(this.portType);
    }

    @PropertyName(value="Title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="Port name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyName(value="Module name")
    @PropertyDescription(value="Module for port propagation.")
    public String getModuleName() {
        return this.module != null ? this.module.getName() : "";
    }

    public void setModuleName(String moduleName) {
        String oldValue = this.getModuleName();
        this.module = (Compartment)this.diagram.findDiagramElement(moduleName);
        if (this.module != null) {
            this.findAvailablePorts();
            this.generatePortName();
            this.firePropertyChange("*", oldValue, moduleName);
        }
    }

    public Compartment getModule() {
        return this.module;
    }

    @PropertyName(value="Access type")
    @PropertyDescription(value="Port access type.")
    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        if (accessType.equals(this.accessType)) {
            return;
        }
        String oldValue = this.accessType;
        this.accessType = accessType;
        if (accessType.equals("private")) {
            this.availableModules = (String[])StreamEx.of((Object[])Util.getModules(this.diagram)).map(DiagramElement::getCompleteNameInDiagram).prepend((Object)"").toArray(String[]::new);
            this.module = null;
        }
        this.findAvailablePorts();
        this.availableParameters = this.getAvailableParameters(this.diagram);
        if (this.alreadyHasPort(this.varName, this.portType, accessType)) {
            this.varName = this.availableParameters.length > 0 ? this.availableParameters[0] : "";
        }
        this.generatePortName();
        this.firePropertyChange("*", oldValue, accessType);
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="Variable name")
    @PropertyDescription(value="Variable asssociated with port.")
    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        String oldValue = this.varName;
        this.varName = varName;
        this.generatePortName();
        this.firePropertyChange("varName", oldValue, varName);
    }

    @PropertyName(value="Base port name")
    @PropertyDescription(value="Base port for propagation.")
    public String getBasePortName() {
        return this.portName;
    }

    public void setBasePortName(String portName) {
        String oldValue = portName;
        this.portName = portName;
        this.generatePortName();
        this.firePropertyChange("portName", oldValue, portName);
    }

    private void generatePortName() {
        String oldValue = this.name;
        if (!this.isPropagatedPort()) {
            String result = this.varName;
            if ((result = result.substring(result.lastIndexOf(".") + 1)).startsWith("$$")) {
                result = result.substring(7);
            } else if (result.startsWith("$")) {
                result = result.substring(1);
            }
            this.name = result.concat("_port");
            this.title = result;
        } else if (!this.getBasePortName().isEmpty()) {
            if (this.accessType.equals("propagated")) {
                this.name = this.portName.concat("_propagated");
            } else if (this.accessType.equals("private")) {
                this.name = this.varName + "_private";
            }
            this.title = this.getModule().get(this.getBasePortName()).getTitle();
        }
        this.name = DefaultSemanticController.generateUniqueNodeName(this.diagram, this.name);
        this.firePropertyChange("*", oldValue, this.name);
    }

    public boolean isDiagramFlat() {
        return !DiagramUtility.isComposite(this.diagram);
    }

    public boolean isPortTypeFixed() {
        return this.isTypeFixed;
    }

    public boolean isNotPropagatedPort() {
        return !this.isPropagatedPort() && !this.isPrivatePort();
    }

    public boolean isPropagatedPort() {
        return "propagated".equals(this.accessType);
    }

    public boolean isPrivatePort() {
        return "private".equals(this.accessType);
    }

    public boolean isPublicPort() {
        return "public".equals(this.accessType);
    }

    public static String[] getParameters(Diagram d) {
        return (String[])d.getRole(EModel.class).getVariables().stream().map(Variable::getName).filter(n -> !n.equals("time")).sorted().toArray(String[]::new);
    }

    public String[] getAvailableParameters(Diagram d) {
        if (this.isPrivatePort()) {
            return (String[])d.getRole(EModel.class).getVariables().stream().map(Variable::getName).filter(n -> !n.equals("time")).sorted().toArray(String[]::new);
        }
        return (String[])d.getRole(EModel.class).getVariables().stream().map(Variable::getName).filter(n -> !n.equals("time")).filter(n -> !this.alreadyHasPort((String)n, this.portType, this.accessType)).sorted().toArray(String[]::new);
    }

    public boolean alreadyHasPort(String name, String type, String accessType) {
        return StreamEx.of(this.existingPorts).anyMatch(p -> Util.getPortVariable(p).equals(name) && Util.getAccessType(p).equals(accessType) && Util.getPortType(p).equals(type));
    }

    public String[] getPropagatablePorts(Compartment compartment, Class<? extends Base> type) {
        return (String[])((StreamEx)compartment.stream(Node.class).filter(node -> node.getKernel() != null && node.getKernel().getClass().equals(type) && !this.isAlreadyPropagated((Node)((Object)node)) && !PortProperties.isInputOccupied(node))).map(MutableDataElementSupport::getName).toArray(String[]::new);
    }

    public String[] getPrivateConnectablePorts(Compartment compartment, Class<? extends Base> type) {
        return (String[])((StreamEx)compartment.stream(Node.class).filter(node -> node.getKernel() != null && node.getKernel().getClass().equals(Stub.ConnectionPort.getOppositeClass(type)) && !PortProperties.isInputOccupied(node))).map(MutableDataElementSupport::getName).toArray(String[]::new);
    }

    public static boolean isInputOccupied(Node node) {
        return Util.isInputPort(node) && node.edges().anyMatch(e -> Util.isDirectedConnection(e));
    }

    public boolean isAlreadyPropagated(Node node) {
        return node.edges().anyMatch(e -> Util.isConnection(e) && Util.isPropagatedPort(e.getOtherEnd(node)));
    }

    public static String[] getModuleNames(Diagram d) {
        return (String[])StreamEx.of((Object[])Util.getModules(d)).map(DiagramElement::getCompleteNameInDiagram).toArray(String[]::new);
    }

    public static String[] getAvailablePortTypes() {
        return Stub.ConnectionPort.typeNameToType.keySet().toArray(new String[Stub.ConnectionPort.typeNameToType.size()]);
    }

    public static String[] getAvailableAccessTypes() {
        return new String[]{"public", "private", "propagated"};
    }
}

