/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.InitialElementProperties;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.CreateEdgeDialog;
import biouml.standard.diagram.CreateReactionDialog;
import biouml.standard.diagram.PathwaySemanticController;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.ReactionInitialProperties;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.diagram.SimpleTableElementProperties;
import biouml.standard.diagram.StubInitialProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.util.PropertiesDialog;

public class PathwaySimulationSemanticController
extends PathwaySemanticController {
    private static Map<Class<?>, String> typeClassToDescription = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagramElementGroup createInstance(@Nonnull biouml.model.Compartment parent, Object type, Point pt, ViewEditorPane viewEditor) {
        boolean isNotificationEnabled = parent.isNotificationEnabled();
        parent.setNotificationEnabled(false);
        try {
            if (type == Event.class) {
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, "math-event"), "math-event"));
                node.setRole(new Event(node));
                DiagramElementGroup diagramElementGroup = new DiagramElementGroup(node);
                return diagramElementGroup;
            }
            if (type == Equation.class) {
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, "math-equation"), "math-equation"));
                node.setRole(new Equation(node));
                node.setShowTitle(false);
                DiagramElementGroup diagramElementGroup = new DiagramElementGroup(node);
                return diagramElementGroup;
            }
            if (type == Function.class) {
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, "math-function"), "math-function"));
                node.setRole(new Function(node));
                node.setShowTitle(false);
                DiagramElementGroup diagramElementGroup = new DiagramElementGroup(node);
                return diagramElementGroup;
            }
            if (type == Constraint.class) {
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, "math-constraint"), "math-constraint"));
                node.setRole(new Constraint(node));
                node.setShowTitle(false);
                DiagramElementGroup diagramElementGroup = new DiagramElementGroup(node);
                return diagramElementGroup;
            }
            if (type == State.class) {
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, "math-state"), "math-state"));
                State state = new State(node);
                state.addOnEntryAssignment(new Assignment("unknown", "0"), false);
                state.addOnExitAssignment(new Assignment("unknown", "0"), false);
                node.setRole(state);
                DiagramElementGroup diagramElementGroup = new DiagramElementGroup(node);
                return diagramElementGroup;
            }
            if (type == Transition.class) {
                CreateEdgeDialog.getTransitionDialog(Module.getModule((DataElement)parent), pt, viewEditor).setVisible(true);
                DiagramElementGroup node = DiagramElementGroup.EMPTY_EG;
                return node;
            }
            Object properties = this.getPropertiesByType(parent, type, pt);
            if (properties != null) {
                if (properties instanceof ReactionInitialProperties) {
                    Diagram diagram = (Diagram)((Object)viewEditor.getView().getModel());
                    new CreateReactionDialog((JFrame)Application.getApplicationFrame(), new ReactionPane(diagram, parent, pt, viewEditor, (ReactionInitialProperties)properties));
                    DiagramElementGroup diagramElementGroup = DiagramElementGroup.EMPTY_EG;
                    return diagramElementGroup;
                }
                if (properties instanceof InitialElementProperties) {
                    if (new PropertiesDialog((JFrame)Application.getApplicationFrame(), "New element", properties).doModal()) {
                        ((InitialElementProperties)properties).createElements(parent, pt, viewEditor);
                    }
                    DiagramElementGroup diagramElementGroup = DiagramElementGroup.EMPTY_EG;
                    return diagramElementGroup;
                }
            }
            DiagramElement de = super.createInstance(parent, type, pt, viewEditor).get(0);
            if (de != null && type != Reaction.class && type != Stub.Note.class && type != Stub.NoteLink.class) {
                de.setRole(new VariableRole(de, 0.0));
            }
            DiagramElementGroup diagramElementGroup = new DiagramElementGroup(de);
            return diagramElementGroup;
        }
        finally {
            parent.setNotificationEnabled(isNotificationEnabled);
        }
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull biouml.model.Compartment compartment, Object type, Point point, Object properties) {
        try {
            if (type instanceof Class) {
                return this.createNodeInstance(compartment, (Class)type, properties, point);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "While creating instance of type " + type.toString(), e);
        }
        return new DiagramElementGroup();
    }

    private DiagramElementGroup createNodeInstance(biouml.model.Compartment parent, Class<?> type, Object properties, Point point) {
        try {
            if (type.equals(Reaction.class)) {
                Reaction oldReaction = (Reaction)properties;
                List<SpecieReference> components = Arrays.asList(oldReaction.getSpecieReferences());
                ReactionInitialProperties reactionProperties = new ReactionInitialProperties();
                reactionProperties.setSpecieReferences(components);
                reactionProperties.setKineticlaw(new KineticLaw(oldReaction.getFormula()));
                DiagramElementGroup elements = reactionProperties.createElements(parent, point, null);
                return elements;
            }
            if (typeClassToDescription.containsKey(type)) {
                String typeDescr = typeClassToDescription.get(type);
                Node node = new Node(parent, (Base)new Stub(null, PathwaySimulationSemanticController.generateUniqueNodeName(parent, typeDescr), typeDescr));
                Role role = properties instanceof Role ? ((Role)properties).clone(node) : (Role)type.getConstructor(DiagramElement.class).newInstance(new Object[]{node});
                node.setRole(role);
                node.setLocation(point);
                return new DiagramElementGroup(node);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "While creating instance of type " + type.toString(), ex);
        }
        return new DiagramElementGroup();
    }

    @Override
    public boolean canAccept(biouml.model.Compartment compartment, DiagramElement de) {
        if (Util.isBlock(compartment)) {
            return de.getKernel() != null && de.getKernel().getType().equals("math-equation");
        }
        if (Util.isPort(de) && !(compartment instanceof Diagram)) {
            return false;
        }
        Role role = de.getRole();
        if (role instanceof Event || role instanceof Equation || role instanceof Function || role instanceof State || role instanceof Constraint) {
            return true;
        }
        if (de instanceof Edge && role instanceof Transition) {
            return ((Edge)de).nodes().allMatch(n -> n.getRole() instanceof State);
        }
        return super.canAccept(compartment, de);
    }

    @Override
    public Object getPropertiesByType(biouml.model.Compartment compartment, Object type, Point point) {
        Class typeClass = null;
        if (type instanceof Class) {
            typeClass = (Class)type;
        } else if (type instanceof String) {
            if (type.equals("block")) {
                return new StubInitialProperties(compartment, "block", biouml.model.Compartment.class);
            }
            if ("table".equals(type)) {
                String name = PathwaySimulationSemanticController.generateUniqueName(Diagram.getDiagram(compartment), "table", false);
                return new SimpleTableElementProperties(name);
            }
            try {
                typeClass = ClassLoading.loadClass((String)((String)type));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (typeClass == null) {
            return null;
        }
        if (Reaction.class.isAssignableFrom(typeClass)) {
            return new ReactionInitialProperties();
        }
        if (Stub.ConnectionPort.class.isAssignableFrom(typeClass)) {
            return new PortProperties(Diagram.getDiagram(compartment), typeClass.asSubclass(Stub.ConnectionPort.class));
        }
        return super.getPropertiesByType(compartment, type, point);
    }

    @Override
    protected Node changeNodeParent(Node oldNode, biouml.model.Compartment newParent) throws Exception {
        Node node = super.changeNodeParent(oldNode, newParent);
        if (node.getKernel() instanceof Reaction) {
            return node;
        }
        node.edges().map(e -> e.getKernel()).select(SpecieReference.class).forEach(sr -> sr.setSpecie(node.getCompleteNameInDiagram()));
        return node;
    }

    @Override
    public Node cloneNode(Node node, String newName, Point location) {
        Node newNode = super.cloneNode(node, newName, location);
        Role role = node.getRole();
        if (role instanceof VariableRole) {
            ((VariableRole)role).addAssociatedElement(newNode);
        }
        return newNode;
    }

    @Override
    public boolean isAcceptableForReaction(Node node) {
        return node.getRole() instanceof VariableRole && !(node.getKernel() instanceof Compartment);
    }

    static {
        typeClassToDescription.put(Equation.class, "math-equation");
        typeClassToDescription.put(Event.class, "math-event");
        typeClassToDescription.put(Function.class, "math-function");
        typeClassToDescription.put(State.class, "math-state");
        typeClassToDescription.put(Constraint.class, "math-constraint");
    }
}

