/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.GlobalViewOptions;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.SimpleTableElement;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.PathwayDiagramViewBuilder;
import biouml.standard.diagram.PathwayDiagramViewOptions;
import biouml.standard.diagram.PathwaySimulationDiagramViewOptions;
import biouml.standard.diagram.Util;
import biouml.standard.type.Reaction;
import biouml.workbench.graph.OnePointFinder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PortFinder;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.EllipseView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.view.FormulaViewBuilder;

public class PathwaySimulationDiagramViewBuilder
extends PathwayDiagramViewBuilder {
    public static final int PORT_SIZE = 12;
    public static final int PORT_INDENT = 2;
    protected FormulaViewBuilder formulaViewBuilder = new FormulaViewBuilder(){

        protected void init() {
            this.defaultFont = new ColorFont("Arial", 0, 11, Color.black);
            this.superscriptFont = new ColorFont("Arial", 0, 9, Color.black);
            this.subscriptFont = new ColorFont("Arial", 0, 9, Color.black);
            this.offset = new Point(2, 0);
            this.subscript = new Point(1, -4);
            this.superscript = new Point(1, -4);
        }
    };

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new PathwaySimulationDiagramViewOptions(null);
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        if ("math-event".equals(node.getKernel().getType())) {
            return this.createEventView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        if ("math-equation".equals(node.getKernel().getType())) {
            return this.createEquationView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        if ("math-state".equals(node.getKernel().getType())) {
            return this.createStateView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        if ("math-function".equals(node.getKernel().getType())) {
            return this.createFunctionView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        if ("math-constraint".equals(node.getKernel().getType())) {
            return this.createConstraintView(container, node, (PathwaySimulationDiagramViewOptions)options, g, false);
        }
        if (node.getKernel().getType().equals("table")) {
            return this.createTableView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        if (Util.isPort(node)) {
            return this.createConnectionPortView(container, node, (PathwaySimulationDiagramViewOptions)options, g);
        }
        return super.createNodeCoreView(container, node, options, g);
    }

    @Override
    @Nonnull
    public CompositeView createNodeView(Node node, DiagramViewOptions options, Graphics g) {
        Role role;
        CompositeView nodeView = super.createNodeView(node, options, g);
        if (options instanceof PathwaySimulationDiagramViewOptions && !Util.isBus(node) && (role = node.getRole()) instanceof VariableRole && ((PathwaySimulationDiagramViewOptions)options).showVariableValue) {
            VariableRole var = (VariableRole)role;
            TextView initialValueView = new TextView(Double.toString(var.getInitialValue()), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), g);
            nodeView.add((View)initialValueView, 95, options.getNodeTitleMargin());
        }
        return nodeView;
    }

    protected void createReactionTitle(DiagramElement reactionNode, CompositeView diagramView, PathwayDiagramViewOptions options, Graphics g) {
        super.createReactionTitle(reactionNode, diagramView, options, g);
        if (options instanceof PathwaySimulationDiagramViewOptions && ((PathwaySimulationDiagramViewOptions)options).showReactionRate) {
            View reactionView = reactionNode.getView();
            Rectangle rBounds = reactionView.getBounds();
            Equation equation = reactionNode.getRole(Equation.class);
            String formula = equation.getFormula();
            if (formula != null) {
                formula = formula.trim();
            }
            if (formula == null || formula.isEmpty()) {
                formula = "--";
            }
            TextView formulaView = new TextView(formula, PathwaySimulationDiagramViewBuilder.getTitleFont(reactionNode, options.getNodeTitleFont()), g);
            Reaction reaction = (Reaction)reactionNode.getKernel();
            formulaView.setModel((Object)reaction.getKineticLaw());
            formulaView.setActive(true);
            Rectangle tBounds = formulaView.getBounds();
            formulaView.setLocation(rBounds.x + (rBounds.width - tBounds.width) / 2, rBounds.y + rBounds.height + 10);
            diagramView.add((View)formulaView);
        }
    }

    @Override
    @Nonnull
    protected CompositeView doCreateCompartmentView(Compartment compartment, DiagramViewOptions options, Graphics g) {
        if (Util.isBlock(compartment)) {
            return this.createBlockView(compartment, options, g);
        }
        return super.doCreateCompartmentView(compartment, options, g);
    }

    @Nonnull
    protected View createMathView(Role role, String math, PathwaySimulationDiagramViewOptions options, Graphics g) {
        if (!options.mathAsText) {
            try {
                Diagram diagram = Diagram.getDiagram(role.getDiagramElement());
                EModel model = diagram.getRole(EModel.class);
                AstStart start = model.readMath(math, role, GlobalViewOptions.getVarNameMode());
                if (role instanceof Equation && ((Equation)role).isInitial()) {
                    AstFunNode funNode = (AstFunNode)start.jjtGetChild(0);
                    funNode.setFunction((ru.biosoft.math.model.Function)new PredefinedFunction("(0) =", 8, -1));
                }
                return this.formulaViewBuilder.createView(start, g);
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Can not generate formula view, \r\n  math=" + math + "\r\n  error=" + t, t);
            }
        }
        return new TextView(math, options.formulaFont, g);
    }

    @Nonnull
    protected CompositeView createBlockView(Compartment block, DiagramViewOptions options, Graphics g) {
        CompositeView compartmentView = new CompositeView();
        ComplexTextView titleView = new ComplexTextView("<b>" + block.getTitle() + "</b>", new Point(0, 0), 2, PathwaySimulationDiagramViewBuilder.getTitleFont(block, options.getCompartmentTitleFont()), options.getFontRegistry(), 15, 200, g);
        compartmentView.add((View)titleView, 2);
        for (Node node : block.stream().select(Node.class)) {
            if (node.getRole() instanceof Equation) {
                CompositeView view = new CompositeView();
                this.createEquationView(view, node, (PathwaySimulationDiagramViewOptions)options, g, true);
                view.setModel((Object)node);
                view.setActive(true);
                node.setView((View)view);
                compartmentView.add((View)view, 76);
                continue;
            }
            this.log.log(Level.SEVERE, "Invalid node \"" + node.getTitle() + "\" with role \"" + node.getRole() + "\" inside block \"" + block.getTitle() + "\". Only equations are allowed inside blocks.");
        }
        Dimension size = block.getShapeSize();
        Rectangle bounds = compartmentView.getBounds();
        if (size.width < bounds.width) {
            size.width = bounds.width;
        }
        if (size.height < bounds.height) {
            size.height = bounds.height;
        }
        compartmentView.remove((View)titleView);
        compartmentView.add((View)titleView, 0);
        compartmentView.add((View)new BoxView(PathwaySimulationDiagramViewBuilder.getBorderPen(block, options.getDefaultPen()), null, bounds.x, bounds.y, size.width, size.height), 31);
        compartmentView.add((View)new LineView(options.getDefaultPen(), 0.0f, 0.0f, (float)size.width, 0.0f), 31, new Point(0, titleView.getBounds().height));
        compartmentView.setModel((Object)block);
        compartmentView.setActive(true);
        compartmentView.setLocation(block.getLocation());
        block.setView((View)compartmentView);
        return compartmentView;
    }

    protected boolean createEventView(CompositeView eventView, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        Event event = (Event)node.getRole();
        if (event == null) {
            return false;
        }
        CompositeView when = new CompositeView();
        ColorFont font = options.formulaFont;
        when.add((View)new TextView("when: ", font, g));
        when.add(this.createMathView(event, event.getTrigger(), options, g), 121);
        eventView.add((View)when);
        if (!event.isTriggerInitialValue()) {
            TextView initial = new TextView("even if on start", font, g);
            eventView.add((View)initial, 76, options.formulaOffset);
        }
        if (!event.isTriggerPersistent()) {
            TextView persistent = new TextView("not persistent", font, g);
            eventView.add((View)persistent, 76, options.formulaOffset);
        }
        if (event.getDelay() != null && !"".equals(event.getDelay()) && !"0".equals(event.getDelay())) {
            CompositeView delay = new CompositeView();
            delay.add((View)new TextView("delay: ", font, g));
            delay.add(this.createMathView(event, event.getDelay(), options, g), 121);
            eventView.add((View)delay, 76, options.formulaOffset);
        }
        if (event.getPriority() != null && !"".equals(event.getPriority())) {
            CompositeView priority = new CompositeView();
            priority.add((View)new TextView("priority: ", font, g));
            priority.add(this.createMathView(event, event.getPriority(), options, g), 121);
            eventView.add((View)priority, 76, options.formulaOffset);
        }
        Point offset = new Point(0, options.formulaOffset.y * 2);
        Rectangle r = eventView.getBounds();
        int y = r.y + r.height + options.formulaOffset.y;
        for (int i = 0; i < event.getEventAssignment().length; ++i) {
            Assignment a = event.getEventAssignment(i);
            eventView.add(this.createMathView(event, a.getVariable() + " = " + a.getMath(), options, g), 76, offset);
            if (i != 0) continue;
            offset = options.formulaOffset;
        }
        ColorFont titleFont = PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getMathTitleFont());
        Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(node, options.getMathPen());
        String title = event.getDiagramElement().getTitle();
        if (title != null && title.trim().length() > 0) {
            eventView.add((View)new TextView(title, titleFont, g), 63);
        }
        r = eventView.getBounds();
        int d = options.borderOffset;
        eventView.add((View)new LineView(pen, (float)(r.x - d), (float)y, (float)(r.x + r.width + d), (float)y));
        eventView.add((View)new BoxView(pen, null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 20.0f, 20.0f)));
        return false;
    }

    protected boolean createEquationView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        return this.createEquationView(view, node, options, g, false);
    }

    protected boolean createEquationView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g, boolean isInsideBlock) {
        Equation eq = (Equation)node.getRole();
        if (eq != null && (eq.getVariable() != null || eq.getType().equals("algebraic"))) {
            if (Equation.isScalar(eq.getType())) {
                view.add(this.createMathView(eq, eq.getVariable() + " = " + eq.getFormula(), options, g));
            } else if (eq.getType().equals("initial assignment")) {
                view.add(this.createMathView(eq, eq.getVariable() + " = " + eq.getFormula(), options, g));
            } else if (eq.getType().equals("rate")) {
                view.add(this.createMathView(eq, "diff(" + eq.getVariable() + ", time) = " + eq.getFormula(), options, g));
            } else {
                view.add(this.createMathView(eq, eq.getFormula(), options, g));
                view.add((View)new TextView(" = 0", this.formulaViewBuilder.getDefaultFont(), g), 121);
            }
        }
        if (node.isShowTitle()) {
            TextView textView = new TextView(node.getTitle(), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getMathTitleFont()), g);
            view.add((View)textView, 28, new Point(0, -textView.getBounds().height));
        }
        int d = options.borderOffset;
        Rectangle r = view.getBounds();
        Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(node, options.getMathPen());
        if (!isInsideBlock) {
            view.add((View)new BoxView(pen, null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 10.0f, 10.0f)));
        }
        return false;
    }

    protected boolean createConstraintView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g, boolean isInsideBlock) {
        try {
            Constraint con = node.getRole(Constraint.class);
            view.add(this.createMathView(con, con.getFormula(), options, g));
            if (node.isShowTitle()) {
                TextView textView = new TextView(node.getTitle(), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getMathTitleFont()), g);
                view.add((View)textView, 28, new Point(0, -textView.getBounds().height));
            }
            int d = options.borderOffset;
            Rectangle r = view.getBounds();
            Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(node, options.getMathPen());
            if (!isInsideBlock) {
                view.add((View)new BoxView(pen, null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 10.0f, 10.0f)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean createFunctionView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        return this.createFunctionView(view, node, options, g, false);
    }

    protected boolean createFunctionView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g, boolean isInsideBlock) {
        Function fun = node.getRole(Function.class);
        view.add(this.createMathView(fun, fun.getFormula(), options, g));
        if (node.isShowTitle()) {
            TextView textView = new TextView(node.getTitle(), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getMathTitleFont()), g);
            view.add((View)textView, 28, new Point(0, -textView.getBounds().height));
        }
        if (!isInsideBlock) {
            int d = options.borderOffset;
            Rectangle r = view.getBounds();
            Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(node, options.getMathPen());
            view.add((View)new BoxView(pen, null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 10.0f, 10.0f)));
        }
        return false;
    }

    public boolean createTableView(CompositeView container, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        int i;
        Dimension d = node.getShapeSize();
        SimpleTableElement table = node.getRole(SimpleTableElement.class);
        SimpleTableElement.VarColumn column = table.getArgColumn();
        SimpleTableElement.VarColumn[] varColumns = table.getColumns();
        String argVariable = column.getVariable();
        String argColumn = column.getColumn();
        int offset = 5;
        TextView titleView = new TextView(node.getTitle(), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), g);
        titleView.setLocation(offset, 0);
        container.add((View)titleView);
        int yStart = titleView.getBounds().height + offset;
        TextView argColumnView = new TextView(argColumn, options.getDefaultFont(), g);
        TextView argView = new TextView(argVariable, options.getDefaultFont(), g);
        int size = varColumns.length;
        TextView[] columnViews = new TextView[size];
        TextView[] variableView = new TextView[size];
        LineView[] horizontalLine = new LineView[size];
        for (int i2 = 0; i2 < size; ++i2) {
            SimpleTableElement.VarColumn col = table.getColumns()[i2];
            columnViews[i2] = new TextView(col.getColumn(), options.getDefaultFont(), g);
            variableView[i2] = new TextView(col.getVariable(), options.getDefaultFont(), g);
        }
        int cellheight = Math.max(argColumnView.getBounds().height, argView.getBounds().height);
        int cellWidth1 = argColumnView.getBounds().width;
        int cellWidth2 = argView.getBounds().width;
        for (int i3 = 0; i3 < size; ++i3) {
            cellheight = Math.max(cellheight, columnViews[i3].getBounds().height);
            cellheight = Math.max(cellheight, variableView[i3].getBounds().height);
            cellWidth1 = Math.max(cellWidth1, columnViews[i3].getBounds().width);
            cellWidth2 = Math.max(cellWidth2, variableView[i3].getBounds().width);
        }
        int width = cellWidth1 + cellWidth2 + 4 * offset;
        int height = (cellheight += 2 * offset) * (size + 1);
        argColumnView.setLocation(offset, yStart + offset);
        argView.setLocation(3 * offset + cellWidth1, yStart + offset);
        for (i = 0; i < size; ++i) {
            columnViews[i].setLocation(offset, yStart + cellheight * (i + 1) + offset);
            variableView[i].setLocation(3 * offset + cellWidth1, yStart + cellheight * (i + 1) + offset);
            horizontalLine[i] = new LineView(options.getDefaultPen(), 0.0f, (float)(yStart + cellheight * (i + 1)), (float)width, (float)(yStart + cellheight * (i + 1)));
        }
        container.add((View)new BoxView(options.getDefaultPen(), new Brush((Paint)Color.white), 0, yStart, width, height));
        container.add((View)new LineView(options.getDefaultPen(), (float)(cellWidth1 + 2 * offset), (float)yStart, (float)(cellWidth1 + 2 * offset), (float)(yStart + height)));
        container.add((View)argColumnView);
        container.add((View)argView);
        for (i = 0; i < size; ++i) {
            container.add((View)columnViews[i]);
            container.add((View)variableView[i]);
            container.add((View)horizontalLine[i]);
        }
        d.width = width;
        d.height = height;
        return false;
    }

    protected boolean createStateView(CompositeView stateView, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        Rectangle r1;
        Rectangle rOn;
        State state = node.getRole(State.class);
        View entry_1 = null;
        for (int i = 0; i < state.getOnEntryAssignment().length; ++i) {
            Assignment a = state.getOnEntryAssignment(i);
            View v = this.createMathView(state, a.getVariable() + " = " + a.getMath(), options, g);
            stateView.add(v, 76, options.formulaOffset);
            if (i != 0) continue;
            entry_1 = v;
        }
        View exit_1 = null;
        for (int i = 0; i < state.getOnExitAssignment().length; ++i) {
            Assignment a = state.getOnExitAssignment(i);
            View v = this.createMathView(state, a.getVariable() + " = " + a.getMath(), options, g);
            stateView.add(v, 76, options.formulaOffset);
            if (i != 0) continue;
            exit_1 = v;
        }
        if (entry_1 != null) {
            TextView onEntry = new TextView("on entry: ", options.stateOnFont, g);
            rOn = onEntry.getBounds();
            r1 = entry_1.getBounds();
            onEntry.setLocation(r1.x - rOn.width - 10, r1.y + (r1.height - rOn.height) / 2);
            stateView.add((View)onEntry);
        }
        if (exit_1 != null) {
            TextView onExit = new TextView("on exit: ", options.stateOnFont, g);
            rOn = onExit.getBounds();
            r1 = exit_1.getBounds();
            onExit.setLocation(r1.x - rOn.width - 10, r1.y + (r1.height - rOn.height) / 2);
            stateView.add((View)onExit);
        }
        Point offset = new Point(0, options.formulaOffset.y * 2);
        Rectangle r = stateView.getBounds();
        int y = r.y - options.formulaOffset.y;
        stateView.add((View)new TextView(node.getTitle(), options.getMathTitleFont(), g), 63, offset);
        r = stateView.getBounds();
        int d = options.borderOffset;
        stateView.add((View)new LineView(options.getMathPen(), (float)(r.x - d), (float)y, (float)(r.x + r.width + d * 2), (float)y));
        stateView.add((View)new BoxView(options.getMathPen(), null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 20.0f, 20.0f)));
        return false;
    }

    protected View createPortCoreView(Node node, PathwaySimulationDiagramViewOptions options) {
        Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(node, options.getNodePen());
        SubDiagram.PortOrientation orientation = Util.getPortOrientation(node);
        String type = node.getKernel().getType();
        if (type.equals("output connection port")) {
            return new PolygonView(pen, options.outputConnectionPortBrush, PathwaySimulationDiagramViewBuilder.createPolygon(orientation, 12));
        }
        if (type.equals("input connection port")) {
            return new PolygonView(pen, options.getInputConnectionPortBrush(), PathwaySimulationDiagramViewBuilder.createPolygon(orientation.opposite(), 12));
        }
        return new EllipseView(pen, options.contactConnectionPortBrush, 0.0f, 0.0f, 12.0f, 12.0f);
    }

    protected boolean createConnectionPortView(CompositeView container, Node node, PathwaySimulationDiagramViewOptions options, Graphics g) {
        container.add(this.createPortCoreView(node, options));
        View title = new FormulaViewBuilder().createTitleView(node.getTitle(), PathwaySimulationDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), g);
        switch (Util.getPortOrientation(node)) {
            case TOP: {
                container.add(title, 79, new Point(0, 3));
                break;
            }
            case RIGHT: {
                container.add(title, 126, new Point(3, 0));
                break;
            }
            case BOTTOM: {
                container.add(title, 63, new Point(0, 3));
                break;
            }
            case LEFT: {
                container.add(title, 121, new Point(3, 0));
            }
        }
        return false;
    }

    public static Polygon createPolygon(SubDiagram.PortOrientation orientation, int size) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        switch (orientation) {
            case TOP: {
                polygon.addPoint(size, 0);
                polygon.addPoint(size / 2, -size);
                return polygon;
            }
            case BOTTOM: {
                polygon.addPoint(size, 0);
                polygon.addPoint(size / 2, size);
                return polygon;
            }
            case RIGHT: {
                polygon.addPoint(0, size);
                polygon.addPoint(size, size / 2);
                return polygon;
            }
        }
        polygon.addPoint(0, size);
        polygon.addPoint(-size, size / 2);
        return polygon;
    }

    public static Polygon createPolygon(SubDiagram.PortOrientation orientation, boolean isOutput, int size) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        if (orientation == SubDiagram.PortOrientation.TOP && isOutput || orientation == SubDiagram.PortOrientation.BOTTOM && !isOutput) {
            polygon.addPoint(size, 0);
            polygon.addPoint(size / 2, -size);
        } else if (orientation == SubDiagram.PortOrientation.BOTTOM && isOutput || orientation == SubDiagram.PortOrientation.TOP && !isOutput) {
            polygon.addPoint(size, 0);
            polygon.addPoint(size / 2, size);
        } else if (orientation == SubDiagram.PortOrientation.RIGHT && isOutput || orientation == SubDiagram.PortOrientation.LEFT && !isOutput) {
            polygon.addPoint(0, size);
            polygon.addPoint(size, size / 2);
        } else if (orientation == SubDiagram.PortOrientation.LEFT && isOutput || orientation == SubDiagram.PortOrientation.RIGHT && !isOutput) {
            polygon.addPoint(0, size);
            polygon.addPoint(-size, size / 2);
        }
        return polygon;
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions viewOptions, Graphics g) {
        if (edge.getKernel().getType().equals("math-transition")) {
            return this.createTransitionView(edge, (PathwaySimulationDiagramViewOptions)viewOptions, g);
        }
        return super.createEdgeView(edge, viewOptions, g);
    }

    @Nonnull
    protected CompositeView createTransitionView(Edge edge, PathwaySimulationDiagramViewOptions viewOptions, Graphics g) {
        Transition transition = edge.getRole(Transition.class);
        Pen pen = PathwaySimulationDiagramViewBuilder.getBorderPen(edge, viewOptions.transitionPen);
        Brush brush = PathwaySimulationDiagramViewBuilder.getBrush(edge, viewOptions.transitionBrush);
        CompositeView view = new CompositeView();
        view.setModel((Object)edge);
        Path path = edge.getPath();
        if (path == null || path.npoints < 2) {
            path = new Path();
            Point in = new Point();
            Point out = new Point();
            if (!this.calculateInOut(edge, in, out)) {
                return view;
            }
            path.addPoint(in.x, in.y);
            path.addPoint(out.x, out.y);
            edge.setPath(path);
        }
        Point outPort = new Point(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1]);
        Point inPort = new Point(path.xpoints[0], path.ypoints[0]);
        ArrowView.Tip endTip = ArrowView.createSimpleTip((Pen)pen, (int)10, (int)5);
        ArrowView arrow = new ArrowView(pen, brush, edge.getSimplePath(), null, endTip);
        arrow.setModel((Object)edge);
        arrow.setActive(true);
        view.add((View)arrow);
        Point controlPoint = null;
        controlPoint = arrow.getPathView() != null ? arrow.getPathView().getMiddlePoint() : new Point((path.xpoints[0] + path.xpoints[1]) / 2, (path.ypoints[0] + path.ypoints[1]) / 2);
        StringBuffer titleString = new StringBuffer();
        if (transition.getWhen() != null && transition.getWhen().length() > 0) {
            titleString.append("when: ");
            titleString.append(transition.getWhen());
        }
        if (transition.getAfter() != null && transition.getAfter().length() > 0) {
            if (titleString.length() > 0) {
                titleString.append("; ");
            }
            titleString.append("after: ");
            titleString.append(transition.getAfter());
        }
        TextView title = null;
        if (titleString.length() > 0) {
            int alignment = 0;
            float a = (float)(outPort.y - inPort.y) / ((float)(outPort.x - inPort.x) + 0.1f);
            alignment = (double)Math.abs(a) < 0.2 ? 63 : 121;
            Point middlePoint = new Point(controlPoint.x - 7, controlPoint.y);
            title = new TextView(titleString.toString(), middlePoint, alignment, PathwaySimulationDiagramViewBuilder.getTitleFont(edge, viewOptions.relationTitleFont), g);
            title.setActive(true);
            title.setModel((Object)edge);
        }
        if (title != null) {
            view.add(title);
        }
        return view;
    }

    @Override
    public PortFinder getPortFinder(Node node) {
        if (Util.isPort(node)) {
            return new OnePointFinder(Util.getPortOrientation(node).opposite(), this.getNodeBounds(node));
        }
        return super.getPortFinder(node);
    }
}

