/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.standard.diagram.MathDiagramUtility;
import biouml.standard.diagram.PathwayDiagramType;
import biouml.standard.diagram.PathwaySimulationDiagramViewBuilder;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.Gene;
import biouml.standard.type.Protein;
import biouml.standard.type.RNA;
import biouml.standard.type.Reaction;
import biouml.standard.type.Stub;
import biouml.standard.type.Substance;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;

public class PathwaySimulationDiagramType
extends PathwayDiagramType {
    @Override
    @Nonnull
    public Diagram createDiagram(DataCollection<?> origin, String diagramName, Base kernel) throws Exception {
        Diagram diagram = super.createDiagram(origin, diagramName, kernel);
        diagram.setRole(new EModel(diagram));
        DiagramPropertyChangeListener listener = new DiagramPropertyChangeListener(diagram);
        diagram.getViewOptions().addPropertyChangeListener(listener);
        return diagram;
    }

    @Override
    public Object[] getNodeTypes() {
        return new Object[]{Compartment.class, "block", Gene.class, RNA.class, Protein.class, Substance.class, Reaction.class, Stub.Note.class, Stub.OutputConnectionPort.class, Stub.InputConnectionPort.class, Stub.ContactConnectionPort.class, Event.class, Equation.class, Function.class, Constraint.class, State.class, "table"};
    }

    public Class[] getEdgeTypes() {
        return new Class[]{Stub.NoteLink.class, Transition.class};
    }

    @Override
    public DiagramViewBuilder getDiagramViewBuilder() {
        if (this.diagramViewBuilder == null) {
            this.diagramViewBuilder = new PathwaySimulationDiagramViewBuilder();
        }
        return this.diagramViewBuilder;
    }

    @Override
    public SemanticController getSemanticController() {
        if (this.semanticController == null) {
            this.semanticController = new PathwaySimulationSemanticController();
        }
        return this.semanticController;
    }

    @Override
    public boolean isGeneralPurpose() {
        return false;
    }

    public static class DiagramPropertyChangeListener
    implements PropertyChangeListener,
    DataCollectionListener {
        protected Logger log = Logger.getLogger(DiagramPropertyChangeListener.class.getName());
        private Diagram diagram;
        private DiagramPropertyChangeListener listenerOnDiagram;

        public DiagramPropertyChangeListener(Diagram diagram) {
            this.diagram = diagram;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof DiagramViewOptions && evt.getPropertyName().equals("dependencyEdges")) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    try {
                        MathDiagramUtility.generateDependencies(this.diagram);
                        DiagramPropertyChangeListener listener = new DiagramPropertyChangeListener(this.diagram);
                        this.diagram.addPropertyChangeListener(listener);
                        this.diagram.addDataCollectionListener(listener);
                        this.listenerOnDiagram = listener;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Can't generate dependency edges");
                    }
                } else {
                    try {
                        this.diagram.removeDataCollectionListener(this.listenerOnDiagram);
                        this.diagram.removePropertyChangeListener(this.listenerOnDiagram);
                        boolean notificationEnabled = this.diagram.isNotificationEnabled();
                        this.diagram.setNotificationEnabled(false);
                        MathDiagramUtility.removeDependencies(this.diagram);
                        this.diagram.setNotificationEnabled(notificationEnabled);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Can't remove dependency edges");
                    }
                }
            }
            if (evt.getSource() instanceof Equation && ((Equation)evt.getSource()).getDiagramElement() instanceof Node && (evt.getPropertyName().equals("formula") || evt.getPropertyName().equals("variable"))) {
                MathDiagramUtility.generateDependenciesForEquation((Node)((Equation)evt.getSource()).getDiagramElement());
            }
        }

        public void elementAdded(DataCollectionEvent e) throws Exception {
            DiagramElement de = (DiagramElement)e.getDataElement();
            if (de instanceof Node && Util.isPort(de)) {
                MathDiagramUtility.generateDependencies(Diagram.getDiagram(de));
            }
        }

        public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        }

        public void elementChanged(DataCollectionEvent e) throws Exception {
        }

        public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        }

        public void elementRemoved(DataCollectionEvent e) throws Exception {
        }

        public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        }
    }
}

