/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.diagram.CreateDiagramElementDialog;
import biouml.standard.diagram.CreateEdgeAction;
import biouml.standard.diagram.CreateEdgeDialog;
import biouml.standard.diagram.CreateReactionDialog;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.diagram.NoteLinkEdgeCreator;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.diagram.SemanticReactionProperties;
import biouml.standard.type.Base;
import biouml.standard.type.Gene;
import biouml.standard.type.Protein;
import biouml.standard.type.RNA;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Substance;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class PathwaySemanticController
extends DefaultSemanticController {
    protected static final Logger log = Logger.getLogger(PathwaySemanticController.class.getName());
    protected MessageBundle messageBundle = new MessageBundle();

    protected void doRemove(Collection<? extends DiagramElement> v) throws Exception {
        for (DiagramElement diagramElement : v) {
            this.remove(diagramElement);
        }
    }

    @Override
    public boolean remove(DiagramElement de) throws Exception {
        if (de instanceof Diagram) {
            return false;
        }
        if (de.getKernel() instanceof Stub.Note || de.getKernel() instanceof Stub.NoteLink) {
            return super.remove(de);
        }
        if (de instanceof Edge) {
            Edge edge = (Edge)de;
            if (edge.getKernel().getType().equals("relation-semantic")) {
                edge.getOrigin().remove(edge.getName());
                return true;
            }
            return false;
        }
        if (de instanceof Compartment) {
            this.doRemove(((Compartment)de).stream().toList());
        }
        Node node = (Node)de;
        Base kernel = node.getKernel();
        DataCollection parent = node.getOrigin();
        if (!kernel.getType().equals("reaction")) {
            ArrayList edgesToRemove = new ArrayList();
            List toRemove = ((StreamEx)((StreamEx)node.edges().peek(edgesToRemove::add)).flatMap(Edge::nodes).filter(n -> n.getKernel().getType().equals("reaction"))).toList();
            for (Edge edge : edgesToRemove) {
                edge.getOrigin().remove(edge.getName());
            }
            this.doRemove(toRemove);
        } else {
            for (Edge edge : node.edges().toList()) {
                edge.getCompartment().remove(edge.getName());
            }
        }
        parent.remove(node.getName());
        return true;
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point point, ViewEditorPane viewEditor) {
        Class<DataElement> typeClass = ((Class)type).asSubclass(DataElement.class);
        Node de = null;
        Diagram diagram = (Diagram)((Object)viewEditor.getView().getModel());
        if (typeClass == Stub.Note.class) {
            String id = PathwaySemanticController.generateUniqueNodeName(parent, "note");
            return new DiagramElementGroup(new Node(parent, (Base)new Stub.Note(null, id)));
        }
        if (typeClass == Stub.NoteLink.class) {
            new CreateEdgeAction().createEdge(point, viewEditor, new NoteLinkEdgeCreator());
            return DiagramElementGroup.EMPTY_EG;
        }
        if (typeClass == SemanticRelation.class) {
            CreateEdgeDialog dialog = CreateEdgeDialog.getSemanticRelationDialog(Module.getModule((DataElement)parent), point, viewEditor);
            dialog.setVisible(true);
            return DiagramElementGroup.EMPTY_EG;
        }
        if (type == Reaction.class) {
            ReactionPane reactionPane = new ReactionPane(diagram, parent, point, viewEditor);
            ApplicationFrame frame = Application.getApplicationFrame();
            CreateReactionDialog dialog = new CreateReactionDialog((JFrame)frame, reactionPane);
            dialog.pack();
            dialog.setLocationRelativeTo((Component)Application.getApplicationFrame());
            dialog.setVisible(true);
        } else {
            try {
                CreateDiagramElementDialog dialog = new CreateDiagramElementDialog(parent, typeClass);
                if (dialog.doModal()) {
                    de = dialog.getNode();
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create new diagram element, error: " + t, t);
            }
        }
        return new DiagramElementGroup(de);
    }

    @Override
    public DiagramElementGroup createInstance(Compartment compartment, Object type, Point point, Object properties) {
        if (type == Reaction.class) {
            Reaction oldReaction = (Reaction)properties;
            List<SpecieReference> components = Arrays.asList(oldReaction.getSpecieReferences());
            SemanticReactionProperties reactionProperties = new SemanticReactionProperties();
            reactionProperties.setReactionName(oldReaction.getName());
            reactionProperties.setKineticlaw(oldReaction.getKineticLaw());
            reactionProperties.setSpecieReferences(components);
            try {
                DiagramElementGroup elements = reactionProperties.createElements(compartment, point, null);
                reactionProperties.putReaction();
                return elements;
            }
            catch (Exception e) {
                return DiagramElementGroup.EMPTY_EG;
            }
        }
        return super.createInstance(compartment, type, point, properties);
    }

    protected Node getNode(Base kernel, Set<Node> elements) {
        DataCollection origin = null;
        String kernelName = kernel.getName();
        for (Node node : elements) {
            if (origin == null) {
                origin = node.getOrigin();
            }
            if (!node.getName().equals(kernelName)) continue;
            return node;
        }
        Node node = new Node((DataCollection<?>)origin, kernel);
        elements.add(node);
        return node;
    }

    @Override
    public Object getPropertiesByType(Compartment compartment, Object type, Point point) {
        if (type instanceof Class && Reaction.class.isAssignableFrom((Class)type)) {
            return new SemanticReactionProperties();
        }
        return super.getPropertiesByType(compartment, type, point);
    }

    @Override
    public boolean isAcceptableForReaction(Node node) {
        return node.getKernel() instanceof Gene || node.getKernel() instanceof RNA || node.getKernel() instanceof Protein || node.getKernel() instanceof Substance;
    }
}

