/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.DiagramViewOptions;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

@PropertyName(value="View options")
public class PathwayDiagramViewOptions
extends DiagramViewOptions {
    protected static final String PEN = "pen";
    protected static final String BRUSH = "brush";
    protected static final String DEFAULT = "default";
    public Brush cellCytoplasmBrush = new Brush((Paint)Color.lightGray);
    public Brush cellNucleusBrush = new Brush((Paint)Color.black);
    public Brush geneBrush = new Brush((Paint)Color.orange.darker());
    public Brush proteinBrush = new Brush((Paint)Color.pink);
    public Brush activeProteinBrush = new Brush((Paint)Color.pink);
    public Brush inactiveProteinBrush = new Brush((Paint)Color.green);
    public Brush modifiedProteinBrush = new Brush((Paint)Color.red);
    public Brush physicalEntityBrush = new Brush((Paint)Color.white);
    public Pen catalystActionPen = new Pen(1.0f, Color.magenta);
    public Pen inhibitorActionPen = new Pen(1.0f, Color.blue);
    public Pen switchOnActionPen = new Pen(1.0f, Color.red);
    public Pen switchOffActionPen = new Pen(1.0f, Color.black);
    public Pen reactionPen = new Pen(1.0f, Color.green.darker());
    public Brush increaseActionBrush = new Brush((Paint)Color.magenta);
    public Brush decreaseActionBrush = new Brush((Paint)Color.blue);
    public Brush switchOnActionBrush = new Brush((Paint)Color.red);
    public Brush switchOffActionBrush = new Brush((Paint)Color.black);
    public Brush reactionBrush = new Brush((Paint)Color.green.darker());
    public Brush substanceBrush = new Brush((Paint)Color.blue);
    public boolean automaticallyLocateReactions = false;
    public boolean showReactionName = false;
    protected ColorFont conceptTitleFont = new ColorFont("Arial", 0, 12, Color.black);
    public Pen conceptPen = new Pen(1.0f, Color.black);
    protected ColorFont functionTitleFont = new ColorFont("Arial", 2, 12, Color.blue);
    protected ColorFont processTitleFont = new ColorFont("Arial", 0, 12, Color.black);
    protected ColorFont stateTitleFont = new ColorFont("Arial", 0, 12, Color.black);
    public Pen statePen = new Pen(1.0f, Color.black);
    protected ColorFont relationTitleFont = new ColorFont("Arial", 0, 12, Color.black);
    protected Point titleMargin = new Point(3, 2);
    protected RelationTypeColor[] relationTypeColors = new RelationTypeColor[]{new RelationTypeColor("default", Color.blue.darker())};
    protected RelationTypeStroke[] relationTypeStrokes = new RelationTypeStroke[]{new RelationTypeStroke("default", new BasicStroke(1.0f)), new RelationTypeStroke("direct", new BasicStroke(1.0f)), new RelationTypeStroke("unknown", new BasicStroke(1.0f)), new RelationTypeStroke("indirect", new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{7.0f, 3.0f}, 0.0f))};
    protected Map<String, Object> semanticRelationOptions;

    public PathwayDiagramViewOptions(Option parent) {
        super(parent);
        this.setDiagramTitleVisible(false);
        this.setCompartmentTitleAlignment(111);
        this.initSemanticRelationOptions();
    }

    public Point getTitleMargin() {
        return this.titleMargin;
    }

    public void setTitleMargin(Point titleMargin) {
        Point oldValue = this.titleMargin;
        this.titleMargin = titleMargin;
        this.firePropertyChange("titleMargin", oldValue, titleMargin);
    }

    public RelationTypeColor[] getRelationTypeColors() {
        return this.relationTypeColors;
    }

    public void setRelationTypeColors(RelationTypeColor[] relationTypeColors) {
        RelationTypeColor[] oldValue = relationTypeColors;
        this.relationTypeColors = relationTypeColors;
        this.firePropertyChange("relationTypeColors", oldValue, relationTypeColors);
    }

    public RelationTypeStroke[] getRelationTypeStrokes() {
        return this.relationTypeStrokes;
    }

    public void setRelationTypeStrokes(RelationTypeStroke[] relationTypeStrokes) {
        RelationTypeStroke[] oldValue = relationTypeStrokes;
        this.relationTypeStrokes = relationTypeStrokes;
        this.firePropertyChange("relationTypeStrokes", oldValue, relationTypeStrokes);
    }

    public void initSemanticRelationOptions() {
        this.semanticRelationOptions = new HashMap<String, Object>();
        for (RelationTypeColor typeColor : this.relationTypeColors) {
            this.semanticRelationOptions.put(BRUSH + typeColor.getType(), new Brush((Paint)typeColor.getColor()));
            for (RelationTypeStroke typeStroke : this.relationTypeStrokes) {
                this.semanticRelationOptions.put(PEN + typeColor.getType() + typeStroke.getType(), new Pen(typeStroke.getStroke(), typeColor.getColor()));
            }
        }
    }

    public Pen getSemanticRelationPen(String relationType, String participationType) {
        Object pen = this.semanticRelationOptions.get(PEN + relationType + participationType);
        if (pen == null) {
            pen = this.semanticRelationOptions.get("pendefault" + participationType);
        }
        if (pen == null) {
            pen = this.semanticRelationOptions.get(PEN + relationType + DEFAULT);
        }
        if (pen == null) {
            pen = this.semanticRelationOptions.get("pendefaultdefault");
        }
        return (Pen)pen;
    }

    public Brush getSemanticRelationBrush(String relationType) {
        Object brush = this.semanticRelationOptions.get(BRUSH + relationType);
        if (brush == null) {
            brush = this.semanticRelationOptions.get("brushdefault");
        }
        return (Brush)brush;
    }

    public ColorFont getStateTitleFont() {
        return this.stateTitleFont;
    }

    public void setStateTitleFont(ColorFont stateTitleFont) {
        this.stateTitleFont = stateTitleFont;
    }

    public static class RelationTypeStroke {
        protected String type;
        protected BasicStroke stroke;

        public RelationTypeStroke(String type, BasicStroke stroke) {
            this.type = type;
            this.stroke = stroke;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public BasicStroke getStroke() {
            return this.stroke;
        }

        public void setStroke(BasicStroke stroke) {
            this.stroke = stroke;
        }
    }

    public static class RelationTypeColor {
        protected String type;
        protected Color color;

        public RelationTypeColor(String type, Color color) {
            this.type = type;
            this.color = color;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

