/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultDiagramViewBuilder;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.GlobalViewOptions;
import biouml.model.Node;
import biouml.standard.diagram.PathwayDiagramViewOptions;
import biouml.standard.type.Base;
import biouml.standard.type.Biopolymer;
import biouml.standard.type.Protein;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.EllipseView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.PolylineView;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class PathwayDiagramViewBuilder
extends DefaultDiagramViewBuilder {
    private static final String DEPENDENCY_TYPE = "dependencyType";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new PathwayDiagramViewOptions(null);
    }

    @Override
    @Nonnull
    public CompositeView createDiagramView(Diagram diagram, Graphics g) {
        CompositeView diagramView = super.createDiagramView(diagram, g);
        this.createReactionTitles(diagram, diagramView, diagram.getViewOptions(), g);
        diagramView.updateBounds();
        return diagramView;
    }

    public void createReactionTitles(Compartment compartment, CompositeView diagramView, DiagramViewOptions diagramOptions, Graphics g) {
        boolean showReactionName = false;
        if (diagramOptions instanceof PathwayDiagramViewOptions) {
            showReactionName = ((PathwayDiagramViewOptions)diagramOptions).showReactionName;
        }
        if (showReactionName) {
            Iterator<DiagramElement> iterator = compartment.iterator();
            while (iterator.hasNext()) {
                DiagramElement de = iterator.next();
                if (de.getKernel() instanceof Reaction) {
                    this.createReactionTitle(de, diagramView, diagramOptions, g);
                    continue;
                }
                if (!(de instanceof Compartment)) continue;
                this.createReactionTitles((Compartment)de, diagramView, diagramOptions, g);
            }
        }
    }

    protected boolean createConceptCoreView(CompositeView container, Node node, String title, PathwayDiagramViewOptions diagramOptions, Graphics g) {
        ComplexTextView view = new ComplexTextView(title, PathwayDiagramViewBuilder.getTitleFont(node, diagramOptions.conceptTitleFont), diagramOptions.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        container.add((View)view);
        Rectangle r = container.getBounds();
        Point d = diagramOptions.getTitleMargin();
        int[] x = new int[]{0, 10, r.width + d.x * 3, r.width + 10 + d.x * 3, r.width + d.x * 3, 10};
        int[] y = new int[]{(r.height + d.y * 3) / 2, 0, 0, (r.height + d.y * 3) / 2, r.height + d.y * 3, r.height + d.y * 3};
        container.add((View)new PolygonView(PathwayDiagramViewBuilder.getBorderPen(node, diagramOptions.conceptPen), null, x, y), 127, null);
        return false;
    }

    protected boolean createFunctionCoreView(CompositeView container, Node node, String title, PathwayDiagramViewOptions diagramOptions, Graphics g) {
        ComplexTextView view = new ComplexTextView(title, PathwayDiagramViewBuilder.getTitleFont(node, diagramOptions.functionTitleFont), diagramOptions.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        container.add((View)view);
        return false;
    }

    protected boolean createProcessCoreView(CompositeView container, Node node, String title, PathwayDiagramViewOptions diagramOptions, Graphics g) {
        ComplexTextView view = new ComplexTextView(title, PathwayDiagramViewBuilder.getTitleFont(node, diagramOptions.processTitleFont), diagramOptions.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        container.add((View)view);
        return false;
    }

    protected boolean createStateCoreView(CompositeView container, Node node, String title, PathwayDiagramViewOptions diagramOptions, Graphics g) {
        ComplexTextView view = new ComplexTextView(title, PathwayDiagramViewBuilder.getTitleFont(node, diagramOptions.stateTitleFont), diagramOptions.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        container.add((View)view);
        Point d = diagramOptions.getTitleMargin();
        Rectangle r = container.getBounds();
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(0.0f, 0.0f, r.width + d.x * 3, r.height + d.y * 3, 10.0f, 10.0f);
        container.add((View)new BoxView(PathwayDiagramViewBuilder.getBorderPen(node, diagramOptions.statePen), null, (RectangularShape)rect), 127, null);
        return false;
    }

    protected boolean createCellCoreView(CompositeView container, Node node, DiagramViewOptions diagramOptions, Graphics g) {
        PathwayDiagramViewOptions options = (PathwayDiagramViewOptions)diagramOptions;
        Pen p = options.getDefaultPen();
        container.add((View)new EllipseView(p, PathwayDiagramViewBuilder.getBrush(node, options.cellCytoplasmBrush), 0.0f, 0.0f, 35.0f, 23.0f));
        container.add((View)new EllipseView(p, options.cellNucleusBrush, 11.0f, 5.0f, 14.0f, 14.0f));
        return true;
    }

    protected boolean createGeneCoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g) {
        Pen p = PathwayDiagramViewBuilder.getBorderPen(node, options.getDefaultPen());
        container.add((View)new BoxView(p, PathwayDiagramViewBuilder.getBrush(node, options.geneBrush), 0, 0, 27, 13));
        container.add((View)new LineView(p, -6.0f, 6.0f, 0.0f, 6.0f));
        container.add((View)new LineView(p, 28.0f, 6.0f, 34.0f, 6.0f));
        PolylineView l = new PolylineView(p);
        l.addPoint(13, 0);
        l.addPoint(13, -9);
        l.addPoint(27, -9);
        container.add((View)l);
        l = new PolylineView(p);
        l.addPoint(22, -12);
        l.addPoint(27, -9);
        l.addPoint(22, -6);
        container.add((View)l);
        return PathwayDiagramViewBuilder.hasTitle(node);
    }

    protected boolean createRNACoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g) {
        Pen p = PathwayDiagramViewBuilder.getBorderPen(node, options.getDefaultPen());
        PolylineView l = new PolylineView(p);
        for (int i = 0; i < 9; ++i) {
            l.addPoint(i * 3, i / 2 * 2 == i ? 0 : 5);
        }
        container.add((View)l);
        return PathwayDiagramViewBuilder.hasTitle(node);
    }

    protected boolean createProteinCoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g, String functionalState, String configuration, String modification) {
        Pen p = PathwayDiagramViewBuilder.getBorderPen(node, options.getDefaultPen());
        Brush b = PathwayDiagramViewBuilder.getBrush(node, options.proteinBrush);
        Brush bP = PathwayDiagramViewBuilder.getBrush(node, options.modifiedProteinBrush);
        if (functionalState != null) {
            if (functionalState.equals("active")) {
                b = PathwayDiagramViewBuilder.getBrush(node, options.activeProteinBrush);
            } else if (functionalState.equals("inactive")) {
                b = PathwayDiagramViewBuilder.getBrush(node, options.inactiveProteinBrush);
            }
        }
        if (configuration == null) {
            configuration = "unknown";
        }
        if (modification == null) {
            modification = "none";
        }
        if (configuration.equals("homodimer")) {
            container.add((View)new EllipseView(p, b, 0.0f, 0.0f, 18.0f, 30.0f));
            container.add((View)new EllipseView(p, b, 12.0f, 0.0f, 18.0f, 30.0f));
            this.paintModification(modification, container, g, p, bP, 23, 1);
        } else if (configuration.equals("heterodimer")) {
            container.add((View)new EllipseView(p, b, 0.0f, 0.0f, 20.0f, 20.0f));
            container.add((View)new EllipseView(p, b, 12.0f, 0.0f, 18.0f, 30.0f));
            this.paintModification(modification, container, g, p, bP, 23, 1);
        } else if (configuration.equals("multimer") || configuration.equals("complex")) {
            container.add((View)new EllipseView(p, b, 0.0f, 0.0f, 20.0f, 20.0f));
            container.add((View)new EllipseView(p, b, 20.0f, 0.0f, 20.0f, 20.0f));
            container.add((View)new EllipseView(p, b, 10.0f, -17.0f, 20.0f, 20.0f));
            this.paintModification(modification, container, g, p, bP, 23, 1);
        } else {
            container.add((View)new EllipseView(p, b, 0.0f, 0.0f, 30.0f, 30.0f));
            this.paintModification(modification, container, g, p, bP, 23, 1);
        }
        return PathwayDiagramViewBuilder.hasTitle(node);
    }

    protected boolean createPhysicalEntityCoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g) {
        Pen p = PathwayDiagramViewBuilder.getBorderPen(node, options.getDefaultPen());
        Brush b = PathwayDiagramViewBuilder.getBrush(node, options.physicalEntityBrush);
        container.add((View)new EllipseView(p, b, 0.0f, 0.0f, 20.0f, 20.0f));
        return true;
    }

    private void paintModification(String modification, CompositeView container, Graphics g, Pen p, Brush bP, int xCenter, int yCenter) {
        String text = null;
        if (modification.equals("phosphorylated")) {
            text = "P";
        }
        if (modification.equals("fatty_acylation")) {
            text = "Fa";
        }
        if (modification.equals("prenylation")) {
            text = "Pr";
        }
        if (modification.equals("cholesterolation")) {
            text = "Ch";
        }
        if (modification.equals("ubiquitination")) {
            text = "U";
        }
        if (modification.equals("sumolation")) {
            text = "S";
        }
        if (modification.equals("glycation")) {
            text = "Gy";
        }
        if (modification.equals("gpi_anchor")) {
            text = "GPI";
        }
        if (modification.equals("unknown")) {
            text = "?";
        }
        if (text != null) {
            ColorFont font = new ColorFont("Courier New", 1, 10, Color.BLACK);
            FontMetrics fontMetrics = g.getFontMetrics(font.getFont());
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(text, g);
            int width = 16;
            int height = 16;
            container.add((View)new EllipseView(p, bP, (float)xCenter, (float)yCenter, (float)width, (float)height));
            width = xCenter + width / 2 + 1 - fontMetrics.stringWidth(text) / 2;
            height = yCenter + height + 1 - (int)lineMetrics.getHeight() / 2;
            container.add((View)new TextView(text, new Point(width, height), 0, font, g));
        }
    }

    protected boolean createSubstanceCoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g) {
        Pen p = PathwayDiagramViewBuilder.getBorderPen(node, options.getDefaultPen());
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(0.0f, 0.0f, 30.0f, 30.0f, 10.0f, 10.0f);
        container.add((View)new BoxView(p, PathwayDiagramViewBuilder.getBrush(node, options.substanceBrush), (RectangularShape)rect));
        return PathwayDiagramViewBuilder.hasTitle(node);
    }

    protected boolean createReactionCoreView(CompositeView container, Node node, PathwayDiagramViewOptions options, Graphics g) {
        Brush brush = PathwayDiagramViewBuilder.getBrush(node, this.getReactionBrush(node.getKernel(), options));
        container.add((View)new EllipseView(null, brush, 0.0f, 0.0f, 7.0f, 7.0f));
        if (options.automaticallyLocateReactions) {
            node.setView((View)container);
            this.locateReaction(node, options, g);
        }
        return false;
    }

    protected void createReactionTitle(DiagramElement reaction, CompositeView diagramView, DiagramViewOptions options, Graphics g) {
        View reactionView = reaction.getView();
        if (reactionView != null) {
            Rectangle rBounds = reactionView.getBounds();
            ComplexTextView titleView = new ComplexTextView(reaction.getTitle(), PathwayDiagramViewBuilder.getTitleFont(reaction, options.getNodeTitleFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
            Rectangle tBounds = titleView.getBounds();
            titleView.setLocation(rBounds.x + (rBounds.width - tBounds.width) / 2, rBounds.y + rBounds.height);
            diagramView.add((View)titleView);
        }
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions viewOptions, Graphics g) {
        PathwayDiagramViewOptions options = (PathwayDiagramViewOptions)viewOptions;
        Base kernel = node.getKernel();
        String type = kernel.getType();
        if (type.startsWith("semantic-concept")) {
            String title = node.getTitle();
            if (title == null) {
                title = node.getName();
            }
            if ("semantic-concept".equals(type)) {
                return this.createConceptCoreView(container, node, title, options, g);
            }
            if ("semantic-concept-function".equals(type)) {
                return this.createFunctionCoreView(container, node, title, options, g);
            }
            if ("semantic-concept-process".equals(type)) {
                return this.createProcessCoreView(container, node, title, options, g);
            }
            if ("semantic-concept-state".equals(type)) {
                return this.createStateCoreView(container, node, title, options, g);
            }
        }
        if ("compartment-cell".equals(type)) {
            return this.createCellCoreView(container, node, options, g);
        }
        if ("molecule-gene".equals(type)) {
            return this.createGeneCoreView(container, node, options, g);
        }
        if ("molecule-RNA".equals(type)) {
            return this.createRNACoreView(container, node, options, g);
        }
        if ("molecule-protein".equals(type)) {
            if (!(kernel instanceof Protein)) {
                return this.createProteinCoreView(container, node, options, g, null, null, null);
            }
            Protein protein = (Protein)kernel;
            return this.createProteinCoreView(container, node, options, g, protein.getFunctionalState(), protein.getStructure(), protein.getModification());
        }
        if ("molecule-substance".equals(type)) {
            return this.createSubstanceCoreView(container, node, options, g);
        }
        if ("physical-entity".equals(type)) {
            return this.createPhysicalEntityCoreView(container, node, options, g);
        }
        if (this.isReaction(kernel)) {
            return this.createReactionCoreView(container, node, options, g);
        }
        return super.createNodeCoreView(container, node, options, g);
    }

    @Override
    @Nonnull
    public CompositeView createNodeView(Node node, DiagramViewOptions options, Graphics g) {
        String name;
        int pos;
        CompositeView view = super.createNodeView(node, options, g);
        Base kernel = node.getKernel();
        if (kernel instanceof Biopolymer && (pos = (name = kernel.getName()).indexOf(58)) > 0) {
            String speciesPrefix = name.substring(0, name.indexOf(58));
            TextView species = new TextView("(" + speciesPrefix + ")", options.getNodeTitleFont(), g);
            view.add((View)species, 79, null);
        }
        return view;
    }

    @Override
    @Nonnull
    public CompositeView createEquivalentNodeGroupView(EquivalentNodeGroup group, DiagramViewOptions options, Graphics g) {
        Object[] kernels;
        String species;
        CompositeView view = super.createEquivalentNodeGroupView(group, options, g);
        Node node = group.getRepresentative();
        Base kernel = node.getKernel();
        if (kernel instanceof Biopolymer && (species = ((StreamEx)StreamEx.of((Object[])(kernels = group.getKernels())).map(DataElement::getName).map(name -> name.substring(0, name.indexOf(58))).distinct()).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")")).length() > "()".length()) {
            TextView speciesView = new TextView(species, options.getNodeTitleFont(), g);
            view.add((View)speciesView, 79, null);
        }
        return view;
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions viewOptions, Graphics g) {
        if (edge.getKernel().getType().equals("dependency")) {
            return this.createDependencyView(edge, g);
        }
        if (edge.getKernel().getType().equals("relation-semantic")) {
            return this.createSemanticRelationView(edge, (PathwayDiagramViewOptions)viewOptions, g);
        }
        PathwayDiagramViewOptions options = (PathwayDiagramViewOptions)viewOptions;
        Pen pen = PathwayDiagramViewBuilder.getBorderPen(edge, this.getRelationPen(edge, options));
        CompositeView view = new CompositeView();
        if (edge.getPath() == null) {
            Diagram.getDiagram(edge).getType().getSemanticController().recalculateEdgePath(edge);
        }
        SimplePath path = edge.getSimplePath();
        ArrowView arrow = new ArrowView(pen, PathwayDiagramViewBuilder.getBrush(edge, options.reactionBrush), path, this.getRelationStartTip(edge, options), this.getRelationEndTip(edge, pen, options));
        arrow.setModel((Object)edge);
        arrow.setActive(true);
        view.add((View)arrow);
        view.setModel((Object)edge);
        view.setActive(false);
        return view;
    }

    @Override
    protected boolean calculateInOut(Edge edge, Point in, Point out, int offsetStart, int offsetEnd) {
        int inOffset = offsetStart;
        int outOffset = offsetEnd;
        if (edge.getInput().getKernel().getType().equals("reaction")) {
            inOffset = 0;
        }
        if (edge.getOutput().getKernel().getType().equals("reaction")) {
            outOffset = 0;
        }
        return super.calculateInOut(edge, in, out, inOffset, outOffset);
    }

    @Nonnull
    public CompositeView createSemanticRelationView(Edge edge, PathwayDiagramViewOptions viewOptions, Graphics g) {
        SemanticRelation relation = (SemanticRelation)edge.getKernel();
        Pen pen = PathwayDiagramViewBuilder.getBorderPen(edge, viewOptions.getSemanticRelationPen(relation.getRelationType(), relation.getParticipation()));
        Brush brush = PathwayDiagramViewBuilder.getBrush(edge, viewOptions.getSemanticRelationBrush(relation.getRelationType()));
        ArrowView.Tip endTip = ArrowView.createSimpleTip((Pen)viewOptions.getSemanticRelationPen(relation.getRelationType(), "default"), (int)10, (int)5);
        String titleString = edge.getTitle();
        if (titleString != null) {
            if (titleString.equalsIgnoreCase(INCREASE)) {
                endTip = ArrowView.createTriangleTip((Pen)viewOptions.getSemanticRelationPen(relation.getRelationType(), "default"), (Brush)new Brush((Paint)Color.white), (int)10, (int)5);
            } else if (titleString.equalsIgnoreCase(DECREASE)) {
                endTip = ArrowView.createLineTip((Pen)viewOptions.getSemanticRelationPen(relation.getRelationType(), "default"), null, (int)0, (int)6);
            }
        }
        CompositeView view = new CompositeView();
        view.setModel((Object)edge);
        Path path = edge.getPath();
        if (path == null || path.npoints < 2) {
            path = new Path();
            Point in = new Point();
            Point out = new Point();
            if (!this.calculateInOut(edge, in, out)) {
                return view;
            }
            path.addPoint(in.x, in.y);
            path.addPoint(out.x, out.y);
            edge.setPath(path);
        }
        Point outPort = new Point(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1]);
        Point inPort = new Point(path.xpoints[0], path.ypoints[0]);
        ArrowView arrow = new ArrowView(pen, brush, edge.getSimplePath(), null, endTip);
        arrow.setModel((Object)edge);
        arrow.setActive(true);
        view.add((View)arrow);
        Point controlPoint = null;
        controlPoint = arrow.getPathView() != null ? arrow.getPathView().getMiddlePoint() : new Point((path.xpoints[0] + path.xpoints[1]) / 2, (path.ypoints[0] + path.ypoints[1]) / 2);
        TextView title = null;
        if (titleString != null && titleString.length() > 0 && this.showRelationTitle(titleString)) {
            float a = (float)(outPort.y - inPort.y) / ((float)(outPort.x - inPort.x) + 0.1f);
            int alignment = (double)Math.abs(a) < 0.2 ? 63 : 121;
            Point middlePoint = new Point(controlPoint.x - 7, controlPoint.y);
            title = new TextView(titleString, middlePoint, alignment, PathwayDiagramViewBuilder.getTitleFont(edge, viewOptions.relationTitleFont), g);
            title.setActive(true);
            title.setModel((Object)edge);
        }
        if (title != null) {
            view.add(title);
        }
        return view;
    }

    protected boolean showRelationTitle(String titleString) {
        return !titleString.equalsIgnoreCase(INCREASE) && !titleString.equalsIgnoreCase(DECREASE) && !titleString.equalsIgnoreCase("influence");
    }

    private static Polygon[] dividePolygon(Polygon p) {
        if (p == null || p.npoints < 2) {
            return null;
        }
        int n = p.npoints;
        double[] len = new double[n - 1];
        double totalLength = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double segLen;
            len[i] = segLen = Math.sqrt((p.xpoints[i + 1] - p.xpoints[i]) * (p.xpoints[i + 1] - p.xpoints[i]) + (p.ypoints[i + 1] - p.ypoints[i]) * (p.ypoints[i + 1] - p.ypoints[i]));
            totalLength += segLen;
        }
        double lenAfterDivided = 0.0;
        int toDivide = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (!((lenAfterDivided += len[i]) > totalLength / 2.0)) continue;
            toDivide = i;
            break;
        }
        int xBeforeDivided = p.xpoints[toDivide];
        int yBeforeDivided = p.ypoints[toDivide];
        int xAfterDivided = p.xpoints[toDivide + 1];
        int yAfterDivided = p.ypoints[toDivide + 1];
        double dividedSegmentLen = len[toDivide];
        double lenBeforeDivided = lenAfterDivided - dividedSegmentLen;
        double fraction = (totalLength / 2.0 - lenBeforeDivided) / dividedSegmentLen;
        int divideX = (int)((double)xBeforeDivided + fraction * (double)(xAfterDivided - xBeforeDivided));
        int divideY = (int)((double)yBeforeDivided + fraction * (double)(yAfterDivided - yBeforeDivided));
        Polygon first = new Polygon();
        for (int i = 0; i <= toDivide; ++i) {
            first.addPoint(p.xpoints[i], p.ypoints[i]);
        }
        first.addPoint(divideX, divideY);
        Polygon second = new Polygon();
        second.addPoint(divideX, divideY);
        for (int i = toDivide + 1; i < n; ++i) {
            second.addPoint(p.xpoints[i], p.ypoints[i]);
        }
        return new Polygon[]{first, second};
    }

    public void locateReaction(Node reactionNode, DiagramViewOptions options, Graphics g) {
        try {
            this.doLocateReaction(reactionNode, options, g);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Can not locate reaction: " + reactionNode.getKernel().getName() + "\n  error: " + t);
        }
    }

    protected void doLocateReaction(Node reactionNode, DiagramViewOptions options, Graphics g) {
        ArrayList<Object> species = new ArrayList<Object>();
        boolean hasReactants = false;
        boolean hasProducts = false;
        for (Edge edge : reactionNode.edges()) {
            Base kernel = edge.getKernel();
            Node specie = edge.getOtherEnd(reactionNode);
            Object view = specie.getView();
            if (view == null) {
                view = this.createNodeView(specie, options, g);
            }
            if (kernel instanceof SpecieReference) {
                SpecieReference ref = (SpecieReference)kernel;
                if (ref.isReactantOrProduct()) {
                    species.add(view);
                }
                if (ref.getRole().equals("reactant")) {
                    hasReactants = true;
                    continue;
                }
                if (!ref.getRole().equals("product")) continue;
                hasProducts = true;
                continue;
            }
            species.add(view);
            if (edge.getInput() == reactionNode) {
                hasProducts = true;
                continue;
            }
            hasReactants = true;
        }
        View reactionView = reactionNode.getView();
        if (reactionView == null) {
            reactionView = this.createNodeView(reactionNode, options, g);
        }
        int x = 0;
        int y = 0;
        int n = 0;
        for (View view : species) {
            Rectangle bounds = view.getBounds();
            x += bounds.x + bounds.width / 2;
            y += bounds.y + bounds.height / 2;
            ++n;
        }
        Rectangle bounds = reactionView.getBounds();
        reactionNode.setLocation(x / n - bounds.width / 2, y / n - bounds.height / 2);
        int dx = 50;
        Point p = reactionNode.getLocation();
        if (hasReactants && !hasProducts) {
            reactionNode.setLocation(p.x + dx, p.y);
        } else if (!hasReactants && !hasProducts) {
            reactionNode.setLocation(p.x - dx, p.y);
        }
    }

    protected Brush getReactionBrush(Base reaction, PathwayDiagramViewOptions options) {
        return options.reactionBrush;
    }

    protected Pen getRelationPen(Edge edge, PathwayDiagramViewOptions options) {
        String type;
        if (edge.getKernel() instanceof Stub.NoteLink) {
            return options.getNoteLinkPen();
        }
        Pen pen = options.reactionPen;
        Base kernel = edge.getKernel();
        if (kernel instanceof SpecieReference && (type = ((SpecieReference)kernel).getModifierAction()) != null) {
            if (type.equals("catalyst")) {
                pen = options.catalystActionPen;
            } else if (type.equals("inhibitor")) {
                pen = options.inhibitorActionPen;
            } else if (type.equals("switch on")) {
                pen = options.switchOnActionPen;
            } else if (type.equals("switch off")) {
                pen = options.switchOffActionPen;
            }
        }
        return pen;
    }

    protected ArrowView.Tip getRelationStartTip(Edge edge, PathwayDiagramViewOptions options) {
        return null;
    }

    protected ArrowView.Tip getRelationEndTip(Edge edge, Pen pen, PathwayDiagramViewOptions options) {
        ArrowView.Tip endTip = null;
        Base kernel = edge.getInput().getKernel();
        if (this.isReaction(kernel)) {
            endTip = ArrowView.createArrowTip((Pen)pen, (Brush)PathwayDiagramViewBuilder.getBrush(edge, this.getReactionBrush(kernel, options)), (int)5, (int)10, (int)4);
        }
        return endTip;
    }

    @Nonnull
    public CompositeView createDependencyView(Edge edge, Graphics g) {
        String depType = edge.getAttributes().getValueAsString(DEPENDENCY_TYPE);
        Pen pen = PathwayDiagramViewBuilder.getBorderPen(edge, this.getDependencyPen(depType));
        if (edge.getPath() == null) {
            Diagram.getDiagram(edge).getType().getSemanticController().recalculateEdgePath(edge);
        }
        ArrowView arrow = new ArrowView(pen, new Brush((Paint)Color.white), edge.getSimplePath(), null, this.getDependencyTip(depType, pen));
        arrow.setActive(true);
        arrow.setModel((Object)edge);
        return arrow;
    }

    public Pen getDependencyPen(String dependencyType) {
        if (INCREASE.equals(dependencyType)) {
            return new Pen(1.0f, Color.red);
        }
        if (DECREASE.equals(dependencyType)) {
            return new Pen(1.0f, Color.blue);
        }
        return new Pen(1.0f, Color.black);
    }

    public ArrowView.Tip getDependencyTip(String dependencyType, Pen pen) {
        if (INCREASE.equals(dependencyType)) {
            return ArrowView.createTriangleTip((Pen)pen, (Brush)new Brush((Paint)Color.white), (int)10, (int)5);
        }
        if (DECREASE.equals(dependencyType)) {
            return ArrowView.createLineTip((Pen)pen, null, (int)3, (int)6);
        }
        return ArrowView.createSimpleTip((Pen)pen, (int)10, (int)5);
    }
}

