/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.DiagramViewOptions;
import biouml.model.Node;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.TableElement;
import biouml.standard.diagram.MathDiagramViewOptions;
import biouml.standard.diagram.PathwaySimulationDiagramViewBuilder;
import biouml.standard.diagram.PathwaySimulationDiagramViewOptions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;

public class MathDiagramViewBuilder
extends PathwaySimulationDiagramViewBuilder {
    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new MathDiagramViewOptions(null);
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        if ("table entity".equals(node.getKernel().getType())) {
            return this.createTableEntityCoreView(container, node, options, g);
        }
        return super.createNodeCoreView(container, node, options, g);
    }

    @Override
    protected boolean createEquationView(CompositeView view, Node node, PathwaySimulationDiagramViewOptions options, Graphics g, boolean isInsideBlock) {
        Equation eq = (Equation)node.getRole();
        boolean simple = ((MathDiagramViewOptions)options).getEquationStyle().equals("Simple");
        if (eq != null && eq.getVariable() != null) {
            String equationText;
            if (Equation.isScalar(eq.getType()) || eq.getType().equals("initial assignment")) {
                equationText = eq.getVariable();
                if (!simple) {
                    equationText = equationText + " = " + eq.getFormula();
                }
                view.add(this.createMathView(eq, equationText, options, g));
            } else if (eq.getType().equals("rate")) {
                if (simple) {
                    equationText = eq.getVariable();
                } else {
                    equationText = "diff(" + eq.getVariable() + ", time)";
                    if (!simple) {
                        equationText = equationText + " = " + eq.getFormula();
                    }
                }
                view.add(this.createMathView(eq, equationText, options, g));
            } else {
                view.add(this.createMathView(eq, eq.getFormula(), options, g));
                view.add((View)new TextView(" = 0", this.formulaViewBuilder.getDefaultFont(), g), 121);
            }
        }
        if (node.isShowTitle()) {
            TextView textView = new TextView(node.getTitle(), MathDiagramViewBuilder.getTitleFont(node, options.getMathTitleFont()), g);
            view.add((View)textView, 28, new Point(0, -textView.getBounds().height));
        }
        int d = options.borderOffset;
        Rectangle r = view.getBounds();
        if (!isInsideBlock) {
            view.add((View)new BoxView(MathDiagramViewBuilder.getBorderPen(node, options.getMathPen()), null, (RectangularShape)new RoundRectangle2D.Float(r.x - d, r.y - d, r.width + d * 2, r.height + d * 2, 10.0f, 10.0f)));
        }
        return false;
    }

    public boolean createTableEntityCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        int i;
        TableElement te = node.getRole(TableElement.class);
        if (te.getTable() == null) {
            TextView header = new TextView("Please specify table!", options.getDefaultFont(), g);
            header.setLocation(5, 5);
            int width = header.getBounds().width + 10;
            int headerheight = header.getBounds().height;
            int height = headerheight * 3 + 15;
            container.add((View)new BoxView(options.getDefaultPen(), new Brush((Paint)Color.white), 0, 0, width, height));
            container.add((View)new LineView(options.getDefaultPen(), (float)width / 2.0f, (float)(headerheight + 5), (float)width / 2.0f, (float)height));
            container.add((View)new LineView(options.getDefaultPen(), 0.0f, (float)(headerheight + 5), (float)width, (float)(headerheight + 5)));
            container.add((View)new LineView(options.getDefaultPen(), 0.0f, (float)(headerheight * 2 + 10), (float)width, (float)(headerheight * 2 + 10)));
            container.add((View)header);
            return false;
        }
        TableElement.Variable[] variables = te.getVariables();
        String formula = te.getFormula();
        if (formula == null) {
            formula = "No formula";
        }
        TextView header = new TextView(formula, options.getDefaultFont(), g);
        header.setLocation(0, 0);
        container.add((View)header);
        int size = variables.length;
        LineView[] verticalLines = new LineView[size - 1];
        TextView[] colNames = new TextView[size];
        TextView[] varNames = new TextView[size];
        int yStart = header.getBounds().height;
        int y = 0;
        int x = 0;
        for (i = 0; i < size; ++i) {
            String colName = variables[i].getColumnName();
            String varName = variables[i].getName();
            colNames[i] = new TextView(colName, options.getDefaultFont(), g);
            varNames[i] = new TextView(varName, options.getDefaultFont(), g);
            y = colNames[i].getBounds().height + 10 + yStart;
            colNames[i].setLocation(x += 5, 5 + yStart);
            varNames[i].setLocation(x, 5 + yStart);
            x += Math.max(colNames[i].getBounds().width, varNames[i].getBounds().width) + 5;
            if (i >= size - 1) continue;
            verticalLines[i] = new LineView(options.getDefaultPen(), (float)x, (float)yStart, (float)x, (float)(y * 3 + 15));
        }
        for (i = 0; i < size; ++i) {
            varNames[i].setLocation(varNames[i].getBounds().getLocation().x, y + 5);
        }
        container.add((View)new BoxView(options.getDefaultPen(), new Brush((Paint)Color.white), 0, yStart, x, y * 3 + 15 - yStart));
        for (i = 0; i < size - 1; ++i) {
            container.add((View)colNames[i]);
            container.add((View)varNames[i]);
            container.add((View)verticalLines[i]);
        }
        container.add((View)colNames[size - 1]);
        container.add((View)varNames[size - 1]);
        container.add((View)new LineView(options.getDefaultPen(), 0.0f, (float)y, (float)x, (float)y));
        container.add((View)new LineView(options.getDefaultPen(), 0.0f, (float)(2 * y + 5), (float)x, (float)(2 * y + 5)));
        return false;
    }

    @Override
    public boolean forbidCustomImage(Node node) {
        return true;
    }
}

