/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.MathCalculator;
import biouml.model.dynamics.MathContext;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class MathDiagramUtility {
    private static final String DEPENDENCY_TYPE = "dependencyType";
    protected static final Logger log = Logger.getLogger(DiagramUtility.class.getName());

    public static void removeDependencies(Diagram diagram) {
        for (Edge e2 : ((StreamEx)diagram.recursiveStream().select(Edge.class).filter(e -> e.getKernel() instanceof Stub.Dependency)).toList()) {
            try {
                e2.getOrigin().remove(e2.getName());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static Map<String, Set<biouml.model.Node>> findEquationNodes(EModel emodel) {
        HashMap<String, Set<biouml.model.Node>> equationNodes = new HashMap<String, Set<biouml.model.Node>>();
        ((StreamEx)emodel.getEquations().filter(eq -> eq.getDiagramElement() instanceof biouml.model.Node && !eq.hasDelegate())).forEach(eq -> {
            Variable var = emodel.getVariable(eq.getVariable());
            if (var != null) {
                equationNodes.computeIfAbsent(var.getName(), k -> new HashSet()).add(MathDiagramUtility.getActualNode((biouml.model.Node)eq.getDiagramElement()));
            }
        });
        return equationNodes;
    }

    public static Map<String, Set<biouml.model.Node>> findVariableNodes(EModel emodel) {
        HashMap<String, Set<biouml.model.Node>> variableNodes = new HashMap<String, Set<biouml.model.Node>>();
        emodel.getVariableRoles().stream().filter(v -> Util.isVariable(v.getDiagramElement())).forEach(v -> variableNodes.computeIfAbsent(v.getName(), k -> new HashSet()).add((biouml.model.Node)v.getDiagramElement()));
        return variableNodes;
    }

    public static Set<biouml.model.Node> findPortNodes(Diagram diagram, String varName, boolean input) {
        HashSet<biouml.model.Node> ports = new HashSet<biouml.model.Node>();
        EModel emodel = diagram.getRole(EModel.class);
        ((StreamEx)diagram.recursiveStream().filter(de -> Util.isInputPort(de) && input || Util.isOutputPort(de) && !input || Util.isContactPort(de))).forEach(de -> {
            biouml.model.Node n = (biouml.model.Node)((Object)de);
            String variable = Util.getPortVariable(n);
            if (variable == null || !emodel.containsVariable(variable)) {
                log.log(Level.SEVERE, "Error: port " + de.getName() + " does not have variable name or variable is incorrect");
            } else if (varName.equals(emodel.getVariable(variable).getName())) {
                ports.add(n);
            }
        });
        return ports;
    }

    public static Map<String, biouml.model.Node> findPortNodes(Diagram diagram, boolean input) {
        HashMap<String, biouml.model.Node> ports = new HashMap<String, biouml.model.Node>();
        EModel emodel = diagram.getRole(EModel.class);
        ((StreamEx)diagram.recursiveStream().filter(de -> Util.isInputPort(de) && input || Util.isOutputPort(de) && !input || Util.isContactPort(de))).forEach(de -> {
            biouml.model.Node n = (biouml.model.Node)((Object)de);
            String variable = Util.getPortVariable(n);
            if (variable == null || !emodel.containsVariable(variable)) {
                log.log(Level.SEVERE, "Error: port " + de.getName() + " does not have variable name or variable is incorrect");
            } else {
                ports.put(emodel.getVariable(variable).getName(), n);
            }
        });
        return ports;
    }

    public static void generateDependencies(Diagram diagram) {
        if (!(diagram.getRole() instanceof EModel)) {
            return;
        }
        EModel emodel = diagram.getRole(EModel.class);
        Map<String, Set<biouml.model.Node>> varToEquationNodes = MathDiagramUtility.findEquationNodes(emodel);
        Map<String, Set<biouml.model.Node>> varToVariableNodes = MathDiagramUtility.findVariableNodes(emodel);
        Map<String, biouml.model.Node> varToInputPort = MathDiagramUtility.findPortNodes(diagram, true);
        Map<String, biouml.model.Node> varOutputPortMap = MathDiagramUtility.findPortNodes(diagram, false);
        MathCalculator calculator = new MathCalculator(emodel);
        List targets = ((StreamEx)StreamEx.of(varToEquationNodes.values()).flatMap(Collection::stream).map(n -> MathDiagramUtility.getActualNode(n)).append((Stream)StreamEx.of(varToVariableNodes.values()).flatMap(Collection::stream))).append(varOutputPortMap.values()).toList();
        for (biouml.model.Node targetNode : targets) {
            try {
                HashMap<biouml.model.Node, Integer> controlNodesEffect = MathDiagramUtility.getControllerNodes(calculator, targetNode, varToEquationNodes, varToVariableNodes, varToInputPort);
                for (Edge edge : ((StreamEx)targetNode.edges().filter(e -> e.getKernel().getType().equals("dependency") && ((Object)((Object)e.getOutput())).equals((Object)targetNode))).toSet()) {
                    edge.getOrigin().remove(edge.getName());
                }
                for (Map.Entry entry : controlNodesEffect.entrySet()) {
                    MathDiagramUtility.generateDependencyEdge((biouml.model.Node)((Object)entry.getKey()), targetNode, (Integer)entry.getValue());
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error during dependency edges generation for node" + (Object)((Object)targetNode) + ": " + ExceptionRegistry.log((Throwable)ex));
            }
        }
    }

    protected static biouml.model.Node getActualNode(biouml.model.Node node) {
        Option parent = node.getParent();
        return parent instanceof biouml.model.Node && Util.isBlock((biouml.model.Node)parent) ? (biouml.model.Node)parent : node;
    }

    private static void generateDependencyEdge(@Nonnull biouml.model.Node controlNode, biouml.model.Node targetNode, int effect) throws Exception {
        if (((Object)((Object)controlNode)).equals((Object)targetNode) && !(controlNode.getRole() instanceof Equation)) {
            return;
        }
        String dependencyType = effect > 0 ? "increase" : (effect < 0 ? "decrease" : "none");
        for (Edge oldEdge : targetNode.getEdges()) {
            if (!oldEdge.getKernel().getType().equals("dependency") || !((Object)((Object)oldEdge.getInput())).equals((Object)controlNode)) continue;
            DynamicProperty dp = oldEdge.getAttributes().getProperty(DEPENDENCY_TYPE);
            if (dp == null || !dependencyType.equals(dp.getValue())) {
                oldEdge.getAttributes().add(new DynamicProperty(DEPENDENCY_TYPE, String.class, (Object)dependencyType));
            }
            return;
        }
        Compartment origin = Diagram.findCommonOrigin(controlNode, targetNode);
        Stub.Dependency kernel = new Stub.Dependency(origin, controlNode.getName() + " -> " + targetNode.getName());
        Edge newEdge = new Edge(kernel, controlNode, targetNode);
        newEdge.getAttributes().add(new DynamicProperty(DEPENDENCY_TYPE, String.class, (Object)dependencyType));
        newEdge.save();
    }

    public static Map<biouml.model.Node, Integer> getControlledNodes(biouml.model.Node node, MathCalculator calculator, Map<String, Set<biouml.model.Node>> varToEquations, Map<String, Set<biouml.model.Node>> varToNodes, Map<String, biouml.model.Node> varToPort) {
        if (Util.isBlock(node)) {
            return ((StreamEx)((Compartment)node).stream(biouml.model.Node.class).filter(n -> n.getRole() instanceof Equation)).flatMapToEntry(n -> MathDiagramUtility.getControlledNodes(n, calculator, varToEquations, varToNodes, varToPort)).toMap();
        }
        if (node.getRole() instanceof Equation) {
            HashMap<biouml.model.Node, Integer> controlledNodes = new HashMap<biouml.model.Node, Integer>();
            String var = node.getRole(Equation.class).getVariable();
            StreamEx.of(varToEquations.values()).flatMap(Collection::stream).forEach(n -> {
                Map<String, Integer> controllerVariablesEffect = MathDiagramUtility.getControllerVariables(calculator, n);
                if (controllerVariablesEffect.containsKey(var)) {
                    controlledNodes.put((biouml.model.Node)((Object)n), controllerVariablesEffect.get(var));
                }
            });
            if (varToNodes.containsKey(var)) {
                for (biouml.model.Node n2 : varToNodes.get(var)) {
                    controlledNodes.put(n2, 0);
                }
            }
            if (varToPort.containsKey(var)) {
                biouml.model.Node n3 = varToPort.get(var);
                controlledNodes.put(n3, 0);
            }
            return controlledNodes;
        }
        return Collections.emptyMap();
    }

    public static HashMap<biouml.model.Node, Integer> getControllerNodes(MathCalculator calculator, biouml.model.Node targetNode, Map<String, Set<biouml.model.Node>> varToEquations, Map<String, Set<biouml.model.Node>> varToNodes, Map<String, biouml.model.Node> varToPort) {
        HashMap<biouml.model.Node, Integer> result = new HashMap<biouml.model.Node, Integer>();
        Map<String, Integer> controllerVariablesEffect = MathDiagramUtility.getControllerVariables(calculator, targetNode);
        for (Map.Entry<String, Integer> entry : controllerVariablesEffect.entrySet()) {
            String var = entry.getKey();
            Set<biouml.model.Node> controllerNodes = varToEquations.get(var);
            if (controllerNodes != null) {
                for (biouml.model.Node controllerNode : controllerNodes) {
                    if (((Object)((Object)controllerNode)).equals((Object)targetNode) && Util.isBlock(targetNode)) {
                        result.put(controllerNode, 0);
                        continue;
                    }
                    result.put(controllerNode, entry.getValue());
                }
            }
            if ((controllerNodes = varToNodes.get(var)) != null) {
                for (biouml.model.Node controllerNode : controllerNodes) {
                    if (((Object)((Object)controllerNode)).equals((Object)targetNode)) continue;
                    result.put(controllerNode, entry.getValue());
                }
            }
            if (!varToPort.containsKey(var)) continue;
            result.put(varToPort.get(var), entry.getValue());
        }
        return result;
    }

    public static Map<String, Integer> getControllerVariables(MathCalculator calculator, biouml.model.Node targetNode) {
        if (targetNode.getRole() instanceof Equation) {
            Equation eq = targetNode.getRole(Equation.class);
            AstStart start = eq.getMath();
            return Utils.variables((Node)start).mapToEntry(controllerVariable -> MathDiagramUtility.calcEffect(calculator, start, controllerVariable)).toMap();
        }
        if (Util.isOutputPort(targetNode)) {
            String controllerVariable2 = Util.getPortVariable(targetNode);
            return Collections.singletonMap(controllerVariable2, 0);
        }
        if (targetNode.getRole() instanceof VariableRole) {
            String controllerVariable3 = targetNode.getRole(VariableRole.class).getName();
            return Collections.singletonMap(controllerVariable3, 0);
        }
        if (Util.isBlock(targetNode)) {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (biouml.model.Node node2 : ((StreamEx)((Compartment)targetNode).stream(biouml.model.Node.class).filter(node -> node.getRole() instanceof Equation)).toList()) {
                Map<String, Integer> resultForEquation = MathDiagramUtility.getControllerVariables(calculator, node2);
                for (Map.Entry<String, Integer> entry : resultForEquation.entrySet()) {
                    result.compute(entry.getKey(), (k, v) -> v == null ? (Integer)entry.getValue() : Integer.valueOf(v + (Integer)entry.getValue()));
                }
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public static int calcEffect(MathCalculator calculator, AstStart formula, String varName) {
        int effect = MathDiagramUtility.calcEffect(calculator, formula, varName, 6.0, null);
        return effect;
    }

    public static int calcEffect(MathCalculator calculator, AstStart formula, String varName, double delta, Double value) {
        try {
            MathContext values = new MathContext();
            double val1 = calculator.calculateMath(formula, values)[0];
            values.put(varName, values.get(varName, 0.0) + delta);
            double val2 = calculator.calculateMath(formula, values)[0];
            return val2 > val1 ? 1 : (val2 < val1 ? -1 : 0);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
            return 0;
        }
    }

    public static void generateDependenciesForEquation(biouml.model.Node node) {
        Diagram diagram = Diagram.getDiagram(node = MathDiagramUtility.getActualNode(node));
        if (!(diagram.getRole() instanceof EModel)) {
            return;
        }
        EModel emodel = diagram.getRole(EModel.class);
        Map<String, Set<biouml.model.Node>> varToEquationNodes = MathDiagramUtility.findEquationNodes(emodel);
        Map<String, Set<biouml.model.Node>> varToVariableNodes = MathDiagramUtility.findVariableNodes(emodel);
        Map<String, biouml.model.Node> varToInputPort = MathDiagramUtility.findPortNodes(diagram, true);
        Map<String, biouml.model.Node> varOutputPortMap = MathDiagramUtility.findPortNodes(diagram, false);
        MathCalculator calculator = new MathCalculator(emodel);
        try {
            HashMap<biouml.model.Node, Integer> controllerNodes = MathDiagramUtility.getControllerNodes(calculator, node, varToEquationNodes, varToVariableNodes, varToInputPort);
            Map<biouml.model.Node, Integer> controlledNodes = MathDiagramUtility.getControlledNodes(node, calculator, varToEquationNodes, varToVariableNodes, varOutputPortMap);
            for (Edge edge : ((StreamEx)node.edges().filter(e -> e.getKernel().getType().equals("dependency"))).toSet()) {
                edge.getOrigin().remove(edge.getName());
            }
            for (Map.Entry entry : controllerNodes.entrySet()) {
                MathDiagramUtility.generateDependencyEdge((biouml.model.Node)((Object)entry.getKey()), node, (Integer)entry.getValue());
            }
            for (Map.Entry entry : controlledNodes.entrySet()) {
                MathDiagramUtility.generateDependencyEdge(node, (biouml.model.Node)((Object)entry.getKey()), (Integer)entry.getValue());
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during dependency edges generation: " + ex.getMessage());
        }
    }
}

