/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Node;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.TableElement;
import biouml.standard.diagram.CreatorElementWithName;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import java.awt.Point;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.util.PropertiesDialog;

public class MathDiagramSemanticController
extends PathwaySimulationSemanticController
implements CreatorElementWithName {
    @Override
    public boolean canAccept(Compartment compartment, DiagramElement de) {
        if (de.getRole() instanceof TableElement) {
            return true;
        }
        return super.canAccept(compartment, de);
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, String name, Point point, Object properties) {
        if (type instanceof String && type.equals("block")) {
            return new DiagramElementGroup(new Compartment(parent, (Base)new Stub(null, name, "block")));
        }
        Class typeClass = (Class)type;
        if (typeClass == Event.class) {
            Node node = new Node(parent, (Base)new Stub(null, name, "math-event"));
            Event event = new Event(node);
            node.setRole(event);
            return new DiagramElementGroup(node);
        }
        if (typeClass == Equation.class) {
            Node node = new Node(parent, (Base)new Stub(null, name, "math-equation"));
            node.setRole(new Equation(node, "scalar", "unknown", "0"));
            node.setShowTitle(false);
            if (properties instanceof Equation) {
                node.getRole(Equation.class).setType(((Equation)properties).getType());
            }
            return new DiagramElementGroup(node);
        }
        if (typeClass == Constraint.class) {
            Node node = new Node(parent, (Base)new Stub(null, MathDiagramSemanticController.generateUniqueNodeName(parent, "math-constraint"), "math-constraint"));
            node.setRole(new Constraint(node));
            node.setShowTitle(false);
            return new DiagramElementGroup(node);
        }
        if (typeClass == Function.class) {
            Node node = new Node(parent, (Base)new Stub(null, name, "math-function"));
            node.setRole(new Function(node));
            node.setShowTitle(false);
            return new DiagramElementGroup(node);
        }
        return DiagramElementGroup.EMPTY_EG;
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point point, ViewEditorPane viewEditor) {
        if (type instanceof String && type.equals("block")) {
            return new DiagramElementGroup(new Compartment(parent, (Base)new Stub(null, MathDiagramSemanticController.generateUniqueNodeName(parent, "block"), "block")));
        }
        Class typeClass = (Class)type;
        if (typeClass == TableElement.class) {
            String name = MathDiagramSemanticController.generateUniqueNodeName(parent, "table entity");
            Node node = new Node(parent, (Base)new Stub(null, name, "table entity"));
            TableElement role = new TableElement(node);
            node.setRole(role);
            PropertiesDialog dialog = new PropertiesDialog((JFrame)Application.getApplicationFrame(), "New table entity", (Object)role);
            if (dialog.doModal()) {
                if (role.getTable() == null) {
                    log.log(Level.SEVERE, "Please specify table");
                    return null;
                }
                return new DiagramElementGroup(node);
            }
            return DiagramElementGroup.EMPTY_EG;
        }
        return super.createInstance(parent, type, point, viewEditor);
    }
}

