/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.standard.diagram.FormulaDescription;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.math.Expression;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.math.xml.MathMLParser;

public class FormulaTemplatePane
extends JPanel {
    public static final String SBO_PATH = "databases/SBO";
    public static final String SBO_RATE_LAW = "SBO:0000001";
    public static final String PANE_NAME = "SBO template";
    public static final String NAME = "Name";
    public static final String VALUE = "Value";
    public static final String COMMENT = "Comment";
    public static final String[] COLUMN_NAMES = new String[]{"Name", "Value", "Comment"};
    public static final String REACTANT_CONCENTRATION = "concentration of reactant";
    public static final String SUBSTRATE_CONCENTRATION = "concentration of substrate";
    public static final String PRODUCT_CONCENTRATION = "concentration of product";
    public static final String ENZYME_CONCENTRATION = "concentration of enzyme";
    public static final String MODIFIER_CONCENTRATION = "concentration of modifier";
    public static final String ACTIVATOR_CONCENTRATION = "concentration of activator";
    public static final String ENZYME = "enzyme";
    public static final String MODIFIER = "modifier";
    public static final String REACTANT = "reactant";
    public static final String SUBSTRATE = "substrate";
    public static final String PRODUCT = "product";
    public static final Set<String> SBO_REACTANTS = StreamEx.of((Object[])new String[]{"concentration of reactant", "concentration of substrate", "reactant", "product"}).toSet();
    public static final Set<String> SBO_PRODUCTS = StreamEx.of((Object[])new String[]{"concentration of product", "product", "substrate"}).toSet();
    public static final Set<String> SBO_MODIFIERS = StreamEx.of((Object[])new String[]{"concentration of enzyme", "concentration of modifier", "concentration of activator", "enzyme", "modifier"}).toSet();
    private JComboBox<String> formulas = new JComboBox();
    private JTable paramsTable = new JTable();
    private JTextField targetText;
    private JEditorPane description = new JEditorPane();
    private List<VariableDescription> currentParams = null;
    private List<FunctionDescription> functionDescriptionList;
    private Expression expression = new Expression(null, "0");
    private DefaultRowModel reactionComponents;
    private static final LinearFormatter linearFormatter = new LinearFormatter();
    private static final ru.biosoft.math.model.Parser mathMLParser = new MathMLParser();
    private Diagram diagram;

    public FormulaTemplatePane(JTextField targetText, DefaultRowModel reactionComponents, Diagram diagram) {
        super(new BorderLayout());
        this.targetText = targetText;
        this.reactionComponents = reactionComponents;
        this.diagram = diagram;
        this.initMathList();
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add(this.formulas, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.formulas.addItemListener(e -> this.selectFunctionAction());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        this.paramsTable.setModel(new ParamsTableModel());
        this.paramsTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.paramsTable.getColumnModel().getColumn(2).setPreferredWidth(600);
        this.paramsTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.paramsTable);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(0, 100));
        bottomPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.description.setEditable(false);
        JScrollPane scrollPane2 = new JScrollPane(this.description);
        scrollPane2.setHorizontalScrollBarPolicy(31);
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setPreferredSize(new Dimension(0, 90));
        bottomPanel.add((Component)scrollPane2, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)topPanel, "North");
        this.add((Component)bottomPanel, "South");
        this.selectFunctionAction();
    }

    protected void initMathList() {
        List mathList = null;
        DataCollection sboCollection = null;
        try {
            sboCollection = ((Module)DataElementPath.create((String)SBO_PATH).getDataElement(Module.class)).getPrimaryCollection();
            Method m = sboCollection.getClass().getMethod("getFormulas", String.class);
            mathList = (List)m.invoke((Object)sboCollection, SBO_RATE_LAW);
        }
        catch (Exception e) {
            mathList = new ArrayList();
        }
        this.functionDescriptionList = new ArrayList<FunctionDescription>();
        for (FormulaDescription formula : mathList) {
            FunctionDescription fd = this.createFunctionDescription(formula, sboCollection);
            if (fd == null || fd.getFunctionsString().contains("selector") || this.functionDescriptionList.contains(fd)) continue;
            this.functionDescriptionList.add(fd);
        }
    }

    protected FunctionDescription createFunctionDescription(FormulaDescription formula, DataCollection<?> ontology) {
        FunctionDescription fd = new FunctionDescription();
        try {
            mathMLParser.setDeclareUndefinedVariables(false);
            mathMLParser.setContext(this.expression.getParserContext());
            int status = mathMLParser.parse(formula.getMath());
            if ((status & 4) == 0) {
                this.expression.setAstStart(mathMLParser.getStartNode());
            }
            String function = linearFormatter.format(this.expression.getAstStart())[1];
            function = function.substring(function.indexOf("=") + 1).trim();
            function = function.replace("(", "").replace(")", "");
            fd.setFunctionsString(function);
            fd.setName(formula.getName());
            fd.setDescription(formula.getDescription());
        }
        catch (Exception e) {
            return null;
        }
        Node node = this.expression.getAstStart().jjtGetChild(0);
        if (node instanceof AstFunctionDeclaration) {
            fd.setVariables(this.getFunctionParameters((AstFunctionDeclaration)node, ontology));
        }
        return fd;
    }

    protected List<VariableDescription> getFunctionParameters(AstFunctionDeclaration function, DataCollection<?> ontology) {
        return function.getParameters().map(v -> new VariableDescription(v.getName(), v.getName(), this.getVariableDescription((AstVarNode)v, ontology))).toList();
    }

    protected String getVariableDescription(AstVarNode var, DataCollection<?> ontology) {
        String description = var.getDefinitionUrl();
        if (ontology != null && description.contains("#")) {
            description = description.substring(description.indexOf("#") + 1);
            try {
                Method m = ontology.getClass().getMethod("getTermDescription", String.class);
                description = (String)m.invoke(ontology, description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return description.trim();
    }

    protected void refreshTable() {
        this.paramsTable.setModel(new ParamsTableModel());
        this.paramsTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.paramsTable.getColumnModel().getColumn(2).setPreferredWidth(600);
    }

    protected void applyAction() {
        if (this.currentParams == null) {
            return;
        }
        String functionName = (String)this.formulas.getSelectedItem();
        StreamEx.of(this.functionDescriptionList).findFirst(fd -> functionName.equals(fd.getName())).ifPresent(fd -> {
            String functionString = fd.getFunctionsString();
            this.targetText.setText(FormulaTemplatePane.substituteVars(functionString, this.currentParams));
        });
    }

    private static String substituteVars(String formula, List<VariableDescription> vars) {
        Parser parser = new Parser();
        parser.parse(formula);
        AstStart node = parser.getStartNode();
        HashMap<String, String> substitution = new HashMap<String, String>();
        for (VariableDescription var : vars) {
            substitution.put(var.getName(), var.getValue());
        }
        node = Utils.substituteVars((AstStart)node, substitution);
        return new LinearFormatter().format(node)[1];
    }

    public void selectFunctionAction() {
        String targetString = (String)this.formulas.getSelectedItem();
        StreamEx.of(this.functionDescriptionList).findFirst(fd -> fd.getName().equals(targetString)).ifPresent(fd -> {
            this.refreshVariablesValues((FunctionDescription)fd);
            this.currentParams = fd.getVariables();
            this.description.setText(fd.getDescription());
            this.refreshTable();
            this.applyAction();
        });
    }

    public void changeComponents() {
        Map roleCounts = IntStreamEx.range((int)this.reactionComponents.size()).mapToObj(arg_0 -> ((DefaultRowModel)this.reactionComponents).getBean(arg_0)).select(SpecieReference.class).map(SpecieReference::getRole).groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum));
        int reactant = roleCounts.getOrDefault(REACTANT, 0);
        int modifier = roleCounts.getOrDefault(MODIFIER, 0);
        int product = roleCounts.getOrDefault(PRODUCT, 0);
        this.formulas.removeAllItems();
        List allowed = ((StreamEx)StreamEx.of(this.functionDescriptionList).filter(fd -> this.checkRoleCount((FunctionDescription)fd, reactant, modifier, product))).toList();
        ((StreamEx)StreamEx.of((Collection)allowed).map(d -> d.getName()).sorted()).forEach(this.formulas::addItem);
        ((StreamEx)StreamEx.of((Collection)allowed).sorted(Comparator.comparingInt(fd -> fd.getFunctionsString().length()))).findFirst().ifPresent(d -> this.formulas.setSelectedItem(d.getName()));
    }

    public void refreshVariablesValues(FunctionDescription fd) {
        ArrayList<VariableDescription> vars = new ArrayList<VariableDescription>(fd.getVariables());
        for (int i = 0; i < this.reactionComponents.size(); ++i) {
            SpecieReference component = (SpecieReference)this.reactionComponents.getBean(i);
            String role = component.getRole();
            VariableDescription var = vars.stream().filter(v -> this.checkRole(v.getDescription(), role)).findAny().orElse(null);
            if (var == null) continue;
            vars.remove(var);
            var.setValue(component.getSpecieVariable(this.diagram));
        }
    }

    private boolean checkRole(String description, String role) {
        if (description == null) {
            return false;
        }
        if (SBO_REACTANTS.contains(description) && role.equals(REACTANT)) {
            return true;
        }
        if (SBO_MODIFIERS.contains(description) && role.equals(MODIFIER)) {
            return true;
        }
        return SBO_PRODUCTS.contains(description);
    }

    private boolean checkRoleCount(FunctionDescription fd, int reactant, int modifier, int product) {
        boolean hasProduct = false;
        for (VariableDescription var : fd.getVariables()) {
            String description = var.getDescription();
            if (SBO_REACTANTS.contains(description)) {
                --reactant;
                continue;
            }
            if (SBO_MODIFIERS.contains(description)) {
                --modifier;
                continue;
            }
            if (!SBO_PRODUCTS.contains(description)) continue;
            --product;
            hasProduct = true;
        }
        return reactant == 0 && modifier == 0 && (product == 0 || !hasProduct);
    }

    private class ParamsTableModel
    extends AbstractTableModel {
        private ParamsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return FormulaTemplatePane.this.currentParams != null ? FormulaTemplatePane.this.currentParams.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (FormulaTemplatePane.this.currentParams == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    return ((VariableDescription)FormulaTemplatePane.this.currentParams.get(row)).getName();
                }
                case 1: {
                    return ((VariableDescription)FormulaTemplatePane.this.currentParams.get(row)).getValue();
                }
                case 2: {
                    return ((VariableDescription)FormulaTemplatePane.this.currentParams.get(row)).getDescription();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.isCellEditable(row, col)) {
                ((VariableDescription)FormulaTemplatePane.this.currentParams.get(row)).setValue((String)value);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public String getColumnName(int col) {
            return col > 0 && col < COLUMN_NAMES.length ? COLUMN_NAMES[col] : "";
        }
    }

    public static class VariableDescription {
        private String name;
        private String value;
        private String description;

        public VariableDescription(String name, String value, String description) {
            this.name = name;
            this.value = value;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class FunctionDescription {
        private String functionsString;
        private String name;
        private List<VariableDescription> variables;
        private String description;

        public String getFunctionsString() {
            return this.functionsString;
        }

        public void setFunctionsString(String functionsString) {
            this.functionsString = functionsString;
        }

        public List<VariableDescription> getVariables() {
            if (this.variables == null) {
                this.variables = new ArrayList<VariableDescription>();
            }
            return this.variables;
        }

        public void setVariables(List<VariableDescription> variables) {
            this.variables = variables;
        }

        public boolean equals(Object obj) {
            return obj instanceof FunctionDescription && ((FunctionDescription)obj).getName().equals(this.name);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

