/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.CollectionDescription;
import biouml.model.Module;
import biouml.standard.diagram.ElementChooserPaneListener;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.type.Base;
import biouml.standard.type.GenericEntity;
import biouml.standard.type.access.TitleIndex;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.Index;
import ru.biosoft.access.support.NameListToComboBoxModelAdapter;
import ru.biosoft.access.support.NameListToListModelAdapter;
import ru.biosoft.gui.ExplorerPane;

public class ElementChooserPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(ElementChooserPane.class.getName());
    protected String TITLE_PROTOTYPE = "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM";
    private static MessageBundle resources = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    private Class<? extends DataElement> type;
    private final Module module;
    protected JComboBox<String> cbModule;
    protected JComboBox<String> cbName;
    protected NameListToComboBoxModelAdapter cbNameModel;
    protected JTextField tfTitle;
    protected JComboBox<String> cbTitle;
    protected ComboBoxModel<String> cbTitleModel;
    protected ExplorerPane explorerPane;
    protected DataCollection kernelDC;
    protected DataCollection baseKernelDC;
    protected CollectionDescription[] extendedModules;
    protected ElementChooserPaneListener paneListener = null;
    protected TitleIndex index;
    protected boolean lockTitle = false;
    protected boolean lockID = false;
    protected boolean moduleChanging = false;

    public ElementChooserPane(Module module, ExplorerPane explorerPane) throws Exception {
        this.module = module;
        this.explorerPane = explorerPane;
        this.setLayout(new GridBagLayout());
    }

    public ElementChooserPane(Module module, ExplorerPane explorerPane, CollectionDescription[] extendedModules, ElementChooserPaneListener paneListener) throws Exception {
        this(module, explorerPane);
        this.extendedModules = extendedModules;
        this.paneListener = paneListener;
    }

    public void init(Class<? extends DataElement> type) throws Exception {
        this.close();
        this.type = type;
        this.baseKernelDC = this.module.getCategory(type);
        if (this.baseKernelDC == null && this.extendedModules == null) {
            this.add(new JLabel(resources.getResourceString("NEW_ELEMENT_DIALOG_ERROR")));
            this.repaint();
            return;
        }
        if (this.baseKernelDC != null) {
            this.kernelDC = this.baseKernelDC;
        } else if (this.extendedModules.length > 0) {
            this.kernelDC = this.extendedModules[0].getDc();
        }
        this.refreshChooserPane();
    }

    protected void refreshChooserPane() {
        GridBagConstraints gbc;
        if (this.extendedModules != null) {
            if (this.cbModule == null) {
                this.cbModule = new JComboBox();
                gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.weighty = 1.0;
                this.add((Component)new JLabel(resources.getResourceString("DATABASE_COMBO_BOX")), gbc);
                gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.gridwidth = 0;
                this.add(this.cbModule, gbc);
                this.fillModuleComboBox();
                this.cbModule.addActionListener(e -> {
                    String moduleName = (String)this.cbModule.getSelectedItem();
                    if (this.module.getName().equals(moduleName)) {
                        this.kernelDC = this.baseKernelDC;
                    } else if (this.extendedModules != null) {
                        for (CollectionDescription et : this.extendedModules) {
                            if (!et.getModuleName().equals(moduleName)) continue;
                            this.kernelDC = et.getDc();
                        }
                    }
                    this.changeModule(moduleName);
                });
            }
            this.cbModule.repaint();
        }
        this.cbNameModel = new NameListToComboBoxModelAdapter(this.kernelDC);
        if (this.cbName == null) {
            this.cbName = new JComboBox(this.cbNameModel);
            String namePrototype = this.kernelDC.getInfo().getProperty("id-format");
            if (namePrototype != null) {
                this.cbName.setPrototypeDisplayValue(namePrototype);
            } else {
                this.cbName.setPrototypeDisplayValue(this.TITLE_PROTOTYPE);
            }
            this.add(new JLabel(resources.getResourceString("NAME_COMBO_BOX")));
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            this.add(this.cbName, gbc);
            this.cbName.addActionListener(e -> {
                if (!this.lockID && this.tfTitle != null) {
                    this.lockTitle = true;
                    this.tfTitle.setText("");
                    this.lockTitle = false;
                }
                String name = (String)this.cbName.getSelectedItem();
                if (this.cbTitle != null) {
                    String title = ((TitleIndex)this.cbTitle.getModel()).get(name);
                    if (title != null) {
                        this.cbTitle.setSelectedItem(title);
                    }
                    this.cbTitle.repaint();
                }
                try {
                    DataElement selectedKernel = this.kernelDC.get(name);
                    if (this.explorerPane != null) {
                        this.explorerPane.explore((Object)selectedKernel, null);
                    }
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Can not get element '" + name + "', dc=" + this.kernelDC.getCompletePath() + ", error: " + t, t);
                }
            });
        } else {
            this.cbName.removeAllItems();
            this.cbName.setModel((ComboBoxModel<String>)this.cbNameModel);
        }
        if (this.cbTitle != null) {
            this.cbTitle.removeAllItems();
            this.cbTitle.setEnabled(false);
            this.tfTitle.setText("");
            this.tfTitle.setEnabled(false);
        }
        if (this.kernelDC != null && this.kernelDC.getInfo().getQuerySystem() != null && this.kernelDC.getInfo().getQuerySystem().getIndex("title") != null) {
            Index tempIndex = this.kernelDC.getInfo().getQuerySystem().getIndex("title");
            if (tempIndex instanceof TitleIndex) {
                this.index = (TitleIndex)tempIndex;
            }
            if (this.index != null) {
                this.cbTitleModel = this.index;
                this.cbTitleModel.setSelectedItem(null);
                if (this.cbTitle == null) {
                    this.cbTitle = new JComboBox<String>(this.cbTitleModel);
                    this.cbTitle.setPrototypeDisplayValue(this.TITLE_PROTOTYPE);
                    this.cbTitle.addActionListener(e -> {
                        String title = (String)this.cbTitle.getSelectedItem();
                        String name = ((TitleIndex)this.cbTitle.getModel()).getIdByTitle(title);
                        if (name != null && !name.equals(this.cbName.getSelectedItem())) {
                            this.lockID = true;
                            this.cbName.setSelectedItem(name);
                            this.lockID = false;
                        }
                        this.cbName.repaint();
                    });
                    this.tfTitle = new JTextField();
                    this.tfTitle.getAccessibleContext().addPropertyChangeListener(arg0 -> {
                        if (arg0 != null && "AccessibleText".equalsIgnoreCase(arg0.getPropertyName())) {
                            String text = this.tfTitle.getText();
                            this.index.setConstraint(text);
                            if (this.cbTitle.getItemCount() > 0 && !this.lockTitle) {
                                this.lockID = true;
                                this.cbTitle.setSelectedIndex(0);
                                this.lockID = false;
                            }
                            this.cbTitle.repaint();
                        }
                    });
                    gbc = new GridBagConstraints();
                    gbc.fill = 1;
                    gbc.gridheight = 2;
                    gbc.weighty = 1.0;
                    this.add((Component)new JLabel(resources.getResourceString("TITLE_COMBO_BOX")), gbc);
                    gbc = new GridBagConstraints();
                    gbc.fill = 1;
                    gbc.gridwidth = 0;
                    this.add((Component)this.tfTitle, gbc);
                    gbc = new GridBagConstraints();
                    gbc.fill = 1;
                    gbc.gridwidth = 0;
                    this.add(this.cbTitle, gbc);
                } else {
                    this.cbTitle.setModel(this.cbTitleModel);
                }
                this.cbTitle.setEnabled(true);
                this.tfTitle.setEnabled(true);
            }
        }
        this.setControlsEnabled(this.cbName.getItemCount() > 0);
        if (this.cbName.getItemCount() > 0) {
            this.cbName.setSelectedIndex(0);
        }
    }

    protected void changeModule(String moduleName) {
        if (!this.moduleChanging) {
            this.moduleChanging = true;
            this.refreshChooserPane();
            if (this.paneListener != null) {
                this.paneListener.moduleChanged(moduleName, this.kernelDC);
            }
            if (this.cbModule != null) {
                this.cbModule.setSelectedItem(moduleName);
            }
            this.moduleChanging = false;
        }
    }

    public void selectItem(String name, String moduleName) {
        if (this.cbModule != null) {
            this.cbModule.setSelectedItem(moduleName);
        }
        if (this.cbName != null && this.cbName.getModel() != null && ((NameListToListModelAdapter)this.cbName.getModel()).contain(name)) {
            this.cbName.setSelectedItem(name);
        }
    }

    public void addNew(GenericEntity entity) {
        try {
            if (entity != null && this.type != null) {
                DataCollection<? extends DataElement> category;
                if (this.tfTitle != null) {
                    this.tfTitle.setText("");
                }
                if ((category = this.module.getCategory(this.type)) != null) {
                    category.put((DataElement)entity);
                    this.cbName.setSelectedItem(entity.getName());
                    this.cbName.repaint();
                    this.setControlsEnabled(this.cbName.getItemCount() > 0);
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Error during creation new data element", e);
        }
    }

    protected void setControlsEnabled(boolean value) {
        this.cbName.setEnabled(value);
    }

    public void close() {
        if (this.cbNameModel != null) {
            this.cbNameModel.close();
        }
    }

    public Base getKernel() {
        try {
            String name = this.getKernelName();
            if (name == null || this.type == null) {
                return null;
            }
            return (Base)this.module.getKernel(this.type, name);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error during creation of a diagram element", e);
            return null;
        }
    }

    protected String getKernelName() {
        int index = this.cbName.getSelectedIndex();
        if (index >= 0 && index < this.cbName.getItemCount()) {
            return "" + this.cbName.getItemAt(index);
        }
        return null;
    }

    protected void fillModuleComboBox() {
        this.cbModule.removeAllItems();
        ArrayList<String> usedModuleNames = new ArrayList<String>();
        if (this.baseKernelDC != null) {
            this.cbModule.addItem(this.module.getName());
        }
        if (this.extendedModules != null) {
            for (CollectionDescription et : this.extendedModules) {
                String moduleName = et.getModuleName();
                if (usedModuleNames.contains(moduleName)) continue;
                this.cbModule.addItem(moduleName);
                usedModuleNames.add(moduleName);
            }
        }
    }
}

