/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineRegistry;
import biouml.standard.diagram.ConnectionEdgePane;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.apache.commons.lang.StringUtils;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.support.IdGenerator;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;
import ru.biosoft.util.DPSUtils;

public class DiagramUtility {
    protected static final Logger log = Logger.getLogger(DiagramUtility.class.getName());
    public static String SEPARATOR = "/";

    @Nonnull
    public static Node createReactionNode(Diagram diagram, Compartment compartment, Reaction oldReaction, List<SpecieReference> components, String reactionRate, Point point, String type) throws Exception {
        return DiagramUtility.createReactionNode(diagram, compartment, oldReaction, components, reactionRate, point, type, null);
    }

    @Nonnull
    public static Node createReactionNode(Diagram diagram, Compartment compartment, Reaction oldReaction, List<SpecieReference> components, String reactionRate, Point point, String type, String nodeName) throws Exception {
        boolean notificationEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(false);
        DefaultSemanticController controller = (DefaultSemanticController)diagram.getType().getSemanticController();
        Reaction reaction = null;
        DataCollection<Reaction> reactionDC = null;
        if (type == null) {
            Module module = Module.getModule((DataElement)diagram);
            if (module.getType().isCategorySupported()) {
                reactionDC = module.getCategory(Reaction.class);
            }
            String name = nodeName != null ? nodeName : (reactionDC != null ? DefaultSemanticController.generateReactionName(reactionDC) : DefaultSemanticController.generateReactionName(compartment));
            reaction = new Reaction(reactionDC, name);
        } else {
            String name = nodeName != null ? nodeName : DefaultSemanticController.generateUniqueNodeName(diagram, type);
            reaction = new Reaction(null, name);
        }
        reaction.setParent((Option)diagram);
        reaction.setTitle(DiagramUtility.generateReactionTitle(components));
        KineticLaw kineticLaw = new KineticLaw();
        if (reactionRate != null && !reactionRate.equals("")) {
            kineticLaw.setFormula(reactionRate);
        }
        reaction.setKineticLaw(kineticLaw);
        Node reactionNode = new Node(compartment, (Base)reaction);
        if (!controller.canAccept(compartment, reactionNode)) {
            throw new ReactionPane.CreateReactionException("Unacceptable compartment for reaction: " + (compartment != null ? compartment.getName() : "null") + ".");
        }
        reactionNode.setRelativeLocation(diagram, point);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (SpecieReference prototype : components) {
            Node de = diagram.findNode(DiagramUtility.toDiagramPath(prototype.getName()));
            if (de == null) {
                de = diagram.findNode(DiagramUtility.toDiagramPath(prototype.getSpecie()));
            }
            String id = reaction.getName() + ": " + de.getKernel().getName() + " as " + prototype.getRole();
            BaseSupport real = prototype.clone(reaction, id);
            real.setTitle(de.getKernel().getName() + " as " + prototype.getRole());
            String specieLink = reactionDC != null ? CollectionFactory.getRelativeName((DataElement)de.getKernel(), (DataCollection)Module.getModule((DataElement)diagram)) : de.getCompleteNameInDiagram();
            ((SpecieReference)real).setSpecie(specieLink);
            reaction.put((SpecieReference)real);
            Edge edge = ((SpecieReference)real).getRole().equals("product") ? new Edge(real, reactionNode, de) : new Edge(real, de, reactionNode);
            reactionNode.addEdge(edge);
            edges.add(edge);
        }
        DiagramUtility.generateRoles(diagram, reactionNode);
        if (notificationEnabled) {
            diagram.setNotificationEnabled(true);
        }
        reaction.setParent((Option)reactionNode);
        if (reaction.getOrigin() != null) {
            reaction.getOrigin().put((DataElement)reaction);
        }
        if (!compartment.contains(reactionNode.getName())) {
            DiagramUtility.put(diagram, reactionNode);
        }
        for (Edge edge : edges) {
            DiagramUtility.put(diagram, edge);
        }
        return reactionNode;
    }

    public static void put(Diagram diagram, DiagramElement de) throws Exception {
        boolean notificationEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(true);
        de.save();
        diagram.setNotificationEnabled(notificationEnabled);
    }

    public static String generateReactionTitle(List<SpecieReference> components) {
        StringBuffer reactants = new StringBuffer();
        StringBuffer products = new StringBuffer();
        StringBuffer modifiers = new StringBuffer();
        StringBuffer other = new StringBuffer();
        StringBuffer result = new StringBuffer();
        for (SpecieReference component : components) {
            String name = component.getSpecieName();
            if (component.getRole().equals("reactant")) {
                if (reactants.length() > 0) {
                    reactants.append(" + ");
                }
                reactants.append(name);
                continue;
            }
            if (component.getRole().equals("product")) {
                if (products.length() > 0) {
                    products.append(" + ");
                }
                products.append(name);
                continue;
            }
            if (component.getRole().equals("modifier")) {
                if (modifiers.length() > 0) {
                    modifiers.append(", ");
                }
                modifiers.append(name);
                continue;
            }
            if (!component.getRole().equals("other")) continue;
            if (other.length() > 0) {
                other.append(", ");
            }
            other.append(name);
        }
        if (reactants.length() > 0) {
            result.append(reactants.toString());
            result.append(" ");
        }
        if (modifiers.length() == 0 && other.length() == 0) {
            result.append("->");
        } else {
            result.append("-");
            result.append(modifiers.toString());
            result.append(other.toString());
            result.append("->");
        }
        if (products.length() > 0) {
            result.append(" ");
            result.append(products.toString());
        }
        return result.toString();
    }

    public static void generateRoles(Diagram diagram, Node reactionNode) throws Exception {
        if (diagram.getRole() == null || !(diagram.getRole() instanceof EModel)) {
            return;
        }
        DiagramUtility.generateReactionRole(diagram, reactionNode);
        for (Edge edge : (StreamEx)reactionNode.edges().filter(e -> e.getKernel() instanceof SpecieReference && ((SpecieReference)e.getKernel()).isReactantOrProduct())) {
            try {
                DiagramUtility.generateReactionRole(diagram, edge);
            }
            catch (Throwable t) {
                throw new Exception("Can not create equation for edge " + edge.getName() + ", error: " + t.getMessage());
            }
        }
    }

    public static void generateReactionRole(Diagram diagram, DiagramElement de) {
        boolean isEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(false);
        if (de instanceof Node) {
            Equation rule = new Equation(de, "scalar", "$$rate_" + de.getName());
            EModel emodel = diagram.getRole(EModel.class);
            emodel.put(new Variable("$$rate_" + de.getName(), emodel, emodel.getVariables()));
            de.setRole(rule);
        } else if (de instanceof Edge && de.getKernel() instanceof SpecieReference) {
            Edge edge = (Edge)de;
            Node specie = edge.getInput().getKernel() instanceof Reaction ? edge.getOutput() : edge.getInput();
            VariableRole var = (VariableRole)specie.getRole();
            if (var == null) {
                var = new VariableRole(specie, 0.0);
                specie.setRole(var);
                log.warning("Generates variable for specie " + specie.getName());
            }
            de.setRole(new Equation(de, "rate", var.getName()));
        }
        diagram.setNotificationEnabled(isEnabled);
    }

    public static boolean isComposite(Diagram diagram) {
        return DiagramUtility.isComposite(diagram.getType());
    }

    private static boolean isComposite(DiagramType type) {
        Object[] classes = type.getNodeTypes();
        if (classes == null) {
            return false;
        }
        for (Object obj : classes) {
            if (!(obj instanceof Class) || !((Class)obj).isAssignableFrom(SubDiagram.class) && !((Class)obj).isAssignableFrom(Diagram.class) && !DiagramContainer.class.isAssignableFrom((Class)obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean containModules(Compartment diagram) {
        return diagram.recursiveStream().select(Node.class).anyMatch(n -> Util.isSubDiagram(n) || Util.isSwitch(n) || Util.isConstant(n) || Util.isAverager(n));
    }

    public static boolean containPorts(Compartment diagram) {
        return diagram.recursiveStream().select(Node.class).anyMatch(n -> Util.isPort(n));
    }

    public static String toDiagramPath(String pathStr) {
        return StringUtils.join((Object[])DataElementPath.create((String)pathStr).getPathComponents(), (String)".");
    }

    public static DataElementPath toRepositoryPath(String pathStr) {
        return (DataElementPath)StreamEx.split((CharSequence)pathStr, (char)'.').foldLeft((Object)DataElementPath.EMPTY_PATH, (rec$, xva$0) -> ((DataElementPath)rec$).getChildPath(new String[]{xva$0}));
    }

    public static void setBaseOrigin(Diagram diagram) {
        String baseOriginIDProperty = diagram.getAttributes().getValueAsString("baseOriginID");
        if (baseOriginIDProperty != null) {
            diagram.setOrigin(CollectionFactory.getDataCollection((String)baseOriginIDProperty));
        }
    }

    public static List<Node> getReactionNodes(Compartment diagram) {
        return ((StreamEx)diagram.recursiveStream().select(Node.class).filter(node -> node.getKernel() instanceof Reaction)).toList();
    }

    public static StreamEx<Reaction> getReactions(Compartment compartment) {
        return compartment.recursiveStream().select(Node.class).map(node -> node.getKernel()).select(Reaction.class);
    }

    public static StreamEx<Node> getTopLevelPorts(Compartment compartment) {
        return (StreamEx)compartment.recursiveStream().select(Node.class).filter(n -> Util.isPort(n) && !(n.getCompartment() instanceof SubDiagram));
    }

    public static StreamEx<Edge> getConnections(Compartment compartment) {
        return (StreamEx)compartment.recursiveStream().select(Edge.class).filter(e -> Util.isConnection(e));
    }

    public static StreamEx<SubDiagram> getSubDiagrams(Compartment compartment) {
        return compartment.recursiveStream().select(SubDiagram.class);
    }

    public static List<DiagramElement> createPortNode(Compartment compartment, PortProperties portProperties, ViewEditorPane viewEditor, Point point) throws Exception {
        Stub.ConnectionPort kernel;
        Compartment module;
        String basePortName;
        Diagram diagram = Diagram.getDiagram(compartment);
        SemanticController controller = diagram.getType().getSemanticController();
        EModel emodel = diagram.getRole(EModel.class);
        ArrayList<DynamicProperty> propertiesToAdd = new ArrayList<DynamicProperty>();
        Class<? extends Base> type = portProperties.getPortClass();
        if (!Stub.ConnectionPort.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Invalid class for port kernel: " + type.toString());
        }
        DiagramElement basePort = null;
        if (portProperties.isPrivatePort() || portProperties.isPublicPort()) {
            String varName = portProperties.getVarName();
            if (varName == null || varName.isEmpty()) {
                throw new IllegalArgumentException("Please specify variable for port");
            }
            for (Object node : Util.getPorts(diagram)) {
                if (!node.getKernel().getClass().equals(type) || !varName.equals(Util.getPortVariable(node)) || portProperties.isPrivatePort() || !portProperties.getAccessType().equals(Util.getAccessType(node))) continue;
                throw new IllegalArgumentException("Port for the same type and the same variable already exists");
            }
            Variable var = emodel.getVariable(varName);
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"variableName", String.class, (Object)var.getName()));
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"accessType", String.class, (Object)portProperties.getAccessType()));
        }
        if (portProperties.isPrivatePort()) {
            basePortName = portProperties.getBasePortName();
            module = portProperties.getModule();
            if (module != null) {
                if (basePortName == null || basePortName.equals("")) {
                    throw new IllegalArgumentException("Please specify base port for private");
                }
                basePort = module.get(basePortName);
                if (basePort == null || !(basePort instanceof Node)) {
                    throw new IllegalArgumentException("Can not find port " + basePortName + " in module " + module.getName());
                }
            }
        } else if (portProperties.isPropagatedPort()) {
            basePortName = portProperties.getBasePortName();
            module = portProperties.getModule();
            if (module == null) {
                throw new IllegalArgumentException("Please specify module for port propagation");
            }
            if (basePortName == null || basePortName.equals("")) {
                throw new IllegalArgumentException("Please specify base port for propagation");
            }
            for (Node node : Util.getPorts(module)) {
                DynamicProperty basePortAttr;
                if (!node.getKernel().getClass().equals(type) || !Util.isPropagatedPort(node) || (basePortAttr = node.getAttributes().getProperty("basePortName")) == null || !basePortAttr.getValue().equals(basePortName)) continue;
                throw new IllegalArgumentException("Propagated Port for " + basePortName + " already exists");
            }
            basePort = module.get(basePortName);
            if (basePort == null || !(basePort instanceof Node)) {
                throw new IllegalArgumentException("Can not find port " + basePortName + " in module " + module.getName());
            }
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"basePortName", String.class, (Object)basePortName));
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"baseModuleName", String.class, (Object)module.getName()));
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"accessType", String.class, (Object)"propagated"));
            propertiesToAdd.add(DPSUtils.createReadOnly((String)"variableName", String.class, (Object)Util.getPortVariable(basePort)));
        }
        SubDiagram.PortOrientation orientation = SubDiagram.PortOrientation.RIGHT;
        String name = DefaultSemanticController.generateUniqueNodeName(diagram, portProperties.getName());
        if (type == Stub.OutputConnectionPort.class) {
            kernel = new Stub.OutputConnectionPort(null, name);
        } else if (type == Stub.InputConnectionPort.class) {
            kernel = new Stub.InputConnectionPort(null, name);
            orientation = SubDiagram.PortOrientation.LEFT;
        } else {
            kernel = new Stub.ContactConnectionPort(null, name);
        }
        Node connectionPort = new Node(compartment, (Base)kernel);
        connectionPort.setTitle(portProperties.getTitle());
        propertiesToAdd.add(new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)orientation));
        propertiesToAdd.forEach(dp -> connectionPort.getAttributes().add(dp));
        ArrayList<DiagramElement> result = new ArrayList<DiagramElement>();
        if (!controller.canAccept(compartment, connectionPort)) {
            return result;
        }
        result.add(connectionPort);
        Edge e = DiagramUtility.createPropagatedPortEdge(connectionPort);
        if (e != null) {
            result.add(e);
        }
        if ((e = DiagramUtility.createPortEdge(connectionPort, null)) != null) {
            result.add(e);
        }
        if (portProperties.isPrivatePort() && basePort != null) {
            if (portProperties.getPortType().equals("contact connection port") || portProperties.getPortType().equals("contact")) {
                DiagramUtility.createConnection(diagram, connectionPort, (Node)basePort, false);
            } else if (portProperties.getPortType().equals("input connection port") || portProperties.getPortType().equals("input")) {
                DiagramUtility.createConnection(diagram, (Node)basePort, connectionPort, true);
            } else {
                DiagramUtility.createConnection(diagram, connectionPort, (Node)basePort, true);
            }
        }
        return result;
    }

    public static Edge createPortEdge(Node portNode, ViewEditorPane viewEditor) {
        if (Util.isPropagatedPort(portNode)) {
            return null;
        }
        try {
            String varName = Util.getPortVariable(portNode);
            if (varName == null) {
                return null;
            }
            if (!(portNode.getParent() instanceof Compartment)) {
                return null;
            }
            Diagram diagram = Diagram.getDiagram(portNode);
            Option nodeObj = diagram.getRole(EModel.class).getVariable(varName).getParent();
            if (!(nodeObj instanceof Node)) {
                return null;
            }
            String unqueName = DefaultSemanticController.generateUniqueNodeName(diagram, portNode.getName() + "_link");
            Compartment compartment = Compartment.findCommonOrigin((Node)nodeObj, portNode);
            return new Edge(compartment, (Base)new Stub(diagram, unqueName, "portlink"), (Node)nodeObj, portNode);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not add edge for port: " + portNode.getName() + " because of " + ex.getMessage());
            return null;
        }
    }

    public static Edge createPropagatedPortEdge(Node portNode) throws Exception {
        if (!Util.isPropagatedPort(portNode)) {
            return null;
        }
        Node basePort = Util.getBasePort(portNode);
        if (!(portNode.getParent() instanceof Compartment)) {
            return null;
        }
        Diagram diagram = Diagram.getDiagram(portNode);
        String edgeName = DefaultSemanticController.generateUniqueNodeName(diagram, basePort.getName() + "_propagation");
        if (portNode.getKernel().getType().equals("contact connection port")) {
            return new Edge(diagram, (Base)new Stub.UndirectedConnection(diagram, edgeName), basePort, portNode);
        }
        Stub.DirectedConnection kernel = new Stub.DirectedConnection(diagram, edgeName);
        return Util.isInputPort(portNode) ? new Edge(diagram, (Base)kernel, portNode, basePort) : new Edge(diagram, (Base)kernel, basePort, portNode);
    }

    public static void compositeModelPostprocess(Set<SubDiagram> subDiagramSet, Set<ModelDefinition> modelDefinitionSet) {
        HashMap<String, ModelDefinition> nameMap = new HashMap<String, ModelDefinition>();
        for (ModelDefinition modDef : modelDefinitionSet) {
            nameMap.put(modDef.getDiagram().getName(), modDef);
        }
        for (SubDiagram subDiagram : subDiagramSet) {
            Diagram diagram = subDiagram.getDiagram();
            ModelDefinition modDef = (ModelDefinition)((Object)nameMap.get(diagram.getName()));
            if (modDef == null) continue;
            modDef.markRefModelDefinition(diagram);
        }
    }

    public static void compositeModelPostprocess(Diagram compositeDiagram) {
        HashMap<String, ModelDefinition> nameMap = new HashMap<String, ModelDefinition>();
        for (ModelDefinition modDef : compositeDiagram.recursiveStream().select(ModelDefinition.class)) {
            nameMap.put(modDef.getDiagram().getName(), modDef);
        }
        for (SubDiagram subDiagram : compositeDiagram.recursiveStream().select(SubDiagram.class)) {
            Diagram innerDiagram = subDiagram.getDiagram();
            ModelDefinition modDef = (ModelDefinition)((Object)nameMap.get(innerDiagram.getName()));
            if (modDef != null) {
                modDef.markRefModelDefinition(innerDiagram);
            }
            subDiagram.updatePorts();
        }
    }

    public static String generatPath(String parentPath, String variableName) {
        return parentPath.isEmpty() ? variableName : parentPath + SEPARATOR + variableName;
    }

    public static String generatPath(Diagram diagram) {
        ArrayList<String> parents = new ArrayList<String>();
        SubDiagram parentSubDiagram = SubDiagram.getParentSubDiagram(diagram);
        while (parentSubDiagram != null) {
            String[] subDiagramParents = parentSubDiagram.getCompleteNameInDiagram().split("\\.");
            for (int i = subDiagramParents.length - 1; i >= 0; --i) {
                parents.add(subDiagramParents[i]);
            }
            Diagram parentDiagram = Diagram.getDiagram(parentSubDiagram);
            parentSubDiagram = SubDiagram.getParentSubDiagram(parentDiagram);
        }
        return StreamEx.of(parents).joining((CharSequence)SEPARATOR);
    }

    public static List<String> splitPath(String path) {
        return Arrays.asList(path.split(SEPARATOR));
    }

    public static StreamEx<Node> getBuses(Diagram diagram) {
        return (StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> Util.isBus(n));
    }

    public static StreamEx<Node> getInterfacePorts(Diagram diagram) {
        return (StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> Util.isPublicPort(n) || Util.isPropagatedPort(n));
    }

    public static Connection createConnection(Diagram diagram, Node input, Node output, boolean directedConnection) {
        String stubName = IdGenerator.generateUniqueName((DataCollection)diagram, (DecimalFormat)new DecimalFormat("CONNECTION0000"));
        Stub kernel = directedConnection ? new Stub.DirectedConnection(diagram, stubName) : new Stub.UndirectedConnection(diagram, stubName);
        Edge e = new Edge(diagram, (Base)kernel, input, output);
        Connection role = directedConnection ? new DirectedConnection(e) : new UndirectedConnection(e);
        role.setInputPort(new Connection.Port(ConnectionEdgePane.getPortVariableName(input), input.getTitle()));
        role.setOutputPort(new Connection.Port(ConnectionEdgePane.getPortVariableName(output), output.getTitle()));
        e.setRole(role);
        diagram.put(e);
        return role;
    }

    public static void processBuses(Diagram diagram) throws Exception {
        Map clusters = DiagramUtility.getBuses(diagram).groupingBy(n -> n.getRole());
        for (List cluster : clusters.values()) {
            UndirectedConnection con;
            Node port;
            Object edge2;
            List edges = ((StreamEx)StreamEx.of((Collection)cluster).flatMap(n -> n.edges()).filter(e -> Util.isConnection(e))).toList();
            if (edges.size() == 0) continue;
            Connection c = ((Edge)((Object)edges.get(0))).getRole(Connection.class);
            boolean isDirected = c instanceof DirectedConnection;
            List ports = StreamEx.of((Collection)edges).map(e -> Util.isBus(e.getInput()) ? e.getOutput() : e.getInput()).toList();
            for (Object edge2 : edges) {
                ((Edge)((Object)edge2)).getInput().removeEdge((Edge)((Object)edge2));
                ((Edge)((Object)edge2)).getOutput().removeEdge((Edge)((Object)edge2));
                diagram.remove(edge2.getName());
            }
            if (isDirected) {
                Node outputPort = StreamEx.of((Collection)ports).findAny(n -> Util.isOutputPort(n)).orElse(null);
                edge2 = ports.iterator();
                while (edge2.hasNext()) {
                    port = (Node)((Object)edge2.next());
                    if (((Object)((Object)port)).equals((Object)outputPort)) continue;
                    DiagramUtility.createConnection(diagram, outputPort, port, isDirected);
                }
                continue;
            }
            Node mainPort = null;
            edge2 = edges.iterator();
            while (edge2.hasNext()) {
                Edge edge3 = (Edge)((Object)edge2.next());
                con = edge3.getRole(UndirectedConnection.class);
                UndirectedConnection.MainVariableType type = con.getMainVariableType();
                if (type.equals((Object)UndirectedConnection.MainVariableType.NOT_SELECTED)) continue;
                if (type.equals((Object)UndirectedConnection.MainVariableType.INPUT) && !Util.isBus(edge3.getInput())) {
                    mainPort = edge3.getInput();
                    continue;
                }
                if (Util.isBus(edge3.getOutput())) continue;
                mainPort = edge3.getOutput();
            }
            if (mainPort != null) {
                edge2 = ports.iterator();
                while (edge2.hasNext()) {
                    port = (Node)((Object)edge2.next());
                    if (((Object)((Object)port)).equals((Object)mainPort)) continue;
                    con = (UndirectedConnection)DiagramUtility.createConnection(diagram, port, mainPort, false);
                    con.setMainVariableType(UndirectedConnection.MainVariableType.OUTPUT);
                }
                continue;
            }
            for (int i = 1; i < ports.size(); ++i) {
                DiagramUtility.createConnection(diagram, (Node)((Object)ports.get(i)), (Node)((Object)ports.get(0)), false);
            }
        }
        for (Node node : DiagramUtility.getBuses(diagram)) {
            diagram.remove(node.getCompleteNameInDiagram());
        }
    }

    public static SimulationEngine getEngine(Diagram diagram) {
        SimulationEngine engine = DiagramUtility.getPreferredEngine(diagram);
        if (engine != null) {
            return engine;
        }
        return SimulationEngineRegistry.getSimulationEngine((Diagram)diagram);
    }

    public static SimulationEngine getPreferredEngine(Diagram diagram) {
        DynamicProperty dp = diagram.getAttributes().getProperty("simulationOptions");
        if (dp != null && dp.getValue() instanceof SimulationEngine) {
            return (SimulationEngine)dp.getValue();
        }
        return null;
    }

    public static void setPreferredEngine(Diagram diagram, SimulationEngine engine) {
        diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"simulationOptions", SimulationEngine.class, (Object)engine));
    }

    public static void setPlotsInfo(Diagram diagram, PlotsInfo plotsInfo) {
        diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"Plots", PlotsInfo.class, (Object)((Object)plotsInfo)));
    }

    public static PlotsInfo getPlotsInfo(Diagram diagram) {
        Object obj;
        if (diagram.getAttributes().hasProperty("Plots") && (obj = diagram.getAttributes().getValue("Plots")) instanceof PlotsInfo) {
            return (PlotsInfo)((Object)obj);
        }
        return null;
    }

    public static void setInitialValues(Diagram diagram, TableDataCollection collection, String rowID) {
        String[] header = TableDataCollectionUtils.getColumnNames((TableDataCollection)collection);
        double[] row = TableDataCollectionUtils.getDoubleRow((TableDataCollection)collection, (String)rowID);
        for (int j = 0; j < header.length; ++j) {
            String varPath = header[j].toString();
            Variable var = Util.getVariable(diagram, varPath, "\\");
            if (var == null) {
                log.info("Variable not found " + header[j]);
                continue;
            }
            if (var.getName().equals("time")) continue;
            var.setInitialValue(row[j]);
        }
        for (SubDiagram subDiagram : Util.getSubDiagrams(diagram)) {
            try {
                Diagram innerDiagram = subDiagram.getDiagram();
                innerDiagram.save();
            }
            catch (Exception ex) {
                log.info("Could not save subdiagram " + subDiagram.getName());
            }
        }
    }
}

