/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbgn.EquivalenceOperatorProperties;
import biouml.plugins.sbgn.LogicalOperatorProperties;
import biouml.plugins.sbgn.PhenotypeProperties;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Substance;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public class DiagramGenerator {
    private final Diagram diagram;

    public DiagramGenerator(String name) throws Exception {
        this(name, null);
    }

    public DiagramGenerator(String name, DataCollection collection) throws Exception {
        this.diagram = new Diagram(null, new Stub(null, name), new PathwaySimulationDiagramType());
        this.diagram.setRole(new EModel(this.diagram));
    }

    public DiagramGenerator(Diagram diagram) {
        if (!(diagram.getType() instanceof PathwaySimulationDiagramType)) {
            throw new IllegalArgumentException("Only PathwaySimulationDiagramType diagrams allowed");
        }
        if (diagram.getRole() == null || !(diagram.getRole() instanceof EModel)) {
            throw new IllegalArgumentException("Missing or incorrect role in diagram");
        }
        this.diagram = diagram;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public EModel getEModel() {
        return (EModel)this.diagram.getRole();
    }

    public Node createSpecies(String name, double value) throws Exception {
        Node node = new Node(this.diagram, (Base)new Substance(null, name));
        node.setRole(new VariableRole(null, node, value));
        this.diagram.put(node);
        return node;
    }

    public Node createEquation(String variable, String formula, String type) throws Exception {
        Node node = new Node(this.diagram, (Base)new Stub(null, "equation_" + variable, "math-equation"));
        Equation eq = new Equation(node, type, variable, formula);
        node.setRole(eq);
        this.diagram.put(node);
        return node;
    }

    public Node createConstraint(String name, String formula, String message) throws Exception {
        Node node = new Node(this.diagram, (Base)new Stub(null, name, "math-constraint"));
        Constraint constraint = new Constraint(node);
        constraint.setFormula(formula);
        constraint.setMessage(message);
        node.setRole(constraint);
        this.diagram.put(node);
        return node;
    }

    public Node createEvent(String name, String trigger, Assignment assignment) throws Exception {
        Node node = new Node(this.diagram, (Base)new Stub(this.diagram, name));
        Event event = new Event(node);
        event.clearAssignments(false);
        event.setTrigger(trigger);
        event.addEventAssignment(assignment, true);
        node.setRole(event);
        this.diagram.put(node);
        return node;
    }

    public Node createState(String name, Assignment entryAssignment, Assignment exitAssignment) throws Exception {
        return this.createState(name, entryAssignment, exitAssignment, false);
    }

    public Node createState(String name, Assignment entryAssignment, Assignment exitAssignment, boolean isStart) throws Exception {
        ArrayList<Assignment> entryAssignmentList = new ArrayList<Assignment>();
        if (entryAssignment != null) {
            entryAssignmentList.add(entryAssignment);
        }
        ArrayList<Assignment> exitAssignmentList = new ArrayList<Assignment>();
        if (exitAssignment != null) {
            exitAssignmentList.add(exitAssignment);
        }
        return this.createState(name, entryAssignmentList, exitAssignmentList, isStart);
    }

    public Node createState(String name, List<Assignment> entryAssignment, List<Assignment> exitAssignment, boolean isStart) throws Exception {
        Node node = new Node(this.diagram, (Base)new Stub(this.diagram, name, "math-state"));
        State state = new State(node);
        state.setStart(isStart);
        if (entryAssignment != null) {
            for (Assignment assignment : entryAssignment) {
                state.addOnEntryAssignment(assignment, false);
            }
        }
        if (exitAssignment != null) {
            for (Assignment assignment : exitAssignment) {
                state.addOnExitAssignment(assignment, false);
            }
        }
        node.setRole(state);
        this.diagram.put(node);
        return node;
    }

    public Node createState(String name, List<Assignment> entryAssignment, List<Assignment> exitAssignment) throws Exception {
        return this.createState(name, entryAssignment, exitAssignment, false);
    }

    public Edge createTransition(String name, Node from, Node to, String when, String after) throws Exception {
        Edge edge = new Edge(this.diagram, (Base)new Stub(this.diagram, name, "math-transition"), from, to);
        Transition transition = new Transition(edge);
        if (when != null) {
            transition.setWhen(when);
        }
        if (after != null) {
            transition.setAfter(after);
        }
        edge.setRole(transition);
        this.diagram.put(edge);
        return edge;
    }

    public DiagramElementGroup createReaction(String formula, List<SpecieReference> components) throws Exception {
        return this.createReaction(this.diagram, DefaultSemanticController.generateReactionName(this.diagram), formula, components);
    }

    public DiagramElementGroup createReaction(Diagram diagram, String name, String formula, List<SpecieReference> components) throws Exception {
        Reaction prototype = new Reaction(null, name);
        prototype.setFormula(formula);
        prototype.setSpecieReferences((SpecieReference[])StreamEx.of(components).toArray(SpecieReference[]::new));
        DiagramElementGroup reactionElements = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Reaction.class, new Point(0, 0), prototype);
        reactionElements.putToCompartment();
        return reactionElements;
    }

    public DiagramElementGroup createLogicalOperator(Diagram diagram, String name, String type, String reactionName, List<String> components) throws Exception {
        LogicalOperatorProperties lop = new LogicalOperatorProperties(diagram, name + "_" + type);
        lop.setReactionName(reactionName);
        lop.getProperties().add(new DynamicProperty(SBGNPropertyConstants.SBGN_LOGICAL_OPERATOR_PD, String.class, (Object)type));
        lop.setNodeNames(components.toArray(new String[0]));
        DiagramElementGroup elements = lop.doCreateElements((Compartment)diagram, new Point(0, 0), null);
        elements.putToCompartment();
        return elements;
    }

    public DiagramElementGroup createPhenotype(Diagram diagram, String name, List<String> components) throws Exception {
        PhenotypeProperties phenProps = new PhenotypeProperties(diagram, name);
        phenProps.setNodeNames(components.toArray(new String[0]));
        DiagramElementGroup elements = phenProps.doCreateElements((Compartment)diagram, new Point(0, 0), null);
        elements.putToCompartment();
        return elements;
    }

    public DiagramElementGroup createEquivalence(Diagram diagram, String name, String superTypeNode, List<String> subTypeNodes) throws Exception {
        EquivalenceOperatorProperties eop = new EquivalenceOperatorProperties(diagram, name);
        eop.setMainNodeName(superTypeNode);
        eop.setNodeNames(subTypeNodes.toArray(new String[0]));
        DiagramElementGroup elements = eop.doCreateElements((Compartment)diagram, new Point(0, 0), null);
        elements.putToCompartment();
        return elements;
    }

    public DiagramElementGroup createReaction(String formula, SpecieReference ... components) throws Exception {
        return this.createReaction(formula, StreamEx.of((Object[])components).toList());
    }

    public SpecieReference createSpeciesReference(Node node, String role) throws Exception {
        if (!(node.getRole() instanceof VariableRole)) {
            throw new Exception("Wrong node");
        }
        String specieName = node.getName();
        SpecieReference specieReference = new SpecieReference(null, specieName, role);
        specieReference.setSpecie(specieName);
        return specieReference;
    }

    public void createPort(String variableName, String type) throws Exception {
        String name = DefaultSemanticController.generateUniqueNodeName(this.diagram, "port");
        Node node = new Node(this.diagram, (Base)Stub.ConnectionPort.createPortByType(this.diagram, name, type));
        node.getAttributes().add(new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)SubDiagram.PortOrientation.RIGHT));
        node.getAttributes().add(new DynamicProperty("variableName", String.class, (Object)variableName));
        this.diagram.put(node);
    }
}

