/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Node;
import biouml.standard.diagram.DatabaseReferencesEditDialog;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.type.Base;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Referrer;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.editor.SelectionManager;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class DatabaseReferencesPane
extends JPanel
implements ViewPaneListener {
    public static final String EDIT = "edit";
    public static final String REMOVE = "remove";
    protected Action editAction = new EditAction("edit", this);
    protected Action removeAction = new RemoveAction("remove", this);
    protected Action[] actions;
    protected MessageBundle messageBundle = new MessageBundle();
    protected ViewPane viewPane;
    protected TabularPropertyInspector refTable = new TabularPropertyInspector();
    protected Referrer referrer;
    protected DatabaseReference selectedReference;

    public DatabaseReferencesPane() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.showStandardStub();
    }

    protected void showStandardStub() {
        this.removeAll();
        JLabel text = new JLabel("Select diagram element with database references");
        this.add((Component)text, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.repaint();
        this.validate();
        this.editAction.setEnabled(false);
        this.removeAction.setEnabled(false);
    }

    protected void showDatabaseReferencesTable() {
        this.removeAll();
        JLabel text = new JLabel("Current DB references for DC/title");
        this.add((Component)text, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.refTable.explore((Object[])this.referrer.getDatabaseReferences());
        this.refTable.getTable().setSelectionMode(0);
        this.selectedReference = null;
        this.refTable.addListSelectionListener(event -> {
            Object model;
            if (event.getFirstIndex() != -1 && (model = this.refTable.getModelOfSelectedRow()) instanceof DatabaseReference) {
                this.selectedReference = (DatabaseReference)((Object)((Object)model));
                this.removeAction.setEnabled(true);
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.refTable);
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.repaint();
        this.validate();
        this.editAction.setEnabled(true);
        this.removeAction.setEnabled(false);
    }

    public void explore(ViewPane viewPane) {
        viewPane.addViewPaneListener((ViewPaneListener)this);
        this.viewPane = viewPane;
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
            initializer.initAction(this.editAction, EDIT);
            initializer.initAction(this.removeAction, REMOVE);
            this.actions = new Action[]{this.editAction, this.removeAction};
        }
        return this.actions;
    }

    public void mouseClicked(ViewPaneEvent e) {
    }

    public void mousePressed(ViewPaneEvent event) {
    }

    public void mouseReleased(ViewPaneEvent e) {
        this.diagramSelectionChanged();
    }

    public void mouseEntered(ViewPaneEvent e) {
    }

    public void mouseExited(ViewPaneEvent e) {
    }

    public void mouseDragged(ViewPaneEvent e) {
    }

    public void mouseMoved(ViewPaneEvent e) {
    }

    protected void diagramSelectionChanged() {
        Base kernel;
        SelectionManager sm = this.viewPane.getSelectionManager();
        if (sm.getSelectedModels() != null && sm.getSelectedModels().length > 0 && sm.getSelectedModels()[0] instanceof Node && (kernel = ((Node)((Object)sm.getSelectedModels()[0])).getKernel()) instanceof Referrer) {
            this.referrer = (Referrer)kernel;
            this.showDatabaseReferencesTable();
            return;
        }
        this.showStandardStub();
    }

    class RemoveAction
    extends AbstractAction {
        private final Component parent;

        public RemoveAction(String name, Component parent) {
            super(name);
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DatabaseReferencesPane.this.selectedReference != null) {
                DatabaseReference[] references;
                if (JOptionPane.showConfirmDialog(this.parent, "Do you really want to remove selected reference?") == 0 && (references = DatabaseReferencesPane.this.referrer.getDatabaseReferences()) != null && references.length > 0) {
                    DatabaseReferencesPane.this.referrer.setDatabaseReferences((DatabaseReference[])StreamEx.of((Object[])references).without((Object)DatabaseReferencesPane.this.selectedReference).toArray(DatabaseReference[]::new));
                    DatabaseReferencesPane.this.showDatabaseReferencesTable();
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, "Select database reference from the table");
            }
        }
    }

    class EditAction
    extends AbstractAction {
        private final Component parent;

        public EditAction(String name, Component parent) {
            super(name);
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabaseReferencesEditDialog dialog = new DatabaseReferencesEditDialog(this.parent, DatabaseReferencesPane.this.referrer);
            if (dialog.isEnabled() && dialog.doModal()) {
                DatabaseReferencesPane.this.referrer.setDatabaseReferences(dialog.getValue());
                DatabaseReferencesPane.this.showDatabaseReferencesTable();
            }
        }
    }
}

