/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Module;
import biouml.model.util.ReferencesHandler;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Referrer;
import biouml.standard.type.RelationType;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ru.biosoft.access.biohub.BioHub;
import ru.biosoft.access.biohub.BioHubRegistry;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.util.OkCancelDialog;

public class DatabaseReferencesEditDialog
extends OkCancelDialog {
    private static Logger log = Logger.getLogger(DatabaseReferencesEditDialog.class.getName());
    protected TabularPropertyInspector referencesEditor = new TabularPropertyInspector();
    protected TabularPropertyInspector geneHubEditor = new TabularPropertyInspector();
    protected JPanel topPane = new JPanel(new GridBagLayout());
    protected JPanel bottomPane = new JPanel(new GridBagLayout());
    protected JPanel newPane = new JPanel(new GridBagLayout());
    protected JPanel searchOptionsPane = new JPanel(new GridBagLayout());
    protected JPanel referencesPane = new JPanel(new GridBagLayout());
    protected JPanel buttonsPane = new JPanel(new GridBagLayout());
    protected JPanel geneHubPane = new JPanel(new GridBagLayout());
    protected JPanel newButtonsPane = new JPanel(new GridBagLayout());
    protected JButton newPaneAddButton;
    protected JButton newPaneOpenButton = new JButton("Open in browser");
    protected JButton newPaneSearchButton = new JButton("Search in gene hub");
    protected JPanel geneHubButtonsPane = new JPanel(new GridBagLayout());
    protected JButton geneHubPaneOpenButton = new JButton("Open in browser");
    protected JPanel referencesButtonsPane = new JPanel(new GridBagLayout());
    protected JButton referencesPaneRemoveButton = new JButton("Remove");
    protected JButton referencesPaneOpenButton = new JButton("Open in browser");
    protected JButton addButton = new JButton("Add");
    protected JButton searchButton = new JButton("Search");
    protected JComboBox<String> geneHubName = new JComboBox();
    protected JComboBox<String> geneHubOrganism = new JComboBox();
    protected JComboBox<String> geneHubDatabase = new JComboBox();
    protected JComboBox<String> newDatabase = new JComboBox();
    protected JTextField newID = new JTextField();
    protected JTextField newAC = new JTextField();
    protected JComboBox<String> newRelation = new JComboBox();
    protected JTextField newComment = new JTextField();
    protected Map<String, DatabaseInfo> databaseInfoMap = new HashMap<String, DatabaseInfo>();
    public static final String DEFAULT_BINDER = "<not selected>";
    protected Module module;
    protected DatabaseReference[] references;
    protected DatabaseReference[] searchResults = new DatabaseReference[0];
    protected DataCollection<DatabaseInfo> databaseInfo;
    protected DataCollection<?> metadata;
    protected DatabaseReference selectedReferenceLeft;
    protected DatabaseReference selectedReferenceRight;
    protected boolean enabled = true;
    public static final String TITLE = "Database References Editor";

    public DatabaseReferencesEditDialog(Component parent, Referrer referrer) {
        super(parent, TITLE);
        this.references = referrer.getDatabaseReferences();
        this.module = Module.getModule(referrer);
        try {
            this.metadata = (DataCollection)this.module.get("Dictionaries");
            if (this.metadata != null) {
                this.databaseInfo = (DataCollection)this.metadata.get("database info");
            }
        }
        catch (Throwable t) {
            this.enabled = false;
            String message = "\"database info\" collection is not able for current database";
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), message, "Error", 0);
            log.log(Level.SEVERE, message);
        }
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initComboBoxes();
        this.initButtons();
        this.newPane.setBorder(new TitledBorder("New database reference:"));
        this.newPane.setPreferredSize(new Dimension(0, 140));
        this.newPane.add((Component)new JLabel("Database:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add(this.newDatabase, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)new JLabel("ID:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)this.newID, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)new JLabel("AC:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)this.newAC, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)new JLabel("Relation:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add(this.newRelation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)new JLabel("Comment:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)this.newComment, new GridBagConstraints(3, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newButtonsPane.add((Component)this.newPaneAddButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newButtonsPane.add((Component)this.newPaneOpenButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newButtonsPane.add((Component)this.newPaneSearchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.newPane.add((Component)this.newButtonsPane, new GridBagConstraints(1, 2, 5, 1, 1.0, 0.0, 13, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.setBorder(new TitledBorder("Gene hub search options:"));
        this.searchOptionsPane.setPreferredSize(new Dimension(200, 140));
        this.searchOptionsPane.add((Component)new JLabel("Gene hub:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.add(this.geneHubName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.add((Component)new JLabel("Organism:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.add(this.geneHubOrganism, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.add((Component)new JLabel("Database:"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.searchOptionsPane.add(this.geneHubDatabase, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesPane.setBorder(new TitledBorder("Current DB references for gene/title:"));
        this.referencesEditor.explore((Object[])this.references);
        this.referencesEditor.getTable().setSelectionMode(0);
        this.referencesEditor.addListSelectionListener(event -> {
            Object model;
            if (event.getFirstIndex() != -1 && (model = this.referencesEditor.getModelOfSelectedRow()) instanceof DatabaseReference) {
                this.selectedReferenceLeft = (DatabaseReference)((Object)((Object)model));
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.referencesEditor);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.referencesPane.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesButtonsPane.add((Component)this.referencesPaneRemoveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesButtonsPane.add((Component)this.referencesPaneOpenButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesPane.add((Component)this.referencesButtonsPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.buttonsPane.setPreferredSize(new Dimension(100, 100));
        this.buttonsPane.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.buttonsPane.add((Component)this.searchButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.geneHubPane.setBorder(new TitledBorder("Gene hub references:"));
        this.geneHubEditor.explore((Object[])this.searchResults);
        this.geneHubEditor.getTable().setSelectionMode(0);
        this.geneHubEditor.addListSelectionListener(event -> {
            Object model;
            if (event.getFirstIndex() != -1 && (model = this.geneHubEditor.getModelOfSelectedRow()) instanceof DatabaseReference) {
                this.selectedReferenceRight = (DatabaseReference)((Object)((Object)model));
            }
        });
        JScrollPane scrollPane2 = new JScrollPane((Component)this.geneHubEditor);
        scrollPane2.setPreferredSize(new Dimension(300, 100));
        scrollPane2.setHorizontalScrollBarPolicy(30);
        scrollPane2.setVerticalScrollBarPolicy(20);
        this.geneHubPane.add((Component)scrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.geneHubButtonsPane.add((Component)this.geneHubPaneOpenButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.geneHubPane.add((Component)this.geneHubButtonsPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.topPane.add((Component)this.newPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.topPane.add((Component)this.searchOptionsPane, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.bottomPane.add((Component)this.referencesPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.bottomPane.add((Component)this.buttonsPane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.bottomPane.add((Component)this.geneHubPane, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        content.add((Component)this.topPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        content.add((Component)this.bottomPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.selectedReferenceLeft = null;
        this.selectedReferenceRight = null;
        this.updateOKButton();
        this.setGeneHubSearchActivity();
        this.setContent(content);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void updateOKButton() {
        this.okButton.setEnabled(true);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public DatabaseReference[] getValue() {
        return this.references;
    }

    protected void initComboBoxes() {
        try {
            if (this.databaseInfo != null) {
                ArrayList<String> dbNames = new ArrayList<String>();
                for (DatabaseInfo dbInfo : this.databaseInfo) {
                    dbNames.add(dbInfo.getTitle());
                    this.databaseInfoMap.put(dbInfo.getTitle(), dbInfo);
                }
                Collections.sort(dbNames);
                for (String dbName : dbNames) {
                    this.newDatabase.addItem(dbName);
                }
            }
            this.newRelation.addItem("");
            DataCollection relationType = (DataCollection)this.metadata.get("relation type");
            if (relationType != null) {
                for (RelationType type : relationType) {
                    this.newRelation.addItem(type.getTitle());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.geneHubName.addItem(DEFAULT_BINDER);
        try {
            BioHubRegistry.bioHubs().map(BioHubRegistry.BioHubInfo::getName).forEach(this.geneHubName::addItem);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.geneHubName.addItemListener(e -> this.setGeneHubSearchActivity());
    }

    protected void initButtons() {
        this.newPaneAddButton = new JButton();
        this.newPaneAddButton.setLayout(new BorderLayout());
        this.newPaneAddButton.add((Component)new JLabel("Add to references"), "Center");
        this.newPaneAddButton.addActionListener(event -> this.addNewReferenceAction());
        this.referencesPaneRemoveButton.addActionListener(event -> this.removeReferenceAction());
        this.searchButton.addActionListener(event -> this.searchReferencesByCurrentReference());
        this.newPaneSearchButton.addActionListener(event -> this.searchReferencesByNewReference());
        this.addButton.addActionListener(event -> this.addFoundReference());
        this.newPaneOpenButton.addActionListener(event -> this.openNewReference());
        this.referencesPaneOpenButton.addActionListener(event -> this.openCurrentReference());
        this.geneHubPaneOpenButton.addActionListener(event -> this.openReferenceFromGeneHub());
    }

    protected void addNewReferenceAction() {
        DatabaseReference dr = new DatabaseReference();
        String database = this.databaseInfoMap.get(this.newDatabase.getSelectedItem()).getName();
        if (database != null && !database.equals("")) {
            dr.setDatabaseName(database);
        } else {
            dr.setDatabaseName("");
        }
        String id = this.newID.getText();
        if (id != null && !id.equals("")) {
            dr.setId(id);
        } else {
            dr.setId("");
        }
        String ac = this.newAC.getText();
        if (ac != null && !ac.equals("")) {
            dr.setAc(ac);
        } else {
            dr.setAc("");
        }
        String relation = (String)this.newRelation.getSelectedItem();
        if (relation != null && !relation.equals("")) {
            dr.setRelationshipType(relation);
        } else {
            dr.setRelationshipType("");
        }
        String comment = this.newComment.getText();
        if (comment != null && !comment.equals("")) {
            dr.setComment(comment);
        } else {
            dr.setComment("");
        }
        if (this.references == null) {
            this.references = new DatabaseReference[]{dr};
        } else {
            DatabaseReference[] databaseReferences = new DatabaseReference[this.references.length + 1];
            System.arraycopy(this.references, 0, databaseReferences, 0, this.references.length);
            databaseReferences[this.references.length] = dr;
            this.references = databaseReferences;
        }
        this.selectedReferenceLeft = null;
        this.referencesEditor.explore((Object[])this.references);
    }

    protected void removeReferenceAction() {
        int row;
        if (this.references != null && this.references.length > 0 && this.selectedReferenceLeft != null && (row = this.getRowByDatabaseReference(this.references, this.selectedReferenceLeft)) != -1) {
            if (this.references.length == 1) {
                this.references = null;
            } else {
                DatabaseReference[] databaseReferences = new DatabaseReference[this.references.length - 1];
                if (row > 0) {
                    System.arraycopy(this.references, 0, databaseReferences, 0, row);
                }
                if (row < this.references.length - 1) {
                    System.arraycopy(this.references, row + 1, databaseReferences, row, this.references.length - (row + 1));
                }
                this.references = databaseReferences;
            }
            this.selectedReferenceLeft = null;
            this.referencesEditor.explore((Object[])this.references);
        }
    }

    protected void searchReferencesByCurrentReference() {
        DatabaseReference[] results = null;
        if (this.selectedReferenceLeft != null) {
            int row = this.getRowByDatabaseReference(this.references, this.selectedReferenceLeft);
            if (row != -1 && !this.geneHubName.getSelectedItem().equals(DEFAULT_BINDER)) {
                DatabaseReference currentReference = this.references[row];
                try {
                    Element[] elementResults;
                    BioHub bioHub = BioHubRegistry.getBioHub((String)this.geneHubName.getSelectedItem().toString());
                    Element[] elementArray = elementResults = bioHub == null ? null : bioHub.getReference(currentReference.convertToElement(), null, null, 1, -1);
                    results = elementResults == null ? new DatabaseReference[]{} : DatabaseReferencesEditDialog.convertToDatabaseReferences(elementResults);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.searchResults = results;
            this.selectedReferenceRight = null;
            this.geneHubEditor.explore((Object[])this.searchResults);
        }
    }

    protected void searchReferencesByNewReference() {
        DatabaseReference[] results = null;
        if (!this.geneHubName.getSelectedItem().equals(DEFAULT_BINDER)) {
            DatabaseReference newReference = new DatabaseReference();
            newReference.setDatabaseName((String)this.newDatabase.getSelectedItem());
            newReference.setId(this.newID.getText());
            newReference.setAc(this.newAC.getText());
            newReference.setRelationshipType((String)this.newRelation.getSelectedItem());
            newReference.setComment(this.newComment.getText());
            try {
                Element[] elementResults;
                BioHub bioHub = BioHubRegistry.getBioHub((String)this.geneHubName.getSelectedItem().toString());
                Element[] elementArray = elementResults = bioHub == null ? null : bioHub.getReference(newReference.convertToElement(), null, null, 1, -1);
                results = elementResults == null ? new DatabaseReference[]{} : DatabaseReferencesEditDialog.convertToDatabaseReferences(elementResults);
            }
            catch (Exception ex) {
                log.info("microarray or genehub plugin doesn't support");
            }
        }
        this.searchResults = results;
        this.selectedReferenceRight = null;
        this.geneHubEditor.explore((Object[])this.searchResults);
    }

    protected void addFoundReference() {
        int row;
        if (this.searchResults != null && this.searchResults.length > 0 && (row = this.getRowByDatabaseReference(this.searchResults, this.selectedReferenceRight)) != -1) {
            DatabaseReference newDatabaseReference = this.searchResults[row];
            if (this.references == null) {
                this.references = new DatabaseReference[]{newDatabaseReference};
            } else {
                DatabaseReference[] databaseReferences = new DatabaseReference[this.references.length + 1];
                System.arraycopy(this.references, 0, databaseReferences, 0, this.references.length);
                databaseReferences[this.references.length] = newDatabaseReference;
                this.references = databaseReferences;
                this.selectedReferenceLeft = null;
                this.referencesEditor.explore((Object[])this.references);
            }
        }
    }

    protected void openReference(String databaseTitle, String id) {
        DatabaseInfo di;
        if (databaseTitle != null && id != null && !id.equals("") && !databaseTitle.equals("") && (di = this.databaseInfoMap.get(databaseTitle)) != null) {
            String url = di.getQueryById();
            if (null == url) {
                log.log(Level.SEVERE, "ID query not found in database info");
                return;
            }
            url = url.replace('$', '@').replaceAll("@id@", id).replace('@', '$');
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't open url link. ", t);
            }
        }
    }

    protected void openNewReference() {
        String database = (String)this.newDatabase.getSelectedItem();
        String id = this.newID.getText();
        this.openReference(database, id);
    }

    protected void openCurrentReference() {
        int row = this.getRowByDatabaseReference(this.references, this.selectedReferenceLeft);
        if (row != -1) {
            DatabaseReference dr = this.references[row];
            String databaseTitle = null;
            for (DatabaseInfo di : this.databaseInfoMap.values()) {
                if (!di.getName().equals(dr.getDatabaseName())) continue;
                databaseTitle = di.getTitle();
                break;
            }
            if (null == databaseTitle) {
                for (DatabaseInfo di : this.databaseInfoMap.values()) {
                    if (!di.getTitle().equals(dr.getDatabaseName())) continue;
                    databaseTitle = di.getTitle();
                    break;
                }
            }
            if (null == databaseTitle) {
                databaseTitle = "";
            }
            String id = dr.getId();
            this.openReference(databaseTitle, id);
        }
    }

    protected void openReferenceFromGeneHub() {
        int row = this.getRowByDatabaseReference(this.searchResults, this.selectedReferenceRight);
        if (row != -1) {
            DatabaseReference dr = this.searchResults[row];
            String databaseTitle = null;
            for (DatabaseInfo di : this.databaseInfoMap.values()) {
                if (!di.getName().equals(dr.getDatabaseName())) continue;
                databaseTitle = di.getTitle();
                break;
            }
            if (null == databaseTitle) {
                for (DatabaseInfo di : this.databaseInfoMap.values()) {
                    if (!di.getTitle().equals(dr.getDatabaseName())) continue;
                    databaseTitle = di.getTitle();
                    break;
                }
            }
            if (null == databaseTitle) {
                databaseTitle = "";
            }
            String id = dr.getId();
            this.openReference(databaseTitle, id);
        }
    }

    protected void setGeneHubSearchActivity() {
        if (this.geneHubName.getSelectedItem().equals(DEFAULT_BINDER)) {
            this.newPaneSearchButton.setEnabled(false);
            this.searchButton.setEnabled(false);
            this.geneHubOrganism.setEnabled(false);
            this.geneHubDatabase.setEnabled(false);
        } else {
            this.newPaneSearchButton.setEnabled(true);
            this.searchButton.setEnabled(true);
            this.geneHubOrganism.setEnabled(true);
            this.geneHubDatabase.setEnabled(true);
        }
    }

    protected int getRowByDatabaseReference(DatabaseReference[] collection, DatabaseReference element) {
        int i = 0;
        for (DatabaseReference reference : collection) {
            if (reference == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static DatabaseReference[] convertToDatabaseReferences(Element[] elements) {
        return ReferencesHandler.convertToDatabaseReferences(elements);
    }
}

