/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Module;
import biouml.standard.diagram.ConnectionEdgePane;
import biouml.standard.diagram.SemanticRelationPane;
import biouml.standard.diagram.SimpleEdgePane;
import biouml.standard.diagram.TransitionPane;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class CreateEdgeDialog
extends OkCancelDialog {
    SemanticRelationPane content;

    public static CreateEdgeDialog getSemanticRelationDialog(Module module, Point point, ViewEditorPane viewEditor) {
        return new CreateEdgeDialog(point, "New relation", new SemanticRelationPane(module, viewEditor));
    }

    public static CreateEdgeDialog getTransitionDialog(Module module, Point point, ViewEditorPane viewEditor) {
        return new CreateEdgeDialog(point, "New transition", new TransitionPane(module, viewEditor));
    }

    public static CreateEdgeDialog getSimpleEdgeDialog(Module module, Point point, ViewEditorPane viewEditor, String edgeName, String edgeType, DynamicPropertySet initAttributes) {
        return new CreateEdgeDialog(point, "New edge", new SimpleEdgePane(module, viewEditor, edgeName, edgeType, initAttributes));
    }

    public static CreateEdgeDialog getConnectionDialog(Module module, Point point, ViewEditorPane viewEditor, Class connectionType, Compartment parent) {
        return new CreateEdgeDialog(point, "New connection", new ConnectionEdgePane(module, viewEditor, connectionType, parent));
    }

    public CreateEdgeDialog(Point point, String title, SemanticRelationPane relationPane) {
        super((JFrame)Application.getApplicationFrame(), title, false);
        JComponent editor;
        this.content = relationPane;
        this.setContent(this.content);
        this.pack();
        if (Application.getApplicationFrame() != null && (editor = Application.getApplicationFrame().getPanelManager().getPanel("diagram")) != null) {
            Window root = SwingUtilities.getWindowAncestor(editor);
            int x = root.getLocation().x + editor.getLocation().x + (root.getSize().width - editor.getSize().width) / 2;
            int y = root.getLocation().y + editor.getLocation().y + editor.getSize().height;
            this.setLocation(x, y);
        }
        relationPane.okButton = this.okButton;
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        this.content.okPressed();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.content.cancelPressed();
        super.cancelPressed();
    }
}

