/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.annotation.Nonnull;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneLayer;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class CreateEdgeAction {
    public static final String EDGE_END_STUB = "edge-end-stub";
    private CompositeView layerView;
    private BoxView startBox;
    private BoxView endBox;
    private Pen startEndPen = new Pen(3.0f, Color.GREEN);
    private Pen errorPen = new Pen(3.0f, Color.RED);

    public void createEdge(Point point, final ViewEditorPane viewEditor, final EdgeCreator creator) {
        View startView = viewEditor.getView().getDeepestActive(point);
        if (startView == null) {
            return;
        }
        Object model = startView.getModel();
        if (!(model instanceof Node)) {
            return;
        }
        final Node startNode = (Node)((Object)model);
        final Diagram diagram = Diagram.getDiagram(startNode);
        this.startBox = new BoxView(this.startEndPen, null, startNode.getView().getBounds());
        final SemanticController controller = diagram.getType().getSemanticController();
        final DiagramViewBuilder viewBuilder = diagram.getType().getDiagramViewBuilder();
        final ViewPaneLayer layer = new ViewPaneLayer(){

            public void paintLayer(Graphics2D g2) {
                CreateEdgeAction.this.startBox.paint(g2);
                if (CreateEdgeAction.this.endBox != null) {
                    CreateEdgeAction.this.endBox.paint(g2);
                }
                CreateEdgeAction.this.layerView.paint(g2);
            }
        };
        viewEditor.addLayer(layer);
        viewEditor.addViewPaneListener((ViewPaneListener)new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                Object model;
                View view = e.getViewSource();
                Object object = model = view == null ? null : view.getModel();
                if (model instanceof Node && model != diagram) {
                    Node endNode = (Node)((Object)model);
                    try {
                        Edge edge = creator.createEdge(startNode, endNode, false);
                        if (!controller.canAccept(edge.getCompartment(), edge)) {
                            throw new IllegalArgumentException("Edge cannot be accepted");
                        }
                        viewEditor.add((Object)edge, new Point(0, 0));
                    }
                    catch (IllegalArgumentException ex) {
                        ApplicationUtils.errorBox((Throwable)ex);
                    }
                }
                viewEditor.removeLayer(layer);
                viewEditor.removeViewPaneListener((ViewPaneListener)this);
                viewEditor.repaint();
            }

            public void mouseMoved(ViewPaneEvent e) {
                Node endNode;
                Object model;
                View view = e.getViewSource();
                Object object = model = view == null ? null : view.getModel();
                if (model instanceof Node && model != diagram) {
                    endNode = (Node)((Object)model);
                    CreateEdgeAction.this.endBox = new BoxView(CreateEdgeAction.this.startEndPen, null, endNode.getView().getBounds());
                } else {
                    endNode = new Node(diagram, (Base)new Stub(null, CreateEdgeAction.EDGE_END_STUB, CreateEdgeAction.EDGE_END_STUB));
                    endNode.setLocation(e.getPoint());
                    endNode.setShapeSize(new Dimension(1, 1));
                    CreateEdgeAction.this.endBox = null;
                }
                Edge edge = creator.createEdge(startNode, endNode, true);
                if (CreateEdgeAction.this.endBox != null && !controller.canAccept(edge.getCompartment(), edge)) {
                    CreateEdgeAction.this.endBox.setPen(CreateEdgeAction.this.errorPen);
                }
                controller.recalculateEdgePath(edge);
                CreateEdgeAction.this.layerView = viewBuilder.createEdgeView(edge, diagram.getViewOptions(), ApplicationUtils.getGraphics());
                viewEditor.repaint();
            }
        });
    }

    public static interface EdgeCreator {
        public Edge createEdge(@Nonnull Node var1, @Nonnull Node var2, boolean var3) throws IllegalArgumentException;
    }
}

