/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.CollectionDescription;
import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.diagram.ElementChooserPane;
import biouml.standard.diagram.ElementChooserPaneListener;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.GenericEntity;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.support.NewDataElementDialog;
import ru.biosoft.gui.ExplorerPane;

public class CreateDiagramElementDialog
extends OkCancelDialog
implements ElementChooserPaneListener {
    protected Logger log = Logger.getLogger(CreateDiagramElementDialog.class.getName());
    private static MessageBundle resources = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    @Nonnull
    private biouml.model.Compartment parent;
    private Node node;
    private Class<? extends DataElement> type;
    protected ExplorerPane explorerPane;
    protected ElementChooserPane elementChooser;
    protected JButton newButton;
    protected Module module;
    protected CollectionDescription[] extendedModules;
    protected DataCollection elementDC;

    public CreateDiagramElementDialog(@Nonnull biouml.model.Compartment parent, Class<? extends DataElement> type) throws Exception {
        this((JFrame)Application.getApplicationFrame(), resources.getResourceString("NEW_ELEMENT_DIALOG"), parent, type);
    }

    protected CreateDiagramElementDialog(JFrame frame, String titlePrototype, @Nonnull biouml.model.Compartment parent, Class<? extends DataElement> type) throws Exception {
        super(frame, "");
        this.parent = parent;
        this.type = type;
        this.module = Module.getModule((DataElement)parent);
        this.elementDC = this.module.getCategory(type);
        this.extendedModules = this.module.getExternalCategories(type);
        if (this.elementDC == null && (this.extendedModules == null || this.extendedModules.length == 0)) {
            this.setContent(new JLabel(resources.getResourceString("NEW_ELEMENT_DIALOG_ERROR")));
            return;
        }
        if (this.elementDC == null) {
            this.elementDC = this.extendedModules[0].getDc();
        }
        this.setTitle(MessageFormat.format(titlePrototype, this.elementDC.getName()));
        this.newButton = new JButton(resources.getResourceString("NEW_BUTTON"));
        this.newButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.buttonPanel.add((Component)this.newButton, 0);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateDiagramElementDialog.this.newPressed();
            }
        });
        this.newButton.setEnabled(this.elementDC != null && Base.class.isAssignableFrom(type) ? this.elementDC.isMutable() : false);
        JPanel content = new JPanel(new BorderLayout(10, 10));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.explorerPane = new ExplorerPane();
        this.explorerPane.setPreferredSize(new Dimension(400, 300));
        String borderTitle = MessageFormat.format(resources.getResourceString("EXPLORER_BORDER_TITLE"), this.elementDC != null ? this.elementDC.getName() : "");
        this.explorerPane.setBorder((Border)new TitledBorder(new EtchedBorder(), borderTitle));
        content.add((Component)this.explorerPane, "Center");
        this.elementChooser = new ElementChooserPane(Module.getModule((DataElement)parent), this.explorerPane, this.extendedModules, this){

            @Override
            protected void setControlsEnabled(boolean enable) {
                super.setControlsEnabled(enable);
                CreateDiagramElementDialog.this.okButton.setEnabled(enable);
            }
        };
        this.elementChooser.init(type);
        content.add((Component)this.elementChooser, "North");
        this.setContent(content);
    }

    protected void newPressed() {
        try {
            GenericEntity entity;
            NewDataElementDialog newDataElementDialog;
            DataCollection<? extends DataElement> category = Module.getModule((DataElement)this.parent).getCategory(this.type);
            if (category != null && (newDataElementDialog = new NewDataElementDialog((Component)((Object)this), "New data element", category)).doModal() && (entity = (GenericEntity)newDataElementDialog.getNewDataElement()) != null) {
                this.elementChooser.addNew(entity);
            }
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Error during creation new data element", e);
        }
    }

    protected void okPressed() {
        if (this.elementChooser != null) {
            this.elementChooser.close();
            this.node = this.createDiagramElement();
        }
        if (this.node != null) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.elementChooser != null) {
            this.elementChooser.close();
        }
        super.cancelPressed();
    }

    protected Node createDiagramElement() {
        Node node = null;
        try {
            String name = this.getKernelName();
            if (name == null) {
                return null;
            }
            if (Diagram.class == this.type) {
                Diagram selectedDiagram = (Diagram)this.elementDC.get(name);
                if (selectedDiagram.getRole() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), resources.getResourceString("NULL_MODEL_ERROR"), "Error", 0);
                    return null;
                }
                if (Diagram.optDiagram(this.parent) == selectedDiagram) {
                    JOptionPane.showMessageDialog((Component)((Object)this), resources.getResourceString("INCORRECT_ELEMENT_ERROR"), "Error", 0);
                    return null;
                }
                return selectedDiagram;
            }
            Base base = (Base)Module.getModule((DataElement)this.parent).getKernel(this.elementDC.getCompletePath().getChildPath(new String[]{name}).toString());
            node = Compartment.class.isAssignableFrom(this.type) ? new biouml.model.Compartment(this.parent, this.getKernelName(), base) : new Node(this.parent, this.getKernelName(), base);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error during creation of a diagram element", e);
        }
        return node;
    }

    protected String getKernelName() {
        return this.elementChooser.getKernelName();
    }

    public Node getNode() {
        return this.node;
    }

    public void selectItem(String name, String moduleName) {
        this.elementChooser.selectItem(name, moduleName);
    }

    @Override
    public void moduleChanged(String moduleName, DataCollection targetDC) {
        this.elementDC = targetDC;
        if (!this.module.getName().equals(moduleName) && this.extendedModules != null) {
            StreamEx.of((Object[])this.extendedModules).findFirst(et -> et.getModuleName().equals(moduleName)).ifPresent(et -> this.newButton.setEnabled(!et.isReadOnly() && this.elementDC.isMutable()));
        } else {
            this.newButton.setEnabled(this.elementDC.isMutable() && Base.class.isAssignableFrom(this.type));
        }
    }
}

