/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.MultipleDirectedConnection;
import biouml.model.dynamics.MultipleUndirectedConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.SemanticRelationPane;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Specie;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.support.IdGenerator;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.util.OkCancelDialog;
import ru.biosoft.util.Pair;

public class ConnectionEdgePane
extends SemanticRelationPane {
    protected Stub edgeStub;
    protected Class<?> connectionType;
    protected boolean directedConnection;
    protected Compartment parent;

    public ConnectionEdgePane(Module module, ViewEditorPane viewEditor, Class<?> connectionType, Compartment parent) {
        super(module, viewEditor);
        this.connectionType = connectionType;
        this.directedConnection = Stub.DirectedConnection.class.isAssignableFrom(connectionType);
        this.parent = parent;
    }

    @Override
    public boolean createRelation() {
        try {
            Stub edgeStub;
            String stubName = IdGenerator.generateUniqueName((DataCollection)this.parent, (DecimalFormat)new DecimalFormat("CONNECTION0000"));
            Constructor<?> c = this.connectionType.getConstructor(DataCollection.class, String.class);
            this.directedConnection = Stub.DirectedConnection.class.isAssignableFrom(this.connectionType);
            this.edgeStub = edgeStub = (Stub)c.newInstance(null, stubName);
            return true;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "Exception: " + t, "Error", 0);
            return false;
        }
    }

    @Override
    protected void createEdge() {
        try {
            Node inNode = (Node)this.inSelector.getDiagramElement();
            Node outNode = (Node)this.outSelector.getDiagramElement();
            Compartment origin = Node.findCommonOrigin(inNode, outNode);
            if (((Object)((Object)inNode)).equals((Object)outNode)) {
                JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connections for the same element are not allowed.");
                return;
            }
            Edge edge = null;
            edge = Util.isSubDiagram(inNode) && (Util.isSubDiagram(outNode) || Util.isPlot(outNode)) ? this.createMultipleConnection(inNode, outNode, origin) : this.createConnection(inNode, outNode);
            if (edge != null) {
                this.viewEditor.startTransaction("Add");
                origin.put(edge);
                this.viewEditor.completeTransaction();
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Can not create Edge for connection '" + this.edgeStub.getName() + "'");
        }
    }

    private Edge createMultipleConnection(Node inNode, Node outNode, Compartment origin) throws Exception {
        if (((Object)((Object)inNode)).equals((Object)origin) || ((Object)((Object)outNode)).equals((Object)origin)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connections for main diagram are not allowed");
            return null;
        }
        if (Util.isPlot(outNode) && !this.directedConnection) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Undirected connections are not allowed for plot");
            return null;
        }
        Edge oldEdge = ConnectionEdgePane.getEdgeIfAlreadyExists(inNode, outNode, origin, this.connectionType);
        ParametersConnectionDialog dialog = new ParametersConnectionDialog(this, null, "Establish parameters connections", inNode, outNode, oldEdge);
        if (!dialog.doModal()) {
            return null;
        }
        Set<Pair<String, String>> connections = dialog.getConnections();
        Edge newEdge = this.makeDiagramConnectionEdge(oldEdge, inNode, outNode, origin, connections);
        if (oldEdge != null) {
            newEdge.setPath(oldEdge.getPath());
            this.viewEditor.startTransaction("Remove");
            origin.remove(oldEdge.getName());
            this.viewEditor.completeTransaction();
        }
        return newEdge;
    }

    public Edge makeDiagramConnectionEdge(Edge oldEdge, @Nonnull Node inNode, @Nonnull Node outNode, Compartment origin, Set<Pair<String, String>> connections) throws Exception {
        if (connections == null || connections.size() == 0) {
            return null;
        }
        Edge newEdge = new Edge(origin, (Base)this.edgeStub, inNode, outNode);
        MultipleConnection role = this.directedConnection ? new MultipleDirectedConnection(newEdge) : new MultipleUndirectedConnection(newEdge);
        role.setInputPort(new Connection.Port(inNode));
        role.setOutputPort(new Connection.Port(outNode));
        StringBuffer title = new StringBuffer();
        for (Pair<String, String> pair : connections) {
            String intitle = this.getConnectionTitle(inNode, (String)pair.getFirst());
            String outtitle = this.getConnectionTitle(outNode, (String)pair.getSecond());
            if (title.length() != 0) {
                title.append(", ");
            }
            title.append(intitle);
            if (this.directedConnection) {
                DirectedConnection dc = new DirectedConnection(newEdge);
                dc.setInputPort(new Connection.Port((String)pair.getFirst(), intitle));
                dc.setOutputPort(new Connection.Port((String)pair.getSecond(), outtitle));
                role.addConnection(dc);
                continue;
            }
            UndirectedConnection udc = new UndirectedConnection(newEdge);
            udc.setInputPort(new Connection.Port((String)pair.getFirst(), intitle));
            udc.setOutputPort(new Connection.Port((String)pair.getSecond(), outtitle));
            role.addConnection(udc);
        }
        newEdge.setRole(role);
        newEdge.setTitle(title.toString());
        if (oldEdge != null) {
            newEdge.setPath(oldEdge.getPath());
        }
        return newEdge;
    }

    public Edge createConnection(Node inNode, Node outNode) {
        boolean valid = false;
        if (Util.isBus(inNode) && Util.isBus(outNode)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connection between buses is not allowed");
            return null;
        }
        if (Util.isDiagram(inNode) || Util.isDiagram(outNode)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connection between selected elements is not allowed");
            return null;
        }
        if (inNode.getKernel() instanceof Specie && !Util.isPort(outNode) || outNode.getKernel() instanceof Specie && !Util.isPort(inNode)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connection between selected elements is not allowed");
            return null;
        }
        if (!(!inNode.getParent().equals(outNode.getParent()) || Util.isBus(inNode) && Util.isPrivatePort(outNode) || Util.isBus(outNode) && Util.isPrivatePort(inNode))) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Connection between selected elements is not allowed");
            return null;
        }
        if (this.directedConnection && this.canBeInput(inNode) && this.canBeOutput(outNode)) {
            valid = true;
        } else if (!this.directedConnection && this.canBeContact(inNode) && this.canBeContact(outNode)) {
            valid = true;
        }
        if (!valid) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Can not create connection between " + inNode.getName() + " and " + outNode.getName());
            return null;
        }
        Edge edge = new Edge(this.edgeStub, inNode, outNode);
        Connection role = this.directedConnection ? new DirectedConnection(edge) : new UndirectedConnection(edge);
        role.setInputPort(new Connection.Port(ConnectionEdgePane.getPortVariableName(inNode), inNode.getTitle()));
        role.setOutputPort(new Connection.Port(ConnectionEdgePane.getPortVariableName(outNode), outNode.getTitle()));
        edge.setRole(role);
        return edge;
    }

    public static String getPortVariableName(Node node) {
        String name = node.getName();
        if (Util.isPort(node)) {
            if (node.getAttributes().getProperty("variableName") != null) {
                name = (String)node.getAttributes().getProperty("variableName").getValue();
            }
        } else if (node.getRole() instanceof VariableRole) {
            name = node.getRole(VariableRole.class).getName();
        }
        return name.replace("_port", "");
    }

    protected String getConnectionTitle(Node node, String name) {
        EModel model;
        Variable var;
        Diagram d;
        if (node instanceof SubDiagram) {
            node = ((SubDiagram)node).getDiagram();
        }
        if ((d = Diagram.getDiagram(node)).getRole() instanceof EModel && (var = (model = d.getRole(EModel.class)).getVariable(name)) instanceof VariableRole) {
            return ((VariableRole)var).getDiagramElement().getTitle();
        }
        return name;
    }

    public static Edge getEdgeIfAlreadyExists(Node inDiagram, Node outDiagram, Compartment origin, Class<?> connectionType) {
        for (Edge edge : origin.stream(Edge.class)) {
            Connection con;
            Role role = edge.getRole();
            if (!(role instanceof MultipleConnection) || !(con = (Connection)role).getInputPort().getVariableName().equals(inDiagram.getName()) || !con.getOutputPort().getVariableName().equals(outDiagram.getName()) || (!(role instanceof MultipleDirectedConnection) || !Stub.DirectedConnection.class.isAssignableFrom(connectionType)) && (!(role instanceof MultipleUndirectedConnection) || !Stub.UndirectedConnection.class.isAssignableFrom(connectionType))) continue;
            return edge;
        }
        return null;
    }

    public String[][] getExistedConnections(Edge edge) {
        if (edge == null) {
            return null;
        }
        String[][] existedConnections = new String[1][2];
        Role edgeRole = edge.getRole();
        int counter = 0;
        if (edgeRole instanceof MultipleConnection) {
            Connection[] dcList = ((MultipleConnection)edgeRole).getConnections();
            existedConnections = new String[dcList.length][2];
            for (Connection dc : dcList) {
                existedConnections[counter][0] = dc.getInputPort().getVariableName();
                existedConnections[counter][1] = dc.getOutputPort().getVariableName();
                ++counter;
            }
        }
        return existedConnections;
    }

    @Override
    public void release() {
        this.viewEditor.setSelectionEnabled(true);
        this.viewEditor.removeViewPaneListener((ViewPaneListener)this.adapter);
    }

    @Override
    public void okPressed() {
        this.createEdge();
        this.release();
    }

    @Override
    protected void cancelPressed() {
        this.release();
    }

    protected boolean canBeInput(Node node) {
        Base kernel = node.getKernel();
        if (kernel == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Node " + node.getName() + " has no kernel");
            return false;
        }
        if (kernel instanceof Stub.OutputConnectionPort || kernel instanceof Stub.Constant) {
            return true;
        }
        if (Util.isBus(node)) {
            for (Edge edge : node.getEdges()) {
                Role role = edge.getRole();
                if (!(role instanceof UndirectedConnection)) continue;
                JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Bus " + node.getName() + " already has undirected connections");
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean canBeOutput(Node node) {
        Base kernel = node.getKernel();
        if (kernel == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Node " + node.getName() + " has no kernel");
            return false;
        }
        if (kernel instanceof Stub.InputConnectionPort || Util.isBus(node)) {
            for (Edge edge : node.getEdges()) {
                Role role = edge.getRole();
                if (role instanceof UndirectedConnection) {
                    JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Bus " + node.getName() + " has undirected connections. No directed connections allowed");
                    return false;
                }
                if (!(role instanceof DirectedConnection) || !((Object)((Object)edge.getOutput())).equals((Object)node)) continue;
                JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Node " + node.getName() + "already has incoming directed conection");
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean canBeContact(Node node) {
        Base kernel = node.getKernel();
        if (kernel == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Node " + node.getName() + " has no kernel");
            return false;
        }
        if (kernel instanceof Stub.ContactConnectionPort) {
            return true;
        }
        if (kernel instanceof Specie) {
            return true;
        }
        if (Util.isBus(node)) {
            for (Edge edge : node.getEdges()) {
                if (!(edge.getRole() instanceof DirectedConnection)) continue;
                JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Bus " + node.getName() + " has directed connections. No undirected connections allowed");
                return false;
            }
            return true;
        }
        return false;
    }

    private class ParametersConnectionDialog
    extends OkCancelDialog {
        private JTable inTable;
        private JTable outTable;
        private final JTable connectionTable;
        private Node notDiagramNode;
        final /* synthetic */ ConnectionEdgePane this$0;

        /*
         * Exception decompiling
         */
        public ParametersConnectionDialog(ConnectionEdgePane var1_1, Component parent, String title, Node input, Node output, Edge edge) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Set<Pair<String, String>> getConnections() {
            HashSet<Pair<String, String>> connections = new HashSet<Pair<String, String>>();
            if (this.connectionTable != null && this.connectionTable.getRowCount() > 0) {
                for (int i = 0; i < this.connectionTable.getRowCount(); ++i) {
                    String left = this.connectionTable.getValueAt(i, 0).toString();
                    String right = this.connectionTable.getValueAt(i, 1).toString();
                    connections.add((Pair<String, String>)new Pair((Object)left, (Object)right));
                }
            }
            return connections;
        }

        private static /* synthetic */ Object[][] lambda$new$3(int x$0) {
            return new Object[x$0][];
        }

        private static /* synthetic */ Object[] lambda$new$2(Object p) {
            return new Object[]{p};
        }

        private static /* synthetic */ Object[][] lambda$new$1(int x$0) {
            return new Object[x$0][];
        }

        public class DeleteActionListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParametersConnectionDialog.this.connectionTable.getModel() != null && ParametersConnectionDialog.this.connectionTable.getModel().getRowCount() > 0 && ParametersConnectionDialog.this.connectionTable.getSelectedRow() != -1) {
                    int[] columnsNumbers = ParametersConnectionDialog.this.connectionTable.getSelectedRows();
                    Arrays.sort(columnsNumbers);
                    for (int i = columnsNumbers.length; i > 0; --i) {
                        int deleteIndex = columnsNumbers[i - 1];
                        ((DefaultTableModel)ParametersConnectionDialog.this.connectionTable.getModel()).removeRow(deleteIndex);
                    }
                }
            }
        }

        public class AddActionListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                int inRowIndex = -1;
                int outRowIndex = -1;
                Object[] newLine = new Object[2];
                if (ParametersConnectionDialog.this.inTable != null) {
                    inRowIndex = ParametersConnectionDialog.this.inTable.getSelectedRow();
                }
                if (ParametersConnectionDialog.this.outTable != null) {
                    outRowIndex = ParametersConnectionDialog.this.outTable.getSelectedRow();
                }
                if (inRowIndex != -1 && outRowIndex != -1) {
                    Object fromName = ParametersConnectionDialog.this.inTable.getModel().getValueAt(inRowIndex, 0);
                    Object toName = ParametersConnectionDialog.this.outTable.getModel().getValueAt(outRowIndex, 0);
                    newLine[0] = fromName;
                    newLine[1] = toName;
                } else if (inRowIndex != -1) {
                    Object fromName = ParametersConnectionDialog.this.inTable.getModel().getValueAt(inRowIndex, 0);
                    Object toName = "";
                    if (ParametersConnectionDialog.this.notDiagramNode != null && Util.isPort(ParametersConnectionDialog.this.notDiagramNode)) {
                        toName = ParametersConnectionDialog.this.notDiagramNode.getName();
                    } else if (ParametersConnectionDialog.this.notDiagramNode != null && Util.isPlot(ParametersConnectionDialog.this.notDiagramNode)) {
                        toName = fromName;
                    }
                    newLine[0] = fromName;
                    newLine[1] = toName;
                } else if (outRowIndex != -1) {
                    Object toName = ParametersConnectionDialog.this.outTable.getModel().getValueAt(outRowIndex, 0);
                    String fromName = "";
                    if (ParametersConnectionDialog.this.notDiagramNode != null) {
                        fromName = ParametersConnectionDialog.this.notDiagramNode.getName();
                    }
                    newLine[0] = fromName;
                    newLine[1] = toName;
                }
                if (newLine[0].toString().length() > 0 && newLine[1].toString().length() > 0) {
                    if (ParametersConnectionDialog.this.connectionTable.getModel().getRowCount() < 1) {
                        ((DefaultTableModel)ParametersConnectionDialog.this.connectionTable.getModel()).addRow(newLine);
                    } else if (ParametersConnectionDialog.this.connectionTable.getModel().getValueAt(0, 0) == null || ParametersConnectionDialog.this.connectionTable.getModel().getValueAt(0, 0).toString().length() < 1) {
                        ((DefaultTableModel)ParametersConnectionDialog.this.connectionTable.getModel()).setValueAt(newLine[0], 0, 0);
                        ((DefaultTableModel)ParametersConnectionDialog.this.connectionTable.getModel()).setValueAt(newLine[1], 0, 1);
                    } else {
                        ((DefaultTableModel)ParametersConnectionDialog.this.connectionTable.getModel()).addRow(newLine);
                    }
                }
            }
        }
    }
}

