/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.standard.diagram.BusProperties;
import biouml.standard.diagram.CreateEdgeDialog;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.SubDiagramProperties;
import biouml.standard.diagram.Util;
import biouml.standard.diagram.properties.ConstantElementProperties;
import biouml.standard.diagram.properties.SwitchElementProperties;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class CompositeSemanticController
extends PathwaySimulationSemanticController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point pt, ViewEditorPane viewEditor) {
        boolean isNotificationEnabled = parent.isNotificationEnabled();
        parent.setNotificationEnabled(false);
        try {
            Class typeClass;
            if (type instanceof Class && ((typeClass = (Class)type) == Stub.DirectedConnection.class || typeClass == Stub.UndirectedConnection.class)) {
                parent.setNotificationEnabled(true);
                CreateEdgeDialog dialog = CreateEdgeDialog.getConnectionDialog(Module.getModule((DataElement)parent), pt, viewEditor, typeClass, parent);
                dialog.setVisible(true);
                DiagramElementGroup diagramElementGroup = DiagramElementGroup.EMPTY_EG;
                return diagramElementGroup;
            }
            DiagramElementGroup diagramElementGroup = super.createInstance(parent, type, pt, viewEditor);
            return diagramElementGroup;
        }
        finally {
            parent.setNotificationEnabled(isNotificationEnabled);
        }
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment compartment, Object type, Point point, Object properties) {
        try {
            if (type.equals(Stub.ConnectionPort.class) && properties instanceof PortProperties) {
                PortProperties portProperties = (PortProperties)properties;
                return portProperties.createElements(compartment, point, null);
            }
            if (type.equals(SubDiagram.class) && properties instanceof SubDiagramProperties) {
                SubDiagramProperties subDiagramProperties = (SubDiagramProperties)properties;
                return subDiagramProperties.createElements(compartment, point, null);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "While creating instance of type " + type.toString(), e);
        }
        return super.createInstance(compartment, type, point, properties);
    }

    @Override
    public boolean canAccept(Compartment compartment, DiagramElement de) {
        if (compartment instanceof SubDiagram) {
            return false;
        }
        if (de instanceof Node && (Util.isBus(de) || Util.isPlot(de) || Util.isSwitch(de) || de instanceof SubDiagram)) {
            return true;
        }
        return super.canAccept(compartment, de);
    }

    @Override
    public boolean remove(DiagramElement de) throws Exception {
        Edge edge;
        if (de instanceof Diagram) {
            return false;
        }
        if (de instanceof SubDiagram) {
            for (Edge edge2 : CompositeSemanticController.getEdges((Node)de)) {
                edge2.getCompartment().remove(edge2.getName());
            }
            de.getOrigin().remove(de.getName());
            return true;
        }
        if (de instanceof Edge && ((edge = (Edge)de).getKernel().getType().equals("directed-edge") || edge.getKernel().getType().equals("undirected-edge"))) {
            if (Util.isModulePort(edge.getInput()) && Util.isPropagatedPort(edge.getOutput()) || Util.isModulePort(edge.getOutput()) && Util.isPropagatedPort(edge.getInput())) {
                return false;
            }
            edge.getOrigin().remove(edge.getName());
            return true;
        }
        if (Util.isModulePort(de)) {
            return false;
        }
        return super.remove(de);
    }

    @Override
    public Dimension move(DiagramElement de, Compartment newParent, Dimension offset, Rectangle oldBounds) throws Exception {
        if (Util.isModulePort(de)) {
            Compartment compartment = (Compartment)de.getOrigin();
            boolean keepOrientation = offset.width == 0 && offset.height == 0;
            CompositeSemanticController.movePortToEdge((Node)de, compartment, offset, keepOrientation);
            for (Edge edge : ((Node)de).getEdges()) {
                this.recalculateEdgePath(edge);
            }
            return offset;
        }
        if (de instanceof DiagramContainer) {
            Compartment compartment = (Compartment)de;
            Point location = compartment.getLocation();
            location.translate(offset.width, offset.height);
            boolean notification = compartment.isNotificationEnabled();
            compartment.setNotificationEnabled(false);
            compartment.setLocation(location);
            compartment.setNotificationEnabled(notification);
            for (Node node : compartment.getNodes()) {
                Point nodeLocation = node.getLocation();
                nodeLocation.translate(offset.width, offset.height);
                node.setLocation(nodeLocation);
            }
            for (Edge edge : CompositeSemanticController.getEdges(compartment)) {
                this.recalculateEdgePath(edge);
            }
            return offset;
        }
        return super.move(de, newParent, offset, oldBounds);
    }

    @Override
    public boolean isResizable(DiagramElement diagramElement) {
        if (diagramElement instanceof SubDiagram || diagramElement instanceof Node && Util.isAverager(diagramElement)) {
            return true;
        }
        return super.isResizable(diagramElement);
    }

    public static Dimension movePortToEdge(Node node, Compartment compartment, Dimension offset, boolean keepOrientation) {
        Point oldLocation = node.getLocation();
        Point newLocation = new Point(oldLocation);
        newLocation.translate(offset.width, offset.height);
        CompositeSemanticController.movePortToEdge(node, compartment, newLocation, keepOrientation);
        node.setLocation(newLocation);
        return new Dimension(oldLocation.x - newLocation.x, oldLocation.y - newLocation.y);
    }

    public static void movePortToEdge(Node node, Compartment compartment, Point location, boolean keepOrientation) {
        Rectangle domain = new Rectangle(compartment instanceof Diagram ? new Point(0, 0) : compartment.getLocation(), compartment.getShapeSize());
        CompositeSemanticController.movePortToEdge(node, domain, location, keepOrientation);
    }

    public static void movePortToEdge(Node node, Rectangle domain, Point location, boolean keepOrientation) {
        Dimension nodeSize = node.getView() == null ? node.getShapeSize() : node.getView().getBounds().getSize();
        SubDiagram.PortOrientation orientation = Util.getPortOrientation(node);
        if (!keepOrientation) {
            double leftDistance = location.x - domain.x;
            double rightDistance = domain.x + domain.width - (location.x + nodeSize.width);
            double topDistance = location.y - domain.y;
            double bottomDistance = domain.y + domain.height - (location.y + nodeSize.height);
            double distance = Double.MAX_VALUE;
            if (leftDistance < distance) {
                distance = leftDistance;
                orientation = SubDiagram.PortOrientation.LEFT;
            }
            if (rightDistance < distance) {
                distance = rightDistance;
                orientation = SubDiagram.PortOrientation.RIGHT;
            }
            if (topDistance < distance) {
                distance = topDistance;
                orientation = SubDiagram.PortOrientation.TOP;
            }
            if (bottomDistance < distance) {
                orientation = SubDiagram.PortOrientation.BOTTOM;
            }
            if (!orientation.equals((Object)Util.getPortOrientation(node))) {
                node.getAttributes().setValue("orientation", (Object)orientation);
                Diagram diagram = Diagram.getDiagram(node);
                DiagramViewOptions viewOptions = diagram.getViewOptions();
                DiagramViewBuilder viewBuilder = diagram.getType().getDiagramViewBuilder();
                CompositeView view = viewBuilder.createNodeView(node, viewOptions, ApplicationUtils.getGraphics());
                nodeSize = view.getBounds().getSize();
            }
        }
        switch (orientation) {
            case TOP: {
                location.y = domain.y;
                location.x = Math.min(Math.max(domain.x, location.x), domain.x + domain.width - nodeSize.width);
                break;
            }
            case RIGHT: {
                location.x = domain.x + domain.width - nodeSize.width;
                location.y = Math.min(Math.max(domain.y, location.y), domain.y + domain.height - nodeSize.height);
                break;
            }
            case BOTTOM: {
                location.y = domain.y + domain.height - nodeSize.height;
                location.x = Math.min(Math.max(domain.x, location.x), domain.x + domain.width - nodeSize.width);
                break;
            }
            case LEFT: {
                location.x = domain.x;
                location.y = Math.min(Math.max(domain.y, location.y), domain.y + domain.height - nodeSize.height);
            }
        }
    }

    public static List<Edge> getEdges(Node node) {
        return ((StreamEx)node.recursiveStream().select(Node.class).filter(n -> Util.isPort(n) || n instanceof Compartment)).flatMap(Node::edges).toList();
    }

    @Override
    public Object getPropertiesByType(Compartment compartment, Object type, Point point) {
        if (type.equals(Stub.Bus.class.getName()) || type instanceof Class && Stub.Bus.class.isAssignableFrom((Class)type)) {
            String name = CompositeSemanticController.generateUniqueNodeName(compartment, "bus");
            return new BusProperties((EModel)Diagram.getDiagram(compartment).getRole(), name);
        }
        if (type instanceof Class && SubDiagram.class.isAssignableFrom((Class)type) || type.equals(SubDiagram.class.getName())) {
            return new SubDiagramProperties(Diagram.getDiagram(compartment));
        }
        if (type.equals(Stub.SwitchElement.class.getName()) || type.equals(Stub.SwitchElement.class)) {
            return new SwitchElementProperties(CompositeSemanticController.generateUniqueNodeName(Diagram.getDiagram(compartment), "Switcher"));
        }
        if (type.equals(Stub.Constant.class.getName()) || type.equals(Stub.Constant.class)) {
            return new ConstantElementProperties(CompositeSemanticController.generateUniqueNodeName(Diagram.getDiagram(compartment), "Constant"));
        }
        return super.getPropertiesByType(compartment, type, point);
    }
}

