/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.standard.diagram.CompositeDiagramType;
import biouml.standard.diagram.CompositeModelUtility;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.TabularPropertiesEditor;
import ru.biosoft.table.ColumnModel;
import ru.biosoft.table.StandardTableDataCollection;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;
import ru.biosoft.table.datatype.DataType;

public class CompositeReactionsEditor
extends TabularPropertiesEditor
implements PropertyChangeListener {
    protected FindConnectedReactionsAction findConnectedReactionsAction;

    public boolean canExplore(Object model) {
        if (model instanceof Diagram) {
            return ((Diagram)((Object)model)).getType() instanceof CompositeDiagramType;
        }
        return false;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        try {
            TableDataCollection table = this.getRowModel();
            this.explore(table.iterator());
            this.getTable().setAutoResizeMode(4);
        }
        catch (Exception e) {
            this.explore(null);
        }
    }

    protected TableDataCollection getRowModel() throws Exception {
        Diagram compositeDiagram = (Diagram)((Object)this.model);
        HashSet<HashSet<Node>> reactions = CompositeModelUtility.getConnectedReactions(compositeDiagram);
        StandardTableDataCollection reactionCollection = new StandardTableDataCollection(null, "");
        ColumnModel columns = reactionCollection.getColumnModel();
        compositeDiagram.stream(SubDiagram.class).map(MutableDataElementSupport::getName).forEach(name -> columns.addColumn(name, DataType.BooleanType.class));
        int columnCount = columns.getColumnCount();
        for (HashSet<Node> reactionSet : reactions) {
            String key = null;
            Object[] row = new Boolean[columnCount];
            block1: for (int i = 0; i < columnCount; ++i) {
                row[i] = null;
                for (Node reaction : reactionSet) {
                    if (key == null) {
                        key = reaction.getName();
                    }
                    if (!Diagram.getDiagram(reaction).getName().equals(columns.getColumn(i).getName())) continue;
                    row[i] = false;
                    continue block1;
                }
            }
            TableDataCollectionUtils.addRow((TableDataCollection)reactionCollection, key, (Object[])row);
        }
        return reactionCollection;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public Action[] getActions() {
        ActionManager actionManager = Application.getActionManager();
        if (this.findConnectedReactionsAction == null) {
            this.findConnectedReactionsAction = new FindConnectedReactionsAction();
            actionManager.addAction("Refresh parameters", (Action)this.findConnectedReactionsAction);
            this.findConnectedReactionsAction.setEnabled(true);
        }
        return new Action[]{this.findConnectedReactionsAction};
    }

    public class FindConnectedReactionsAction
    extends AbstractAction {
        public static final String KEY = "Refresh parameters";

        public FindConnectedReactionsAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompositeReactionsEditor.this.explore(CompositeReactionsEditor.this.model, CompositeReactionsEditor.this.document);
        }
    }
}

