/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.Referrer;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;

public class CompositeModelUtility {
    private static HashMap<Variable, HashSet<Variable>> generateConnectedMap(Diagram compositeDiagram) {
        HashMap<Variable, HashSet<Variable>> result = new HashMap<Variable, HashSet<Variable>>();
        Iterator<DiagramElement> iterator = compositeDiagram.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            Role role = de.getRole();
            if (!(de instanceof Edge) || !(role instanceof Connection)) continue;
            if (role instanceof MultipleConnection) {
                for (Connection connection : ((MultipleConnection)role).getConnections()) {
                    CompositeModelUtility.readConnection(connection, result);
                }
                continue;
            }
            CompositeModelUtility.readConnection((Connection)role, result);
        }
        return result;
    }

    private static void readConnection(Connection con, HashMap<Variable, HashSet<Variable>> connectionMap) {
        Edge edge = (Edge)con.getDiagramElement();
        Diagram inputDiagram = CompositeModelUtility.getDiagram(edge.getInput());
        Diagram outputDiagram = CompositeModelUtility.getDiagram(edge.getOutput());
        Variable inputVar = inputDiagram.getRole(EModel.class).getVariable(con.getInputPort().getVariableName());
        Variable outputVar = outputDiagram.getRole(EModel.class).getVariable(con.getOutputPort().getVariableName());
        if (inputVar instanceof VariableRole && outputVar instanceof VariableRole) {
            Node inputNode = (Node)((VariableRole)inputVar).getDiagramElement();
            Variable oldKey = null;
            HashSet<Variable> newVariables = new HashSet<Variable>();
            for (Map.Entry<Variable, HashSet<Variable>> entry : connectionMap.entrySet()) {
                HashSet<Variable> variables = entry.getValue();
                if (!variables.contains((Object)inputVar) && !variables.contains((Object)outputVar)) continue;
                newVariables.addAll(variables);
                oldKey = entry.getKey();
                break;
            }
            newVariables.add(inputVar);
            newVariables.add(outputVar);
            if (oldKey != null) {
                connectionMap.remove((Object)oldKey);
            }
            Variable newKey = Util.isBus(inputNode) ? outputVar : inputVar;
            connectionMap.put(newKey, newVariables);
        }
    }

    public static HashSet<HashSet<Node>> getConnectedReactions(Diagram compositeDiagram) throws Exception {
        HashSet<HashSet<Node>> connectedReactions = new HashSet<HashSet<Node>>();
        HashMap<Variable, HashSet<Variable>> connectionMap = CompositeModelUtility.generateConnectedMap(compositeDiagram);
        HashSet checkedDiagrams = new HashSet();
        HashMap<Diagram, Set<Node>> diagramReactions = new HashMap<Diagram, Set<Node>>();
        for (SubDiagram subDiagram : CompositeModelUtility.getSubDiagrams2(compositeDiagram)) {
            diagramReactions.put(subDiagram.getDiagram(), CompositeModelUtility.getReactions(subDiagram));
        }
        for (Map.Entry entry : diagramReactions.entrySet()) {
            checkedDiagrams.add(entry.getKey());
            for (Node reaction1 : (Set)entry.getValue()) {
                for (Map.Entry entry2 : diagramReactions.entrySet()) {
                    if (checkedDiagrams.contains(entry2.getKey())) continue;
                    for (Node reaction2 : (Set)entry2.getValue()) {
                        if (!CompositeModelUtility.isConnected(reaction1, reaction2, connectionMap)) continue;
                        HashSet reactions = StreamEx.of(connectedReactions).findFirst(set -> set.contains((Object)reaction1) || set.contains((Object)reaction2)).orElseGet(() -> {
                            HashSet set = new HashSet();
                            connectedReactions.add(set);
                            return set;
                        });
                        reactions.add(reaction1);
                        reactions.add(reaction2);
                    }
                }
            }
        }
        return connectedReactions;
    }

    private static boolean isConnected(Node reactionNode1, Node reactionNode2, HashMap<Variable, HashSet<Variable>> connectionMap) throws Exception {
        SpecieReference[] refs2;
        Reaction reaction1 = (Reaction)reactionNode1.getKernel();
        Reaction reaction2 = (Reaction)reactionNode2.getKernel();
        Diagram d1 = CompositeModelUtility.getDiagram(reactionNode1);
        Diagram d2 = CompositeModelUtility.getDiagram(reactionNode2);
        SpecieReference[] refs1 = reaction1.getSpecieReferences();
        if (refs1.length != (refs2 = reaction2.getSpecieReferences()).length) {
            return false;
        }
        for (SpecieReference reference1 : refs1) {
            VariableRole var1 = reference1.getSpecieVariableRole(d1);
            boolean isConnected = false;
            for (SpecieReference reference2 : refs2) {
                VariableRole var2 = reference2.getSpecieVariableRole(d2);
                boolean bl = isConnected = reference1.getType().equals(reference2.getType()) && CompositeModelUtility.isConnected(var1, var2, connectionMap);
                if (isConnected) break;
            }
            if (isConnected) continue;
            return false;
        }
        return true;
    }

    private static boolean isConnected(Variable var1, Variable var2, HashMap<Variable, HashSet<Variable>> connectionMap) {
        for (HashSet<Variable> variables : connectionMap.values()) {
            if (!variables.contains((Object)var1) || !variables.contains((Object)var2)) continue;
            return true;
        }
        return false;
    }

    private static SubDiagram[] getSubDiagrams2(Diagram compositeDiagram) {
        return (SubDiagram[])compositeDiagram.stream(SubDiagram.class).toArray(SubDiagram[]::new);
    }

    private static Set<Node> getReactions(Compartment compartment) {
        return ((StreamEx)compartment.recursiveStream().select(Node.class).filter(node -> node.getKernel() instanceof Reaction)).toSet();
    }

    public static Base cloneKernel(Base kernel, DataCollection<?> newCollection, String newName) {
        Base result = null;
        try {
            result = (Base)kernel.getClass().getConstructor(DataCollection.class, String.class, String.class).newInstance(newCollection, newName, kernel.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = (Base)kernel.getClass().getConstructor(DataCollection.class, String.class).newInstance(newCollection, newName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            return kernel;
        }
        for (DynamicProperty dp : kernel.getAttributes()) {
            result.getAttributes().add(dp);
        }
        if (result instanceof Referrer) {
            ((Referrer)result).setDatabaseReferences(((Referrer)kernel).getDatabaseReferences());
            ((Referrer)result).setLiteratureReferences(((Referrer)kernel).getLiteratureReferences());
            ((Referrer)result).setComment(((Referrer)kernel).getComment());
        }
        return result;
    }

    public static void replaceNode(Node toReplace, Node replacement) throws Exception {
        Compartment parent = toReplace.getCompartment();
        for (Edge edge : Util.getEdges(toReplace)) {
            if (((Object)((Object)edge.getInput())).equals((Object)toReplace)) {
                toReplace.removeEdge(edge);
                replacement.addEdge(edge);
                edge.setInput(replacement);
            }
            if (!((Object)((Object)edge.getOutput())).equals((Object)toReplace)) continue;
            toReplace.removeEdge(edge);
            replacement.addEdge(edge);
            edge.setOutput(replacement);
        }
        parent.remove(toReplace.getName());
        parent.put(replacement);
    }

    public static void replaceSubDiagram(SubDiagram toReplace, SubDiagram replacement) throws Exception {
        Diagram parent = Diagram.getDiagram(toReplace);
        boolean in = false;
        for (Edge edge : Util.getEdges(toReplace)) {
            Connection.Port port;
            String varName;
            Node newPort;
            String portName;
            if (((Object)((Object)edge.getInput())).equals((Object)toReplace)) {
                in = true;
                edge.setInput(replacement);
                replacement.addEdge(edge);
            } else if (((Object)((Object)edge.getOutput())).equals((Object)toReplace)) {
                edge.setOutput(replacement);
                replacement.addEdge(edge);
            } else if (edge.getInput().getParent().equals((Object)toReplace)) {
                in = true;
                portName = edge.getInput().getName();
                newPort = replacement.findNode(portName);
                edge.setInput(newPort);
                newPort.addEdge(edge);
            } else if (edge.getOutput().getParent().equals((Object)toReplace)) {
                portName = edge.getOutput().getName();
                newPort = replacement.findNode(portName);
                edge.setOutput(newPort);
                newPort.addEdge(edge);
            }
            if (!(edge.getRole() instanceof Connection)) continue;
            Connection connection = edge.getRole(Connection.class);
            if (in) {
                varName = Util.getPortVariable(edge.getInput());
                port = connection.getInputPort();
            } else {
                varName = Util.getPortVariable(edge.getOutput());
                port = connection.getOutputPort();
            }
            port.setVariableName(varName);
            port.setVariableTitle(varName);
        }
        boolean notif = parent.isNotificationEnabled();
        parent.setNotificationEnabled(false);
        parent.remove(toReplace.getName());
        replacement.save();
        parent.setNotificationEnabled(notif);
    }

    public static Diagram getDiagram(Node node) {
        if (Util.isPort(node) && node.getParent() instanceof SubDiagram) {
            return ((SubDiagram)node.getParent()).getDiagram();
        }
        if (node instanceof SubDiagram) {
            return ((SubDiagram)node).getDiagram();
        }
        return Diagram.getDiagram(node);
    }

    public static void createView(Node node) {
        if (node.getView() != null) {
            return;
        }
        Diagram diagram = Diagram.getDiagram(node);
        DiagramViewBuilder diagramViewBuilder = diagram.getType().getDiagramViewBuilder();
        Graphics2D g = ApplicationUtils.getGraphics();
        CompositeView view = node instanceof Diagram ? diagramViewBuilder.createDiagramView((Diagram)node, g) : (node instanceof Compartment ? diagramViewBuilder.createCompartmentView((Compartment)node, diagram.getViewOptions(), g) : diagramViewBuilder.createNodeView(node, diagram.getViewOptions(), g));
        node.setView((View)view);
    }

    public static Edge clone(Edge oldEdge, Compartment newParent, Base newKernel, Node newInput, Node newOutput) {
        Edge edge = new Edge(newParent, newKernel, newInput, newOutput);
        Role role = oldEdge.getRole();
        if (role != null) {
            edge.setRole(role.clone(edge));
        }
        CompositeModelUtility.copyAttributes(oldEdge, edge);
        return edge;
    }

    public static void copyAttributes(DiagramElement from, DiagramElement to) {
        for (DynamicProperty dp : from.getAttributes()) {
            try {
                to.getAttributes().add(DynamicPropertySetSupport.cloneProperty((DynamicProperty)dp));
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isFreePort(Node node) {
        for (Edge e : node.getEdges()) {
            if (!Util.isDirectedConnection(e) && !Util.isUndirectedConnection(e)) continue;
            return false;
        }
        return true;
    }

    public static HashMap<Node, Point> generateShiftMap(Diagram compositeDiagram) {
        HashMap<Node, Point> newLocations = new HashMap<Node, Point>();
        Node[] nodes = compositeDiagram.getNodes();
        NodeComparator xComparator = new NodeComparator(true);
        Arrays.sort(nodes, xComparator);
        for (int i = 0; i < nodes.length - 1; ++i) {
            Node subDiagram = nodes[i];
            if (!(subDiagram instanceof SubDiagram)) continue;
            Diagram innerDiagram = ((SubDiagram)subDiagram).getDiagram();
            CompositeModelUtility.createView(subDiagram);
            CompositeModelUtility.createView(innerDiagram);
            Rectangle moduleRec = subDiagram.getView().getBounds();
            int moduleWidth = moduleRec.width;
            Rectangle diagramRec = new Rectangle(innerDiagram.getView().getBounds());
            int diagramWidth = diagramRec.width;
            diagramRec.setLocation(moduleRec.getLocation());
            for (int j = i + 1; j < nodes.length; ++j) {
                Point newLocation;
                Node node = nodes[j];
                Rectangle nodeRec = node.getView().getBounds();
                Point location = nodeRec.getLocation();
                if (nodeRec.y > moduleRec.y + moduleRec.height) continue;
                if (node instanceof SubDiagram) {
                    node = ((SubDiagram)node).getDiagram();
                }
                Point point = newLocation = newLocations.containsKey((Object)node) ? newLocations.get((Object)node) : location;
                if (diagramRec.intersects(nodeRec)) {
                    newLocation.translate(diagramWidth - moduleWidth, 0);
                }
                newLocations.put(node, newLocation);
            }
        }
        NodeComparator yComparator = new NodeComparator(false);
        Arrays.sort(nodes, yComparator);
        for (int i = 0; i < nodes.length - 1; ++i) {
            Node subDiagram = nodes[i];
            if (!(subDiagram instanceof SubDiagram)) continue;
            Diagram innerDiagram = ((SubDiagram)subDiagram).getDiagram();
            CompositeModelUtility.createView(subDiagram);
            CompositeModelUtility.createView(innerDiagram);
            Rectangle diagramRec = new Rectangle(innerDiagram.getView().getBounds());
            Rectangle moduleRec = subDiagram.getView().getBounds();
            int moduleHeight = moduleRec.height;
            diagramRec.setLocation(moduleRec.getLocation());
            int diagramHeight = diagramRec.height;
            for (int j = i + 1; j < nodes.length; ++j) {
                Node node = nodes[j];
                Rectangle nodeRec = new Rectangle(node.getView().getBounds());
                Point location = nodeRec.getLocation();
                if (nodeRec.x > moduleRec.x + moduleRec.width) continue;
                CompositeModelUtility.createView(node);
                if (node instanceof SubDiagram) {
                    node = ((SubDiagram)node).getDiagram();
                }
                Point newLocation = newLocations.containsKey((Object)node) ? newLocations.get((Object)node) : location;
                nodeRec.setLocation(newLocation);
                if (diagramRec.intersects(nodeRec)) {
                    newLocation.translate(0, diagramHeight - moduleHeight);
                }
                if (node instanceof SubDiagram) {
                    node = ((SubDiagram)node).getDiagram();
                }
                newLocations.put(node, newLocation);
            }
        }
        for (Node node : nodes) {
            Diagram d;
            if (!(node instanceof SubDiagram) || newLocations.containsKey((Object)(d = ((SubDiagram)node).getDiagram()))) continue;
            newLocations.put(d, node.getLocation());
        }
        return newLocations;
    }

    public static Set<ConnectionChain> findUndirectedConnections(Diagram diagram) {
        HashSet<ConnectionChain> result = new HashSet<ConnectionChain>();
        HashSet processed = new HashSet();
        for (Node port : (StreamEx)diagram.recursiveStream().select(Node.class).filter(de -> Util.isPort(de))) {
            if (processed.contains((Object)port)) continue;
            ConnectionChain chain = new ConnectionChain();
            CompositeModelUtility.findUndirectedConnections(port, chain);
            result.add(chain);
            processed.addAll(chain.nodes);
        }
        return result;
    }

    public static void findUndirectedConnections(Node node, ConnectionChain chain) {
        if (Util.isPort(node)) {
            chain.nodes.add(node);
            for (Edge e : (StreamEx)node.edges().filter(edge -> Util.isUndirectedConnection(edge) && edge.getRole() != null)) {
                UndirectedConnection connection = e.getRole(UndirectedConnection.class);
                if (!connection.getMainVariableType().equals((Object)UndirectedConnection.MainVariableType.NOT_SELECTED)) {
                    chain.mainNode = connection.getMainVariableType().equals((Object)UndirectedConnection.MainVariableType.INPUT) ? e.getInput() : e.getOutput();
                }
                Node otherEnd = e.getOtherEnd(node);
                if (chain.nodes.contains((Object)otherEnd)) continue;
                CompositeModelUtility.findUndirectedConnections(otherEnd, chain);
            }
        }
    }

    public static Variable getPropagatedVariable(Node node) throws Exception {
        if (node.getParent() instanceof SubDiagram) {
            node = CompositeModelUtility.getInnerPort(node);
        }
        while (Util.isPropagatedPort(node)) {
            node = CompositeModelUtility.getInnerPort(Util.getBasePort(node));
        }
        Diagram diagram = Diagram.getDiagram(node);
        EModel emodel = diagram.getRole(EModel.class);
        String varName = Util.getPortVariable(node);
        return emodel.getVariable(varName);
    }

    public static Node getInnerPort(Node node) {
        return ((SubDiagram)node.getParent()).getDiagram().findNode(node.getName());
    }

    public static class ConnectionChain {
        private final Set<Node> nodes = new HashSet<Node>();
        private Node mainNode = null;

        public Node getMainNode() {
            return this.mainNode;
        }

        public Set<Node> getNodes() {
            return this.nodes;
        }
    }

    public static class NodeComparator
    implements Comparator<Node> {
        boolean xComparator;

        protected NodeComparator(boolean xComparator) {
            this.xComparator = xComparator;
        }

        @Override
        public int compare(Node n1, Node n2) {
            int v2;
            int v1;
            if (this.xComparator) {
                v1 = n1.getLocation().x;
                v2 = n2.getLocation().x;
            } else {
                v1 = n1.getLocation().y;
                v2 = n2.getLocation().y;
            }
            return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
        }
    }
}

