/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.diagram.CompositeDiagramType;
import biouml.standard.diagram.CompositeModelUtility;
import biouml.standard.diagram.CreatorElementWithName;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.diagram.ReactionInitialProperties;
import biouml.standard.diagram.Util;
import biouml.standard.state.State;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Reaction;
import biouml.standard.type.Referrer;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.exception.InternalException;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.UndeclaredFunction;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.util.Pair;

public class CompositeModelPreprocessor
extends Preprocessor {
    public static String VAR_PATH_DELIMITER = "/";
    public static final int AUTO_DETECT = 0;
    public static final int SBML_STYLE = 1;
    public static final int BIOUML_STYLE = 2;
    private boolean layout = false;
    private int nameStyle = 0;
    private Set<Node> processedEquations;
    private Map<String, String> varPathMapping = new HashMap<String, String>();
    private HashMap<Pair<String, String>, String> substitutionMap;
    private HashMap<Pair<String, String>, String> functionSubstitutionMap;
    private HashMap<Pair<String, Diagram>, String> oldVariablesToNew;
    private HashMap<String, String> conversionFactors;
    private HashMap<Node, Node> oldNodesToNew;
    private HashMap<String, AstStart> dConnected;
    private HashMap<Node, Point> subDiagramShift;
    private HashMap<String, Set<String>> uConnected;
    private HashMap<String, Variable> uConnectedInfo;
    private HashMap<String, Node> newVarsToOldNodes;
    private HashMap<String, Variable> newVarsToOld;
    private HashMap<String, String> variablesInfo;
    private Diagram compositeDiagram;
    private Diagram diagram;
    private EModel eModel;
    private DiagramType type;
    protected boolean asSubDiagram = false;
    HashSet<String> variableIDS;

    public void setNameStyle(int style) {
        this.nameStyle = style;
    }

    public String getNewFunctionName(String oldName, String subDiagramName) {
        return this.functionSubstitutionMap.get(new Pair((Object)oldName, (Object)subDiagramName));
    }

    public String getNewVariableName(String oldName, String subDiagramName) {
        return this.substitutionMap.get(new Pair((Object)oldName, (Object)subDiagramName));
    }

    public Map<String, Map<String, String>> getCodeVariableNames() {
        if (this.substitutionMap != null) {
            HashMap<String, Map<String, String>> codeVariableNames = new HashMap<String, Map<String, String>>();
            for (Map.Entry<Pair<String, String>, String> entry : this.substitutionMap.entrySet()) {
                String key = (String)entry.getKey().getSecond();
                codeVariableNames.computeIfAbsent(key, k -> new HashMap()).put(entry.getKey().getFirst(), entry.getValue());
            }
            return codeVariableNames;
        }
        return null;
    }

    public Map<String, String> getVarPathToOldPath() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Pair<String, String>, String> e : this.substitutionMap.entrySet()) {
            String newName = e.getValue();
            String oldPath = (String)e.getKey().getSecond() + "\\" + (String)e.getKey().getFirst();
            result.put(newName, oldPath);
        }
        return result;
    }

    private String getUniqueVariableName(Diagram parent, String oldName) {
        return this.oldVariablesToNew.get(new Pair((Object)oldName, (Object)parent));
    }

    public Diagram preprocess(Diagram compositeDiagram, DataCollection<?> origin) throws Exception {
        return this.preprocess(compositeDiagram, origin, null);
    }

    public Diagram preprocess(Diagram compositeDiagram) throws Exception {
        return this.preprocess(compositeDiagram, null);
    }

    public Diagram preprocess(Diagram inputDiagram, DataCollection<?> origin, String newName) throws Exception {
        if (!this.accept(inputDiagram)) {
            return inputDiagram;
        }
        if (!DiagramUtility.isComposite(inputDiagram)) {
            return this.asSubDiagram ? inputDiagram : inputDiagram.clone(origin, inputDiagram.getName());
        }
        Diagram diagram = this.compositeDiagram = this.asSubDiagram ? inputDiagram : inputDiagram.clone(origin, inputDiagram.getName());
        if (this.nameStyle == 0) {
            this.nameStyle = inputDiagram.getType().getClass().getName().endsWith("SbgnCompositeDiagramType") || inputDiagram.getType().getClass().getName().endsWith("SbmlCompositeDiagramType") ? 1 : 2;
        }
        this.compositeDiagram.getRole(EModel.class).setAutodetectTypes(false);
        long time = System.currentTimeMillis();
        this.log.info("Preprocessing diagram " + this.compositeDiagram.getName());
        this.init(this.compositeDiagram, origin, newName);
        this.diagram.setNotificationEnabled(false);
        boolean cdNotif = this.compositeDiagram.isNotificationEnabled();
        this.compositeDiagram.setNotificationEnabled(false);
        DiagramUtility.processBuses(this.compositeDiagram);
        this.processCompositeSubDiagrams(this.compositeDiagram);
        CompositeModelPreprocessor.processSwitches(this.compositeDiagram);
        if (this.layout) {
            CompositeModelUtility.createView(this.compositeDiagram);
            this.subDiagramShift = CompositeModelUtility.generateShiftMap(this.compositeDiagram);
        }
        this.readVariableRoles(this.compositeDiagram);
        this.readVariables(this.compositeDiagram);
        this.readConnections(this.compositeDiagram);
        this.processVariables(this.compositeDiagram, this.diagram);
        this.processVariableRoles(this.compositeDiagram, this.diagram, true);
        this.processVariableRoles(this.compositeDiagram, this.diagram, false);
        this.readFunctions(this.compositeDiagram, this.diagram);
        this.processRateEquations(this.compositeDiagram);
        this.readNodes(this.compositeDiagram, this.diagram);
        this.readClones(this.compositeDiagram, this.diagram);
        this.readReactions(this.compositeDiagram);
        this.readEdges(this.compositeDiagram);
        this.readPorts(this.compositeDiagram, this.diagram);
        for (String varName : this.eModel.getParameters().stream().map(v -> v.getName()).filter(n -> this.dConnected.containsKey(n)).collect(Collectors.toList())) {
            this.eModel.getVariables().remove(varName);
        }
        this.processConstants(this.compositeDiagram);
        this.log.info("Done in " + (System.currentTimeMillis() - time) + " mseconds");
        DynamicProperty dp = this.compositeDiagram.getAttributes().getProperty("Plots");
        if (dp != null) {
            this.diagram.getAttributes().add(new DynamicProperty(dp.getName(), dp.getType(), dp.getValue()));
        }
        this.compositeDiagram.getRole(EModel.class).setAutodetectTypes(true);
        this.compositeDiagram.setNotificationEnabled(cdNotif);
        this.diagram.setNotificationEnabled(true);
        return this.diagram;
    }

    private void processVariables(Diagram compositeDiagram, Diagram diagram) {
        EModel emodel = diagram.getRole(EModel.class);
        for (Diagram dgr : SubDiagram.diagrams(compositeDiagram)) {
            boolean notif = dgr.isNotificationEnabled();
            dgr.setNotificationEnabled(false);
            for (Variable var : dgr.getRole(EModel.class).getVariables()) {
                SubDiagram subDiagram;
                Diagram diagramKey;
                String uniqueName;
                if (var instanceof VariableRole || var.getName().startsWith("$$") || this.dConnected.containsKey(uniqueName = this.getUniqueVariableName(diagramKey = (subDiagram = SubDiagram.getParentSubDiagram(dgr)) != null ? subDiagram.getDiagram() : compositeDiagram, var.getName()))) continue;
                String masterVariable = this.getMasterVariable(uniqueName);
                if (masterVariable.equals(uniqueName)) {
                    Variable realVar = this.uConnectedInfo.get(uniqueName);
                    if (realVar != null) {
                        emodel.put(realVar.clone(uniqueName));
                    } else {
                        emodel.put(var.clone(uniqueName));
                    }
                }
                String key = subDiagram != null ? subDiagram.getCompleteNameInDiagram() : "";
                this.substitutionMap.put((Pair<String, String>)new Pair((Object)var.getName(), (Object)key), uniqueName);
            }
            dgr.setNotificationEnabled(notif);
        }
    }

    private static DiagramType defineType(Diagram diagram) {
        DiagramType type = diagram.getType();
        List<SubDiagram> subDiagrams = Util.getSubDiagrams(diagram);
        for (SubDiagram subDiagram : subDiagrams) {
            DiagramType innerType = subDiagram.getDiagram().getType();
            if (innerType instanceof CompositeDiagramType) continue;
            return innerType;
        }
        return type;
    }

    private Diagram init(Diagram compositeDiagram, DataCollection<?> origin, String newName) throws Exception {
        this.type = CompositeModelPreprocessor.defineType(compositeDiagram);
        this.conversionFactors = new HashMap();
        this.variableIDS = new HashSet();
        this.dConnected = new HashMap();
        this.uConnected = new HashMap();
        this.uConnectedInfo = new HashMap();
        this.newVarsToOld = new HashMap();
        this.oldVariablesToNew = new HashMap();
        this.oldNodesToNew = new HashMap();
        this.functionSubstitutionMap = new HashMap();
        this.substitutionMap = new HashMap();
        this.varPathMapping = new HashMap<String, String>();
        this.variablesInfo = new HashMap();
        this.newVarsToOldNodes = new HashMap();
        this.processedEquations = new HashSet<Node>();
        if (newName == null) {
            newName = compositeDiagram.getName() + "_plain";
        }
        this.diagram = this.type.createDiagram(origin, newName, null);
        this.eModel = this.diagram.getRole(EModel.class);
        return this.diagram;
    }

    private void readVariables(Diagram compositeDiagram) throws Exception {
        for (Diagram dgr : SubDiagram.diagrams(compositeDiagram)) {
            for (Variable var : dgr.getRole(EModel.class).getVariables()) {
                if (var instanceof VariableRole) continue;
                String oldVarName = var.getName();
                String newVarName = this.generateUniqueVariableName(oldVarName, dgr);
                this.oldVariablesToNew.put((Pair<String, Diagram>)new Pair((Object)oldVarName, (Object)dgr), newVarName);
                this.newVarsToOld.put(newVarName, var);
            }
        }
    }

    private void readFunctions(Diagram compositeDiagram, Diagram diagram) {
        String key;
        SubDiagram subDiagram;
        String functionName;
        EModel newEmodel = diagram.getRole(EModel.class);
        HashSet<String> newFunctions = new HashSet<String>();
        for (Diagram dgr : SubDiagram.diagrams(compositeDiagram)) {
            for (Function f : dgr.getRole(EModel.class).getFunctions()) {
                functionName = f.getName();
                subDiagram = SubDiagram.getParentSubDiagram(dgr);
                key = subDiagram != null ? subDiagram.getCompleteNameInDiagram() : "";
                String newFunctionName = CompositeModelPreprocessor.generateUniqueFunctionName(functionName, subDiagram, false, newFunctions);
                newFunctions.add(newFunctionName);
                this.functionSubstitutionMap.put((Pair<String, String>)new Pair((Object)functionName, (Object)key), newFunctionName);
            }
        }
        for (Diagram dgr : SubDiagram.diagrams(compositeDiagram)) {
            for (Function f : dgr.getRole(EModel.class).getFunctions()) {
                functionName = f.getName();
                subDiagram = SubDiagram.getParentSubDiagram(dgr);
                key = subDiagram != null ? subDiagram.getCompleteNameInDiagram() : "";
                Node oldNode = (Node)f.getDiagramElement();
                String newFunctionName = this.functionSubstitutionMap.get(new Pair((Object)functionName, (Object)key));
                String rightSide = f.getRightHandSide();
                String processed = this.processFunction(rightSide, dgr);
                Function newFunction = new Function(null, newFunctionName, f.getArguments(), processed);
                DiagramElementGroup group = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Function.class, oldNode.getLocation(), newFunction);
                group.putToCompartment();
                group.nodesStream().map(n -> n.getRole()).select(Function.class).forEach(fun -> newEmodel.readMath(fun.getFormula(), (Role)fun, this.eModel.getVariableResolver(0), true));
            }
        }
    }

    private static String generateUniqueFunctionName(String name, SubDiagram subDiagram, boolean sbmlStyle, Set<String> names) {
        String result = sbmlStyle && subDiagram != null ? subDiagram.getName() + "__" + name : name;
        int i = 1;
        while (names.contains(result)) {
            result = name + "_" + i++;
        }
        return result;
    }

    private void readVariableRoles(Diagram diagram) {
        SubDiagram.diagrams(diagram).forEach(dgr -> this.readVariableRoles((Compartment)((Object)dgr), ""));
    }

    public void readVariableRoles(Compartment compartment, String newCompartmentPath) {
        Diagram diagram = CompositeModelUtility.getDiagram(compartment);
        for (Node node : (StreamEx)compartment.stream(Node.class).filter(n -> n.getRole() instanceof VariableRole)) {
            Role role = node.getRole();
            String oldVarName = ((VariableRole)role).getName();
            String newVarName = this.generateUniqueVariableName(oldVarName, diagram);
            if (((Object)((Object)role.getDiagramElement())).equals((Object)node)) {
                if (!(compartment instanceof Diagram)) {
                    newVarName = newVarName.replace(compartment.getCompleteNameInDiagram(), newCompartmentPath);
                }
                this.oldVariablesToNew.put((Pair<String, Diagram>)new Pair((Object)oldVarName, (Object)diagram), newVarName);
                this.newVarsToOldNodes.put(newVarName, (Node)role.getDiagramElement());
                this.newVarsToOld.put(newVarName, (VariableRole)role);
            }
            if (!(node instanceof Compartment)) continue;
            this.readVariableRoles((Compartment)node, this.generateCompartmentName(newVarName));
        }
    }

    private void readConnections(Diagram compositeDiagram) throws Exception {
        for (Connection c2 : compositeDiagram.recursiveStream().select(Edge.class).map(DiagramElement::getRole).select(Connection.class).flatCollection(c -> MultipleConnection.getBasicConnections(c).toSet())) {
            this.readConnection(c2);
        }
        this.transformUndirectedConnections();
        this.adjustUniqueNames();
        this.adjustDirectedConnections();
        for (AstStart function : this.dConnected.values()) {
            this.extendFunction((ru.biosoft.math.model.Node)function);
        }
    }

    private void readConnection(Connection connection) throws Exception {
        Edge edge = (Edge)connection.getDiagramElement();
        if (Util.isConstant(edge.getInput()) || Util.isPlot(edge.getInput()) || Util.isPlot(edge.getOutput())) {
            return;
        }
        if (Util.isPropagatedPort(edge.getInput()) || Util.isPropagatedPort(edge.getOutput())) {
            return;
        }
        Diagram inDiagram = CompositeModelUtility.getDiagram(edge.getInput());
        Diagram outDiagram = CompositeModelUtility.getDiagram(edge.getOutput());
        String inOldVariableName = connection.getInputPort().getVariableName();
        String outOldVariableName = connection.getOutputPort().getVariableName();
        EModel outModel = outDiagram.getRole(EModel.class);
        EModel inModel = inDiagram.getRole(EModel.class);
        Variable outOldVariable = outModel.getVariable(outOldVariableName);
        Variable inOldVariable = inModel.getVariable(inOldVariableName);
        if (outOldVariable == null && Util.isPort(edge.getOutput())) {
            outOldVariableName = Util.getPortVariable(edge.getOutput());
            outOldVariable = outModel.getVariable(outOldVariableName);
        }
        if (outOldVariable == null) {
            throw new Exception("Connection " + connection.getDiagramElement().getName() + " is not correct: variable " + outOldVariableName + " can not be found in module " + outDiagram.getName());
        }
        if (inOldVariable == null && Util.isPort(edge.getInput())) {
            inOldVariableName = Util.getPortVariable(edge.getInput());
            inOldVariable = inModel.getVariable(inOldVariableName);
        }
        if (inOldVariable == null) {
            throw new Exception("Connection " + connection.getDiagramElement().getName() + " is not correct: variable " + inOldVariableName + " can not be found in module " + inDiagram.getName());
        }
        String inVariableName = this.getUniqueVariableName(inDiagram, inOldVariableName);
        String outVariableName = this.getUniqueVariableName(outDiagram, outOldVariableName);
        if (connection instanceof DirectedConnection) {
            String function = ((DirectedConnection)connection).getFunction();
            if (function == null || function.equals("")) {
                function = inOldVariableName;
                SubDiagram subDiagram = SubDiagram.getParentSubDiagram(outDiagram);
                String key = subDiagram != null ? subDiagram.getCompleteNameInDiagram() : "";
                this.substitutionMap.put((Pair<String, String>)new Pair((Object)outOldVariableName, (Object)key), inVariableName);
            }
            AstStart functionNode = (AstStart)this.parse(function);
            this.renameVariables((ru.biosoft.math.model.Node)functionNode, inDiagram);
            if (this.dConnected.containsKey(outVariableName)) {
                throw new Exception("Multiple directed connections to the same variable " + outOldVariableName);
            }
            this.dConnected.put(outVariableName, functionNode);
        } else {
            String auxVariableName = null;
            String mainVariableName = null;
            Double initialValue = null;
            UndirectedConnection.MainVariableType type = ((UndirectedConnection)connection).getMainVariableType();
            if (type != UndirectedConnection.MainVariableType.NOT_SELECTED) {
                if (type == UndirectedConnection.MainVariableType.INPUT) {
                    mainVariableName = inVariableName;
                    auxVariableName = outVariableName;
                } else {
                    mainVariableName = outVariableName;
                    auxVariableName = inVariableName;
                }
                String factor = ((UndirectedConnection)connection).getConversionFactor();
                if (!factor.isEmpty()) {
                    this.conversionFactors.put(mainVariableName, factor);
                }
            } else {
                initialValue = ((UndirectedConnection)connection).getInitialValue();
                if (inOldVariable instanceof VariableRole && outOldVariable instanceof VariableRole) {
                    boolean outIsMain;
                    boolean bl = outIsMain = inVariableName.length() > outVariableName.length();
                    if (outIsMain) {
                        mainVariableName = outVariableName;
                        auxVariableName = inVariableName;
                        initialValue = inOldVariable.getInitialValue();
                    } else {
                        mainVariableName = inVariableName;
                        auxVariableName = outVariableName;
                        initialValue = outOldVariable.getInitialValue();
                    }
                } else {
                    initialValue = ((UndirectedConnection)connection).getInitialValue();
                    if (inOldVariable instanceof VariableRole) {
                        mainVariableName = inVariableName;
                        auxVariableName = outVariableName;
                    } else {
                        mainVariableName = outVariableName;
                        auxVariableName = inVariableName;
                    }
                }
            }
            this.registerUndirectedConnection(mainVariableName, auxVariableName, initialValue);
        }
    }

    private void renameVariables(ru.biosoft.math.model.Node expression, Diagram subDiagram) {
        Utils.deepChildren((ru.biosoft.math.model.Node)expression).select(AstVarNode.class).forEach(var -> {
            String newName = this.getUniqueVariableName(subDiagram, var.getName());
            var.setName(newName);
            var.setTitle(newName);
        });
    }

    private void processCompositeSubDiagrams(Diagram diagram) throws Exception {
        for (SubDiagram subDiagram : diagram.recursiveStream().select(SubDiagram.class)) {
            Diagram associatedDiagram = subDiagram.getDiagram();
            if (!DiagramUtility.containModules(associatedDiagram)) continue;
            boolean notif = associatedDiagram.isNotificationEnabled();
            associatedDiagram.setNotificationEnabled(false);
            subDiagram = this.processCompositeSubDiagram(diagram, subDiagram);
            associatedDiagram.setNotificationEnabled(notif);
        }
    }

    private void readReactions(Diagram diagram) throws Exception {
        for (Diagram dgr : SubDiagram.diagrams(diagram)) {
            this.processReactions(dgr, dgr, this.diagram);
        }
    }

    private void readEdges(Diagram diagram) throws Exception {
        for (Diagram dgr : SubDiagram.diagrams(diagram)) {
            this.readEdges(dgr, this.diagram);
        }
    }

    public SubDiagram processCompositeSubDiagram(Diagram compositeDiagram, SubDiagram subDiagram) throws Exception {
        CompositeModelPreprocessor preprocessor = new CompositeModelPreprocessor();
        preprocessor.asSubDiagram = true;
        Diagram innerDiagram = subDiagram.getDiagram();
        innerDiagram.getAttributes().remove("relativeSubDiagram");
        Diagram processedSubDiagram = preprocessor.preprocess(innerDiagram, null);
        SubDiagram newSubDiagram = new SubDiagram(compositeDiagram, processedSubDiagram, subDiagram.getName());
        for (Object dp : subDiagram.getAttributes()) {
            newSubDiagram.getAttributes().add((DynamicProperty)dp);
        }
        newSubDiagram.setDiagram(processedSubDiagram);
        this.varPathMapping.putAll(preprocessor.getVarPathMapping(subDiagram.getName()));
        boolean in = false;
        for (Edge edge : Util.getEdges(subDiagram)) {
            Connection.Port port;
            String varName;
            Node newPort;
            String portName;
            if (((Object)((Object)edge.getInput())).equals((Object)subDiagram)) {
                in = true;
                edge.setInput(newSubDiagram);
                newSubDiagram.addEdge(edge);
            } else if (((Object)((Object)edge.getOutput())).equals((Object)subDiagram)) {
                edge.setOutput(newSubDiagram);
                newSubDiagram.addEdge(edge);
            } else if (edge.getInput().getParent().equals((Object)subDiagram)) {
                in = true;
                portName = edge.getInput().getName();
                newPort = newSubDiagram.findNode(portName);
                edge.setInput(newPort);
                newPort.addEdge(edge);
            } else if (edge.getOutput().getParent().equals((Object)subDiagram)) {
                portName = edge.getOutput().getName();
                newPort = newSubDiagram.findNode(portName);
                edge.setOutput(newPort);
                newPort.addEdge(edge);
            }
            if (!(edge.getRole() instanceof Connection)) continue;
            Connection connection = edge.getRole(Connection.class);
            if (in) {
                varName = Util.getPortVariable(edge.getInput());
                port = connection.getInputPort();
            } else {
                varName = Util.getPortVariable(edge.getOutput());
                port = connection.getOutputPort();
            }
            port.setVariableName(varName);
            port.setVariableTitle(varName);
        }
        boolean notif = compositeDiagram.isNotificationEnabled();
        compositeDiagram.setNotificationEnabled(false);
        State state = compositeDiagram.getCurrentState();
        compositeDiagram.restore();
        compositeDiagram.remove(subDiagram.getName());
        newSubDiagram.save();
        if (state != null) {
            compositeDiagram.setStateEditingMode(state);
        }
        compositeDiagram.setNotificationEnabled(notif);
        return newSubDiagram;
    }

    public void readEdges(Compartment compartment, Compartment newCompartment) throws Exception {
        Iterator<DiagramElement> iterator = compartment.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            try {
                Edge edge;
                if (de instanceof Compartment) {
                    this.readEdges((Compartment)de, (Compartment)this.oldNodesToNew.get((Object)de));
                    continue;
                }
                if (!(de instanceof Edge) || (edge = (Edge)de).getKernel() instanceof SpecieReference || edge.getKernel() instanceof Stub && Util.isSourceSink(edge.getInput()) || Util.isSourceSink(edge.getOutput())) continue;
                Node inputNode = this.oldNodesToNew.get((Object)edge.getInput());
                Node outputNode = this.oldNodesToNew.get((Object)edge.getOutput());
                if (inputNode == null || outputNode == null) continue;
                Edge newEdge = CompositeModelUtility.clone(edge, newCompartment, edge.getKernel(), inputNode, outputNode);
                newCompartment.put(newEdge);
            }
            catch (Exception ex) {
                throw new Exception("Error during edge" + de.getName() + " processing: " + ex.getMessage());
            }
        }
    }

    private Node readSpecies(Node node, Compartment newCompartment, Node mainNode, boolean readCompartments) throws Exception {
        Diagram subDiagram = CompositeModelUtility.getDiagram(node);
        VariableRole oldVariable = node.getRole(VariableRole.class);
        String uniqueVariableName = this.getUniqueVariableName(subDiagram, oldVariable.getName());
        String newNodeName = this.generateNodeName(uniqueVariableName);
        Node newNode = null;
        if (mainNode != null && !((Object)((Object)mainNode)).equals((Object)node)) {
            newNodeName = DefaultSemanticController.generateUniqueName(newCompartment, newNodeName);
            newNode = Diagram.getDiagram(mainNode).getType().getSemanticController().cloneNode(mainNode, newNodeName, node.getLocation());
        } else {
            Base oldKernel = node.getKernel();
            Base newKernel = CompositeModelUtility.cloneKernel(oldKernel, null, newNodeName);
            newNode = node.clone(newCompartment, newNodeName, newKernel);
            if (node instanceof Compartment) {
                ((Compartment)newNode).clear();
            }
            VariableRole varRole = null;
            varRole = this.uConnectedInfo.containsKey(uniqueVariableName) ? ((VariableRole)this.uConnectedInfo.get(uniqueVariableName)).clone(newNode, uniqueVariableName) : newNode.getRole(VariableRole.class).clone(newNode, uniqueVariableName);
            newNode.setRole(varRole);
            this.eModel.put((VariableRole)newNode.getRole());
        }
        this.setLocation(newNode, subDiagram);
        newNode.setLocation(this.getNewLocation(newNode, subDiagram));
        if (this.dConnected.containsKey(uniqueVariableName)) {
            newNode.getRole(VariableRole.class).setBoundaryCondition(true);
            this.createConnectionEquation(newNode, this.dConnected.get(uniqueVariableName));
        }
        if ("compartment".equals(node.getKernel().getType())) {
            this.processVariableRoles((Compartment)node, (Compartment)newNode, readCompartments);
        }
        newNode.setOrigin(newCompartment);
        newCompartment.put(newNode);
        this.oldNodesToNew.put(node, newNode);
        SubDiagram parentSubDiagram = SubDiagram.getParentSubDiagram(subDiagram);
        String key = parentSubDiagram != null ? parentSubDiagram.getCompleteNameInDiagram() : "";
        this.substitutionMap.put((Pair<String, String>)new Pair((Object)oldVariable.getName(), (Object)key), ((VariableRole)newNode.getRole()).getName());
        return newNode;
    }

    private void setLocation(Node node, Diagram subDiagram) {
        node.recursiveStream().select(Node.class).forEach(n -> n.setLocation(this.getNewLocation((Node)((Object)n), subDiagram)));
    }

    private Compartment readCompartment(Compartment compartment, Compartment newCompartment) throws Exception {
        Diagram subDiagram = CompositeModelUtility.getDiagram(compartment);
        VariableRole oldVariable = compartment.getRole(VariableRole.class);
        String uniqueVariableName = this.getUniqueVariableName(subDiagram, oldVariable.getName());
        newCompartment.clear();
        newCompartment.getCompartment().put(newCompartment);
        if (!this.getMasterVariable(uniqueVariableName).equals(uniqueVariableName)) {
            String uniqueName = this.getUniqueVariableName(subDiagram, oldVariable.getName());
            this.eModel.getVariables().remove(uniqueName);
            return null;
        }
        if (compartment.getView() == null) {
            CompositeModelUtility.createView(compartment);
        }
        Rectangle rectangle = compartment.getView().getBounds();
        rectangle.setLocation(newCompartment.getLocation());
        for (String auxVariableName : this.getAuxVariables(uniqueVariableName)) {
            Node oldAuxNode = this.newVarsToOldNodes.get(auxVariableName);
            if (((Object)((Object)oldAuxNode)).equals((Object)compartment)) continue;
            this.readNodes((Compartment)oldAuxNode, newCompartment);
            if (oldAuxNode.getView() == null) {
                CompositeModelUtility.createView(oldAuxNode);
            }
            Rectangle r1 = oldAuxNode.getView().getBounds();
            r1.setLocation(this.getNewLocation(oldAuxNode, subDiagram));
            rectangle = rectangle.union(r1);
            this.oldNodesToNew.put(oldAuxNode, newCompartment);
        }
        newCompartment.setShapeSize(rectangle.getSize());
        newCompartment.setLocation(rectangle.getLocation());
        this.readNodes(compartment, newCompartment);
        return newCompartment;
    }

    public static SubDiagram processSwitch(Compartment switchNode) throws Exception {
        String condition = switchNode.getAttributes().getProperty("Condition").getValue().toString();
        Diagram switchDiagram = new Diagram(null, new Stub(null, switchNode.getName()), new PathwaySimulationDiagramType());
        switchDiagram.setRole(new EModel(switchDiagram));
        String formula = "piecewise( " + condition + "=> experiment; default )";
        Equation eq = new Equation(null, "scalar", "out", formula);
        DiagramElement de = switchDiagram.getType().getSemanticController().createInstance((Compartment)switchDiagram, Equation.class, new Point(0, 0), eq).getElement();
        switchDiagram.put(de);
        HashMap portNameToEdge = new HashMap();
        for (Node portNode : switchNode.getNodes()) {
            if (!Util.isInputPort(portNode) && !Util.isOutputPort(portNode)) continue;
            switchDiagram.put(portNode.clone(switchDiagram, portNode.getName()));
            ((StreamEx)portNode.edges().filter(e -> Util.isDirectedConnection(e))).forEach(e -> portNameToEdge.put(portNode.getName(), e));
        }
        SubDiagram subDiagram = new SubDiagram(switchNode, switchDiagram, switchNode.getName());
        subDiagram.setLocation(switchNode.getLocation());
        subDiagram.setShapeSize(switchNode.getShapeSize());
        subDiagram.updatePorts();
        for (Node portNode : subDiagram.getNodes()) {
            String originalPortName = portNode.getAttributes().getValue("originalPort").toString();
            Edge e2 = (Edge)((Object)portNameToEdge.get(originalPortName));
            if (e2 == null) continue;
            portNode.addEdge(e2);
            if (e2.getInput().getName().equals(originalPortName)) {
                e2.setInput(portNode);
                continue;
            }
            e2.setOutput(portNode);
        }
        return subDiagram;
    }

    private static void processSwitches(Diagram compositeDiagram) throws Exception {
        for (Compartment node : (StreamEx)compositeDiagram.recursiveStream().select(Compartment.class).filter(Util::isSwitch)) {
            compositeDiagram.put(CompositeModelPreprocessor.processSwitch(node));
        }
    }

    private void processConstants(Diagram compositeDiagram) throws Exception {
        for (Node node : (StreamEx)compositeDiagram.recursiveStream().select(Node.class).filter(Util::isConstant)) {
            double value = Double.parseDouble(node.getAttributes().getProperty("Initial value").getValue().toString());
            for (Edge edge : (StreamEx)node.edges().filter(Util::isDirectedConnection)) {
                Node otherNode = edge.getOtherEnd(node);
                String variableName = Util.getPortVariable(otherNode);
                Diagram d = CompositeModelUtility.getDiagram(otherNode);
                SubDiagram subDiagram = SubDiagram.getParentSubDiagram(d);
                Diagram keyDiagram = subDiagram != null ? subDiagram.getDiagram() : compositeDiagram;
                String newVariableName = this.getUniqueVariableName(keyDiagram, variableName);
                Variable var = this.eModel.getVariable(newVariableName);
                var.setInitialValue(value);
                var.setConstant(true);
            }
        }
    }

    private String generateCompartmentName(String variableName) {
        String compartmentName = variableName;
        if (compartmentName.startsWith("$")) {
            compartmentName = compartmentName.substring(1);
        }
        return compartmentName.replace("\"", "");
    }

    private String generateNodeName(String variableName) {
        String nodeName = variableName;
        if (nodeName.startsWith("$")) {
            nodeName = nodeName.substring(1);
        }
        if (nodeName.contains(".")) {
            nodeName = nodeName.substring(nodeName.lastIndexOf(".") + 1);
        }
        return nodeName.replace("\"", "");
    }

    public void readClones(Compartment compartment, Compartment newCompartment) throws Exception {
        HashSet<VariableRole> toRemove = new HashSet<VariableRole>();
        for (VariableRole var : this.eModel.getVariableRoles()) {
            try {
                String name = var.getName();
                DiagramElement de = var.getDiagramElement();
                String mainVarName = this.getMasterVariable(name);
                if (name.equals(mainVarName)) continue;
                Variable mainVariable = this.eModel.getVariable(mainVarName);
                if (!(mainVariable instanceof VariableRole)) {
                    throw new InternalException("Variable " + mainVarName + " is not VariableRole");
                }
                DiagramElement mainDe = ((VariableRole)mainVariable).getDiagramElement();
                de.setRole((VariableRole)mainVariable);
                de.setTitle(mainDe.getTitle());
                ((VariableRole)mainVariable).addAssociatedElement(de);
                de.getAttributes().add(new DynamicProperty("sbgn:cloneMarker", String.class, (Object)mainDe.getCompleteNameInDiagram()));
                toRemove.add(var);
            }
            catch (Exception ex) {
                throw new Exception("Error during " + var.getName() + " processing: " + ex.getMessage());
            }
        }
        for (VariableRole var : toRemove) {
            this.eModel.getVariables().remove(var.getName());
        }
    }

    protected void readConnectedEquations(Compartment compartment, HashMap<String, List<Equation>> varToRateEqs) {
        for (Node node : compartment.getNodes()) {
            if (node.getRole() instanceof Equation) {
                Equation eq = node.getRole(Equation.class);
                if (!eq.getType().equals("rate")) continue;
                String uniqueName = this.getUniqueVariableName(Diagram.getDiagram(node), eq.getVariable());
                String masterVariable = this.getMasterVariable(uniqueName);
                varToRateEqs.computeIfAbsent(masterVariable, k -> new ArrayList()).add(eq);
                continue;
            }
            if (node instanceof SubDiagram) {
                this.readConnectedEquations(((SubDiagram)node).getDiagram(), varToRateEqs);
                continue;
            }
            if (!(node instanceof Compartment)) continue;
            this.readConnectedEquations((Compartment)node, varToRateEqs);
        }
    }

    public void processRateEquations(Compartment compartment) {
        HashMap<String, List<Equation>> varToRateEqs = new HashMap<String, List<Equation>>();
        this.readConnectedEquations(compartment, varToRateEqs);
        for (Map.Entry<String, List<Equation>> entry : varToRateEqs.entrySet()) {
            try {
                String masterVariable = entry.getKey();
                if (entry.getValue().size() <= 1) continue;
                Node node = null;
                StringBuilder formulaBuilder = new StringBuilder();
                for (Equation eq : entry.getValue()) {
                    DynamicProperty timeScale;
                    Diagram diagram = Diagram.getDiagram(eq.getDiagramElement());
                    String eqFormula = eq.getFormula();
                    if (formulaBuilder.length() > 0) {
                        formulaBuilder.append("+");
                    }
                    eqFormula = this.processExpression(eqFormula, diagram, true);
                    SubDiagram subDiagram = SubDiagram.getParentSubDiagram(diagram);
                    if (subDiagram != null && (timeScale = subDiagram.getAttributes().getProperty("Time scale")) != null && !timeScale.getValue().toString().isEmpty()) {
                        eqFormula = "(" + eqFormula + ")/" + timeScale.getValue().toString();
                    }
                    formulaBuilder.append(eqFormula);
                    String uniqueVariable = this.getUniqueVariableName(diagram, eq.getVariable());
                    if (uniqueVariable.equals(masterVariable)) {
                        node = (Node)eq.getDiagramElement();
                    }
                    this.processedEquations.add((Node)eq.getDiagramElement());
                }
                if (node == null) {
                    node = (Node)varToRateEqs.get(masterVariable).get(0).getDiagramElement();
                }
                if (this.conversionFactors.containsKey(masterVariable)) {
                    String conversionFactor = this.conversionFactors.get(masterVariable);
                    formulaBuilder.insert(0, '(');
                    formulaBuilder.append(")*").append(conversionFactor);
                }
                Equation eq = new Equation(null, "rate", masterVariable, formulaBuilder.toString());
                Point location = this.getNewLocation(node, Diagram.getDiagram(node));
                DiagramElement de = this.diagram.getType().getSemanticController().createInstance((Compartment)this.diagram, Equation.class, location, eq).getElement();
                de.save();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Error during rate equations processing");
            }
        }
    }

    public void readPorts(Compartment compartment, Compartment newCompartment) throws Exception {
        Diagram subDiagram = CompositeModelUtility.getDiagram(compartment);
        for (Node node : compartment.getNodes()) {
            AstStart start;
            if (!Util.isPort(node) || !node.getParent().equals((Object)this.compositeDiagram)) continue;
            Node newNode = null;
            String oldVariable = Util.getPortVariable(node);
            if (Util.isPropagatedPort(node)) {
                newNode = node.clone(newCompartment, CompositeModelPreprocessor.generateUniqueNodeName(node.getName(), newCompartment));
                if (!((Object)((Object)Diagram.getDiagram(node))).equals((Object)this.compositeDiagram)) continue;
                for (Edge edge : node.getEdges()) {
                    Node anotherNode;
                    if (!(edge.getKernel() instanceof Stub.DirectedConnection) && !(edge.getKernel() instanceof Stub.UndirectedConnection) || !Util.isPort(anotherNode = edge.getOtherEnd(node))) continue;
                    oldVariable = Util.getPortVariable(anotherNode);
                    SubDiagram portSubDiagram = (SubDiagram)anotherNode.getParent();
                    oldVariable = this.getUniqueVariableName(portSubDiagram.getDiagram(), oldVariable);
                }
            } else {
                if (!Util.isPublicPort(node)) continue;
                newNode = node.clone(newCompartment, CompositeModelPreprocessor.generateUniqueNodeName(node.getName(), newCompartment));
                oldVariable = this.getUniqueVariableName(Diagram.getDiagram(node), Util.getPortVariable(node));
            }
            String newVariable = this.getMasterVariable(oldVariable);
            if (this.dConnected.containsKey(oldVariable) && (start = this.dConnected.get(oldVariable)).jjtGetNumChildren() == 1 && start.jjtGetChild(0) instanceof AstVarNode) {
                AstVarNode varNode = (AstVarNode)start.jjtGetChild(0);
                newVariable = varNode.getName();
            }
            Util.setPortVariable(newNode, newVariable);
            Util.setPublic(newNode);
            newNode.setLocation(this.getNewLocation(newNode, subDiagram));
            newNode.save();
        }
    }

    public void processCompartments(Compartment compartment, Compartment newCompartment) throws Exception {
        if (compartment instanceof Diagram) {
            for (Diagram dgr : compartment.recursiveStream().select(SubDiagram.class).map(DiagramContainer::getDiagram)) {
                this.processCompartments(dgr, newCompartment);
            }
        }
        for (Node node : (StreamEx)compartment.stream(Compartment.class).filter(c -> "compartment".equals(c.getKernel().getType()))) {
        }
    }

    public void processVariableRoles(Compartment compartment, Compartment newCompartment, boolean processCompartments) throws Exception {
        if (compartment instanceof Diagram) {
            for (Diagram dgr : compartment.recursiveStream().select(SubDiagram.class).map(DiagramContainer::getDiagram)) {
                this.processVariableRoles(dgr, newCompartment, processCompartments);
            }
        }
        for (Node node : (StreamEx)compartment.stream(Node.class).filter(c -> c.getRole() instanceof VariableRole)) {
            String masterVariableName;
            VariableRole oldVariable;
            Diagram subDiagram;
            String uniqueVariableName;
            boolean isCompartment = "compartment".equals(node.getKernel().getType());
            if (isCompartment) {
                if (!processCompartments) {
                    Compartment newNode = (Compartment)this.oldNodesToNew.get((Object)node);
                    this.processVariableRoles((Compartment)node, newNode, processCompartments);
                    continue;
                }
            } else if (processCompartments) continue;
            if (this.oldNodesToNew.containsKey((Object)node)) continue;
            VariableRole varRole = node.getRole(VariableRole.class);
            Node mainNode = (Node)varRole.getDiagramElement();
            Node newMainNode = null;
            if (!((Object)((Object)mainNode)).equals((Object)node) && !this.oldNodesToNew.keySet().contains((Object)mainNode)) {
                newMainNode = this.readSpecies(mainNode, newCompartment, null, processCompartments);
            }
            if (!(uniqueVariableName = this.getUniqueVariableName(subDiagram = CompositeModelUtility.getDiagram(node), (oldVariable = node.getRole(VariableRole.class)).getName())).equals(masterVariableName = this.getMasterVariable(uniqueVariableName))) {
                Node oldNode = this.newVarsToOldNodes.get(masterVariableName);
                newMainNode = this.oldNodesToNew.get((Object)oldNode);
                Node newMainCompartment = this.oldNodesToNew.get((Object)oldNode.getCompartment());
                if (newMainCompartment == null) {
                    newMainCompartment = this.diagram;
                }
                if (newMainNode == null) {
                    newMainNode = this.readSpecies(oldNode, (Compartment)newMainCompartment, null, processCompartments);
                }
            }
            this.readSpecies(node, newCompartment, newMainNode, processCompartments);
        }
    }

    public void readNodes(Compartment compartment, Compartment newCompartment) throws Exception {
        Diagram subDiagram = CompositeModelUtility.getDiagram(compartment);
        for (Node node : compartment.getNodes()) {
            this.readNode(node, subDiagram, compartment, newCompartment);
        }
    }

    public void readNode(Node node, Diagram subDiagram, Compartment compartment, Compartment newCompartment) throws Exception {
        try {
            Role role;
            if (node instanceof SubDiagram) {
                this.readNodes(((SubDiagram)node).getDiagram(), this.diagram);
                return;
            }
            if (node.getKernel() instanceof Reaction || Util.isPlot(node) || Util.isConstant(node) || Util.isSwitch(node) || Util.isPort(node) || node instanceof ModelDefinition || Util.isSourceSink(node) || node.getRole() instanceof Function || Util.isVariable(node)) {
                return;
            }
            if (this.processedEquations.contains((Object)node) || this.oldNodesToNew.keySet().contains((Object)node)) {
                return;
            }
            String newName = CompositeModelPreprocessor.generateUniqueNodeName(node.getName(), newCompartment);
            Node newNode = node.clone(newCompartment, newName);
            newNode.setLocation(this.getNewLocation(newNode, subDiagram));
            if (newNode instanceof Compartment) {
                ((Compartment)newNode).clear();
                this.readNodes((Compartment)node, (Compartment)newNode);
            }
            if ((role = node.getRole()) instanceof Equation) {
                DynamicProperty timeScale;
                SubDiagram sDiagram;
                Equation equation = (Equation)role;
                String variableName = equation.getVariable();
                String uniqueName = this.getUniqueVariableName(subDiagram, variableName);
                if (this.dConnected.containsKey(uniqueName)) {
                    return;
                }
                this.processExpressionOwner((ExpressionOwner)((Object)role), subDiagram, (ExpressionOwner)((Object)newNode.getRole()));
                String formula = newNode.getRole(Equation.class).getFormula();
                String mainVariable = this.getMasterVariable(uniqueName);
                if (this.conversionFactors.containsKey(mainVariable)) {
                    formula = "(" + formula + ")*" + this.conversionFactors.get(mainVariable);
                }
                if (equation.getType().equals("rate") && (sDiagram = SubDiagram.getParentSubDiagram(subDiagram)) != null && (timeScale = sDiagram.getAttributes().getProperty("Time scale")) != null && !timeScale.getValue().toString().isEmpty()) {
                    formula = "(" + formula + ")/" + timeScale.getValue().toString();
                }
                newNode.getRole(Equation.class).setFormula(formula);
            } else if (role instanceof ExpressionOwner) {
                this.processExpressionOwner((ExpressionOwner)((Object)role), subDiagram, (ExpressionOwner)((Object)newNode.getRole()));
            }
            newCompartment.put(newNode);
            this.oldNodesToNew.put(node, newNode);
        }
        catch (Exception ex) {
            throw new Exception("Error during " + node.getName() + " processing: " + ex.getMessage(), ex);
        }
    }

    private Point getNewLocation(Node node, Diagram diagram) {
        if (!this.layout) {
            return node.getLocation();
        }
        if (node.getView() == null) {
            CompositeModelUtility.createView(node);
        }
        Point location = new Point(node.getView().getBounds().getLocation());
        if (this.subDiagramShift != null && this.subDiagramShift.containsKey((Object)diagram)) {
            Point diagramLocation = this.subDiagramShift.get((Object)diagram);
            location.translate(diagramLocation.x, diagramLocation.y);
        } else if (this.subDiagramShift != null && this.subDiagramShift.containsKey((Object)node)) {
            location = this.subDiagramShift.get((Object)node);
        }
        return location;
    }

    private void processReactions(Compartment compartment, Diagram subDiagram, Compartment newCompartment) throws Exception {
        for (Node node : compartment.getNodes()) {
            try {
                DiagramElementGroup reactionElements;
                String variable;
                String uniqueVariableName;
                if (node.getKernel() instanceof Stub.ConnectionPort || node instanceof SubDiagram) continue;
                if (node instanceof Compartment && !((Compartment)node).isEmpty()) {
                    this.processReactions((Compartment)node, subDiagram, (Compartment)this.oldNodesToNew.get((Object)node));
                    continue;
                }
                if (!(node.getKernel() instanceof Reaction) || !this.getMasterVariable(uniqueVariableName = this.getUniqueVariableName(subDiagram, variable = node.getRole(Equation.class).getVariable())).equals(uniqueVariableName)) continue;
                Reaction reaction = (Reaction)node.getKernel();
                ArrayList<SpecieReference> components = new ArrayList<SpecieReference>();
                HashMap<Node, Node> masterSpeciesToCloned = new HashMap<Node, Node>();
                for (SpecieReference reference : reaction.getSpecieReferences()) {
                    String specie = DiagramUtility.toDiagramPath(reference.getSpecie());
                    Node newSpecieNode = this.oldNodesToNew.get((Object)subDiagram.findNode(specie));
                    Node masterNode = (Node)newSpecieNode.getRole().getDiagramElement();
                    if (!((Object)((Object)masterNode)).equals((Object)newSpecieNode)) {
                        masterSpeciesToCloned.put(masterNode, newSpecieNode);
                        newSpecieNode = masterNode;
                    }
                    BaseSupport newReference = reference.clone(newCompartment, newSpecieNode.getCompleteNameInDiagram());
                    ((SpecieReference)newReference).setSpecie(newSpecieNode.getCompleteNameInDiagram());
                    components.add((SpecieReference)newReference);
                }
                Referrer newReaction = reaction.clone((DataCollection)null, reaction.getName());
                ((Reaction)newReaction).setSpecieReferences(components.toArray(new SpecieReference[components.size()]));
                Node newNode = null;
                String reactionName = this.generateUniqueVariableName(node.getName(), subDiagram);
                SemanticController controller = this.diagram.getType().getSemanticController();
                if (controller instanceof CreatorElementWithName) {
                    reactionElements = ((CreatorElementWithName)controller).createInstance(newCompartment, Reaction.class, reactionName, node.getLocation(), newReaction);
                } else {
                    Edge[] properties = new ReactionInitialProperties();
                    properties.setKineticlaw(reaction.getKineticLaw());
                    properties.setSpecieReferences(components);
                    reactionElements = properties.createElements(newCompartment, node.getLocation(), null);
                }
                newNode = (Node)reactionElements.getElement(Util::isReaction);
                for (Node n : reactionElements.nodesStream()) {
                    n.getCompartment().put(n);
                }
                for (Edge e : reactionElements.edgesStream()) {
                    e.getCompartment().put(e);
                }
                newReaction = (Reaction)newNode.getKernel();
                ((Reaction)newReaction).setFormula(this.processExpression(reaction.getFormula(), subDiagram, true));
                for (Edge edge : newNode.getEdges()) {
                    if (!(edge.getKernel() instanceof SpecieReference) || !(edge.getRole() instanceof Equation)) continue;
                    Equation edgeEq = edge.getRole(Equation.class);
                    edgeEq.getFormula();
                    Node input = edge.getInput();
                    Node output = edge.getOutput();
                    if (masterSpeciesToCloned.containsKey((Object)input)) {
                        edge.setInput((Node)((Object)masterSpeciesToCloned.get((Object)input)));
                        ((Node)((Object)masterSpeciesToCloned.get((Object)input))).addEdge(edge);
                        continue;
                    }
                    if (!masterSpeciesToCloned.containsKey((Object)output)) continue;
                    edge.setOutput((Node)((Object)masterSpeciesToCloned.get((Object)output)));
                    ((Node)((Object)masterSpeciesToCloned.get((Object)output))).addEdge(edge);
                }
                block7: for (Edge e : node.getEdges()) {
                    Node specieNode = ((Object)((Object)node)).equals((Object)e.getInput()) ? e.getOutput() : e.getInput();
                    Node newSpecieNode = this.oldNodesToNew.get((Object)specieNode);
                    if (Util.isSourceSink(specieNode)) continue;
                    for (Edge newEdge : newSpecieNode.getEdges()) {
                        if ((!((Object)((Object)newSpecieNode)).equals((Object)newEdge.getInput()) || !((Object)((Object)newNode)).equals((Object)newEdge.getOutput())) && (!((Object)((Object)newSpecieNode)).equals((Object)newEdge.getOutput()) || !((Object)((Object)newNode)).equals((Object)newEdge.getInput()))) continue;
                        CompositeModelUtility.copyAttributes(e, newEdge);
                        newEdge.setTitle(e.getTitle());
                        newEdge.setComment(e.getComment());
                        continue block7;
                    }
                }
                newReaction.setDatabaseReferences(reaction.getDatabaseReferences());
                newReaction.setLiteratureReferences(reaction.getLiteratureReferences());
                newNode.setLocation(this.getNewLocation(newNode, subDiagram));
                CompositeModelUtility.copyAttributes(node, newNode);
                SubDiagram sDiagram = SubDiagram.getParentSubDiagram(Diagram.getDiagram(compartment));
                if (sDiagram != null) {
                    DynamicProperty timeFactor = sDiagram.getAttributes().getProperty("Time scale");
                    DynamicProperty extentFactor = sDiagram.getAttributes().getProperty("Extent factor");
                    String factor = "1";
                    if (extentFactor != null && !extentFactor.getValue().toString().isEmpty()) {
                        factor = extentFactor.getValue().toString();
                    }
                    if (timeFactor != null && !timeFactor.getValue().toString().isEmpty()) {
                        factor = factor + "/" + timeFactor.getValue().toString();
                    }
                    if (!factor.equals("1")) {
                        ((Reaction)newReaction).setFormula(((Reaction)newReaction).getFormula() + "*(" + factor + ")");
                    }
                }
                this.oldNodesToNew.put(node, newNode);
            }
            catch (Exception ex) {
                throw new Exception("Error during reaction " + node.getName() + " processing: " + ex.getMessage());
            }
        }
    }

    private void createConnectionEquation(Node node, AstStart formula) throws Exception {
        String name = node.getRole(VariableRole.class).getName();
        Equation eq = new Equation(null, "scalar", name, new LinearFormatter().format(formula)[1]);
        DiagramElement de = this.diagram.getType().getSemanticController().createInstance((Compartment)this.diagram, Equation.class, new Point(0, 0), eq).getElement();
        this.diagram.put(de);
    }

    private void extendFunction(ru.biosoft.math.model.Node function) {
        int n = function.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            String key;
            ru.biosoft.math.model.Node child = function.jjtGetChild(i);
            if (!(child instanceof AstVarNode) || !this.dConnected.containsKey(key = ((AstVarNode)child).getName())) continue;
            ru.biosoft.math.model.Node inputConnection = (ru.biosoft.math.model.Node)this.dConnected.get(key);
            this.extendFunction(inputConnection);
            if (inputConnection.jjtGetNumChildren() == 1) {
                inputConnection = inputConnection.jjtGetChild(0);
            }
            function.jjtReplaceChild(child, inputConnection);
        }
    }

    private ru.biosoft.math.model.Node parse(String str) {
        Parser parser = new Parser();
        parser.parse(str);
        return parser.getStartNode();
    }

    private boolean isConnected(String varName) {
        return StreamEx.ofValues(this.uConnected).anyMatch(set -> set.contains(varName));
    }

    private String getMasterVariable(String varName) {
        return StreamEx.ofKeys(this.uConnected, set -> set.contains(varName)).findAny().orElse(varName);
    }

    private Set<String> getAuxVariables(String mainVariableName) {
        return this.uConnected.getOrDefault(mainVariableName, Collections.emptySet());
    }

    private void transformUndirectedConnections() {
        HashMap<String, String> toReplace = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : this.uConnected.entrySet()) {
            Variable oldVariable = this.newVarsToOld.get(entry.getKey());
            String main = entry.getKey();
            Set<String> vars = entry.getValue();
            String newVarName = null;
            for (String varName : vars) {
                Variable oldVar = this.newVarsToOld.get(varName);
                Diagram parent = this.getParentDiagram(oldVar);
                if (!((Object)((Object)parent)).equals((Object)this.compositeDiagram)) continue;
                toReplace.put(main, varName);
                newVarName = varName;
            }
            if (newVarName == null) continue;
            this.uConnectedInfo.put(newVarName, oldVariable);
        }
        for (Map.Entry<String, Set<String>> entry : toReplace.entrySet()) {
            Set<String> value = this.uConnected.get(entry.getKey());
            this.uConnected.remove(entry.getKey());
            this.uConnected.put((String)((Object)entry.getValue()), value);
        }
    }

    private void adjustDirectedConnections() {
        for (Map.Entry<String, AstStart> e : this.dConnected.entrySet()) {
            this.adjustDirectedConnection((ru.biosoft.math.model.Node)e.getValue());
        }
    }

    private void adjustDirectedConnection(ru.biosoft.math.model.Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ru.biosoft.math.model.Node child = node.jjtGetChild(i);
            if (child instanceof AstVarNode) {
                String variableName = ((AstVarNode)child).getName();
                String[] parts = variableName.split("\\.");
                Object[] newParts = new String[parts.length];
                boolean replaced = false;
                for (int j = 0; j < parts.length; ++j) {
                    String substitution = this.getMasterVariable(parts[j]);
                    if (!parts[j].equals(substitution)) {
                        newParts[j] = substitution;
                        replaced = true;
                        continue;
                    }
                    newParts[j] = parts[j];
                }
                if (!replaced) continue;
                String newVal = StreamEx.of((Object[])newParts).joining((CharSequence)".");
                AstStart newChild = (AstStart)this.parse(newVal);
                node.jjtReplaceChild(node.jjtGetChild(i), newChild.jjtGetChild(0));
                continue;
            }
            this.adjustDirectedConnection(child);
        }
    }

    private Diagram getParentDiagram(Variable var) {
        if (var instanceof VariableRole) {
            return Diagram.getDiagram(((VariableRole)var).getDiagramElement());
        }
        return ((EModel)var.getParent()).getDiagramElement();
    }

    private void registerUndirectedConnection(String mainVariableName, String auxVariableName, Double initialValue) {
        HashSet<String> newSet = new HashSet<String>();
        newSet.add(mainVariableName);
        newSet.add(auxVariableName);
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.uConnected.keySet());
        for (String mainVar : keySet) {
            Set<String> set = this.uConnected.get(mainVar);
            if (!set.contains(mainVariableName) && !set.contains(auxVariableName)) continue;
            newSet.addAll(set);
            this.uConnected.remove(mainVar);
            if (mainVar.equals(auxVariableName)) break;
            mainVariableName = mainVar;
            break;
        }
        this.uConnected.put(mainVariableName, newSet);
        String varInfo = null;
        if (this.variablesInfo.containsKey(mainVariableName)) {
            varInfo = this.variablesInfo.get(mainVariableName);
        }
        if (this.nameStyle == 1) {
            if (!mainVariableName.contains("__")) {
                varInfo = mainVariableName;
            } else if (varInfo == null || varInfo.contains("__")) {
                varInfo = auxVariableName;
            }
        } else {
            varInfo = mainVariableName;
        }
        this.variablesInfo.put(mainVariableName, varInfo);
    }

    public static String generateUniqueNodeName(String oldName, Compartment newCompartment) {
        String newName = oldName;
        int counter = 1;
        while (newCompartment.contains(newName)) {
            newName = oldName + "_" + counter++;
        }
        return newName;
    }

    @Nonnull
    private String generateUniqueVariableName(@Nonnull String oldName, Diagram diagram) {
        String newBaseID;
        if (oldName.equals("time")) {
            return "time";
        }
        if (this.nameStyle == 1) {
            SubDiagram subDiagram;
            boolean isRate = false;
            if (oldName.startsWith("$$rate_")) {
                isRate = true;
                oldName = oldName.substring(7);
            }
            if ((subDiagram = SubDiagram.getParentSubDiagram(diagram)) == null) {
                return isRate ? "$$rate_" + oldName : oldName;
            }
            String path = "";
            String baseId = oldName;
            if (oldName.contains(".")) {
                path = oldName.substring(0, oldName.lastIndexOf("."));
                baseId = oldName.substring(oldName.lastIndexOf(".") + 1);
                return path + "." + subDiagram.getName() + "__" + baseId;
            }
            if (isRate) {
                return "$$rate_" + subDiagram.getName() + "__" + baseId;
            }
            if (baseId.startsWith("$")) {
                return "$" + subDiagram.getName() + "__" + baseId.substring(1);
            }
            return subDiagram.getName().replace(" ", "_") + "__" + baseId;
        }
        if (oldName.startsWith("$$")) {
            return oldName;
        }
        String newName = oldName.replace("\"", "");
        if (oldName.startsWith("$")) {
            newName = newName.substring(1);
        }
        String newID = newBaseID = newName.substring(newName.lastIndexOf(".") + 1);
        int counter = 1;
        while (true) {
            if (counter != 1) {
                newID = newBaseID + counter;
            }
            if (!this.variableIDS.contains(newID)) break;
            ++counter;
        }
        this.variableIDS.add(newID);
        if (counter != 1) {
            newName = newName + counter;
        }
        if (!VariableRole.IDENTIFIER.matcher(newName).matches()) {
            newName = "\"" + newName + "\"";
        }
        if (oldName.startsWith("$")) {
            newName = "$" + newName;
        }
        return newName;
    }

    private void processExpressionOwner(ExpressionOwner oldOwner, Diagram subDiagram, ExpressionOwner newOwner) {
        DynamicProperty dp;
        SubDiagram sDiagram;
        String delay;
        if (oldOwner instanceof Equation && !((Equation)oldOwner).getType().equals("algebraic")) {
            String[] expressions = oldOwner.getExpressions();
            String[] newExpressions = new String[]{this.processExpression(expressions[0], subDiagram, false), this.processExpression(expressions[1], subDiagram, true)};
            newOwner.setExpressions(newExpressions);
        } else if (!(oldOwner instanceof Function)) {
            newOwner.setExpressions((String[])StreamEx.of((Object[])oldOwner.getExpressions()).map(expr -> this.processExpression((String)expr, subDiagram, true)).toArray(String[]::new));
        }
        if (newOwner instanceof Event && (delay = ((Event)newOwner).getDelay()) != null && !delay.isEmpty() && !delay.equals("0") && (sDiagram = SubDiagram.getParentSubDiagram(subDiagram)) != null && (dp = sDiagram.getAttributes().getProperty("Time scale")) != null && !dp.getValue().toString().isEmpty()) {
            ((Event)newOwner).setDelay("(" + delay + ")*" + dp.getValue().toString());
        }
    }

    private String processExpression(String oldExpression, Diagram subDiagram, boolean rightSide) {
        if (oldExpression == null || oldExpression.isEmpty()) {
            return oldExpression;
        }
        ru.biosoft.math.model.Node expression = this.parse(oldExpression).jjtGetChild(0);
        ru.biosoft.math.model.Node newExpression = this.processExpression(expression, subDiagram, rightSide);
        AstStart start = new AstStart(0);
        start.jjtAddChild(newExpression, 0);
        return new LinearFormatter().format(start)[1];
    }

    private String processFunction(String oldExpression, Diagram subDiagram) {
        if (oldExpression == null || oldExpression.isEmpty()) {
            return oldExpression;
        }
        ru.biosoft.math.model.Node expression = this.parse(oldExpression).jjtGetChild(0);
        ru.biosoft.math.model.Node newExpression = this.processFunction(expression, subDiagram);
        AstStart start = new AstStart(0);
        start.jjtAddChild(newExpression, 0);
        return new LinearFormatter().format(start)[1];
    }

    private ru.biosoft.math.model.Node processFunction(ru.biosoft.math.model.Node expression, Diagram subDiagram) {
        SubDiagram sDiagram;
        String key;
        String funName;
        String newName;
        ru.biosoft.math.model.Node newExpression = Utils.cloneAST((ru.biosoft.math.model.Node)expression);
        if (newExpression instanceof AstFunNode && (newName = this.getNewFunctionName(funName = ((AstFunNode)newExpression).getFunction().getName(), key = (sDiagram = SubDiagram.getParentSubDiagram(subDiagram)) != null ? sDiagram.getCompleteNameInDiagram() : "")) != null) {
            ru.biosoft.math.model.Function oldFunction = ((AstFunNode)newExpression).getFunction();
            ((AstFunNode)newExpression).setFunction((ru.biosoft.math.model.Function)new UndeclaredFunction(newName, oldFunction.getPriority()));
        }
        for (int i = 0; i < newExpression.jjtGetNumChildren(); ++i) {
            ru.biosoft.math.model.Node child = newExpression.jjtGetChild(i);
            newExpression.jjtReplaceChild(child, this.processFunction(child, subDiagram));
        }
        return newExpression;
    }

    private ru.biosoft.math.model.Node processExpression(ru.biosoft.math.model.Node expression, Diagram subDiagram, boolean rightSide) {
        ru.biosoft.math.model.Node newExpression = Utils.cloneAST((ru.biosoft.math.model.Node)expression);
        if (newExpression instanceof AstVarNode) {
            return this.processVarNode((AstVarNode)expression, subDiagram, rightSide);
        }
        if (newExpression instanceof AstFunNode) {
            String funName = ((AstFunNode)newExpression).getFunction().getName();
            if (funName.equals("=") && newExpression.jjtGetChild(0) instanceof AstVarNode) {
                ru.biosoft.math.model.Node varNode = newExpression.jjtGetChild(0);
                String varName = ((AstVarNode)varNode).getName();
                String mainVariable = this.getMasterVariable(this.getUniqueVariableName(subDiagram, varName));
                String conversionFactor = this.conversionFactors.get(mainVariable);
                ru.biosoft.math.model.Node newVariable = this.processVarNode((AstVarNode)newExpression.jjtGetChild(0), subDiagram, false);
                ru.biosoft.math.model.Node newFormula = this.processExpression(newExpression.jjtGetChild(1), subDiagram, rightSide);
                if (conversionFactor != null && !conversionFactor.isEmpty()) {
                    ru.biosoft.math.model.Node factor = this.parse(conversionFactor).jjtGetChild(0);
                    newFormula = Utils.applyFunction((ru.biosoft.math.model.Node)newFormula, (ru.biosoft.math.model.Node)factor, (ru.biosoft.math.model.Function)new PredefinedFunction("*", 4, -1));
                }
                newExpression.jjtReplaceChild(newExpression.jjtGetChild(1), newFormula);
                newExpression.jjtReplaceChild(newExpression.jjtGetChild(0), newVariable);
                return newExpression;
            }
            if (funName.equals("delay")) {
                DynamicProperty timeFactor;
                for (int i = 0; i < newExpression.jjtGetNumChildren(); ++i) {
                    ru.biosoft.math.model.Node child = newExpression.jjtGetChild(i);
                    newExpression.jjtReplaceChild(child, this.processExpression(child, subDiagram, rightSide));
                }
                SubDiagram sDiagram = SubDiagram.getParentSubDiagram(subDiagram);
                if (sDiagram != null && (timeFactor = sDiagram.getAttributes().getProperty("Time scale")) != null && !timeFactor.getValue().toString().isEmpty()) {
                    ru.biosoft.math.model.Node formula = Utils.cloneAST((ru.biosoft.math.model.Node)newExpression.jjtGetChild(1));
                    ru.biosoft.math.model.Node factor = this.parse(timeFactor.getValue().toString()).jjtGetChild(0);
                    formula = Utils.applyFunction((ru.biosoft.math.model.Node)formula, (ru.biosoft.math.model.Node)factor, (ru.biosoft.math.model.Function)new PredefinedFunction("*", 4, -1));
                    newExpression.jjtReplaceChild(newExpression.jjtGetChild(1), formula);
                }
                return newExpression;
            }
            SubDiagram sDiagram = SubDiagram.getParentSubDiagram(subDiagram);
            String key = sDiagram != null ? sDiagram.getCompleteNameInDiagram() : "";
            String newName = this.getNewFunctionName(funName, key);
            if (newName != null) {
                ru.biosoft.math.model.Function oldFunction = ((AstFunNode)newExpression).getFunction();
                ((AstFunNode)newExpression).setFunction((ru.biosoft.math.model.Function)new UndeclaredFunction(newName, oldFunction.getPriority()));
            }
        }
        for (int i = 0; i < newExpression.jjtGetNumChildren(); ++i) {
            ru.biosoft.math.model.Node child = newExpression.jjtGetChild(i);
            newExpression.jjtReplaceChild(child, this.processExpression(child, subDiagram, rightSide));
        }
        return newExpression;
    }

    protected ru.biosoft.math.model.Node processVarNode(AstVarNode node, Diagram diagram, boolean rightSide) {
        DynamicProperty dp;
        ru.biosoft.math.model.Node result = node.cloneAST();
        String varName = diagram.getRole(EModel.class).getVariable(node.getName()).getName();
        String uniqueName = this.getUniqueVariableName(diagram, varName);
        if (uniqueName == null) {
            return null;
        }
        result = this.parse(uniqueName).jjtGetChild(0);
        SubDiagram subDiagram = SubDiagram.getParentSubDiagram(diagram);
        if (varName.startsWith("$$")) {
            if (!rightSide || subDiagram == null) {
                return result;
            }
            DynamicProperty timeFactor = subDiagram.getAttributes().getProperty("Time scale");
            DynamicProperty extentFactor = subDiagram.getAttributes().getProperty("Extent factor");
            String factor = "1";
            if (timeFactor != null && !timeFactor.getValue().toString().isEmpty()) {
                factor = timeFactor.getValue().toString();
            }
            if (extentFactor != null && !extentFactor.getValue().toString().isEmpty()) {
                factor = factor + "/" + extentFactor.getValue().toString();
            }
            if (factor != "1") {
                ru.biosoft.math.model.Node nodeFactor = this.parse(factor).jjtGetChild(0);
                result = Utils.applyFunction((ru.biosoft.math.model.Node)result, (ru.biosoft.math.model.Node)nodeFactor, (ru.biosoft.math.model.Function)new PredefinedFunction("*", 4, -1));
            }
        }
        if (varName.equals("time") && subDiagram != null && (dp = subDiagram.getAttributes().getProperty("Time scale")) != null && !dp.getValue().toString().isEmpty()) {
            ru.biosoft.math.model.Node nodeFactor = this.parse(dp.getValue().toString()).jjtGetChild(0);
            return Utils.applyFunction((ru.biosoft.math.model.Node)result, (ru.biosoft.math.model.Node)nodeFactor, (ru.biosoft.math.model.Function)new PredefinedFunction("/", 4, -1));
        }
        if (this.dConnected.containsKey(uniqueName)) {
            return this.dConnected.get(uniqueName).jjtGetChild(0);
        }
        String mainVariable = this.getMasterVariable(uniqueName);
        if (mainVariable != null && !mainVariable.equals(uniqueName)) {
            String convFactor;
            result = this.parse(mainVariable).jjtGetChild(0);
            if (rightSide && (convFactor = this.conversionFactors.get(mainVariable)) != null && !convFactor.isEmpty()) {
                ru.biosoft.math.model.Node nodeFactor = this.parse(convFactor).jjtGetChild(0);
                result = Utils.applyFunction((ru.biosoft.math.model.Node)result, (ru.biosoft.math.model.Node)nodeFactor, (ru.biosoft.math.model.Function)new PredefinedFunction("/", 4, -1));
            }
        }
        return result;
    }

    private void processDirectedConnections() {
        for (AstStart formula : this.dConnected.values()) {
            this.applyUndirectedConnection((ru.biosoft.math.model.Node)formula);
        }
    }

    private void applyUndirectedConnection(ru.biosoft.math.model.Node expression) {
        for (int i = 0; i < expression.jjtGetNumChildren(); ++i) {
            ru.biosoft.math.model.Node child = expression.jjtGetChild(i);
            if (child instanceof AstVarNode) {
                String variableName = ((AstVarNode)child).getName();
                String mainVar = this.getMasterVariable(variableName);
                AstStart newChild = (AstStart)this.parse(mainVar);
                expression.jjtReplaceChild(expression.jjtGetChild(i), newChild.jjtGetChild(0));
                continue;
            }
            this.applyUndirectedConnection(child);
        }
    }

    public void adjustUniqueNames() {
        HashMap<Pair<String, Diagram>, String> replacements = new HashMap<Pair<String, Diagram>, String>();
        for (Map.Entry<Pair<String, Diagram>, String> e : this.oldVariablesToNew.entrySet()) {
            Pair<String, Diagram> key = e.getKey();
            String value = e.getValue();
            String[] parts = value.split("\\.");
            Object[] newParts = new String[parts.length];
            if (this.isConnected(value)) continue;
            newParts[parts.length - 1] = parts[parts.length - 1];
            boolean replaced = false;
            for (int i = 0; i < parts.length - 1; ++i) {
                String substitution = this.getMasterVariable(parts[i]);
                if (!parts[i].equals(substitution)) {
                    newParts[i] = substitution;
                    replaced = true;
                    continue;
                }
                newParts[i] = parts[i];
            }
            if (!replaced) continue;
            String newValue = StreamEx.of((Object[])newParts).joining((CharSequence)".");
            replacements.put(key, newValue);
        }
        this.oldVariablesToNew.putAll(replacements);
    }

    public Map<String, String> getVarPathMapping(String parentSubDiagram) {
        HashMap newPathMapping = new HashMap();
        EntryStream.of(this.substitutionMap).forEach(e -> {
            Pair key = (Pair)e.getKey();
            String newName = (String)e.getValue();
            String subDiagram = (String)key.getSecond();
            String path = subDiagram.isEmpty() ? (String)key.getFirst() : subDiagram.concat(VAR_PATH_DELIMITER).concat((String)key.getFirst());
            newPathMapping.put(path, newName);
        });
        HashMap<String, String> extendedPathMapping = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.varPathMapping.entrySet()) {
            String value = entry.getValue();
            extendedPathMapping.put(entry.getKey(), (String)newPathMapping.get(value));
        }
        for (Map.Entry<String, String> entry : newPathMapping.entrySet()) {
            if (this.varPathMapping.containsValue(entry.getKey())) continue;
            extendedPathMapping.put(entry.getKey(), entry.getValue());
        }
        if (!parentSubDiagram.isEmpty()) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry e3 : extendedPathMapping.entrySet()) {
                String newName = parentSubDiagram.concat(VAR_PATH_DELIMITER).concat((String)e3.getValue());
                String oldPath = (String)e3.getKey();
                String path = parentSubDiagram.concat(VAR_PATH_DELIMITER).concat(oldPath);
                result.put(path, newName);
            }
            return result;
        }
        return extendedPathMapping;
    }
}

