/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.GlobalViewOptions;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.DirectedConnection;
import biouml.standard.diagram.CompositeDiagramViewOptions;
import biouml.standard.diagram.PathwaySimulationDiagramViewBuilder;
import biouml.standard.diagram.Util;
import biouml.standard.type.Stub;
import biouml.workbench.graph.OnePointFinder;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import ru.biosoft.graph.OrientedPortFinder;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.PortFinder;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.EllipseView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;

public class CompositeDiagramViewBuilder
extends PathwaySimulationDiagramViewBuilder {
    protected static final int BORDER = 10;
    protected static final int PORTS_DISTANCE = 15;

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new CompositeDiagramViewOptions(null);
    }

    @Override
    public boolean createCompartmentCoreView(CompositeView container, Compartment compartment, DiagramViewOptions options, Graphics g) {
        if ("switch".equals(compartment.getKernel().getType())) {
            return this.createSwitchCoreView(container, compartment, (CompositeDiagramViewOptions)options, g);
        }
        if (compartment instanceof SubDiagram) {
            return this.createSubDiagramView(container, (SubDiagram)compartment, (CompositeDiagramViewOptions)options, g);
        }
        return super.createCompartmentCoreView(container, compartment, options, g);
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        if ("connection bus".equals(node.getKernel().getType())) {
            return this.createBusView(container, node, (CompositeDiagramViewOptions)options, g);
        }
        if ("constant".equals(node.getKernel().getType())) {
            return this.createConstantView(container, node, (CompositeDiagramViewOptions)options, g);
        }
        return super.createNodeCoreView(container, node, options, g);
    }

    protected boolean createConstantView(CompositeView constantView, Node node, CompositeDiagramViewOptions options, Graphics g) {
        constantView.add((View)new BoxView(CompositeDiagramViewBuilder.getBorderPen(node, options.getModulePen()), CompositeDiagramViewBuilder.getBrush(node, options.getConstantBrush()), 0, 0, 60, 40));
        String value = node.getAttributes().getProperty("Initial value").getValue().toString();
        constantView.add((View)new TextView(value, CompositeDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), g), 127);
        return false;
    }

    public boolean createSwitchCoreView(CompositeView container, Compartment compartment, CompositeDiagramViewOptions options, Graphics g) {
        try {
            Dimension size;
            ComplexTextView titleView = null;
            if (compartment.isShowTitle()) {
                titleView = new ComplexTextView(compartment.getTitle(), CompositeDiagramViewBuilder.getTitleFont(compartment, options.getCompartmentTitleFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
            }
            if ((size = compartment.getShapeSize()) == null) {
                size = new Dimension(100, 80);
            }
            container.add((View)new BoxView(CompositeDiagramViewBuilder.getBorderPen(compartment, options.getModulePen()), CompositeDiagramViewBuilder.getBrush(compartment, options.getSwitchBrush()), 0, 0, size.width, size.height));
            container.add((View)titleView, 127);
            container.setModel((Object)compartment);
            container.setActive(true);
            container.setLocation(compartment.getLocation());
            compartment.setView((View)container);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return false;
    }

    protected boolean createBusView(CompositeView busView, Node node, CompositeDiagramViewOptions options, Graphics g) {
        Object brushObj;
        Brush brush = options.getBusBrush();
        DynamicProperty dp = node.getAttributes().getProperty("color");
        if (dp != null && (brushObj = dp.getValue()) instanceof Brush) {
            brush = (Brush)brushObj;
        }
        busView.add((View)new EllipseView(options.getNodePen(), brush, 0.0f, 0.0f, 20.0f, 20.0f));
        return true;
    }

    protected boolean createSubDiagramView(CompositeView container, SubDiagram compartment, CompositeDiagramViewOptions options, Graphics g) {
        String title = compartment.getTitle();
        if (title == null || title.isEmpty()) {
            title = compartment.getName();
        }
        ComplexTextView titleView = new ComplexTextView(title, CompositeDiagramViewBuilder.getTitleFont(compartment, options.getCompartmentTitleFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        Dimension size = compartment.getShapeSize();
        if (size == null) {
            size = new Dimension(50, 50);
        }
        container.add((View)new BoxView(CompositeDiagramViewBuilder.getBorderPen(compartment, options.getModulePen()), CompositeDiagramViewBuilder.getBrush(compartment, options.getModuleBrush()), 0, 0, size.width, size.height));
        container.add((View)titleView, 127);
        Diagram diagram = compartment.getDiagram();
        ComplexTextView expView = null;
        if (diagram.getCurrentState() != null) {
            expView = new ComplexTextView(diagram.getCurrentStateName(), options.getStateTitleFont(), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
            Point titleLocation = titleView.getLocation();
            int newY = titleLocation.y - expView.getBounds().height;
            expView.setLocation(expView.getLocation().x, newY + expView.getBounds().height);
            titleView.setLocation(titleLocation.x, newY);
            container.add((View)expView, 127);
        }
        container.setModel((Object)compartment);
        container.setActive(true);
        container.setLocation(compartment.getLocation());
        compartment.setView((View)container);
        return false;
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions viewOptions, Graphics g) {
        CompositeDiagramViewOptions options = (CompositeDiagramViewOptions)viewOptions;
        String type = edge.getKernel().getType();
        if (type.equals("directed-edge") || type.equals("undirected-edge") || type.equals("note-edge")) {
            CompositeView view = new CompositeView();
            if (edge.getPath() == null) {
                Diagram.getDiagram(edge).getType().getSemanticController().recalculateEdgePath(edge);
            }
            SimplePath path = edge.getSimplePath();
            Pen pen = CompositeDiagramViewBuilder.getBorderPen(edge, options.getConnectionPen());
            Brush brush = CompositeDiagramViewBuilder.getBrush(edge, options.getConnectionBrush());
            ArrowView arrow = null;
            if (type.equals("directed-edge")) {
                DirectedConnection role;
                int w1 = 5;
                int w2 = 10;
                int h = 5;
                if (!options.isCollapsed()) {
                    w1 = 20;
                    w2 = 30;
                    h = 10;
                }
                arrow = new ArrowView(pen, brush, path, null, options.arrows ? ArrowView.createArrowTip((Pen)pen, (Brush)brush, (int)w1, (int)w2, (int)h) : null);
                Role edgeRole = edge.getRole();
                if (edgeRole instanceof DirectedConnection && (role = (DirectedConnection)edgeRole).getFunction() != null) {
                    ComplexTextView function = new ComplexTextView(role.getFunction(), CompositeDiagramViewBuilder.getTitleFont(edge, options.getDefaultFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
                    Point location = new Point(path.xpoints[path.npoints / 2] - function.getBounds().width / 2, path.ypoints[path.npoints / 2] + 3);
                    function.setLocation(location);
                    function.setActive(true);
                    function.setModel((Object)edge);
                    view.add((View)function);
                }
            } else if (type.equals("undirected-edge")) {
                arrow = new ArrowView(pen, brush, path, options.arrows ? ArrowView.createEllipseTip((Pen)pen, (Brush)brush, (int)2) : null, options.arrows ? ArrowView.createEllipseTip((Pen)pen, (Brush)brush, (int)2) : null);
            } else if (type.equals("note-edge")) {
                arrow = new ArrowView(options.getNoteLinkPen(), null, path, 0, 0);
            }
            if (arrow != null) {
                view.add(arrow);
                arrow.setActive(true);
                arrow.setModel((Object)edge);
            }
            if (edge.nodes().noneMatch(n -> n.getKernel() instanceof Stub.ConnectionPort)) {
                TextView titleView = null;
                if (arrow != null && edge.getTitle() != null && edge.getTitle().length() > 0) {
                    int alignment = 0;
                    float a = (float)(edge.getOutPort().y - edge.getInPort().y) / ((float)(edge.getOutPort().x - edge.getInPort().x) + 0.1f);
                    alignment = (double)Math.abs(a) < 0.2 ? 63 : 121;
                    Point middlePoint = arrow.getPathView().getMiddlePoint();
                    titleView = new TextView(edge.getTitle(), new Point(middlePoint.x, middlePoint.y), alignment, CompositeDiagramViewBuilder.getTitleFont(edge, options.connectionTitleFont), g);
                    titleView.move(titleView.getBounds().width / 2, 0);
                    if (edge.getPath().getBounds().intersects(titleView.getBounds())) {
                        titleView.move(0, -titleView.getBounds().height);
                    }
                    titleView.setActive(true);
                    titleView.setModel((Object)edge);
                }
                if (titleView != null) {
                    view.add(titleView);
                }
            }
            view.setModel((Object)edge);
            view.setActive(false);
            return view;
        }
        return super.createEdgeView(edge, viewOptions, g);
    }

    @Override
    public PortFinder getPortFinder(Node node) {
        if (Util.isModulePort(node)) {
            return new OnePointFinder(Util.getPortOrientation(node), this.getNodeBounds(node));
        }
        if (Util.isPublicPort(node) || Util.isPropagatedPort(node)) {
            return new OnePointFinder(Util.getPortOrientation(node).opposite(), this.getNodeBounds(node));
        }
        if (Util.isPrivatePort(node)) {
            OrientedPortFinder portFinder = new OrientedPortFinder();
            for (Edge e : node.edges()) {
                if (Util.isConnection(e)) {
                    portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.TOP, OrthogonalPathLayouter.Orientation.TOP);
                    portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.RIGHT, OrthogonalPathLayouter.Orientation.RIGHT);
                    portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.BOTTOM, OrthogonalPathLayouter.Orientation.BOTTOM);
                    portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.LEFT, OrthogonalPathLayouter.Orientation.LEFT);
                    continue;
                }
                portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.TOP, OrthogonalPathLayouter.Orientation.BOTTOM);
                portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.RIGHT, OrthogonalPathLayouter.Orientation.LEFT);
                portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.BOTTOM, OrthogonalPathLayouter.Orientation.TOP);
                portFinder.addPort((Object)e, OrthogonalPathLayouter.Orientation.LEFT, OrthogonalPathLayouter.Orientation.RIGHT);
            }
            return portFinder;
        }
        return super.getPortFinder(node);
    }
}

