/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.diagram.Util;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.util.bean.BeanInfoEx2;
import ru.biosoft.workbench.editors.GenericMultiSelectEditor;

public class CloneNodeAction
extends BackgroundDynamicAction {
    public boolean isApplicable(Object object) {
        return object instanceof Diagram && ((Diagram)((Object)object)).getType().getSemanticController() instanceof PathwaySimulationSemanticController;
    }

    public Object getProperties(Object model, List<DataElement> selectedItems) {
        if (!this.isApplicable(selectedItems)) {
            return null;
        }
        return new CloneNodeActionParameters(selectedItems);
    }

    boolean isApplicable(List<DataElement> selectedItems) {
        return selectedItems.size() >= 1 && selectedItems.get(0) instanceof Node && ((Node)selectedItems.get(0)).getRole() instanceof VariableRole;
    }

    public JobControl getJobControl(Object model, final List<DataElement> selectedItems, final Object properties) throws Exception {
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                try {
                    if (!CloneNodeAction.this.isApplicable(selectedItems)) {
                        return;
                    }
                    CloneNodeActionParameters parameters = (CloneNodeActionParameters)properties;
                    Node node = (Node)((Object)selectedItems.get(0));
                    SemanticController controller = Diagram.getDiagram(node).getType().getSemanticController();
                    if (parameters.separateClones) {
                        for (Node reactionNode : parameters.reactions) {
                            Point newLocation = node.getLocation();
                            newLocation.translate(5, 5);
                            Node clonedNode = controller.cloneNode(node, parameters.getNodeName() + "_" + reactionNode.getName(), newLocation);
                            clonedNode.save();
                            for (Edge e : reactionNode.getEdges()) {
                                if (e.getOtherEnd(reactionNode) != node) continue;
                                CloneNodeAction.swapNode(node, clonedNode, e);
                            }
                        }
                    } else {
                        Point newLocation = node.getLocation();
                        newLocation.translate(5, 5);
                        Node clonedNode = controller.cloneNode(node, parameters.getNodeName(), newLocation);
                        clonedNode.save();
                        for (Node reactionNode : parameters.reactions) {
                            for (Edge e : reactionNode.getEdges()) {
                                if (e.getOtherEnd(reactionNode) != node) continue;
                                CloneNodeAction.swapNode(node, clonedNode, e);
                            }
                        }
                    }
                    this.resultsAreReady(new Object[]{Diagram.getDiagram(node)});
                }
                catch (Exception e) {
                    throw new JobControlException((Throwable)e);
                }
            }
        };
    }

    public static void swapNode(@Nonnull Node oldNode, @Nonnull Node newNode, @Nonnull Edge e) {
        if (e.getInput() == oldNode) {
            e.setInput(newNode);
            newNode.addEdge(e);
        } else if (e.getOutput() == oldNode) {
            e.setOutput(newNode);
            newNode.addEdge(e);
        } else {
            throw new IllegalArgumentException((Object)((Object)e) + ": Supplied node " + (Object)((Object)oldNode) + " is not my input or output");
        }
    }

    public static class ReactionSelector
    extends GenericMultiSelectEditor {
        protected String[] getAvailableValues() {
            Set<String> list = ((CloneNodeActionParameters)this.getBean()).getAvailableReactions();
            return list.toArray(new String[list.size()]);
        }
    }

    public static class CloneNodeActionParametersBeanInfo
    extends BeanInfoEx2<CloneNodeActionParameters> {
        public CloneNodeActionParametersBeanInfo() {
            super(CloneNodeActionParameters.class);
        }

        protected void initProperties() throws Exception {
            this.add("nodeName");
            this.add("reactions", ReactionSelector.class);
            this.add("separateClones");
        }
    }

    public static class CloneNodeActionParameters {
        private final Map<String, Node> availableReactions;
        private String nodeName;
        private boolean separateClones = false;
        private Node[] reactions = new Node[0];

        @PropertyName(value="Separate clone for each reaction")
        @PropertyDescription(value="Create separate clone for each reaction.")
        public boolean isSeparateClones() {
            return this.separateClones;
        }

        public void setSeparateClones(boolean separateClones) {
            this.separateClones = separateClones;
        }

        @PropertyName(value="Name")
        @PropertyDescription(value="name of the new node.")
        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @PropertyName(value="Reactions to redirect")
        @PropertyDescription(value="Reactions which will be redirected to the new node.")
        public String[] getReactions() {
            return (String[])StreamEx.of((Object[])this.reactions).map(r -> r.getName()).toArray(String[]::new);
        }

        public void setReactions(String[] reactions) {
            this.reactions = (Node[])StreamEx.of((Object[])reactions).map(r -> this.availableReactions.get(r)).toArray(Node[]::new);
        }

        public Set<String> getAvailableReactions() {
            return this.availableReactions.keySet();
        }

        public CloneNodeActionParameters(List<DataElement> elements) {
            Node node = (Node)elements.get(0);
            this.nodeName = DefaultSemanticController.generateUniqueNodeName(node.getCompartment(), node.getName());
            this.availableReactions = ((StreamEx)node.edges().map(e -> e.getOtherEnd(node)).filter(Util::isReaction)).toMap(n -> n.getName(), n -> n);
        }
    }
}

