/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.standard.diagram.CompositeSemanticController;
import biouml.standard.diagram.SubDiagramProperties;
import biouml.standard.diagram.Util;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.List;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.util.bean.BeanInfoEx2;

public class ChangeSubdiagramAction
extends BackgroundDynamicAction {
    public boolean isApplicable(Object object) {
        return object instanceof Diagram && ((Diagram)((Object)object)).getType().getSemanticController() instanceof CompositeSemanticController;
    }

    public Object getProperties(Object model, List<DataElement> selectedItems) {
        if (!this.isApplicable(selectedItems)) {
            return null;
        }
        return new ChangeSubdiagramActionParameters(selectedItems);
    }

    boolean isApplicable(List<DataElement> selectedItems) {
        return selectedItems.size() == 1 && selectedItems.get(0) instanceof SubDiagram;
    }

    public JobControl getJobControl(Object model, final List<DataElement> selectedItems, final Object properties) throws Exception {
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                try {
                    if (!ChangeSubdiagramAction.this.isApplicable(selectedItems)) {
                        return;
                    }
                    ChangeSubdiagramActionParameters parameters = (ChangeSubdiagramActionParameters)properties;
                    SubDiagram subdiagram = (SubDiagram)((Object)selectedItems.get(0));
                    Diagram diagram = Diagram.getDiagram(subdiagram);
                    SemanticController controller = diagram.getType().getSemanticController();
                    DataElementPath path = parameters.getDataElementPath();
                    SubDiagramProperties properties2 = new SubDiagramProperties(diagram);
                    properties2.setDiagramPath(path);
                    properties2.setExternal(true);
                    properties2.setName(subdiagram.getName());
                    DiagramElementGroup deg = controller.createInstance(subdiagram.getCompartment(), SubDiagram.class, subdiagram.getLocation(), properties2);
                    SubDiagram newSubdiagram = (SubDiagram)deg.get(0);
                    newSubdiagram.setShapeSize(subdiagram.getShapeSize());
                    for (Node node : subdiagram.getNodes()) {
                        Node newNode = ChangeSubdiagramAction.this.findPort(newSubdiagram, Util.getPortVariable(node));
                        if (newNode != null) {
                            for (Edge e : node.getEdges()) {
                                ChangeSubdiagramAction.swapNode(node, newNode, e);
                            }
                            continue;
                        }
                        for (Edge e : node.getEdges()) {
                            diagram.remove(e.getName());
                        }
                    }
                    diagram.getType().getSemanticController().remove(subdiagram);
                    this.resultsAreReady(new Object[]{diagram});
                }
                catch (Exception e) {
                    throw new JobControlException((Throwable)e);
                }
            }
        };
    }

    private Node findPort(SubDiagram subdiagram, String varName) {
        return ((StreamEx)subdiagram.stream(Node.class).filter(n -> Util.getPortVariable(n).equals(varName))).findAny().orElse(null);
    }

    public static void swapNode(@Nonnull Node oldNode, @Nonnull Node newNode, @Nonnull Edge e) {
        if (e.getInput() == oldNode) {
            oldNode.removeEdge(e);
            e.setInput(newNode);
            newNode.addEdge(e);
        } else if (e.getOutput() == oldNode) {
            oldNode.removeEdge(e);
            e.setOutput(newNode);
            newNode.addEdge(e);
        } else {
            throw new IllegalArgumentException((Object)((Object)e) + ": Supplied node " + (Object)((Object)oldNode) + " is not my input or output");
        }
    }

    public static class ChangeSubdiagramActionParametersParametersBeanInfo
    extends BeanInfoEx2<ChangeSubdiagramActionParameters> {
        public ChangeSubdiagramActionParametersParametersBeanInfo() {
            super(ChangeSubdiagramActionParameters.class);
        }

        protected void initProperties() throws Exception {
            this.add("path");
        }
    }

    public static class ChangeSubdiagramActionParameters {
        private DataElementPath path;

        @PropertyName(value="Subdiagram path")
        @PropertyDescription(value="Subdiagram path.")
        public DataElementPath getDataElementPath() {
            return this.path;
        }

        public void setDataElementPath(DataElementPath path) {
            this.path = path;
        }

        public ChangeSubdiagramActionParameters(List<DataElement> des) {
        }
    }
}

