/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.List;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.util.bean.BeanInfoEx2;

public class ChangePortTypeAction
extends BackgroundDynamicAction {
    public boolean isApplicable(Object object) {
        return object instanceof Diagram && ((Diagram)((Object)object)).getType().getSemanticController() instanceof PathwaySimulationSemanticController;
    }

    public Object getProperties(Object model, List<DataElement> selectedItems) {
        if (!this.isApplicable(selectedItems)) {
            return null;
        }
        return new ChangePortTypeActionParameters(selectedItems);
    }

    boolean isApplicable(List<DataElement> selectedItems) {
        return selectedItems.size() == 1 && selectedItems.get(0) instanceof DiagramElement && Util.isPort((DiagramElement)selectedItems.get(0));
    }

    public JobControl getJobControl(final Object model, final List<DataElement> selectedItems, final Object properties) throws Exception {
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                try {
                    if (!ChangePortTypeAction.this.isApplicable(selectedItems)) {
                        return;
                    }
                    Diagram diagram = (Diagram)((Object)model);
                    ChangePortTypeActionParameters parameters = (ChangePortTypeActionParameters)properties;
                    Node node = (Node)((Object)selectedItems.get(0));
                    PathwaySimulationSemanticController controller = (PathwaySimulationSemanticController)diagram.getType().getSemanticController();
                    PortProperties properties2 = new PortProperties(diagram, Stub.ConnectionPort.class);
                    properties2.setVarName(Util.getPortVariable(node));
                    properties2.setAccessType(Util.getAccessType(node));
                    properties2.setName(node.getName());
                    properties2.setPortType(parameters.getPortType());
                    for (Edge e : node.edges()) {
                        e.getCompartment().remove(e.getName());
                    }
                    Compartment c = node.getCompartment();
                    c.remove(node.getName());
                    Node newNode = (Node)controller.createInstance(c, Stub.ConnectionPort.class, node.getLocation(), properties2).getElement();
                    Util.setPortOrientation(newNode, Util.getPortOrientation(node));
                    diagram.put(newNode);
                    for (Edge e : node.getEdges()) {
                        ChangePortTypeAction.swapNode(node, newNode, e);
                    }
                }
                catch (Exception e) {
                    throw new JobControlException((Throwable)e);
                }
            }
        };
    }

    public static void swapNode(@Nonnull Node oldNode, @Nonnull Node newNode, @Nonnull Edge e) {
        if (e.getInput() == oldNode) {
            oldNode.removeEdge(e);
            e.setInput(newNode);
            newNode.addEdge(e);
        } else if (e.getOutput() == oldNode) {
            oldNode.removeEdge(e);
            e.setOutput(newNode);
            newNode.addEdge(e);
        } else {
            throw new IllegalArgumentException((Object)((Object)e) + ": Supplied node " + (Object)((Object)oldNode) + " is not my input or output");
        }
    }

    public static class ChangePortTypeActionParametersBeanInfo
    extends BeanInfoEx2<ChangePortTypeActionParameters> {
        public ChangePortTypeActionParametersBeanInfo() {
            super(ChangePortTypeActionParameters.class);
        }

        protected void initProperties() throws Exception {
            this.addWithTags("portType", new String[]{"input", "output", "contact"});
        }
    }

    public static class ChangePortTypeActionParameters {
        private String portType = "contact";

        @PropertyName(value="Port type")
        @PropertyDescription(value="Port type.")
        public String getPortType() {
            return this.portType;
        }

        public void setPortType(String portType) {
            this.portType = portType;
        }

        public ChangePortTypeActionParameters(List<DataElement> elements) {
        }
    }
}

