/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.diagram;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementProperties;
import biouml.model.Node;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.editor.ViewEditorPane;

@PropertyName(value="Bus properties")
@PropertyDescription(value="Bus properties.")
public class BusProperties
extends Option
implements InitialElementProperties {
    public static final String NEW_VARIABLE_CONSTANT = "<new>";
    protected String name;
    protected VariableRole variable;
    protected EModel model;

    public BusProperties(EModel model) {
        this.model = model;
    }

    public BusProperties(EModel model, String name) {
        this(model);
        this.setName(name);
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="New variable name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Variable var = this.model.getVariable(name);
        this.name = name;
        this.variable = var instanceof VariableRole ? (VariableRole)var : null;
        this.firePropertyChange("*", null, null);
    }

    public void setVariable(String variable) {
        if (variable.equals(NEW_VARIABLE_CONSTANT)) {
            if (this.variable != null) {
                this.name = "";
                this.variable = null;
            }
        } else if (variable.startsWith("$")) {
            this.setName(variable.substring(1));
        }
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Variable, if <new> is chosen then new variable name will be specified by name field")
    public String getVariable() {
        if (this.variable == null) {
            return NEW_VARIABLE_CONSTANT;
        }
        return this.variable.getName();
    }

    @Override
    public DiagramElementGroup createElements(Compartment compartment, Point location, ViewEditorPane viewPane) throws Exception {
        DiagramElement[] nodes;
        Node otherNode;
        if (this.name.isEmpty()) {
            throw new Exception("Empty bus name");
        }
        String nodeName = BusProperties.generateUniqueBusName(compartment, this.name);
        Node node = new Node(compartment, nodeName, (Base)new Stub.Bus(null, nodeName));
        node.setNotificationEnabled(false);
        if (this.variable == null) {
            this.variable = new VariableRole(node, 0.0);
        }
        if ((otherNode = (Node)StreamEx.of((Object[])(nodes = this.variable.getAssociatedElements())).select(Node.class).without((Object)node).findAny().orElse(null)) != null && otherNode.getAttributes().getProperty("color") != null) {
            node.getAttributes().add(otherNode.getAttributes().getProperty("color"));
        } else {
            node.getAttributes().add(new DynamicProperty("color", Brush.class, (Object)new Brush((Paint)Color.gray)));
        }
        this.variable.addAssociatedElement(node);
        node.setRole(this.variable);
        node.setTitle(this.variable.getName().replace("$", ""));
        if (viewPane != null) {
            node.setNotificationEnabled(true);
            boolean isNotificationEnabled = compartment.isNotificationEnabled();
            compartment.setNotificationEnabled(true);
            viewPane.add((Object)node, location);
            compartment.setNotificationEnabled(isNotificationEnabled);
        }
        return new DiagramElementGroup(node);
    }

    public static String generateUniqueBusName(Compartment parent, String name) {
        String result = name;
        int index = 0;
        while (parent.get(result) != null) {
            result = name + "(" + ++index + ")";
        }
        return result;
    }
}

