/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard;

import biouml.model.Module;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.workbench.graphsearch.QueryEngineSupport;
import biouml.workbench.graphsearch.QueryOptions;
import biouml.workbench.graphsearch.SearchElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementPathSet;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.jobcontrol.JobControl;

public class StandardQueryEngine
extends QueryEngineSupport {
    protected static final Logger log = Logger.getLogger(StandardQueryEngine.class.getName());

    @Override
    public String getName(TargetOptions dbOptions) {
        return "General collection search";
    }

    @Override
    public int canSearchLinked(TargetOptions dbOptions) {
        Module module;
        DataElementPathSet collections = dbOptions.getUsedCollectionPaths();
        if (collections.size() == 1 && (module = (Module)collections.first().optDataElement(Module.class)) != null) {
            return 10;
        }
        return 0;
    }

    @Override
    public SearchElement[] searchLinked(SearchElement[] startNodes, QueryOptions queryOptions, TargetOptions dbOptions, JobControl jobControl) throws Exception {
        Module module = (Module)dbOptions.getUsedCollectionPaths().first().getDataElement(Module.class);
        HashSet<SearchElement> elements = new HashSet<SearchElement>();
        if (startNodes != null) {
            for (SearchElement startNode : startNodes) {
                this.internalSearchLinked(startNode, queryOptions.getDirection(), queryOptions.getDepth(), elements, module, jobControl);
            }
        }
        return elements.toArray(new SearchElement[elements.size()]);
    }

    protected void internalSearchLinked(SearchElement node, int direction, float depth, Set<SearchElement> elements, Module module, JobControl jobControl) throws Exception {
        if (depth == 0.0f) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("'node' can't be null");
        }
        Base kernel = node.getBase();
        if (kernel == null) {
            throw new IllegalArgumentException("Kernel of 'node' can't be null node=" + (Object)((Object)node));
        }
        if (jobControl != null) {
            jobControl.setPreparedness(0);
        }
        HashSet<SearchElement> addedElements = new HashSet<SearchElement>();
        if (kernel instanceof Reaction) {
            for (SpecieReference sr : ((Reaction)kernel).getSpecieReferences()) {
                Base specie;
                int linkDirection;
                SpecieReference[] relationType = null;
                if (sr.getRole().equals("product")) {
                    linkDirection = 1;
                    relationType = "product";
                } else if (sr.getRole().equals("reactant")) {
                    linkDirection = 0;
                    relationType = "reactant";
                } else {
                    linkDirection = 0;
                    relationType = "modifier";
                }
                if (direction != linkDirection && direction != 2 || (specie = this.getSpecieBase(module, sr)) == null) continue;
                SearchElement specieNodeInfo = new SearchElement(specie);
                specieNodeInfo.setLinkedFromPath(this.getPath(node.getBase()));
                specieNodeInfo.setLinkedLength(0.5f);
                specieNodeInfo.setLinkedDirection(linkDirection);
                specieNodeInfo.setRelationType((String)relationType);
                if (elements.contains((Object)specieNodeInfo)) continue;
                elements.add(specieNodeInfo);
                addedElements.add(specieNodeInfo);
            }
        } else {
            DataCollection<SemanticRelation> relations;
            DataCollection<Reaction> reactions = this.getReactions(module, kernel, direction);
            if (reactions != null) {
                ArrayList<SearchElement> addedReactions = new ArrayList<SearchElement>();
                for (Reaction reaction : reactions) {
                    SearchElement reactionNodeInfo = new SearchElement(reaction);
                    reactionNodeInfo.setLinkedFromPath(this.getPath(node.getBase()));
                    for (SpecieReference sr : reaction.getSpecieReferences()) {
                        Base base = this.getSpecieBase(module, sr);
                        if (base == null || !base.getName().equals(node.getBase().getName())) continue;
                        reactionNodeInfo.setLinkedLength(0.5f);
                        if (sr.getRole().equals("product")) {
                            reactionNodeInfo.setLinkedDirection(0);
                            reactionNodeInfo.setRelationType("product");
                            break;
                        }
                        if (sr.getRole().equals("reactant")) {
                            reactionNodeInfo.setLinkedDirection(1);
                            reactionNodeInfo.setRelationType("reactant");
                            break;
                        }
                        reactionNodeInfo.setLinkedDirection(1);
                        reactionNodeInfo.setRelationType("modifier");
                        break;
                    }
                    if (elements.contains((Object)reactionNodeInfo)) continue;
                    elements.add(reactionNodeInfo);
                    addedReactions.add(reactionNodeInfo);
                    addedElements.add(reactionNodeInfo);
                }
            }
            if (depth >= 1.0f && (relations = this.getSemanticRelations(module, kernel, direction)) != null) {
                for (SemanticRelation rel : relations) {
                    String inName = rel.getInputElementName();
                    String outName = rel.getOutputElementName();
                    Base inputElement = (Base)module.getKernel(DataElementPath.create((String)"Data").getRelativePath(inName).toString());
                    Base outputElement = (Base)module.getKernel(DataElementPath.create((String)"Data").getRelativePath(outName).toString());
                    if (null != inputElement && kernel != inputElement) {
                        SearchElement inputNodeInfo = new SearchElement(inputElement);
                        inputNodeInfo.setLinkedFromPath(this.getPath(node.getBase()));
                        inputNodeInfo.setLinkedLength(1.0f);
                        inputNodeInfo.setLinkedDirection(0);
                        inputNodeInfo.setRelationType("semantic");
                        if (!elements.contains((Object)inputNodeInfo)) {
                            elements.add(inputNodeInfo);
                            addedElements.add(inputNodeInfo);
                        }
                    }
                    if (null == outputElement || kernel == outputElement) continue;
                    SearchElement outputNodeInfo = new SearchElement(outputElement);
                    outputNodeInfo.setLinkedFromPath(this.getPath(node.getBase()));
                    outputNodeInfo.setLinkedLength(1.0f);
                    outputNodeInfo.setLinkedDirection(1);
                    outputNodeInfo.setRelationType("semantic");
                    if (elements.contains((Object)outputNodeInfo)) continue;
                    elements.add(outputNodeInfo);
                    addedElements.add(outputNodeInfo);
                }
            }
        }
        int addedSize = addedElements.size();
        int i = 0;
        Iterator specieIterator = addedElements.iterator();
        while (specieIterator.hasNext()) {
            ++i;
            if (jobControl != null) {
                jobControl.setPreparedness((int)((double)i * 100.0 / (double)addedSize));
            }
            SearchElement specieNodeInfo = (SearchElement)((Object)specieIterator.next());
            this.internalSearchLinked(specieNodeInfo, direction, depth - specieNodeInfo.getLinkedLength(), elements, module, null);
        }
        if (jobControl != null) {
            jobControl.setPreparedness(100);
        }
    }

    protected Base getSpecieBase(Module module, SpecieReference sr) throws Exception {
        String specieName = sr.getSpecie();
        Base base = (Base)module.getKernel(specieName);
        if (null == base) {
            log.log(Level.SEVERE, "Cannot find reaction species by name " + specieName);
        }
        return base;
    }

    protected DataCollection<Reaction> getReactions(Module module, Base kernel, int direction) throws Exception {
        DataCollection[] dcList = CollectionFactoryUtils.findDataCollections((DataElementPath)module.getCompletePath(), Reaction.class);
        if (dcList == null || dcList.length == 0) {
            return null;
        }
        VectorDataCollection reactions = new VectorDataCollection(module.getType().getCategory(Reaction.class), null, new Properties());
        String kernelName = CollectionFactory.getRelativeName((DataElement)kernel, (DataCollection)module);
        if (kernelName != null) {
            for (DataCollection fullReactions : dcList) {
                block1: for (Reaction r : fullReactions) {
                    Iterator<SpecieReference> iterator = r.iterator();
                    while (iterator.hasNext()) {
                        SpecieReference node = iterator.next();
                        if (!node.getSpecie().equals(kernelName)) continue;
                        if (1 == direction) {
                            if (!"reactant".equalsIgnoreCase(node.getRole()) && !"modifier".equalsIgnoreCase(node.getRole())) continue;
                            reactions.put((DataElement)r);
                            continue block1;
                        }
                        if (0 == direction) {
                            if (!"product".equalsIgnoreCase(node.getRole())) continue;
                            reactions.put((DataElement)r);
                            continue block1;
                        }
                        if (2 == direction) {
                            if (!"reactant".equalsIgnoreCase(node.getRole()) && !"product".equalsIgnoreCase(node.getRole()) && !"modifier".equalsIgnoreCase(node.getRole())) continue;
                            reactions.put((DataElement)r);
                            continue block1;
                        }
                        if (-1 != direction) continue;
                        reactions.put((DataElement)r);
                        continue block1;
                    }
                }
            }
        }
        return reactions;
    }

    protected DataCollection<SemanticRelation> getSemanticRelations(Module module, Base kernel, int direction) throws Exception {
        DataCollection[] relationCollections = CollectionFactoryUtils.findDataCollections((DataElementPath)module.getCompletePath(), SemanticRelation.class);
        if (relationCollections == null || relationCollections.length == 0) {
            return null;
        }
        VectorDataCollection relations = new VectorDataCollection(module.getType().getCategory(SemanticRelation.class), null, new Properties());
        DataCollection<?> category = module.getCategory(kernel.getClass());
        if (category != null) {
            String kernelName = DataElementPath.EMPTY_PATH.getChildPath(new String[]{kernel.getOrigin().getName(), kernel.getName()}).toString();
            for (DataCollection fullRelations : relationCollections) {
                for (SemanticRelation r : fullRelations) {
                    if (1 == direction) {
                        if (!r.getInputElementName().equals(kernelName)) continue;
                        relations.put((DataElement)r);
                        continue;
                    }
                    if (0 == direction) {
                        if (!r.getOutputElementName().equals(kernelName)) continue;
                        relations.put((DataElement)r);
                        continue;
                    }
                    if (2 != direction && -1 != direction || !r.getInputElementName().equals(kernelName) && !r.getOutputElementName().equals(kernelName)) continue;
                    relations.put((DataElement)r);
                }
            }
        }
        return relations;
    }
}

