/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard;

import biouml.model.Diagram;
import biouml.model.DiagramType;
import biouml.model.Module;
import biouml.model.ModuleType;
import biouml.model.util.DiagramXmlTransformer;
import biouml.model.xml.XmlDiagramType;
import biouml.standard.diagram.GeneNetworkDiagramType;
import biouml.standard.diagram.MetabolicPathwayDiagramType;
import biouml.standard.diagram.PathwayDiagramType;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.diagram.SemanticNetworkDiagramType;
import biouml.standard.type.Base;
import biouml.standard.type.Cell;
import biouml.standard.type.Compartment;
import biouml.standard.type.Complex;
import biouml.standard.type.Concept;
import biouml.standard.type.Constant;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.Gene;
import biouml.standard.type.Protein;
import biouml.standard.type.Publication;
import biouml.standard.type.RNA;
import biouml.standard.type.Reaction;
import biouml.standard.type.RelationType;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.Species;
import biouml.standard.type.Stub;
import biouml.standard.type.Substance;
import biouml.standard.type.Unit;
import biouml.standard.type.access.ReactionTransformer;
import biouml.standard.type.access.TitleIndex;
import com.developmentontheedge.application.Application;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.DefaultQuerySystem;
import ru.biosoft.access.FileImagesDataCollection;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.Repository;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementSupport;
import ru.biosoft.access.support.BeanInfoEntryTransformer;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.util.ObjectExtensionRegistry;

public class StandardModuleType
extends DataElementSupport
implements ModuleType {
    private static final ObjectExtensionRegistry<DiagramType> diagramTypes = new ObjectExtensionRegistry("biouml.workbench.diagramType", DiagramType.class);
    private static final List<String> OBSOLETE_TYPES = Arrays.asList("sbgn_simulation_ext.xml", "sbgn_simulation.xml", "arterialTree.xml");
    protected Logger log = Logger.getLogger(StandardModuleType.class.getName());
    public static final String VERSION = "0.7.7";
    public static final String DATABASE_INFO = "database info";
    public static final String RELATION_TYPE = "relation type";
    public static final String SPECIES = "species";
    public static final String UNIT = "unit";
    protected HashMap<Class<? extends DataElement>, String> types = new HashMap();

    protected StandardModuleType(String name) {
        super(name, null);
        this.initCategories();
    }

    public StandardModuleType() {
        super(Application.getGlobalValue((String)"ApplicationName") + " standard", null);
        this.initCategories();
    }

    protected void initCategories() {
        this.types.put(Cell.class, "Data/cell");
        this.types.put(Compartment.class, "Data/compartment");
        this.types.put(Diagram.class, "Diagrams");
        this.types.put(Concept.class, "Data/concept");
        this.types.put(Complex.class, "Data/complex");
        this.types.put(Substance.class, "Data/substance");
        this.types.put(Gene.class, "Data/gene");
        this.types.put(RNA.class, "Data/rna");
        this.types.put(Protein.class, "Data/protein");
        this.types.put(SemanticRelation.class, "Data/relation");
        this.types.put(Reaction.class, "Data/reaction");
        this.types.put(Constant.class, "Data/constant");
        this.types.put(Publication.class, "Data/literature");
        this.types.put(DatabaseInfo.class, "Dictionaries/database info");
        this.types.put(Species.class, "Dictionaries/species");
        this.types.put(Unit.class, "Dictionaries/unit");
        this.types.put(RelationType.class, "Dictionaries/relation type");
    }

    public static StreamEx<Class<? extends DiagramType>> getGeneralPurposeTypes() {
        return ((StreamEx)diagramTypes.stream().filter(DiagramType::isGeneralPurpose)).map(Object::getClass);
    }

    @Override
    public Class<? extends DiagramType>[] getDiagramTypes() {
        return (Class[])StandardModuleType.getGeneralPurposeTypes().append((Object[])new Class[]{PathwayDiagramType.class, PathwaySimulationDiagramType.class, SemanticNetworkDiagramType.class, MetabolicPathwayDiagramType.class, GeneNetworkDiagramType.class}).toArray(Class[]::new);
    }

    @Override
    public String[] getXmlDiagramTypes() {
        List nameList = XmlDiagramType.getTypesCollection().getNameList();
        nameList.removeAll(OBSOLETE_TYPES);
        return nameList.toArray(new String[nameList.size()]);
    }

    @Override
    public boolean isCategorySupported() {
        return true;
    }

    @Override
    public String getCategory(Class<? extends DataElement> c) {
        try {
            ClassLoading.loadClass((String)c.getName(), null);
        }
        catch (LoggedClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown kernel class: " + c.getName());
        }
        String category = this.types.get(c);
        if (category == null && !Stub.class.isAssignableFrom(c)) {
            try {
                for (Map.Entry<Class<? extends DataElement>, String> entry : this.types.entrySet()) {
                    Class<? extends DataElement> type = entry.getKey();
                    try {
                        String baseType;
                        String kernelType;
                        DataElement de;
                        DataElement obj = type.getConstructor(DataCollection.class, String.class).newInstance(null, "test");
                        if (!(obj instanceof Base) || !((de = c.getConstructor(DataCollection.class, String.class).newInstance(null, "test")) instanceof Base) || !(kernelType = ((Base)de).getType()).startsWith(baseType = ((Base)obj).getType()) || !obj.getClass().isInstance(de)) continue;
                        return entry.getValue();
                    }
                    catch (NoSuchMethodException e) {
                        this.log.info("Incorrect type: " + type.getName());
                    }
                }
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Unexpected error", t);
                return null;
            }
        }
        return category;
    }

    @Override
    public Module createModule(Repository parent, String name) throws Exception {
        Properties primary = new Properties();
        primary.setProperty("name", name);
        primary.setProperty("class", LocalRepository.class.getName());
        Properties transformed = new Properties();
        transformed.setProperty("class", Module.class.getName());
        transformed.setProperty("module-type", StandardModuleType.class.getName());
        Module module = (Module)CollectionFactoryUtils.createDerivedCollection((Repository)parent, (String)name, (Properties)primary, (Properties)transformed, (String)name);
        LocalRepository moduleLR = (LocalRepository)module.getPrimaryCollection();
        Repository dataDC = CollectionFactoryUtils.createLocalRepository((Repository)moduleLR, (String)"Data");
        Repository metadataDC = CollectionFactoryUtils.createLocalRepository((Repository)moduleLR, (String)"Dictionaries");
        module.put((DataElement)metadataDC);
        Properties props = new Properties();
        props.setProperty("name", "Images");
        props.setProperty("fileFilter", "bmp jpg jpeg gif png");
        props.setProperty("class", FileImagesDataCollection.class.getName());
        FileImagesDataCollection imagesDC = (FileImagesDataCollection)CollectionFactoryUtils.createSubDirCollection((Repository)moduleLR, (String)"Images", (Properties)props);
        module.put((DataElement)imagesDC);
        this.createDataCollection("cell", dataDC, Cell.class);
        DataCollection dc = (DataCollection)dataDC.get("cell");
        dc.getInfo().writeProperty("id-format", "CEL0000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("compartment", dataDC, Compartment.class);
        dc = (DataCollection)dataDC.get("compartment");
        dc.getInfo().writeProperty("id-format", "CMP0000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("concept", dataDC, Concept.class);
        dc = (DataCollection)dataDC.get("concept");
        dc.getInfo().writeProperty("id-format", "CPT000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("complex", dataDC, Complex.class);
        dc = (DataCollection)dataDC.get("complex");
        dc.getInfo().writeProperty("id-format", "CPX000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("substance", dataDC, Substance.class);
        dc = (DataCollection)dataDC.get("substance");
        dc.getInfo().writeProperty("id-format", "SBS000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("gene", dataDC, Gene.class);
        dc = (DataCollection)dataDC.get("gene");
        dc.getInfo().writeProperty("id-format", "GEN000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("rna", dataDC, RNA.class);
        dc = (DataCollection)dataDC.get("rna");
        dc.getInfo().writeProperty("id-format", "RNA000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("protein", dataDC, Protein.class);
        dc = (DataCollection)dataDC.get("protein");
        dc.getInfo().writeProperty("id-format", "PRT000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("relation", dataDC, SemanticRelation.class);
        dc = (DataCollection)dataDC.get("relation");
        dc.getInfo().writeProperty("id-format", "RLT000000");
        this.createDataCollection("reaction", dataDC, Reaction.class, ReactionTransformer.class);
        dc = (DataCollection)dataDC.get("reaction");
        dc.getInfo().writeProperty("id-format", "RCT000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection("literature", dataDC, Publication.class);
        dc = (DataCollection)dataDC.get("literature");
        dc.getInfo().writeProperty("id-format", "LIT000000");
        dc.getInfo().writeProperty("querySystem", DefaultQuerySystem.class.getName());
        dc.getInfo().writeProperty("querySystem.indexes", "title");
        dc.getInfo().writeProperty("index.title", TitleIndex.class.getName());
        this.createDataCollection(DATABASE_INFO, metadataDC, DatabaseInfo.class);
        this.createDataCollection(RELATION_TYPE, metadataDC, RelationType.class);
        this.createDataCollection(SPECIES, metadataDC, Species.class);
        this.createDataCollection(UNIT, metadataDC, Unit.class);
        String diagramHistoryPath = Application.getGlobalValue((String)"HistoryDiagrams", null);
        Properties additional = new Properties();
        if (diagramHistoryPath != null) {
            additional.setProperty("history-collection", diagramHistoryPath);
        }
        CollectionFactoryUtils.createTransformedFileCollection((Repository)moduleLR, (String)"Diagrams", (String)"", DiagramXmlTransformer.class, (Properties)additional);
        return module;
    }

    protected void createDataCollection(String name, Repository dataDC, Class<? extends DataElement> dataElementType) throws Exception {
        this.createDataCollection(name, dataDC, dataElementType, BeanInfoEntryTransformer.class);
    }

    protected void createDataCollection(String name, Repository dataDC, Class<? extends DataElement> dataElementType, Class<?> transformerClass) throws Exception {
        CollectionFactoryUtils.createTransformedCollection((Repository)dataDC, (String)name, transformerClass, dataElementType, null, null, (String)".dat", (String)"ID", (String)"ID", (String)"//", null);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public boolean canCreateEmptyModule() {
        return true;
    }
}

