/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard;

import biouml.model.Module;
import biouml.standard.SqlModuleType;
import biouml.standard.StandardQueryEngine;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementPathSet;
import ru.biosoft.access.core.VectorDataCollection;

public class SqlQueryEngine
extends StandardQueryEngine {
    @Override
    public String getName(TargetOptions dbOptions) {
        return "SQL collection search";
    }

    @Override
    public int canSearchLinked(TargetOptions dbOptions) {
        Module module;
        DataElementPathSet collections = dbOptions.getUsedCollectionPaths();
        if (collections.size() == 1 && (module = (Module)collections.first().optDataElement(Module.class)) != null && module.getType() instanceof SqlModuleType) {
            return 17;
        }
        return 0;
    }

    protected String getReaction(String kernelName, int direction) {
        String sql = "SELECT reactionID AS \"name\" FROM reactionComponents WHERE specieID LIKE '%" + kernelName + "'";
        String whereRole = null;
        if (1 == direction) {
            whereRole = " AND (role='reactant' OR role='modifier')";
        } else if (0 == direction) {
            whereRole = " AND role='product'";
        } else if (2 == direction) {
            whereRole = " AND (role='product' OR role='reactant' OR role='modifier')";
        } else if (-1 == direction) {
            // empty if block
        }
        if (null != whereRole) {
            sql = sql + whereRole;
        }
        return sql;
    }

    @Override
    protected DataCollection<Reaction> getReactions(Module module, Base kernel, int direction) throws Exception {
        DataCollection<Reaction> fullReactions = module.getCategory(Reaction.class);
        Connection conn = DataCollectionUtils.getSqlConnection(fullReactions);
        if (conn != null) {
            VectorDataCollection reactions = new VectorDataCollection(module.getType().getCategory(Reaction.class), fullReactions, new Properties());
            String kernelName = CollectionFactory.getRelativeName((DataElement)kernel, (DataCollection)module);
            if (kernelName != null) {
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(this.getReaction(kernelName, direction));){
                    while (rs.next()) {
                        String id = rs.getString("name");
                        Reaction r = (Reaction)fullReactions.get(id);
                        reactions.put((DataElement)r);
                    }
                }
            }
            return reactions;
        }
        return super.getReactions(module, kernel, direction);
    }

    protected String getSemanticRelation(String kernelName, int direction) {
        String sql = "SELECT ID AS \"name\" FROM relations WHERE ";
        if (1 == direction) {
            sql = sql + this.getSemanticRelationInOutCondition(kernelName, true);
        } else if (0 == direction) {
            sql = sql + this.getSemanticRelationInOutCondition(kernelName, false);
        } else if (2 == direction || -1 == direction) {
            sql = sql + this.getSemanticRelationInOutCondition(kernelName, true) + " OR " + this.getSemanticRelationInOutCondition(kernelName, false);
        }
        return sql;
    }

    private String getSemanticRelationInOutCondition(String kernelName, boolean isInput) {
        if (isInput) {
            return "inputElement LIKE '" + kernelName + "' ";
        }
        return "outputElement LIKE '" + kernelName + "' ";
    }

    @Override
    protected DataCollection<SemanticRelation> getSemanticRelations(Module module, Base kernel, int direction) throws Exception {
        DataCollection<SemanticRelation> fullRelations = module.getCategory(SemanticRelation.class);
        Connection conn = DataCollectionUtils.getSqlConnection(fullRelations);
        if (conn != null) {
            VectorDataCollection relations = new VectorDataCollection(module.getType().getCategory(SemanticRelation.class), fullRelations, new Properties());
            String category = module.getType().getCategory(kernel.getClass());
            if (category != null) {
                String kernelName = DataElementPath.EMPTY_PATH.getChildPath(new String[]{kernel.getOrigin().getName(), kernel.getName()}).toString();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(this.getSemanticRelation(kernelName, direction));){
                    while (rs.next()) {
                        String id = rs.getString("name");
                        SemanticRelation r = (SemanticRelation)fullRelations.get(id);
                        relations.put((DataElement)r);
                    }
                }
            }
            return relations;
        }
        return super.getSemanticRelations(module, kernel, direction);
    }
}

