/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.xml.XmlDiagramTypeConstants;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.type.Base;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Point;
import java.util.List;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class XmlReactionPane
extends ReactionPane {
    private final String type;
    private final String kernelType;
    private final DynamicPropertySet initAttributes;

    public XmlReactionPane(Diagram diagram, Compartment compartment, Point point, ViewEditorPane viewEditor, String type, String kernelType, DynamicPropertySet initAttributes) {
        super(diagram, compartment, point, viewEditor);
        this.type = type;
        this.kernelType = kernelType;
        this.initAttributes = initAttributes;
    }

    @Override
    protected boolean createReaction() throws Exception {
        Node reactionNode;
        if (!this.isReactionValid()) {
            throw new ReactionPane.CreateReactionException(this.resources.getString("REACTION_COMPONENT_NOT_VALID"));
        }
        this.viewEditor.startTransaction("Create reaction");
        if (this.kernelType != null && this.kernelType.equals("biouml.standard.type.Reaction")) {
            List<SpecieReference> componentsList = this.getComponentList();
            reactionNode = DiagramUtility.createReactionNode(this.diagram, this.compartment, null, componentsList, this.reactionEditPane.getFormula(), this.point, this.type);
            reactionNode.getAttributes().add(new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)this.type));
            for (Edge edge : reactionNode.getEdges()) {
                edge.getAttributes().add(new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)this.type));
            }
        } else {
            String name = DefaultSemanticController.generateUniqueNodeName(this.compartment, this.type);
            Stub reaction = new Stub(null, name, this.type);
            reaction.setTitle(DiagramUtility.generateReactionTitle(this.getComponentList()));
            reactionNode = new Node(this.compartment, (Base)reaction);
            for (SpecieReference prototype : this.getComponentList()) {
                Edge edge;
                String xmlType;
                Node de = this.diagram.findNode(prototype.getSpecie());
                if (prototype.getRole().equals("product")) {
                    xmlType = "production";
                    edge = new Edge(new Stub(null, "", xmlType), reactionNode, de);
                } else if (prototype.getRole().equals("reactant")) {
                    xmlType = "consumption";
                    edge = new Edge(new Stub(null, "", xmlType), de, reactionNode);
                } else if (prototype.getRole().equals("modifier")) {
                    xmlType = "regulation";
                    edge = new Edge(new Stub(null, "", xmlType), de, reactionNode);
                } else {
                    throw new InternalException("Invalid role: " + prototype.getRole() + "; specie = " + prototype);
                }
                edge.getAttributes().add(new DynamicProperty("specieType", String.class, (Object)prototype.getRole()));
                DynamicProperty dp = new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)xmlType);
                edge.getAttributes().add(dp);
                edge.save();
            }
            reactionNode.setRelativeLocation(this.diagram, this.point);
            reactionNode.getAttributes().add(new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)this.type));
        }
        for (DynamicProperty property : this.initAttributes) {
            reactionNode.getAttributes().add(property);
        }
        reactionNode = (Node)this.diagram.getType().getSemanticController().validate(this.diagram, reactionNode, true);
        this.compartment.put(reactionNode);
        this.viewEditor.completeTransaction();
        return true;
    }
}

