/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Compartment;
import biouml.model.DefaultDiagramViewBuilder;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.xml.DiagramElementJScriptWrapper;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramViewOptions;
import biouml.standard.diagram.PathwayDiagramViewBuilder;
import biouml.standard.type.Base;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import ru.biosoft.graph.PortFinder;
import ru.biosoft.graph.ShapeChanger;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;
import ru.biosoft.util.TextUtil;

public class XmlDiagramViewBuilder
extends DefaultDiagramViewBuilder {
    protected static final Logger log = Logger.getLogger(XmlDiagramViewBuilder.class.getName());
    protected XmlDiagramType xmlDiagramType;
    private final ThreadLocal<Context> contextMap = new ThreadLocal();
    private final Map<String, ImporterTopLevel> scopeMap = new HashMap<String, ImporterTopLevel>();
    protected Map<String, Function> functionsMap = new HashMap<String, Function>();
    protected Map<Object, Icon> icons = new HashMap<Object, Icon>();
    protected Map<String, String> functionCodesMap = new HashMap<String, String>();
    private XmlDiagramViewOptions diagramViewOptions;

    public DiagramViewBuilder getBaseViewBuilder() {
        return this.baseViewBuilder;
    }

    public XmlDiagramViewBuilder(XmlDiagramType diagramType) {
        this.xmlDiagramType = diagramType;
        this.baseViewBuilder = new DefaultDiagramViewBuilder();
    }

    public Context getContext() {
        Context context = this.contextMap.get();
        if (context == null) {
            context = Context.enter();
            context.initStandardObjects((ScriptableObject)this.getScope());
            this.contextMap.set(context);
            try {
                ImporterTopLevel scope = this.getScope();
                scope.put("prototype", (Scriptable)scope, (Object)Context.toObject((Object)this.baseViewBuilder, (Scriptable)scope));
                for (String packageName : XmlDiagramType.IMPORT_PACKAGES) {
                    NativeJavaPackage pack = new NativeJavaPackage(packageName, this.getClass().getClassLoader());
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)pack, (Scriptable)scope);
                    scope.importPackage(null, null, new Object[]{pack}, null);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not initialise JavaScript context for Xml Diagram View Builder");
            }
        }
        return context;
    }

    public ImporterTopLevel getScope() {
        ImporterTopLevel scope;
        String threadKey = Thread.currentThread().getName();
        if (this.scopeMap.containsKey(threadKey)) {
            scope = this.scopeMap.get(threadKey);
        } else {
            scope = new ImporterTopLevel();
            this.scopeMap.put(threadKey, scope);
        }
        return scope;
    }

    public void addFunction(String type, String script) {
        Function f = this.getContext().compileFunction((Scriptable)this.getScope(), script, "view function for " + type, 0, null);
        this.functionsMap.put(type, f);
        this.functionCodesMap.put(type, script);
    }

    public void removeFunction(String type) {
        this.functionsMap.remove(type);
        this.functionCodesMap.remove(type);
    }

    public String findElementType(Base kernel) {
        if (kernel == null) {
            return null;
        }
        String type = this.xmlDiagramType.getKernelTypeName(kernel.getClass());
        if (type == null) {
            type = kernel.getType();
        }
        if (this.typeMapping != null && this.typeMapping.containsKey(type)) {
            return (String)this.typeMapping.get(type);
        }
        return type;
    }

    @Override
    public boolean createCompartmentCoreView(CompositeView container, Compartment compartment, DiagramViewOptions options, Graphics g) {
        boolean showTitle = this.createNodeCoreView(container, compartment, options, g);
        container.setLocation(compartment.getLocation());
        container.setModel((Object)compartment);
        container.setActive(true);
        return showTitle;
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        Object typeObj = node.getAttributes().getValue("xmlElementType");
        String type = typeObj != null ? typeObj.toString() : this.findElementType(node.getKernel());
        if (type != null && this.functionsMap.containsKey(type)) {
            Function f = this.functionsMap.get(type);
            try {
                this.addMissingAttributes(node, type);
                ImporterTopLevel scope = this.getScope();
                Object[] functionArgs = new Object[]{container, new DiagramElementJScriptWrapper(node), options, g};
                Boolean result = (Boolean)f.call(this.getContext(), (Scriptable)scope, (Scriptable)scope, functionArgs);
                return result;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create view, type=" + type + ", JavaScript function=" + f + ", error=" + t, t);
            }
        }
        return this.baseViewBuilder.createNodeCoreView(container, node, this.baseViewOptions, g);
    }

    public void addMissingAttributes(Node node, String type) {
        DynamicPropertySet oldAttributes = node.getAttributes();
        DynamicPropertySet newAttributes = this.xmlDiagramType.getType(type);
        Iterator iter = newAttributes.nameIterator();
        while (iter.hasNext()) {
            String pName = (String)iter.next();
            if (oldAttributes.getProperty(pName) != null) continue;
            DynamicProperty dp = newAttributes.getProperty(pName);
            Object value = null;
            Object kernelValue = node.getKernel().getAttributes().getValue(pName);
            if (dp.getType().isInstance(kernelValue)) {
                value = kernelValue;
            } else {
                try {
                    value = dp.getType().getConstructor(String.class).newInstance(dp.getValue().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) {
                    try {
                        value = dp.getType().newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    value = TextUtil.fromString((Class)dp.getType(), (String)dp.getValue().toString());
                }
            }
            oldAttributes.add(new DynamicProperty(pName, dp.getType(), value));
        }
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions options, Graphics g) {
        Object typeObj;
        String type = this.isReactionEdge(edge) ? this.findElementType((Base)edge.getKernel().getOrigin()) : ((typeObj = edge.getAttributes().getValue("xmlElementType")) != null ? typeObj.toString() : this.findElementType(edge.getKernel()));
        if (type != null && this.functionsMap.containsKey(type)) {
            CompositeView view = new CompositeView();
            Function f = this.functionsMap.get(type);
            Object[] functionArgs = new Object[]{view, new DiagramElementJScriptWrapper(edge), options, g};
            try {
                ImporterTopLevel scope = this.getScope();
                f.call(this.getContext(), (Scriptable)scope, (Scriptable)scope, functionArgs);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create view, type=" + type + ", JavaScript function=" + f + ", error=" + t, t);
            }
            this.initArrowViews((View)view, (Object)edge);
            return view;
        }
        if (edge.getKernel().getType().equals("dependency")) {
            PathwayDiagramViewBuilder builder = new PathwayDiagramViewBuilder();
            return builder.createDependencyView(edge, g);
        }
        return this.baseViewBuilder.createEdgeView(edge, this.baseViewOptions, g);
    }

    private boolean isReactionEdge(Edge edge) {
        if (edge.getKernel() instanceof SpecieReference) {
            String[] reactionTypes;
            String inNodeType = this.findElementType(edge.getInput().getKernel());
            String outNodeType = this.findElementType(edge.getOutput().getKernel());
            for (String rType : reactionTypes = this.xmlDiagramType.getReactionTypes()) {
                if (!inNodeType.equals(rType) && !outNodeType.equals(rType)) continue;
                return true;
            }
        }
        return false;
    }

    protected void initArrowViews(View view, Object model) {
        if (view instanceof ArrowView) {
            view.setModel(model);
            view.setActive(true);
        } else if (view instanceof CompositeView) {
            view.setModel(model);
            for (int i = 0; i < ((CompositeView)view).size(); ++i) {
                this.initArrowViews(((CompositeView)view).elementAt(i), model);
            }
        }
    }

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        if (this.diagramViewOptions == null) {
            this.diagramViewOptions = new XmlDiagramViewOptions(null);
        }
        this.diagramViewOptions.setDiagramTitleVisible(false);
        return (DiagramViewOptions)this.diagramViewOptions.clone();
    }

    public DynamicPropertySet getViewOptions() {
        if (this.diagramViewOptions == null) {
            this.diagramViewOptions = new XmlDiagramViewOptions(null);
        }
        return this.diagramViewOptions.getOptions();
    }

    protected Point[] getPoints(Edge edge, Point point, Rectangle inBounds) {
        Point in = new Point();
        Point out = new Point();
        if (edge.getOutput().getView() == null) {
            log.warning("Node view is empty, node=" + edge.getOutput().getName());
            return null;
        }
        Rectangle rin = new Rectangle(point.x, point.y, inBounds.width, inBounds.height);
        XmlDiagramViewBuilder.calcAttachmentPoints(rin, edge.getOutput().getView().getBounds(), in, out, 1, 3);
        return new Point[]{in, out};
    }

    public void setIcon(Object key, Icon icon) {
        this.icons.put(key, icon);
    }

    @Override
    public Icon getIcon(Object type) {
        String strType;
        Icon icon = this.icons.get(type);
        if (icon == null && (strType = this.xmlDiagramType.getKernelTypeName(type)) != null) {
            icon = this.icons.get(strType);
        }
        if (icon == null) {
            icon = new ImageIcon();
        }
        return icon;
    }

    public Map<String, String> getFunctionCodes() {
        return this.functionCodesMap;
    }

    @Override
    public PortFinder getPortFinder(Node node) {
        return this.baseViewBuilder.getPortFinder(node);
    }

    @Override
    public ShapeChanger getShapeChanger(Node node) {
        return this.baseViewBuilder.getShapeChanger(node);
    }
}

