/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Diagram;
import biouml.model.util.DiagramXmlWriter;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramTypeReader;
import biouml.model.xml.XmlDiagramTypeSupport;
import biouml.model.xml.XmlDiagramViewBuilder;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlDiagramTypeWriter
extends XmlDiagramTypeSupport {
    public static final String VERSION = "0.8.0";
    public static final String APPVERSION = "0.8.0";
    protected static final Logger log = Logger.getLogger(XmlDiagramTypeReader.class.getName());
    private Document doc;
    protected OutputStream stream;
    private final Map<Object, String> elementType2Icon = new HashMap<Object, String>();
    private int counter = 0;

    public XmlDiagramTypeWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void write(XmlDiagramType diagramType) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.write(diagramType, transformerFactory.newTransformer());
    }

    public void write(XmlDiagramType diagramType, Transformer transformer) throws Exception {
        if (diagramType == null) {
            String msg = "XmlDiagramTypeWriter - diagramType is null, can not be written.";
            NullPointerException e = new NullPointerException(msg);
            log.log(Level.SEVERE, msg, e);
            throw e;
        }
        this.diagramType = diagramType;
        this.buildDocument();
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.stream);
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    protected Document buildDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.doc.appendChild(this.createGraphicNotationElement());
        return this.doc;
    }

    protected Element createGraphicNotationElement() {
        Element element = this.doc.createElement("graphic-notation");
        element.setAttribute("version", "0.8.0");
        element.setAttribute("appVersion", "0.8.0");
        element.setAttribute("title", this.diagramType.getTitle());
        String plugins = this.diagramType.getRequiredPlugins();
        if (plugins != null) {
            element.setAttribute("requiredPlugins", plugins);
        }
        element.appendChild(this.createPropertiesElement());
        element.appendChild(this.createNodesElement());
        element.appendChild(this.createEdgesElement());
        element.appendChild(this.createReactionsElement());
        element.appendChild(this.createViewOptionsElement());
        element.appendChild(this.createViewBuilderElement());
        element.appendChild(this.createIconsElement());
        element.appendChild(this.createSemanticControllerElement());
        element.appendChild(this.createExamplesElement());
        return element;
    }

    private Node createIconsElement() {
        Element iconElement;
        String base64;
        Icon icon;
        Element iconsElement = this.doc.createElement("icons");
        XmlDiagramViewBuilder diagramViewBuilder = this.diagramType.getXmlDiagramViewBuilder();
        for (Object edgeType : this.diagramType.getEdgeTypes()) {
            icon = diagramViewBuilder.getIcon(edgeType);
            base64 = XmlDiagramTypeWriter.encodeBase64(icon);
            if (base64 == null) {
                XmlDiagramTypeWriter.error("ERROR_UNSERIALIZABLE_ICON_TYPE", new String[]{edgeType.toString()});
                continue;
            }
            iconElement = this.doc.createElement("icon");
            iconElement.setAttribute("name", this.getIconName(edgeType));
            iconElement.setTextContent(base64);
            iconsElement.appendChild(iconElement);
        }
        for (Object nodeType : this.diagramType.getNodeTypes()) {
            icon = diagramViewBuilder.getIcon(nodeType);
            base64 = XmlDiagramTypeWriter.encodeBase64(icon);
            if (base64 == null) {
                XmlDiagramTypeWriter.error("ERROR_UNSERIALIZABLE_ICON_TYPE", new String[]{nodeType.toString()});
                continue;
            }
            iconElement = this.doc.createElement("icon");
            iconElement.setAttribute("name", this.getIconName(nodeType));
            iconElement.setTextContent(base64);
            iconsElement.appendChild(iconElement);
        }
        return iconsElement;
    }

    private String getIconName(Object type) {
        return this.elementType2Icon.get(this.diagramType.getKernelTypeName(type));
    }

    private String setIconNameForType(String type) {
        String iconName = "icon" + this.counter++;
        this.elementType2Icon.put(type, iconName);
        return iconName;
    }

    private Node createViewBuilderElement() {
        Element viewBuilderElement = this.doc.createElement("viewBuilder");
        XmlDiagramViewBuilder diagramViewBuilder = this.diagramType.getXmlDiagramViewBuilder();
        String prototype = diagramViewBuilder.getBaseViewBuilder().getClass().getName();
        viewBuilderElement.setAttribute("prototype", prototype);
        for (Map.Entry<String, String> e : diagramViewBuilder.getFunctionCodes().entrySet()) {
            Element nodeViewElement = this.doc.createElement("nodeView");
            nodeViewElement.setAttribute("type", e.getKey());
            nodeViewElement.appendChild(this.doc.createCDATASection(e.getValue()));
            viewBuilderElement.appendChild(nodeViewElement);
        }
        return viewBuilderElement;
    }

    private Node createViewOptionsElement() {
        Element viewOptionsElement = this.doc.createElement("viewOptions");
        DynamicPropertySet options = this.diagramType.getXmlDiagramViewBuilder().getViewOptions();
        DiagramXmlWriter.serializeDPS(this.doc, viewOptionsElement, options, null);
        return viewOptionsElement;
    }

    private Node createSemanticControllerElement() {
        Element element;
        Element semanticControllerElement = this.doc.createElement("semanticController");
        XmlDiagramSemanticController diagramSemanticController = (XmlDiagramSemanticController)this.diagramType.getSemanticController();
        String prototype = diagramSemanticController.getPrototype().getClass().getName();
        semanticControllerElement.setAttribute("prototype", prototype);
        if (diagramSemanticController.getCanAcceptCode() != null) {
            element = this.doc.createElement("canAccept");
            element.appendChild(this.doc.createCDATASection(diagramSemanticController.getCanAcceptCode()));
            semanticControllerElement.appendChild(element);
        }
        if (diagramSemanticController.getIsResizableCode() != null) {
            element = this.doc.createElement("isResizable");
            element.appendChild(this.doc.createCDATASection(diagramSemanticController.getIsResizableCode()));
            semanticControllerElement.appendChild(element);
        }
        if (diagramSemanticController.getMoveCode() != null) {
            element = this.doc.createElement("move");
            element.appendChild(this.doc.createCDATASection(diagramSemanticController.getMoveCode()));
            semanticControllerElement.appendChild(element);
        }
        if (diagramSemanticController.getRemoveCode() != null) {
            element = this.doc.createElement("remove");
            element.appendChild(this.doc.createCDATASection(diagramSemanticController.getRemoveCode()));
            semanticControllerElement.appendChild(element);
        }
        return semanticControllerElement;
    }

    private Node createEdgesElement() {
        Element edgeTypesElement = this.doc.createElement("edges");
        for (String edgeType : this.diagramType.getEdges()) {
            DynamicPropertySet typeDPS;
            String iconName = this.setIconNameForType(edgeType);
            Element edgeElement = this.doc.createElement("edge");
            edgeElement.setAttribute("icon", iconName);
            edgeElement.setAttribute("type", edgeType);
            Object kernelType = this.diagramType.getKernelType(edgeType);
            if (kernelType instanceof Class) {
                edgeElement.setAttribute("kernelType", ((Class)kernelType).getName());
            }
            if ((typeDPS = this.diagramType.getType(edgeType)) != null) {
                DiagramXmlWriter.serializeDPS(this.doc, edgeElement, typeDPS, this.diagramType.getProperties());
            }
            edgeTypesElement.appendChild(edgeElement);
        }
        return edgeTypesElement;
    }

    private Node createNodesElement() {
        Element nodeTypesElement = this.doc.createElement("nodes");
        if (this.diagramType.getNodes() != null) {
            for (String nodeType : this.diagramType.getNodes()) {
                DynamicPropertySet typeDPS;
                Object bean;
                Object kernelType;
                String idFormat;
                String iconName = this.setIconNameForType(nodeType);
                Element nodeElement = this.doc.createElement("node");
                nodeElement.setAttribute("icon", iconName);
                nodeElement.setAttribute("type", nodeType);
                if (this.diagramType.checkCompartment(nodeType)) {
                    nodeElement.setAttribute("isCompartment", "true");
                }
                if ((idFormat = this.diagramType.getIdFormat(nodeType)) != null) {
                    nodeElement.setAttribute("id-format", idFormat);
                }
                if ((kernelType = this.diagramType.getKernelType(nodeType)) instanceof Class) {
                    nodeElement.setAttribute("kernelType", ((Class)kernelType).getName());
                }
                if (this.diagramType.getDefaultTypeName() != null && this.diagramType.getDefaultTypeName().equals(nodeType)) {
                    nodeElement.setAttribute("isDefault", "true");
                }
                if (this.diagramType.checkNeedLayout(nodeType)) {
                    nodeElement.setAttribute("needLayout", "true");
                }
                if ((bean = this.diagramType.getPropertiesBean(nodeType)) != null) {
                    nodeElement.setAttribute("propertiesBean", bean.getClass().getName());
                }
                if ((typeDPS = this.diagramType.getType(nodeType)) != null) {
                    DiagramXmlWriter.serializeDPS(this.doc, nodeElement, typeDPS, this.diagramType.getProperties());
                }
                nodeTypesElement.appendChild(nodeElement);
            }
        }
        return nodeTypesElement;
    }

    private Node createReactionsElement() {
        Element nodeTypesElement = this.doc.createElement("reactions");
        if (this.diagramType.getReactionTypes() != null) {
            for (String nodeType : this.diagramType.getReactionTypes()) {
                DynamicPropertySet typeDPS;
                String iconName = this.setIconNameForType(nodeType);
                Element nodeElement = this.doc.createElement("reaction");
                nodeElement.setAttribute("icon", iconName);
                nodeElement.setAttribute("type", nodeType);
                Object kernelType = this.diagramType.getKernelType(nodeType);
                if (kernelType instanceof Class) {
                    nodeElement.setAttribute("kernelType", ((Class)kernelType).getName());
                }
                if ((typeDPS = this.diagramType.getType(nodeType)) != null) {
                    DiagramXmlWriter.serializeDPS(this.doc, nodeElement, typeDPS, this.diagramType.getProperties());
                }
                nodeTypesElement.appendChild(nodeElement);
            }
        }
        return nodeTypesElement;
    }

    private Node createExamplesElement() {
        Element examplesElement = this.doc.createElement("examples");
        Iterator<String> iter = this.diagramType.getExampleNameList().iterator();
        while (iter.hasNext()) {
            Diagram diagram = this.diagramType.getExample(iter.next());
            Element exampleElement = this.doc.createElement("example");
            exampleElement.setAttribute("name", diagram.getName());
            exampleElement.appendChild(DiagramXmlWriter.serializeDiagram(this.doc, diagram));
            examplesElement.appendChild(exampleElement);
        }
        return examplesElement;
    }

    private Node createPropertiesElement() {
        Element properties = this.doc.createElement("properties");
        DiagramXmlWriter.serializeDPS(this.doc, properties, this.diagramType.getProperties(), null);
        return properties;
    }

    public static String encodeBase64(Icon icon) {
        if (icon instanceof ImageIcon) {
            ByteArrayOutputStream baos = null;
            try {
                BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = bi.createGraphics();
                g2.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
                baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, "png", baos);
            }
            catch (Exception e) {
                return null;
            }
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        return null;
    }
}

